/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.editor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class AcceleoEnvResourceFactory
extends ResourceFactoryImpl {
    private IQualifiedNameQueryEnvironment queryEnvironment;
    private ResourceSet resourceSetForModels;
    private IProject project;

    public AcceleoEnvResourceFactory(IProject project) {
        this.project = project;
        this.init();
    }

    public void init() {
        if (this.queryEnvironment != null && this.resourceSetForModels != null) {
            this.dispose();
        }
        IQualifiedNameResolver resolver = QueryPlugin.getPlugin().createQualifiedNameResolver(AcceleoPlugin.getPlugin().getClass().getClassLoader(), EPackage.Registry.INSTANCE, this.project, "::", false);
        LinkedHashMap options = new LinkedHashMap();
        ArrayList exceptions = new ArrayList();
        this.resourceSetForModels = AQLUtils.createResourceSetForModels(exceptions, (Object)((Object)this), (ResourceSet)new ResourceSetImpl(), options);
        this.queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)this.resourceSetForModels, (boolean)true);
        String newLine = options.getOrDefault("newLine", System.lineSeparator());
        AcceleoEvaluator evaluator = new AcceleoEvaluator(this.queryEnvironment.getLookupEngine(), newLine);
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
        resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::", true));
    }

    public Resource createResource(URI uri) {
        String qualifiedName = uri.toString().replaceFirst("acceleoenv::", "");
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        Object resolved = resolver.resolve(qualifiedName);
        if (resolved instanceof Module) {
            return ((Module)resolved).eResource();
        }
        return null;
    }

    public IFile getSourceFile(Module module) {
        IFile[] files;
        String moduleQualifiedName;
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        java.net.URI sourceURI = resolver.getSourceURI(moduleQualifiedName = resolver.getQualifiedName((Object)module));
        if (sourceURI != null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(sourceURI)).length > 0) {
            return files[0];
        }
        return null;
    }

    public void dispose() {
        AQLUtils.cleanResourceSetForModels((Object)((Object)this), (ResourceSet)this.resourceSetForModels);
        AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (ResourceSet)this.resourceSetForModels);
    }
}

