/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;

@ServiceProvider(value="Property services")
public class PropertiesServices {
    private final Properties properties;

    public PropertiesServices(Properties properties) {
        this.properties = properties;
    }

    @Documentation(value="Get the property value for the given key.", params={@Param(name="key", value="The property key")}, result="The property value", examples={@Example(expression="'property1'.getProperty()", result="a message")})
    public String getProperty(String key) {
        String propertyValue = this.properties.getProperty(key);
        return this.format(propertyValue, new Object[0]);
    }

    @Documentation(value="Get the property value for the given key.", params={@Param(name="key", value="The property key")}, result="The property value", examples={@Example(expression="'property1'.getProperty()", result="a message")})
    public String getProperty(String key, List<Object> arguments) {
        String propertyValue = this.properties.getProperty(key);
        return this.format(propertyValue, arguments.toArray(new Object[arguments.size()]));
    }

    private String format(String propertyValue, Object[] arguments) {
        String res = propertyValue != null ? MessageFormat.format(propertyValue, arguments) : "";
        return res;
    }
}

