/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.annotations.api.documentation.Throw;

@ServiceProvider(value="Services available for Strings")
public class StringServices {
    public static final String NEW_LINE = "\n";
    public static final String WINDOWS_NEW_LINE = "\r\n";
    public static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n|\n");
    public static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("(\r\n|\n)(\r\n|\n)");

    @Documentation(value="Returns a string that is the result of the concatenation of the current string and the string \"b\".", params={@Param(name="self", value="The current String."), @Param(name="b", value="The String that will be appended at the end of the current String.")}, result="The concatenated String.", examples={@Example(expression="'Hello'.concat('World')", result="HelloWorld")}, comment="This operation behaves like '+' between two strings.")
    public String concat(String self, String b) {
        return this.nullToEmpty(self) + this.nullToEmpty(b);
    }

    @Documentation(value="Returns a string that is the result of the concatenation of the current string and the string \"b\".", params={@Param(name="self", value="The current String."), @Param(name="b", value="The String that will be appended at the end of the current String.")}, result="The concatenated String.", examples={@Example(expression="'Hello' + 'World'", result="HelloWorld")}, comment="This operation behaves like '+' between two strings.")
    public String add(String self, String b) {
        return this.nullToEmpty(self) + this.nullToEmpty(b);
    }

    @Documentation(value="Replaces the first substring of the current String that matches the regular expression \"regex\" with the String \"replacement\".", params={@Param(name="self", value="The current String."), @Param(name="regex", value="The regular expression used to find the substring to replace in the current String."), @Param(name="replacement", value="The replacement String.")}, result="Returns the resulting String of a substitution of the first substring matching the given regex by the given replacement", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"regex\" or \"replacement\" is null."), @Throw(type=PatternSyntaxException.class, value="If the regular expression's syntax is invalid")}, examples={@Example(expression="'Hello'.replace('(.*)ll', 'Wh')", result="'Who'")})
    public String replaceFirst(String self, String regex, String replacement) {
        return this.replace(self, regex, replacement);
    }

    @Documentation(value="Replaces the first substring of the current String that matches the regular expression \"regex\" with the String \"replacement\".", params={@Param(name="self", value="The current String."), @Param(name="regex", value="The regular expression used to find the substring to replace in the current String."), @Param(name="replacement", value="The replacement String.")}, result="Returns the resulting String of a substitution of the first substring matching the given regex by the given replacement", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"regex\" or \"replacement\" is null."), @Throw(type=PatternSyntaxException.class, value="If the regular expression's syntax is invalid")}, examples={@Example(expression="'Hello'.replace('(.*)ll', 'Wh')", result="'Who'")})
    public String replace(String self, String regex, String replacement) {
        return this.nullToEmpty(self).replaceFirst(this.nullToEmpty(regex), this.nullToEmpty(replacement));
    }

    @Documentation(value="Replaces each substring of the current String that matches the given regular expression \"regex\" with the String \"replacement\".", params={@Param(name="self", value="The current String."), @Param(name="regex", value="The regular expression used to find all the substrings to replace in the current String."), @Param(name="replacement", value="The replacement String.")}, result="Returns the resulting String of a substitution of all the substrings matching the given regex by the given replacement", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"regex\" or \"replacement\" is null."), @Throw(type=PatternSyntaxException.class, value="If the regular expression's syntax is invalid")}, examples={@Example(expression="'TestTest'.replace('.st', 'erminated')", result="'TerminatedTerminated'")})
    public String replaceAll(String self, String regex, String replacement) {
        return this.nullToEmpty(self).replaceAll(this.nullToEmpty(regex), this.nullToEmpty(replacement));
    }

    @Documentation(value="Returns the current String prefixed with the given \"prefix\".", params={@Param(name="self", value="The current String that will be prefixed"), @Param(name="prefix", value="The String that will be prepended before the current String")}, result="The current String prefixed with the given \"prefix\"", examples={@Example(expression="'World'.prefix('Hello')", result="'HelloWorld'")})
    public String prefix(String self, String prefix) {
        return this.nullToEmpty(prefix) + this.nullToEmpty(self);
    }

    @Documentation(value="Returns \"true\" if the current String contains the String \"b\"", params={@Param(name="self", value="The current String"), @Param(name="b", value="The String that we will look for in the current String")}, result="\"true\" if the current String contains the String \"b\", \"false\" otherwise", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"b\" is null.")}, examples={@Example(expression="'Hello'.contains('llo')", result="true")})
    public Boolean contains(String self, String b) {
        return this.nullToEmpty(self).contains(this.nullToEmpty(b));
    }

    @Documentation(value="Returns \"true\" if the current String matches the given \"regex\".", params={@Param(name="self", value="The current String"), @Param(name="regex", value="The regex used for the match")}, result="\"true\" if \"self\" matches the given regex, \"false\" otherwise.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"regex\" is null.")}, examples={@Example(expression="'Hello'.matches('*llo')", result="true")})
    public Boolean matches(String self, String regex) {
        return this.nullToEmpty(self).matches(this.nullToEmpty(regex));
    }

    @Documentation(value="Returns true if the current String ends with the string \"b\".", params={@Param(name="self", value="The current String"), @Param(name="b", value="The String that may be at the end of the current String")}, result="\"true\" if the current String ends with the string \"b\", \"false\" otherwise.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"b\" is null.")}, examples={@Example(expression="'Hello'.endsWidth('llo')", result="true")})
    public Boolean endsWith(String self, String b) {
        return this.nullToEmpty(self).endsWith(this.nullToEmpty(b));
    }

    @Documentation(value="Returns true if the current String starts with the string \"b\".", params={@Param(name="self", value="The current String"), @Param(name="b", value="The String that may be at the beginning of the current String")}, result="\"true\" if the current String starts with the string \"b\", \"false\" otherwise.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"b\" is null.")}, examples={@Example(expression="'Hello'.startsWith('Hell')", result="true")})
    public Boolean startsWith(String self, String b) {
        return this.nullToEmpty(self).startsWith(this.nullToEmpty(b));
    }

    @Documentation(value="Returns true if the current String is equals to the String \"b\" without considering case in the comparison.", params={@Param(name="self", value="The current String"), @Param(name="b", value="The String to compare with the current String")}, result="\"true\" if the current String is equal to the string \"b\", without considering case, \"false\" otherwise.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"b\" is null.")}, examples={@Example(expression="'Hello'.equalsIgnoreCase('hello')", result="true")})
    public Boolean equalsIgnoreCase(String self, String b) {
        return this.nullToEmpty(self).equalsIgnoreCase(this.nullToEmpty(b));
    }

    @Documentation(value="Returns the \"n\" first characters of the current String, or the current String itself if its size is less than \"n\".", params={@Param(name="self", value="The current String"), @Param(name="n", value="The number of characters that must be retrieved from the beginning of the current String.")}, result="The \"n\" first characters of the current String", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"n\" is null."), @Throw(type=IndexOutOfBoundsException.class, value="If \"n\" is not a valid index of self (i.e it is inferior to 0).")}, examples={@Example(expression="'HelloWorld'.first(5)", result="'Hello'")})
    public String first(String self, Integer n) {
        String result = self == null || self.length() < n ? self : self.substring(0, n);
        return result;
    }

    @Documentation(value="Returns the \"n\" last characters of the current String, or the current String if its size is less than \"n\".", params={@Param(name="self", value="The current String"), @Param(name="n", value="The number of characters that must be retrieved from the end of the current String")}, result="The \"n\" last characters of the current String", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"n\" is null."), @Throw(type=IndexOutOfBoundsException.class, value="If \"n\" is not a valid index of self (i.e it is greater than the size of the current String).")}, examples={@Example(expression="'HelloWorld'.last(5)", result="'World'")})
    public String last(String self, Integer n) {
        String result = self == null || self.length() < n ? self : self.substring(self.length() - n, self.length());
        return result;
    }

    @Documentation(value="Returns the index of the last occurrence of \"subString\" in the current String, \"-1\" if the current String doesn't contain this particular substring. The index referential is 1 as in OCL and not 0.", params={@Param(name="self", value="The current String"), @Param(name="subString", value="The substring that we want to find in the current String")}, result="The index of the last occurrence of subString in the current String or -1 if not found", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"subString\" is null.")}, examples={@Example(expression="'HelloHello'.lastIndex('World')", result="6")})
    public Integer lastIndex(String self, String subString) {
        int index = this.nullToEmpty(self).lastIndexOf(this.nullToEmpty(subString)) + 1;
        if (index == 0) {
            index = -1;
        }
        return index;
    }

    @Documentation(value="Returns the index of the first occurrence \"subString\" in the current String, or -1 if \"subString\" is not in the current String. The index referential is 1 as in OCL and not 0.", params={@Param(name="self", value="The current String"), @Param(name="subString", value="The substring that we want to find in the current String")}, result="The index of the first occurrence of subString in the current String or -1 if not found", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String or \"subString\" is null.")}, examples={@Example(expression="'HelloHello'.index('Hello')", result="1")})
    public Integer index(String self, String b) {
        int index = this.nullToEmpty(self).indexOf(this.nullToEmpty(b)) + 1;
        if (index == 0) {
            index = -1;
        }
        return index;
    }

    @Documentation(value="Returns the index of the first occurrence \"subString\" in the current String from the given index, or -1 if \"subString\" is not in the current String. The index referential is 1 as in OCL and not 0.", params={@Param(name="self", value="The current String"), @Param(name="subString", value="The substring that we want to find in the current String"), @Param(name="indexString", value="The starting index from which the substring will be searched")}, result="The index of the first occurrence of subString in the current String or -1 if not found", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String, \"subString\" or index is null.")}, examples={@Example(expression="'HelloHello'.index('Hello', 2)", result="6")})
    public Integer index(String self, String subString, Integer index) {
        int indexResult = this.nullToEmpty(self).indexOf(this.nullToEmpty(subString), (int)index) + 1;
        if (indexResult == 0) {
            indexResult = -1;
        }
        return indexResult;
    }

    @Documentation(value="Returns the index of the last occurrence \"subString\" in the current String searching backward from the given index, or -1 if \"subString\" is not in the current String. The index referential is 1 as in OCL and not 0.", params={@Param(name="self", value="The current String"), @Param(name="subString", value="The substring that we want to find in the current String"), @Param(name="indexString", value="The starting index from which the substring will be searched")}, result="The index of the last occurrence of subString in the current String or -1 if not found", exceptions={@Throw(type=NullPointerException.class, value="Thrown if the current String, \"subString\" or index is null.")}, examples={@Example(expression="'HelloHello'.lastIndex('Hello', 7)", result="1")})
    public Integer lastIndex(String self, String subString, Integer index) {
        int indexResult = this.nullToEmpty(self).lastIndexOf(this.nullToEmpty(subString), (int)index) + 1;
        if (indexResult == 0) {
            indexResult = -1;
        }
        return indexResult;
    }

    @Documentation(value="Returns the current String with all characters transformed to lower case.", params={@Param(name="self", value="The current String from which we want to convert all characters to lower case.")}, result="The current String with all upper case characters converted to lower case.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if \"self\" is \"null\".")}, examples={@Example(expression="'HelloWorld'.toLower()", result="'helloworld'")})
    public String toLower(String self) {
        String result = self == null ? null : self.toLowerCase();
        return result;
    }

    @Documentation(value="Returns the self string with the first characters transformed to lower case.", params={@Param(name="self", value="The current String from which we want to convert the first character to lower case.")}, result="The current String with the first character transformed to lower case.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if \"self\" is \"null\".")}, examples={@Example(expression="'HelloWorld'.toLowerFirst()", result="'helloWorld'")})
    public String toLowerFirst(String self) {
        Object resultString = self == null ? null : (self.length() == 0 ? self : (self.length() == 1 ? self.toLowerCase() : Character.toLowerCase(self.charAt(0)) + self.substring(1)));
        return resultString;
    }

    @Documentation(value="Returns the current String with all characters transformed to upper case.", params={@Param(name="self", value="The current String from which we want to convert all characters to upper case.")}, result="The current String with all lower case characters converted to upper case.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if \"self\" is \"null\".")}, examples={@Example(expression="'HelloWorld'.toUpper()", result="'HELLOWORLD'")})
    public String toUpper(String self) {
        String result = self == null ? null : self.toUpperCase();
        return result;
    }

    @Documentation(value="Returns the current String with the first characters transformed to upper case.", params={@Param(name="self", value="The current String from which we want to convert the first character to upper case.")}, result="The current String with the first character transformed to upper case.", exceptions={@Throw(type=NullPointerException.class, value="Thrown if \"self\" is \"null\".")}, examples={@Example(expression="'helloworld'.toUpperFirst()", result="'Helloworld'")})
    public String toUpperFirst(String self) {
        Object resultString = self == null ? null : (self.length() == 0 ? self : (self.length() == 1 ? self.toUpperCase() : Character.toUpperCase(self.charAt(0)) + self.substring(1)));
        return resultString;
    }

    @Documentation(value="Returns \"true\" if self consists only of alphabetical characters, \"false\" otherwise.", params={@Param(name="self", value="The string we want to ensure it consists only of alphabetical characters.")}, result="\"true\" if self consists only of alphabetical characters, \"false\" otherwise.", examples={@Example(expression="'abc123'.isAlpha()", result="false"), @Example(expression="'abcdef'.isAlpha()", result="true")})
    public Boolean isAlpha(String self) {
        Boolean result = Boolean.TRUE;
        if (self != null) {
            char[] chars;
            char[] cArray = chars = self.toCharArray();
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetter(c)) {
                    result = Boolean.FALSE;
                    break;
                }
                ++n2;
            }
        } else {
            result = Boolean.FALSE;
        }
        return result;
    }

    @Documentation(value="Returns \"true\" if self consists only of alphanumeric characters, \"false\" otherwise.", params={@Param(name="self", value="The string we want to ensure it consists only of alphanumeric characters.")}, result="\"true\" if self consists only of alphanumeric characters, \"false\" otherwise.", examples={@Example(expression="'abc123'.isAlphaNum()", result="true"), @Example(expression="'abcdef'.isAlphaNum()", result="true")})
    public Boolean isAlphaNum(String self) {
        Boolean result = Boolean.TRUE;
        if (self != null) {
            char[] chars;
            char[] cArray = chars = self.toCharArray();
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c)) {
                    result = Boolean.FALSE;
                    break;
                }
                ++n2;
            }
        } else {
            result = Boolean.FALSE;
        }
        return result;
    }

    @Documentation(value="Return the length of the current String.", params={@Param(name="self", value="The current String")}, result="The length of the specified string", examples={@Example(expression="'HelloWorld'.size()", result="10")})
    public Integer size(String self) {
        int result = self == null || self.isEmpty() ? 0 : this.nullToEmpty(self).length();
        return result;
    }

    @Documentation(value="Returns a string containing all characters from self starting from index lower up to the end of the string included. The lower parameter should be contained between 1 and self.size() included. Lower cannot be greater than the size of the String.", params={@Param(name="self", value="The current String"), @Param(name="lower", value="The lower bound")}, result="A string containing all characters from self starting from index lower included.", examples={@Example(expression="'HelloWorld'.substring(5)", result="'World'"), @Example(expression="'HelloWorld'.substring(1)", result="'HelloWorld'")})
    public String substring(String self, Integer lower) {
        String result = self == null ? null : self.substring(lower - 1);
        return result;
    }

    @Documentation(value="Returns a string containing all characters from self starting from index lower up to index upper included. Both lower and upper parameters should be contained between 1 and self.size() included. Lower cannot be greater than upper.", params={@Param(name="self", value="The current String"), @Param(name="lower", value="The lower bound"), @Param(name="upper", value="The upper bound")}, result="a string containing all characters from self starting from index lower up to index upper included. Both lower and upper parameters should be contained between 1 and self.size() included. lower cannot be greater than upper", examples={@Example(expression="'HelloWorld'.substring(1, 5)", result="'Hello'")})
    public String substring(String self, Integer lower, Integer upper) {
        String result = self == null ? null : self.substring(lower - 1, upper);
        return result;
    }

    @Documentation(value="Returns an integer of value equal to self", params={@Param(name="self", value="The current String")}, result="An integer of value equal to self", exceptions={@Throw(type=NumberFormatException.class, value="Thrown if self does not represent an integer")}, examples={@Example(expression="'42'.toInteger()", result="42")})
    public Integer toInteger(String self) {
        return Integer.valueOf(this.nullToEmpty(self));
    }

    @Documentation(value="Returns a real of value equal to self", params={@Param(name="self", value="The current String")}, result="A real of value equal to self", exceptions={@Throw(type=NumberFormatException.class, value="Thrown if self does not represent a real")}, examples={@Example(expression="'41.9'.toReal()", result="41.9")})
    public Double toReal(String self) {
        return Double.valueOf(this.nullToEmpty(self));
    }

    @Documentation(value="Returns an integer that is either negative, zero or positive depending on whether s1 is alphabetically less than, equal to or greater than self. Note that upper case letters come before lower case ones, so that 'AA' is closer to 'AC' than it is to 'Ab'.", params={@Param(name="self", value="The current String"), @Param(name="s1", value="The other String")}, result="An integer that is either negative, zero or positive depending on whether s1 is alphabetically less than, equal to or greater than self. Note that upper case letters come before lower case ones, so that 'AA' is closer to 'AC' than it is to 'Ab'", examples={@Example(expression="'strcmp operation'.strcmp('strcmp')", result="10"), @Example(expression="'strcmp operation'.strcmp('strcmp operation')", result="0"), @Example(expression="'strcmp operation'.strcmp('strtok')", result="-17")})
    public Integer strcmp(String self, String s1) {
        return this.nullToEmpty(self).compareTo(this.nullToEmpty(s1));
    }

    @Documentation(value="Searches r in self.", params={@Param(name="self", value="The current String"), @Param(name="r", value="The String to search")}, result="\"true\" if r is found, \"false\" otherwise", examples={@Example(expression="'HelloWorld'.strstr('World')", result="true")})
    public Boolean strstr(String self, String r) {
        return this.nullToEmpty(self).indexOf(this.nullToEmpty(r)) > -1;
    }

    @Documentation(value="Substitutes the first occurrence of the substring \"r\" in self by \"t\" and returns the resulting string. Will return self if it contains no occurrence of the substring r.", params={@Param(name="self", value="The current String"), @Param(name="r", value="The String to replace"), @Param(name="t", value="The replacement String")}, result="A new String", examples={@Example(expression="'WorldWorld'.substitute('World', 'Hello')", result="'HelloWorld'")})
    public String substituteFirst(String self, String r, String t) {
        return this.substitute(self, r, t);
    }

    @Documentation(value="Substitutes the first occurrence of the substring \"r\" in self by \"t\" and returns the resulting string. Will return self if it contains no occurrence of the substring r.", params={@Param(name="self", value="The current String"), @Param(name="r", value="The String to replace"), @Param(name="t", value="The replacement String")}, result="A new String", examples={@Example(expression="'WorldWorld'.substitute('World', 'Hello')", result="'HelloWorld'")})
    public String substitute(String self, String r, String t) {
        return Pattern.compile(this.nullToEmpty(r), 16).matcher(this.nullToEmpty(self)).replaceFirst(Matcher.quoteReplacement(this.nullToEmpty(t)));
    }

    @Documentation(value="Substitutes all occurrences of the substring \"r\" in self by \"t\" and returns the resulting string. Will return self if it contains no occurrence of the substring r.", params={@Param(name="self", value="The current String"), @Param(name="r", value="The String to replace"), @Param(name="t", value="The replacement String")}, result="A new String", examples={@Example(expression="'WorldWorld'.substituteAll('World', 'Hello')", result="'HelloHello'")})
    public String substituteAll(String self, String r, String t) {
        return Pattern.compile(this.nullToEmpty(r), 16).matcher(this.nullToEmpty(self)).replaceAll(Matcher.quoteReplacement(this.nullToEmpty(t)));
    }

    @Documentation(value="Trims the given String.", params={@Param(name="self", value="The String to trim")}, result="The trimmed String", examples={@Example(expression="'  Hello World   '.trim()", result="'Hello World'")})
    public String trim(String self) {
        String result = self == null ? null : (self.isEmpty() ? self : this.nullToEmpty(self).trim());
        return result;
    }

    @Documentation(value="Removes all line separators.", params={@Param(name="self", value="The String to trim")}, result="The String with removed line separators", examples={@Example(expression="'Hello\\nWorld'.removeLineSeparators()", result="'HelloWorld'"), @Example(expression="'Hello\\r\\nWorld'.removeLineSeparators()", result="'HelloWorld'")})
    public String removeLineSeparators(String self) {
        String res = self != null ? NEW_LINE_PATTERN.matcher(self).replaceAll("") : null;
        return res;
    }

    @Documentation(value="Removes all empty lines.", params={@Param(name="self", value="The String to trim")}, result="The String with removed empty lines", examples={@Example(expression="'Hello\\n\\nWorld'.removeEmptyLines()", result="'HelloWorld'"), @Example(expression="'Hello\\r\\n\\r\\nWorld'.removeEmptyLines()", result="'HelloWorld'"), @Example(expression="'Hello\\n\\r\\nWorld'.removeEmptyLines()", result="'HelloWorld'"), @Example(expression="'Hello\\r\\n\\nWorld'.removeEmptyLines()", result="'HelloWorld'")})
    public String removeEmptyLines(String self) {
        String res = self != null ? EMPTY_LINE_PATTERN.matcher(self).replaceAll("") : null;
        return res;
    }

    @Documentation(value="Splits the current String by whitespace delimiter into a collection of String", params={@Param(name="self", value="The current String")}, result="The collection of substrings of the current String delimited by whitespaces", examples={@Example(expression="'a, b, c, d'.tokenize()", result="['a,', 'b,', 'c,', 'd']")})
    public List<String> tokenize(String self) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.nullToEmpty(self));
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        return segments;
    }

    @Documentation(value="Splits the current String by using the given \"delimiter\" into a collection of String", params={@Param(name="self", value="The current String"), @Param(name="delimiter", value="The current String")}, result="The collection of substrings of the current String delimited by the given \"delimiter\"", examples={@Example(expression="'a, b, c, d'.tokenize(', ')", result="['a', 'b', 'c', 'd']")})
    public List<String> tokenize(String self, String delimiter) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.nullToEmpty(self), this.nullToEmpty(delimiter));
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        return segments;
    }

    @Documentation(value="Gets the character at the given index of the given String.", params={@Param(name="self", value="The current String"), @Param(name="index", value="The index")}, result="The character at the given index", examples={@Example(expression="'cat'.at(2)", result="'a'")})
    public String at(String str, Integer index) {
        if (str != null) {
            return String.valueOf(str.charAt(index - 1));
        }
        String res = null;
        return res;
    }

    @Documentation(value="Converts the given String in a Sequence of Strings representing each character.", params={@Param(name="self", value="The current String")}, result="The Sequence of Strings representing each caracter", examples={@Example(expression="'cat'.characters()", result="Sequence{'c', 'a', 't'}")})
    public List<String> characters(String str) {
        ArrayList<String> res = new ArrayList<String>();
        String string = this.nullToEmpty(str);
        int i = 0;
        while (i < string.length()) {
            res.add(String.valueOf(string.charAt(i)));
            ++i;
        }
        return res;
    }

    @Documentation(value="Gets the platform line separator.", params={@Param(name="obj", value="Any object")}, result="'\\n' (Unix) or '\\r\\n' (Dos) or '\\r' (Mac Os Classic)", examples={@Example(expression="obj.lineSeparator()", result="'\\n'")})
    public String lineSeparator(Object obj) {
        return System.getProperty("line.separator");
    }

    @Documentation(value="Gets the boolean value of the given String.", params={@Param(name="value", value="The current String")}, result="true if then passed String equals ignoring case to 'true', false otherwise", examples={@Example(expression="'true'.toBoolean()", result="true"), @Example(expression="'True'.toBoolean()", result="true"), @Example(expression="'Some String'.toBoolean()", result="false")})
    public Boolean toBoolean(String value) {
        return Boolean.valueOf(value);
    }

    private String nullToEmpty(String str) {
        String res = str == null ? "" : str;
        return res;
    }
}

