/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.cdo.providers.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.internal.cdo.view.CDOURIHandler;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public class AqlCDOURIHandler
extends CDOURIHandler {
    private static final int BUFFER_SIZE = 8192;

    public AqlCDOURIHandler(InternalCDOView view) {
        super(view);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream res;
        InternalCDOView view = this.getView();
        CDOResourceNode node = view.getResourceNode(uri.path());
        if (node instanceof CDOBinaryResource) {
            res = ((CDOBinaryResource)node).getContents().getContents();
        } else if (node instanceof CDOTextResource) {
            int numCharsRead;
            CDOTextResource textResource = (CDOTextResource)node;
            String encoding = AqlCDOURIHandler.getEncoding(textResource);
            Reader contents = textResource.getContents().getContents();
            char[] charBuffer = new char[8192];
            StringBuilder builder = new StringBuilder();
            while ((numCharsRead = contents.read(charBuffer, 0, charBuffer.length)) != -1) {
                builder.append(charBuffer, 0, numCharsRead);
            }
            res = new ByteArrayInputStream(builder.toString().getBytes(encoding));
        } else {
            res = super.createInputStream(uri, options);
        }
        return res;
    }

    private static String getEncoding(CDOTextResource textResource) {
        String encoding = textResource.getEncoding() != null ? textResource.getEncoding() : "UTF-8";
        return encoding;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        OutputStream res;
        InternalCDOView view = this.getView();
        if (view instanceof InternalCDOTransaction) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)view;
            CDOBinaryResource node = uri.path().lastIndexOf(47) == 0 ? transaction.getOrCreateBinaryResource(uri.path().substring(1)) : transaction.getOrCreateBinaryResource(uri.path());
            res = new CDONodeOutputStream((CDOResourceNode)node);
        } else {
            res = super.createOutputStream(uri, options);
        }
        return res;
    }

    private static final class CDONodeOutputStream
    extends OutputStream {
        private final CDOResourceNode node;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        private CDONodeOutputStream(CDOResourceNode node) {
            this.node = node;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.buffer.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.node instanceof CDOBinaryResource) {
                ((CDOBinaryResource)this.node).setContents(new CDOBlob((InputStream)new ByteArrayInputStream(this.buffer.toByteArray())));
            } else if (this.node instanceof CDOTextResource) {
                CDOTextResource textResource = (CDOTextResource)this.node;
                String encoding = AqlCDOURIHandler.getEncoding(textResource);
                textResource.setContents(new CDOClob((Reader)new StringReader(this.buffer.toString(encoding))));
            } else {
                throw new IllegalStateException("CDOResourceNode type not supported.");
            }
            this.buffer.close();
        }
    }
}

