/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.gen.ide;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.amp.amf.gen.ide.ExtendedResourceLoader;
import org.eclipse.amp.amf.gen.ide.LogWorkflow;
import org.eclipse.amp.amf.gen.ide.MetaABMBuilder;
import org.eclipse.amp.amf.gen.ide.ModelMarkerHelper;
import org.eclipse.amp.amf.gen.ide.WorkflowUIExceptionHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe.core.WorkflowEngine;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractMWEBuilder
extends IncrementalProjectBuilder {
    String sourceExtension;
    protected String[] workflowPaths;
    ExtendedResourceLoader resourceLoader;
    protected static MetaABMBuilder builder;
    private Map<String, String> genProps;
    protected IProgressMonitor currentMonitor;
    boolean createMarkers;
    private ModelMarkerHelper modelMarkerHelper;
    WorkflowUIExceptionHandler exceptionHandler;
    private String taskDescription;
    private String pluginName;
    private boolean reportErrors = true;

    public AbstractMWEBuilder(String taskDescription, String pluginName, String workflowPath, String sourceExtension) {
        this(taskDescription, pluginName, new String[]{workflowPath}, sourceExtension);
    }

    public AbstractMWEBuilder(String taskDescription, String pluginName, String[] workflowPaths, String sourceExtension) {
        this.taskDescription = taskDescription;
        this.pluginName = pluginName;
        this.workflowPaths = workflowPaths;
        this.sourceExtension = sourceExtension;
        this.setGenProperties(new HashMap<String, String>());
        this.loadPlugins();
    }

    public void addURL(URL url) throws CoreException {
        this.resourceLoader.addURL(url);
    }

    public abstract void loadPlugins();

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void generateModel(IResource resource) {
        NullProgressMonitor workflowMonitor;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        LogWorkflow.registerToLogFactory();
        String projectName = resource.getProject().getName();
        String fileName = resource.getName();
        String fullTaskDescription = String.valueOf(this.taskDescription) + " for " + fileName + " in " + projectName;
        if (this.createMarkers) {
            this.modelMarkerHelper = new ModelMarkerHelper(resource);
            this.modelMarkerHelper.deleteMarkers();
        }
        GenerationRunner workflowRunner = new GenerationRunner();
        if (this.currentMonitor != null) {
            workflowMonitor = new ProgressMonitorAdapter(this.currentMonitor);
        } else {
            workflowMonitor = new NullProgressMonitor();
            workflowMonitor.setTaskName(fullTaskDescription);
        }
        this.exceptionHandler = new WorkflowUIExceptionHandler();
        HashMap<String, Object> slotContents = new HashMap<String, Object>();
        slotContents.put("progressMonitor", this.currentMonitor);
        slotContents.put("exceptionHandler", this.exceptionHandler);
        this.loadPropertiesFromPrefs();
        boolean success = true;
        String[] stringArray = this.workflowPaths;
        int n = this.workflowPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String workflow = stringArray[n2];
            if (!(success &= workflowRunner.run(workflow, (ProgressMonitor)workflowMonitor, this.getGenProperties(), slotContents))) break;
            ++n2;
        }
        LogWorkflow.setSuccess(success);
        LogWorkflow.report(this.pluginName, fullTaskDescription, false);
        LogWorkflow.restoreLogFactory();
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    protected void loadPropertiesFromPrefs() {
    }

    public void loadPropertiesFromResource(IResource resource) {
        this.getGenProperties().put("modelFile", resource.getName());
        URI resourceURI = URI.createPlatformResourceURI((String)(String.valueOf(resource.getProject().getName()) + "/" + resource.getProjectRelativePath()), (boolean)true);
        this.getGenProperties().put("modelPath", resourceURI.toPlatformString(true));
        this.getGenProperties().put("outputPath", resource.getProject().getLocation().addTrailingSeparator().toOSString());
        this.getGenProperties().put("buildProject", resource.getProject().getName());
    }

    public void handleModifiedResource(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith(this.sourceExtension)) {
            this.loadPropertiesFromResource(resource);
            this.generateModel(resource);
            try {
                resource.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.amp.amf.gen", "Couldn't refresh model.", (Throwable)e), 2);
                throw new RuntimeException("Core issue when generating model", e);
            }
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.currentMonitor = monitor;
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        this.currentMonitor = null;
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new BuilderResourceVisitor());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new BuilderDeltaVisitor());
    }

    public void setGenProperties(Map<String, String> genProps) {
        this.genProps = genProps;
    }

    public Map<String, String> getGenProperties() {
        return this.genProps;
    }

    public void setCurrentMonitor(IProgressMonitor currentMonitor) {
        this.currentMonitor = currentMonitor;
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    class BuilderDeltaVisitor
    implements IResourceDeltaVisitor {
        BuilderDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    AbstractMWEBuilder.this.handleModifiedResource(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    AbstractMWEBuilder.this.handleModifiedResource(resource);
                }
            }
            return true;
        }
    }

    class BuilderResourceVisitor
    implements IResourceVisitor {
        BuilderResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            AbstractMWEBuilder.this.handleModifiedResource(resource);
            return true;
        }
    }

    private class GenerationRunner
    extends WorkflowEngine {
        private GenerationRunner() {
        }

        public boolean executeWorkflow(Map<?, ?> externalSlotContents, Issues issues) {
            boolean result = false;
            result = super.executeWorkflow(externalSlotContents, issues);
            if (AbstractMWEBuilder.this.createMarkers) {
                AbstractMWEBuilder.this.modelMarkerHelper.addMarkers(issues);
            }
            return result;
        }
    }
}

