/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.gen.ide;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class PluginProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage projectPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.projectPage = new WizardNewProjectCreationPage("Specify model name and location.");
        this.addPage((IWizardPage)this.projectPage);
        this.setWindowTitle("Create a new " + this.getProjectTypeName() + " project.");
        this.projectPage.setDescription(this.getWindowTitle());
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectPage.getProjectName());
    }

    public boolean performFinish() {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectPage.getProjectName());
            if (this.projectPage.useDefaults()) {
                projectDescription.setLocation(null);
            } else {
                projectDescription.setLocation(this.projectPage.getLocationPath());
            }
            this.getProject().create(projectDescription, null);
            projectDescription.setNatureIds(this.getNatures().toArray(new String[0]));
            List<String> builderIDs = this.getBuilders();
            ICommand[] buildCMDS = new ICommand[builderIDs.size()];
            int i = 0;
            for (String builderID : builderIDs) {
                ICommand build = projectDescription.newCommand();
                build.setBuilderName(builderID);
                buildCMDS[i++] = build;
            }
            projectDescription.setBuildSpec(buildCMDS);
            this.getProject().open(null);
            this.getProject().setDescription(projectDescription, null);
            List<IClasspathEntry> classpathEntries = this.getClasspathsEntries();
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), null);
            javaProject.setOutputLocation((IPath)new Path("/" + this.projectPage.getProjectName() + "/bin"), null);
            this.createFiles();
            return true;
        }
        catch (Exception exception) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.getPluginID(), "Problem creating " + this.getProjectTypeName() + " project. Ignoring.", (Throwable)exception));
            try {
                this.getProject().delete(true, null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
    }

    public void createFiles() throws CoreException, IOException {
    }

    public String getProjectTypeName() {
        return "Plugin";
    }

    public String getPluginID() {
        return "org.eclipse.amp.amf.gen.ide";
    }

    public String getSourceDirName() {
        return "src";
    }

    public List<String> getNatures() {
        ArrayList<String> natures = new ArrayList<String>();
        natures.add("org.eclipse.jdt.core.javanature");
        return natures;
    }

    public List<IClasspathEntry> getClasspathsEntries() throws CoreException {
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
        IFolder srcFolder = this.getProject().getFolder(this.getSourceDirName());
        srcFolder.create(true, true, null);
        classpathEntries.add(JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
        return classpathEntries;
    }

    public List<String> getBuilders() {
        ArrayList<String> builderIDs = new ArrayList<String>();
        builderIDs.add("org.eclipse.jdt.core.javabuilder");
        return builderIDs;
    }
}

