/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera.tracking;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.camera.CameraPosition;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Vector3f;

public class TrackingUtil {
    public static CameraPosition figureToScreen(IFigure figure, ICamera camera) {
        IFigure3D fig3D = Figure3DHelper.getAncestor3D(figure);
        if (fig3D == null) {
            throw new IllegalArgumentException("Cannot retrieve 3D ancestor");
        }
        ISurface surface = fig3D.getSurface();
        if (surface == null) {
            throw new IllegalArgumentException("No surface found.");
        }
        CameraPosition pos = new CameraPosition();
        Vector3f v = Math3DCache.getVector3f();
        Vector3f v1 = Math3DCache.getVector3f();
        Vector3f v2 = Math3DCache.getVector3f();
        Vector3f v3 = Math3DCache.getVector3f();
        try {
            pos.setUpVector(surface.getUpVector());
            Math3D.scale((float)-1.0f, (IVector3f)surface.getNormal(), (Vector3f)v);
            pos.setViewDirection((IVector3f)v);
            if (figure instanceof IFigure3D) {
                IFigure3D f3D = (IFigure3D)figure;
                v1.set(f3D.getPosition3D().getCenter3D());
            } else {
                Point p2D = figure.getBounds().getCenter();
                surface.getWorldLocation(p2D, v1);
            }
            float near = camera.getNear();
            camera.unProject(0, 0, 0.0f, Matrix4f.IDENTITY, v2);
            camera.unProject(100, 100, 0.0f, Matrix4f.IDENTITY, v3);
            float projLength = Math3D.distance((IVector3f)v2, (IVector3f)v3);
            float orgLengh = (float)Math.sqrt(20000.0);
            float scale = near * (orgLengh / projLength);
            Math3D.scale((float)scale, (IVector3f)v, (Vector3f)v);
            Math3D.sub((IVector3f)v1, (IVector3f)v, (Vector3f)v1);
            pos.setPosition((IVector3f)v1);
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{v, v1, v2, v3});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{v, v1, v2, v3});
        return pos;
    }
}

