/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util.converter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.draw3d.util.BufferUtils;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ConversionPolicySpecs;
import org.eclipse.swt.graphics.ImageData;

public abstract class ConversionPolicy {
    private ConversionPolicySpecs[] m_specs;

    private ConversionPolicySpecs[] createSpecs() {
        ConversionPolicySpecs.ConversionDirection[] directions;
        ArrayList<ConversionPolicySpecs> specs = new ArrayList<ConversionPolicySpecs>();
        ConversionPolicySpecs.ConversionDirection[] conversionDirectionArray = directions = this.getSupportedDirections();
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            ConversionPolicySpecs.ConversionDirection direction = conversionDirectionArray[n2];
            int[] pixelFormats = this.getSupportedPixelFormats(direction);
            int[] dataTypes = this.getSupportedDataTypes(direction);
            int[] imageDepths = this.getSupportedImageDepths(direction);
            int[] nArray = pixelFormats;
            int n3 = pixelFormats.length;
            int n4 = 0;
            while (n4 < n3) {
                int pixelFormat = nArray[n4];
                int[] nArray2 = dataTypes;
                int n5 = dataTypes.length;
                int n6 = 0;
                while (n6 < n5) {
                    int dataType = nArray2[n6];
                    int[] nArray3 = imageDepths;
                    int n7 = imageDepths.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        int imageDepth = nArray3[n8];
                        specs.add(new ConversionPolicySpecs(direction, pixelFormat, dataType, imageDepth));
                        ++n8;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return specs.toArray(new ConversionPolicySpecs[specs.size()]);
    }

    protected byte getAlpha(int i_x, int i_y, ImageData i_imageData) {
        if (i_imageData.alpha != -1) {
            return (byte)i_imageData.alpha;
        }
        switch (i_imageData.getTransparencyType()) {
            case 2: {
                int width = i_imageData.width;
                int maskPad = i_imageData.maskPad;
                int bpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                int index = i_y * bpl + i_x / 8;
                int offset = 7 - i_x % 8;
                byte b = i_imageData.maskData[index];
                int i = b >>> offset & 1;
                if (i != 0) break;
                return 0;
            }
            case 4: {
                if (i_imageData.getPixel(i_x, i_y) != i_imageData.transparentPixel) break;
                return 0;
            }
            case 1: {
                return (byte)i_imageData.getAlpha(i_x, i_y);
            }
        }
        return -1;
    }

    private ByteBuffer getByteBuffer(ColorBufferInfo i_info, ByteBuffer io_buffer) {
        ByteBuffer buf = io_buffer;
        int size = i_info.getSize();
        if (buf == null || size > buf.capacity()) {
            buf = BufferUtils.createByteBuffer(size);
        } else if (size < buf.capacity()) {
            buf.limit(size);
        }
        return buf;
    }

    public ConversionPolicySpecs[] getSpecs() {
        if (this.m_specs == null) {
            this.m_specs = this.createSpecs();
        }
        return this.m_specs;
    }

    protected abstract int[] getSupportedDataTypes(ConversionPolicySpecs.ConversionDirection var1);

    protected abstract ConversionPolicySpecs.ConversionDirection[] getSupportedDirections();

    protected abstract int[] getSupportedImageDepths(ConversionPolicySpecs.ConversionDirection var1);

    protected abstract int[] getSupportedPixelFormats(ConversionPolicySpecs.ConversionDirection var1);

    protected boolean hasAlpha(ImageData i_imageData) {
        return i_imageData.alpha != -1 || i_imageData.alphaData != null;
    }

    protected boolean hasTransparency(ImageData i_imageData) {
        if (i_imageData == null) {
            throw new NullPointerException("i_imageData must not be null");
        }
        return i_imageData.transparentPixel != -1 || i_imageData.maskData != null;
    }

    protected boolean isMaskedTransparent(int i_x, int i_y, ImageData i_imageData) {
        int offset = i_x % 8;
        int width = i_imageData.width;
        int maskPad = i_imageData.maskPad;
        int bpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
        int index = i_y * bpl + i_x;
        byte b = i_imageData.maskData[index];
        return (1 << offset & b) != 0;
    }

    public ByteBuffer toBuffer(ColorBufferInfo i_info, ImageData i_imageData, ByteBuffer io_buffer, boolean i_flip) {
        ByteBuffer buf = this.getByteBuffer(i_info, io_buffer);
        if (!i_flip) {
            int y = 0;
            while (y < i_imageData.height) {
                int x = 0;
                while (x < i_imageData.width) {
                    i_info.putAlignedBytes(this.toBytes(x, y, i_imageData), buf);
                    ++x;
                }
                ++y;
            }
        } else {
            int y = i_imageData.height - 1;
            while (y >= 0) {
                int x = 0;
                while (x < i_imageData.width) {
                    i_info.putAlignedBytes(this.toBytes(x, y, i_imageData), buf);
                    ++x;
                }
                --y;
            }
        }
        buf.rewind();
        return buf;
    }

    protected abstract byte[] toBytes(int var1, int var2, ImageData var3);
}

