/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.ascape.util.data.DataGroup;
import org.ascape.util.data.DataSeries;
import org.ascape.util.data.DataSeriesStore;

public class DataSelection
extends Observable
implements Observer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DataGroup dataGroup;
    private boolean[] seriesSelected = new boolean[0];
    private int selectedCount = 0;

    public DataGroup getData() {
        return this.dataGroup;
    }

    public void setData(DataGroup dataGroup) {
        if (this.dataGroup != null) {
            this.dataGroup.deleteObserver(this);
        }
        this.dataGroup = dataGroup;
        if (this.dataGroup != null) {
            this.dataGroup.addObserver(this);
            this.update();
        }
    }

    public void update() {
        boolean[] newSeriesSelected = new boolean[this.dataGroup.getSize()];
        System.arraycopy(this.seriesSelected, 0, newSeriesSelected, 0, this.seriesSelected.length);
        this.seriesSelected = newSeriesSelected;
    }

    public boolean isSelected(DataSeries series) {
        int i = 0;
        while (i < this.seriesSelected.length) {
            if (this.seriesSelected[i] && this.dataGroup.getSeries(i) == series) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSelected(int index) {
        return this.seriesSelected[index];
    }

    public synchronized void selectAll() {
        this.selectedCount = this.dataGroup.getSize();
        int i = 0;
        while (i < this.seriesSelected.length) {
            this.seriesSelected[i] = true;
            ++i;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void clearSelection() {
        this.selectedCount = 0;
        int i = 0;
        while (i < this.seriesSelected.length) {
            this.seriesSelected[i] = false;
            ++i;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setSelected(int index, boolean select) {
        if (select && !this.seriesSelected[index]) {
            ++this.selectedCount;
        } else if (!select && this.seriesSelected[index]) {
            --this.selectedCount;
        }
        this.seriesSelected[index] = select;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void setSelected(String name, boolean select) {
        int index = this.dataGroup.getIndexOfSeries(name);
        if (index == -1) {
            throw new RuntimeException("Series \"" + name + "\" does not exist.");
        }
        this.setSelected(index, select);
    }

    public synchronized void setSelected(DataSeries series, boolean select) {
        int index = this.dataGroup.getIndexOfSeries(series);
        if (index == -1) {
            throw new RuntimeException("Series does not exist.");
        }
        this.setSelected(index, select);
    }

    public int getSelectionSize() {
        return this.selectedCount;
    }

    public int getIndexOfSelectedIndex(int index) {
        int count = 0;
        int i = 0;
        while (i < this.dataGroup.getSize()) {
            if (this.seriesSelected[i]) {
                if (count == index) {
                    return i;
                }
                ++count;
            }
            ++i;
        }
        throw new RuntimeException("Selection index out of range in DataSelection.");
    }

    public int getSelectedIndexOf(String name) {
        if (name.startsWith("Total")) {
            System.out.println("***Warning, using \"" + name + "\" to reference statistic series.");
            name = "Sum " + name.substring(6, Integer.MAX_VALUE);
            System.out.println("Usage is deprecated, use \"" + name + "\" instead.***");
        }
        int count = 0;
        int i = 0;
        while (i < this.dataGroup.getSize()) {
            if (this.seriesSelected[i]) {
                if (this.dataGroup.getSeries(i).getName().equals(name)) {
                    return count;
                }
                ++count;
            }
            ++i;
        }
        return -1;
    }

    public String getSelectedName(int index) {
        return this.dataGroup.getSeriesNames()[this.getIndexOfSelectedIndex(index)];
    }

    public DataSeries getSelectedSeries(int index) {
        return this.dataGroup.getSeries(this.getIndexOfSelectedIndex(index));
    }

    public List getSelectedSeries() {
        DataSeries[] allSelected = new DataSeries[this.selectedCount];
        int index = 0;
        int i = 0;
        while (i < this.dataGroup.getSize()) {
            if (this.seriesSelected[i]) {
                allSelected[index] = this.dataGroup.getSeries(i);
                ++index;
            }
            ++i;
        }
        return Arrays.asList(allSelected);
    }

    public List getSelectedSeriesData(int index) {
        try {
            return ((DataSeriesStore)this.getSelectedSeries(index)).toList();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public double getMax() {
        this.update();
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.seriesSelected.length) {
            if (this.seriesSelected[i] && this.dataGroup.getSeries(i).getMax() > max) {
                max = this.dataGroup.getSeries(i).getMax();
            }
            ++i;
        }
        return max;
    }

    public double getMin() {
        this.update();
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.seriesSelected.length) {
            if (this.seriesSelected[i] && this.dataGroup.getSeries(i).getMin() < min) {
                min = this.dataGroup.getSeries(i).getMin();
            }
            ++i;
        }
        return min;
    }

    @Override
    public void update(Observable observed, Object arg) {
        if (observed == this.dataGroup) {
            this.update();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Object clone() {
        try {
            DataSelection clone = (DataSelection)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

