/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextRenderRule;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFont;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontManager;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVBO;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class LwjglTextVBO
extends LwjglVBO {
    private boolean m_buffersInitialized = false;
    private float[] m_color;
    private ByteBuffer m_colorBuffer;
    private LwjglFont m_glFont;
    private PrimitiveSet m_primitives;
    private FloatBuffer m_texCoordBuffer;
    private FloatBuffer m_vertexBuffer;
    private int m_vertexCount;

    public LwjglTextVBO(PrimitiveSet i_primitives, LwjglFontManager i_fontManager) {
        if (i_primitives == null) {
            throw new NullPointerException("i_primitives must not be null");
        }
        if (i_fontManager == null) {
            throw new NullPointerException("i_fontManager must not be null");
        }
        if (i_primitives.getSize() == 0) {
            throw new IllegalArgumentException(i_primitives + " is empty");
        }
        PrimitiveClass primitiveClass = i_primitives.getPrimitiveClass();
        if (!primitiveClass.isText()) {
            throw new IllegalArgumentException(i_primitives + " does not contain text primitives");
        }
        this.m_primitives = i_primitives;
        PrimitiveClass clazz = this.m_primitives.getPrimitiveClass();
        TextRenderRule renderRule = clazz.getRenderRule().asText();
        Font font = renderRule.getFont();
        boolean fontAntialias = renderRule.isFontAntialias();
        this.m_glFont = i_fontManager.getFont(font, ' ', '\u007f', fontAntialias);
        boolean first = true;
        Color constColor = null;
        int constAlpha = -1;
        this.m_vertexCount = 0;
        for (Primitive primitive : this.m_primitives.getPrimitives()) {
            TextPrimitive textPrimitive = (TextPrimitive)primitive;
            TextRenderRule textRenderRule = textPrimitive.getRenderRule().asText();
            String text = textPrimitive.getText();
            Color color = textRenderRule.getTextColor();
            int alpha = textRenderRule.getAlpha();
            if (first) {
                constColor = color;
                constAlpha = alpha;
                first = false;
            } else if (!(constColor == null || constColor.equals((Object)color) && constAlpha == alpha)) {
                constColor = null;
                constAlpha = -1;
            }
            this.m_vertexCount += 4 * this.m_glFont.getLength(text);
        }
        if (constColor != null) {
            this.m_color = ColorConverter.toFloatArray(constColor, (int)constAlpha, null);
        }
    }

    protected void cleanup(Graphics3D i_g3d, ILodHelper i_lodContext) {
        GL11.glPopAttrib();
    }

    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        if (this.m_color != null) {
            i_g3d.glColor4f(this.m_color);
        }
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glDrawArrays((int)7, (int)0, (int)this.m_vertexCount);
    }

    protected Buffer getBuffer(LwjglVBO.BufferType i_type) {
        this.initBuffers();
        switch (i_type) {
            case VERTEX: {
                return this.m_vertexBuffer;
            }
            case COLOR: {
                return this.m_colorBuffer;
            }
            case TEXTURE_COORDINATES: {
                return this.m_texCoordBuffer;
            }
        }
        return null;
    }

    protected LwjglVBO.BufferInfo getBufferInfo(LwjglVBO.BufferType i_type) {
        switch (i_type) {
            case VERTEX: {
                return new LwjglVBO.BufferInfo(5126, 35041, 2, 0, 0);
            }
            case COLOR: {
                return new LwjglVBO.BufferInfo(5120, 35041, 4, 0, 0);
            }
            case TEXTURE_COORDINATES: {
                return new LwjglVBO.BufferInfo(5126, 35041, 2, 0, 0);
            }
        }
        return null;
    }

    protected boolean hasBuffer(LwjglVBO.BufferType i_type) {
        switch (i_type) {
            case TEXTURE_COORDINATES: 
            case VERTEX: {
                return true;
            }
            case COLOR: {
                return this.m_color == null;
            }
        }
        return false;
    }

    private void initBuffers() {
        if (this.m_buffersInitialized) {
            return;
        }
        this.m_vertexBuffer = BufferUtils.createFloatBuffer((int)(2 * this.m_vertexCount));
        this.m_texCoordBuffer = BufferUtils.createFloatBuffer((int)(2 * this.m_vertexCount));
        if (this.m_color == null) {
            this.m_colorBuffer = BufferUtils.createByteBuffer((int)(4 * this.m_vertexCount));
        }
        byte[] c = new byte[4];
        for (Primitive primitive : this.m_primitives.getPrimitives()) {
            TextPrimitive textPrimitive = (TextPrimitive)primitive;
            String text = textPrimitive.getText();
            boolean expand = textPrimitive.isExpand();
            Point position = textPrimitive.getPosition();
            IMatrix3f transformation = textPrimitive.getTransformation();
            if (this.m_color != null) continue;
            TextRenderRule textRenderRule = textPrimitive.getRenderRule().asText();
            Color color = textRenderRule.getTextColor();
            int alpha = textRenderRule.getAlpha();
            this.m_colorBuffer.put(ColorConverter.toByteArray((Color)color, (int)alpha, (byte[])c));
        }
        this.m_buffersInitialized = true;
    }

    protected void prepare(Graphics3D i_g3d, ILodHelper i_lodContext) {
        GL11.glPushAttrib((int)262144);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.m_glFont.getTextureId());
    }

    protected void stateChanged(LwjglVBO.State i_oldState, LwjglVBO.State i_newState) {
        super.stateChanged(i_oldState, i_newState);
        if (i_newState == LwjglVBO.State.READY) {
            this.m_primitives = null;
            this.m_vertexBuffer = null;
            this.m_texCoordBuffer = null;
            this.m_colorBuffer = null;
        }
    }
}

