/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.swt.RegionAction;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.device.swt.util.SwtUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.InteractiveRenderer;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwtEventHandler
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
KeyListener,
FocusListener {
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swt");
    private final org.eclipse.swt.graphics.Cursor hand_cursor;
    private final LinkedHashMap<TriggerCondition, List<RegionAction>> lhmAllTriggers;
    private final IUpdateNotifier iun;
    private RegionAction raTooltip = null;
    private final ULocale lcl;
    private final GC _gc;
    private InteractiveRenderer iv = null;
    private StructureSource srcHighlight;
    private StructureSource srcToggleDataPoint;
    private StructureSource srcToggleVisibility;
    private Menu popupMenu;

    SwtEventHandler(InteractiveRenderer iv, LinkedHashMap<TriggerCondition, List<RegionAction>> _lhmAllTriggers, IUpdateNotifier _jc, ULocale _lcl) {
        this.lhmAllTriggers = _lhmAllTriggers;
        this.iun = _jc;
        this.lcl = _lcl;
        this.hand_cursor = new org.eclipse.swt.graphics.Cursor((Device)Display.getDefault(), 21);
        this._gc = new GC((Drawable)Display.getDefault());
        this.iv = iv;
    }

    private final List<RegionAction> getActionsForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        ArrayList<RegionAction> al = new ArrayList<RegionAction>();
        int i = 0;
        while (i < tca.length) {
            List<RegionAction> tal = this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                al.addAll(tal);
            }
            ++i;
        }
        if (al.size() > 0) {
            return al;
        }
        return null;
    }

    private final boolean isLeftButton(MouseEvent e) {
        return e.button == 1;
    }

    private void handleAction(TriggerCondition[] tgArray, Object event) {
        this.handleAction(tgArray, event, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void handleAction(TriggerCondition[] tgArray, Object event, boolean cleanState) {
        List<RegionAction> al = this.getActionsForConditions(tgArray);
        if (al == null || event == null) {
            return;
        }
        RegionAction ra = null;
        Action ac = null;
        Point p = null;
        if (event instanceof MouseEvent) {
            p = new Point(((MouseEvent)event).x, ((MouseEvent)event).y);
        }
        boolean cfr_ignored_0 = event instanceof KeyEvent;
        boolean bFound = false;
        int i = 0;
        block8: while (i < al.size()) {
            ra = al.get(i);
            if (p == null || ra.contains(p, this._gc)) {
                ac = ra.getAction();
                StructureSource src = ra.getSource();
                switch (ac.getType().getValue()) {
                    case 0: {
                        ActionValue av = ac.getValue();
                        if (av instanceof URLValue) {
                            URLValue uv = (URLValue)ac.getValue();
                            this.openURL(uv);
                            break block8;
                        }
                        if (!(av instanceof MultiURLValues)) break block8;
                        MultiURLValues muv = (MultiURLValues)av;
                        int size = muv.getURLValues().size();
                        if (size == 0) break;
                        if (size == 1) {
                            this.openURL((URLValue)muv.getURLValues().get(0));
                            break block8;
                        }
                        this.openMultiURLs(muv, p);
                        break block8;
                    }
                    case 1: {
                        if (ra != this.raTooltip) {
                            this.hideTooltip();
                        }
                        this.raTooltip = ra;
                        bFound = true;
                        this.showTooltip(this.raTooltip);
                        break block8;
                    }
                    case 2: {
                        bFound = true;
                        this.srcToggleVisibility = this.handleGraphicAction(src, this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL, cleanState);
                        break block8;
                    }
                    case 6: {
                        bFound = true;
                        this.srcToggleDataPoint = this.handleGraphicAction(src, this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, cleanState);
                        break block8;
                    }
                    case 4: {
                        bFound = true;
                        this.srcHighlight = this.handleGraphicAction(src, this.srcHighlight, ActionType.HIGHLIGHT_LITERAL, cleanState);
                        break block8;
                    }
                    case 5: {
                        if (this.iun instanceof ICallBackNotifier) {
                            CallBackValue cv = (CallBackValue)ac.getValue();
                            ((ICallBackNotifier)this.iun).callback(event, (Object)ra.getSource(), cv);
                            break block8;
                        }
                        logger.log(2, Messages.getString("SwtEventHandler.info.improper.callback.notifier", new Object[]{this.iun}, this.lcl));
                        break block8;
                    }
                }
            }
            ++i;
        }
        if (!bFound) {
            this.disableActions(this.getActionTypesForConditions(tgArray));
        }
    }

    private void openMultiURLs(MultiURLValues muv, Point point) {
        Composite comp = (Composite)this.iun.peerInstance();
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        this.popupMenu = new Menu((Decorations)comp.getShell(), 8);
        comp.setMenu(this.popupMenu);
        for (URLValue uv : muv.getURLValues()) {
            MenuItem menuItem = new MenuItem(this.popupMenu, 8);
            menuItem.setText(uv.getLabel().getCaption().getValue());
            menuItem.setData((Object)uv);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    URLValue urlValue = (URLValue)((MenuItem)e.getSource()).getData();
                    SwtEventHandler.this.openURL(urlValue);
                    SwtEventHandler.this.popupMenu.dispose();
                }
            });
        }
        comp.getMenu().setVisible(true);
    }

    private void openURL(URLValue uv) {
        logger.log(1, String.valueOf(Messages.getString("SwtEventHandler.info.redirect.url", this.lcl)) + uv.getBaseUrl());
        SwtUtil.openURL(uv.getBaseUrl());
    }

    protected Set<ActionType> getActionTypesForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        HashSet<ActionType> set = new HashSet<ActionType>();
        int i = 0;
        while (i < tca.length) {
            List<RegionAction> tal = this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                for (RegionAction rg : tal) {
                    ActionType actionType = rg.getAction().getType();
                    set.add(actionType);
                }
            }
            ++i;
        }
        return set;
    }

    private void disableActions(Set<ActionType> actions) {
        if (actions == null) {
            return;
        }
        for (ActionType action : actions) {
            if (action == null) continue;
            switch (action.getValue()) {
                case 1: {
                    if (this.raTooltip == null) break;
                    this.hideTooltip();
                    this.raTooltip = null;
                    break;
                }
                case 4: {
                    if (this.srcHighlight == null) break;
                    this.iv.unregisterAction(this.srcHighlight, ActionType.HIGHLIGHT_LITERAL);
                    this.srcHighlight = null;
                    this.iun.repaintChart();
                    break;
                }
                case 6: {
                    if (this.srcToggleDataPoint == null) break;
                    this.iv.unregisterAction(this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL);
                    this.srcToggleDataPoint = null;
                    this.iun.repaintChart();
                    break;
                }
                case 2: {
                    if (this.srcToggleVisibility == null) break;
                    this.iv.unregisterAction(this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL);
                    this.srcToggleVisibility = null;
                    this.iun.repaintChart();
                }
            }
        }
    }

    private StructureSource handleGraphicAction(StructureSource src, StructureSource previousSrc, ActionType actionType, boolean cleanState) {
        if (previousSrc == null) {
            previousSrc = src;
            this.iv.registerAction(src, actionType);
            this.iun.repaintChart();
        } else if (!this.iv.getSource(src).equals(this.iv.getSource(previousSrc))) {
            if (actionType == ActionType.HIGHLIGHT_LITERAL) {
                this.iv.unregisterAction(previousSrc, actionType);
                previousSrc = src;
                this.iv.registerAction(src, actionType);
            } else {
                previousSrc = src;
                if (this.iv.isRegisteredAction(src, actionType)) {
                    this.iv.unregisterAction(src, actionType);
                } else {
                    this.iv.registerAction(src, actionType);
                }
            }
            this.iun.repaintChart();
        } else if (cleanState) {
            this.iv.unregisterAction(previousSrc, actionType);
            previousSrc = null;
            this.iun.repaintChart();
        }
        return previousSrc;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        TriggerCondition[] tgArray = new TriggerCondition[]{TriggerCondition.ONDBLCLICK_LITERAL};
        this.handleAction(tgArray, e);
    }

    public void mouseDown(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        TriggerCondition[] tgArray = new TriggerCondition[]{TriggerCondition.ONMOUSEDOWN_LITERAL};
        this.handleAction(tgArray, e);
    }

    public void mouseUp(MouseEvent e) {
        TriggerCondition[] triggerConditionArray;
        if (this.isLeftButton(e)) {
            TriggerCondition[] triggerConditionArray2 = new TriggerCondition[3];
            triggerConditionArray2[0] = TriggerCondition.ONMOUSEUP_LITERAL;
            triggerConditionArray2[1] = TriggerCondition.ONCLICK_LITERAL;
            triggerConditionArray = triggerConditionArray2;
            triggerConditionArray2[2] = TriggerCondition.MOUSE_CLICK_LITERAL;
        } else {
            TriggerCondition[] triggerConditionArray3 = new TriggerCondition[1];
            triggerConditionArray = triggerConditionArray3;
            triggerConditionArray3[0] = TriggerCondition.ONRIGHTCLICK_LITERAL;
        }
        TriggerCondition[] tgArray = triggerConditionArray;
        this.handleAction(tgArray, e);
    }

    public void mouseMove(MouseEvent e) {
        List<RegionAction> al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONCLICK_LITERAL, TriggerCondition.ONMOUSEDOWN_LITERAL, TriggerCondition.MOUSE_CLICK_LITERAL, TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL});
        if (al != null) {
            boolean bFound = false;
            int i = 0;
            while (i < al.size()) {
                RegionAction ra = al.get(i);
                if (ra.contains(e.x, e.y, this._gc)) {
                    this.setCursor((Composite)this.iun.peerInstance(), ra.getCursor(), this.hand_cursor);
                    bFound = true;
                    break;
                }
                ++i;
            }
            if (!bFound) {
                this.setCursor((Composite)this.iun.peerInstance(), null, null);
            }
        }
        TriggerCondition[] tgArray = new TriggerCondition[]{TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL};
        this.handleAction(tgArray, e, false);
    }

    public void keyPressed(KeyEvent e) {
        TriggerCondition[] tg = new TriggerCondition[]{TriggerCondition.ONKEYDOWN_LITERAL};
        this.handleAction(tg, e);
    }

    public void keyReleased(KeyEvent e) {
        TriggerCondition[] tg = new TriggerCondition[]{TriggerCondition.ONKEYUP_LITERAL, TriggerCondition.ONKEYPRESS_LITERAL};
        this.handleAction(tg, e);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        TriggerCondition[] tg = new TriggerCondition[]{TriggerCondition.ONMOUSEOUT_LITERAL};
        this.handleAction(tg, e);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONFOCUS_LITERAL}, e);
    }

    public void focusLost(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONBLUR_LITERAL}, e);
    }

    private final void hideTooltip() {
        ((Composite)this.iun.peerInstance()).setToolTipText(null);
    }

    private final void showTooltip(RegionAction ra) {
        Action ac = ra.getAction();
        TooltipValue tv = (TooltipValue)ac.getValue();
        String s = tv.getText();
        ((Composite)this.iun.peerInstance()).setToolTipText(s);
    }

    private void setCursor(Composite composite, Cursor cursor, org.eclipse.swt.graphics.Cursor defaultCursor) {
        if (cursor == null || cursor.getType() == CursorType.AUTO) {
            composite.setCursor(defaultCursor);
            return;
        }
        if (cursor.getType() == CursorType.CUSTOM) {
            EList uris = cursor.getImage();
            for (Image uri : uris) {
                try {
                    ImageData id = null;
                    if (uri instanceof EmbeddedImage) {
                        ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])((EmbeddedImage)uri).getData().getBytes()));
                        id = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)bis).getImageData();
                    } else {
                        File f = SecurityUtil.newFile((URI)new URI(uri.getURL()));
                        id = new ImageData((InputStream)SecurityUtil.newFileInputStream((File)f));
                    }
                    composite.setCursor(new org.eclipse.swt.graphics.Cursor((Device)composite.getDisplay(), id, 0, 0));
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (Exception exception) {}
            }
            composite.setCursor(defaultCursor);
            return;
        }
        composite.setCursor(new org.eclipse.swt.graphics.Cursor((Device)Display.getDefault(), SwtUtil.CURSOR_MAP.get(cursor.getType()).intValue()));
    }

    public final void dispose() {
        this.hand_cursor.dispose();
        this._gc.dispose();
    }
}

