/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.IBreadcrumbDropDownSite;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public abstract class TreeViewerDropDown {
    private static boolean DEBUG = DebugUIPlugin.DEBUG && "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/breadcrumb"));
    private static long MOUSE_MOVE_SCROLL_DELAY = 500L;
    private IBreadcrumbDropDownSite fDropDownSite;
    private TreeViewer fDropDownViewer;

    public Control createDropDown(Composite composite, IBreadcrumbDropDownSite site, TreePath path) {
        this.fDropDownSite = site;
        this.fDropDownViewer = this.createTreeViewer(composite, 772, path);
        this.fDropDownViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (DEBUG) {
                    System.out.println("BreadcrumbItemDropDown.showMenu()$treeViewer>open");
                }
                TreeViewerDropDown.this.openElement(event.getSelection());
            }
        });
        final Tree tree = this.fDropDownViewer.getTree();
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (DEBUG) {
                    System.out.println("BreadcrumbItemDropDown.showMenu()$treeViewer>mouseUp");
                }
                if (e.button != 1) {
                    return;
                }
                if ((OpenStrategy.getOpenMethod() & 1) != 0) {
                    return;
                }
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                LinkedList<Object> pathElements = new LinkedList<Object>();
                while (item != null) {
                    Object data = item.getData();
                    if (data == null) {
                        return;
                    }
                    pathElements.add(0, data);
                    item = item.getParentItem();
                }
                TreeViewerDropDown.this.openElement((ISelection)new TreeSelection(new TreePath(pathElements.toArray())));
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;
            long fLastScrollTime = 0L;

            public void mouseMove(MouseEvent e) {
                if (tree.equals(e.getSource())) {
                    TreeItem o;
                    if (this.fLastItem == null ^ (o = tree.getItem(new Point(e.x, e.y))) == null) {
                        tree.setCursor(o == null ? null : tree.getDisplay().getSystemCursor(21));
                    }
                    if (o instanceof TreeItem) {
                        TreeItem currentItem = o;
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        } else if (System.currentTimeMillis() > this.fLastScrollTime + MOUSE_MOVE_SCROLL_DELAY) {
                            if (e.y < tree.getItemHeight() / 4) {
                                if (currentItem.getParentItem() == null) {
                                    int index = tree.indexOf(o);
                                    if (index < 1) {
                                        return;
                                    }
                                    this.fLastItem = tree.getItem(index - 1);
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                } else {
                                    Point p = tree.toDisplay(e.x, e.y);
                                    Item item = TreeViewerDropDown.this.fDropDownViewer.scrollUp(p.x, p.y);
                                    this.fLastScrollTime = System.currentTimeMillis();
                                    if (item instanceof TreeItem) {
                                        this.fLastItem = (TreeItem)item;
                                        tree.setSelection(new TreeItem[]{this.fLastItem});
                                    }
                                }
                            } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                                if (currentItem.getParentItem() == null) {
                                    int index = tree.indexOf(o);
                                    if (index >= tree.getItemCount() - 1) {
                                        return;
                                    }
                                    this.fLastItem = tree.getItem(index + 1);
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                } else {
                                    Point p = tree.toDisplay(e.x, e.y);
                                    Item item = TreeViewerDropDown.this.fDropDownViewer.scrollDown(p.x, p.y);
                                    this.fLastScrollTime = System.currentTimeMillis();
                                    if (item instanceof TreeItem) {
                                        this.fLastItem = (TreeItem)item;
                                        tree.setSelection(new TreeItem[]{this.fLastItem});
                                    }
                                }
                            }
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    if (tree.getItemCount() == 0) {
                        TreeViewerDropDown.this.fDropDownSite.close();
                        return;
                    }
                    TreeItem[] selection = tree.getSelection();
                    if (selection.length != 1) {
                        return;
                    }
                    int selectionIndex = tree.indexOf(selection[0]);
                    if (selectionIndex != 0) {
                        return;
                    }
                    TreeViewerDropDown.this.fDropDownSite.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fDropDownViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                tree.setRedraw(false);
                new UIJob(this, tree.getDisplay(), "", tree){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ Tree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$tree = tree;
                        this.setSystem(true);
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!this.val$tree.isDisposed()) {
                            try {
                                TreeViewerDropDown.access$3(5.access$0(this.this$1)).updateSize();
                            }
                            finally {
                                this.val$tree.setRedraw(true);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            static /* synthetic */ TreeViewerDropDown access$0(5 var0) {
                return var0.TreeViewerDropDown.this;
            }
        });
        return tree;
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2, TreePath var3);

    protected void openElement(ISelection selection) {
        boolean treeHasFocus;
        if (selection == null || !(selection instanceof ITreeSelection) || selection.isEmpty()) {
            return;
        }
        this.fDropDownSite.notifySelection(selection);
        Tree tree = this.fDropDownViewer.getTree();
        boolean bl = treeHasFocus = !tree.isDisposed() && tree.isFocusControl();
        if (DEBUG) {
            System.out.println("    isDisposed: " + tree.isDisposed());
            System.out.println("    shell hasFocus: " + (!tree.isDisposed() && tree.isFocusControl()));
            System.out.println("    tree hasFocus: " + treeHasFocus);
        }
        if (tree.isDisposed()) {
            return;
        }
        if (!treeHasFocus) {
            this.fDropDownSite.close();
            return;
        }
        this.toggleExpansionState(((ITreeSelection)selection).getPaths()[0]);
    }

    private void toggleExpansionState(TreePath path) {
        Tree tree = this.fDropDownViewer.getTree();
        if (this.fDropDownViewer.getExpandedState((Object)path)) {
            this.fDropDownViewer.collapseToLevel((Object)path, 1);
        } else {
            tree.setRedraw(false);
            try {
                this.fDropDownViewer.expandToLevel((Object)path, 1);
                this.fDropDownSite.updateSize();
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }
}

