/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.mwe;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.container.CompositeComponent;
import org.eclipse.emf.mwe.core.debug.model.NameValuePair;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.core.debug.processing.ElementAdapter;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;
import org.eclipse.emf.mwe.internal.core.ast.parser.XmlLocationAnalyser;
import org.eclipse.emf.mwe.internal.core.debug.mwe.ReflectionUtil;
import org.eclipse.emf.mwe.internal.core.util.ComponentPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowElementAdapter
implements ElementAdapter {
    public static final String TYPE = "workflow";
    private Object context;
    private CompositeComponent root;
    private final XmlLocationAnalyser locationAnalyser = new XmlLocationAnalyser();

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public String getAdapterType() {
        return TYPE;
    }

    @Override
    public boolean canHandle(Object element) {
        if (element instanceof WorkflowComponent) {
            if (this.root == null) {
                this.root = ((WorkflowComponent)element).getContainer();
            }
            return true;
        }
        if (element instanceof SyntaxElement) {
            SyntaxElement se = (SyntaxElement)element;
            return se.resource.endsWith(".oaw");
        }
        return false;
    }

    @Override
    public boolean shallHandle(Object element) {
        return true;
    }

    @Override
    public boolean shallSuspend(Object element, int flag) {
        return true;
    }

    @Override
    public boolean isSurroundingElement(Object element) {
        return CompositeComponent.class.isAssignableFrom(element.getClass());
    }

    @Override
    public SyntaxElement createElement(Object element) {
        WorkflowComponent comp = (WorkflowComponent)element;
        SyntaxElement se = new SyntaxElement();
        Location loc = comp.getLocation();
        loc = this.initialize(loc);
        se.containerName = ComponentPrinter.getContainerName(comp);
        se.elementName = ComponentPrinter.getElementName(comp);
        se.resource = loc.getResource();
        se.start = loc.getNameStart();
        se.end = loc.getNameEnd();
        se.line = loc.getLineNumber();
        return se;
    }

    @Override
    public SyntaxElement createEndElementTO(Object element) {
        CompositeComponent comp = (CompositeComponent)element;
        SyntaxElement se = new SyntaxElement();
        Location loc = comp.getOwnLocation();
        if (loc == null) {
            loc = comp.getLocation();
        }
        loc = this.initializeEndLocation(loc);
        se.containerName = ComponentPrinter.getElementName(comp);
        se.elementName = "end of cartridge";
        if (loc != null) {
            se.resource = loc.getResource();
            se.start = loc.getNameStart();
            se.end = loc.getNameEnd();
            se.line = loc.getLineNumber();
        }
        return se;
    }

    @Override
    public List<NameValuePair> getVariables(Object element) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (element instanceof WorkflowComponent) {
            WorkflowContext ctx = (WorkflowContext)this.context;
            String[] stringArray = ctx.getSlotNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                list.add(new NameValuePair(name, ctx.get(name)));
                ++n2;
            }
        } else {
            int i = 0;
            for (String name : ReflectionUtil.getFieldNames(element)) {
                Object childElement = element instanceof Object[] ? ((Object[])element)[i++] : ReflectionUtil.getFieldValue(element, name);
                list.add(new NameValuePair(name, childElement));
            }
        }
        return list;
    }

    @Override
    public String getVariableDetailRep(Object element) {
        return ReflectionUtil.getNameToString(element);
    }

    @Override
    public String getVariableSimpleRep(Object element) {
        return ReflectionUtil.getSimpleName(element);
    }

    @Override
    public boolean checkVariableHasMembers(Object element) {
        return ReflectionUtil.checkFields(element);
    }

    @Override
    public Object findElement(SyntaxElement se, Object actual, int flag) {
        if (this.root == null) {
            return null;
        }
        return this.findComponent(this.root, se.resource, se.line);
    }

    private Object findComponent(CompositeComponent parent, String resource, int lineNo) {
        Location loc = parent.getOwnLocation();
        if (loc == null) {
            loc = parent.getLocation();
        }
        if (resource.endsWith(loc.getResource())) {
            for (WorkflowComponent comp : parent.getComponents()) {
                if (comp.getLocation().getLineNumber() != lineNo) continue;
                return comp;
            }
        }
        for (WorkflowComponent comp : parent.getComponents()) {
            CompositeComponent child;
            Object found;
            if (!(comp instanceof CompositeComponent) || (found = this.findComponent(child = (CompositeComponent)comp, resource, lineNo)) == null) continue;
            return found;
        }
        return null;
    }

    private Location initialize(Location loc) {
        if (loc.getResource() == null) {
            return null;
        }
        return this.locationAnalyser.adapt(loc);
    }

    private Location initializeEndLocation(Location loc) {
        if (loc.getResource() == null) {
            return null;
        }
        return this.locationAnalyser.adaptEnd(loc);
    }
}

