/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class OpenTypeAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        try {
            while (itr.hasNext()) {
                Object element = itr.next();
                Object sourceElement = this.resolveSourceElement(element);
                if (sourceElement != null) {
                    this.openInEditor(sourceElement);
                    continue;
                }
                Status status = new Status(1, IJavaDebugUIConstants.PLUGIN_ID, 150, "Source not found", null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }

    protected abstract IDebugElement getDebugElement(IAdaptable var1);

    protected abstract IJavaType getTypeToOpen(IDebugElement var1) throws CoreException;

    protected Object resolveSourceElement(Object e) throws CoreException {
        IType source = null;
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            IJavaType type = this.getTypeToOpen(dbgElement);
            while (type instanceof IJavaArrayType) {
                type = ((IJavaArrayType)type).getComponentType();
            }
            if (type != null && (source = JavaDebugUtils.resolveType((IJavaType)type)) == null) {
                source = OpenTypeAction.findTypeInWorkspace(type.getName());
            }
        }
        return source;
    }

    protected void openInEditor(Object sourceElement) throws CoreException {
        if (this.isHierarchy()) {
            if (sourceElement instanceof IJavaElement) {
                OpenTypeHierarchyUtil.open((IJavaElement)((IJavaElement)sourceElement), (IWorkbenchWindow)this.getWorkbenchWindow());
            } else {
                this.typeHierarchyError();
            }
        } else if (sourceElement instanceof IJavaElement) {
            JavaUI.openInEditor((IJavaElement)((IJavaElement)sourceElement));
        } else {
            this.showErrorMessage(ActionMessages.OpenTypeAction_2);
        }
    }

    protected boolean isHierarchy() {
        return false;
    }

    public static IType findTypeInWorkspace(String typeName) throws CoreException {
        class ResultException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IType fType;

            public ResultException(IType type) {
                this.fType = type;
            }
        }
        String simpleName;
        Object qualifications;
        int dot = typeName.lastIndexOf(46);
        if (dot != -1) {
            qualifications = new char[][]{typeName.substring(0, dot).toCharArray()};
            simpleName = typeName.substring(dot + 1);
        } else {
            qualifications = null;
            simpleName = typeName;
        }
        char[][] typeNames = new char[][]{simpleName.toCharArray()};
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                throw new ResultException(match.getType());
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(qualifications, (char[][])typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        }
        catch (ResultException e) {
            return e.fType;
        }
        return null;
    }

    protected void typeHierarchyError() {
        this.showErrorMessage(ActionMessages.ObjectActionDelegate_Unable_to_display_type_hierarchy__The_selected_source_element_is_not_contained_in_the_workspace__1);
    }
}

