/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class ModifierChangeCorrectionProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private ASTNode fNode;
    private int fIncludedModifiers;
    private int fExcludedModifiers;

    public ModifierChangeCorrectionProposal(String label, ICompilationUnit targetCU, IBinding binding, ASTNode node, int includedModifiers, int excludedModifiers, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        this.fBinding = binding;
        this.fNode = node;
        this.fIncludedModifiers = includedModifiers;
        this.fExcludedModifiers = excludedModifiers;
    }

    protected ASTRewrite getRewrite() {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode boundNode = astRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            CompilationUnit newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            if (declNode.getNodeType() == 59) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)declNode;
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        VariableDeclarationRewrite.rewriteModifiers(fieldDecl, new VariableDeclarationFragment[]{fragment}, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, null);
                        return rewrite;
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        VariableDeclarationRewrite.rewriteModifiers(varDecl, new VariableDeclarationFragment[]{fragment}, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, null);
                        return rewrite;
                    }
                } else {
                    boolean cfr_ignored_0 = parent instanceof VariableDeclarationExpression;
                }
                declNode = parent;
            }
            ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, declNode);
            LinkedProposalPositionGroup.PositionInformation trackedDeclNode = listRewrite.setModifiers(this.fIncludedModifiers, this.fExcludedModifiers, null);
            LinkedProposalPositionGroup positionGroup = new LinkedProposalPositionGroup("group");
            positionGroup.addPosition(trackedDeclNode);
            this.getLinkedProposalModel().addPositionGroup(positionGroup);
            if (boundNode != null) {
                this.setEndPosition(rewrite.track(this.fNode));
            }
            return rewrite;
        }
        return null;
    }
}

