/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ControlHolder;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public class Composite
extends Scrollable {
    private Layout layout;
    int layoutCount;
    private final ControlHolder controlHolder = new ControlHolder();
    private Control[] tabList;
    int backgroundMode;
    static /* synthetic */ Class class$0;

    Composite(Composite parent) {
        super(parent);
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    void initState() {
        if ((this.style & 0x300) == 0) {
            this.state |= 0x100;
        }
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this.controlHolder.getControls();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.ControlHolder$IControlHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = adapter == clazz ? this.controlHolder : super.getAdapter(adapter);
        return result;
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public void setLayoutDeferred(boolean defer) {
        this.checkWidget();
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x80) != 0 || (this.state & 0x20) != 0)) {
                this.updateLayout(true, true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout != null) {
            this.layout(changed, false);
        }
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout != null || all) {
            this.markLayout(changed, all);
            this.updateLayout(true, all);
        }
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i = 0;
            while (i < changed.length) {
                Control control = changed[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control.parent;
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite.parent;
                }
                if (!ancestor) {
                    this.error(32);
                }
                ++i;
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            int i2 = 0;
            while (i2 < changed.length) {
                Control child = changed[i2];
                Composite composite = child.parent;
                while (child != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x20;
                        if (!composite.layout.flushCache(child)) {
                            composite.state |= 0x40;
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child.parent;
                }
                ++i2;
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            i2 = updateCount - 1;
            while (i2 >= 0) {
                update[i2].updateLayout(false);
                --i2;
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x20;
            if (changed) {
                this.state |= 0x40;
            }
        }
        if (all) {
            Control[] children = this.controlHolder.getControls();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    void updateLayout(boolean all) {
        this.updateLayout(true, all);
    }

    void updateLayout(boolean resize, boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x80;
            return;
        }
        if ((this.state & 0x20) != 0) {
            boolean changed = (this.state & 0x40) != 0;
            this.state &= 0xFFFFFF9F;
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFFF7F;
            Control[] children = this.controlHolder.getControls();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(resize, all);
                ++i;
            }
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        boolean hasChanged = changed;
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                boolean bl = (this.state & 0x40) != 0;
                this.state &= 0xFFFFFFBF;
                size = this.layout.computeSize(this, wHint, hHint, hasChanged |= bl);
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, hasChanged);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x40;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this.controlHolder.getControls();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this.controlHolder.getControls();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this.getChildren();
        Control focusedChild = null;
        int i = 0;
        while (focusedChild == null && i < children.length) {
            Control child = children[i];
            if (child.setFocus()) {
                focusedChild = child;
            }
            ++i;
        }
        boolean result = true;
        if (focusedChild == null) {
            result = super.setFocus();
        }
        return result;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        Control[] newList = tabList;
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
        }
        this.tabList = newList;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] result = this._getTabList();
        if (result == null) {
            int count = 0;
            Control[] list = this.controlHolder.getControls();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            result = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    result[index++] = list[i2];
                }
                ++i2;
            }
        }
        return result;
    }

    Control[] _getTabList() {
        if (this.tabList != null) {
            int count = 0;
            int i = 0;
            while (i < this.tabList.length) {
                if (!this.tabList[i].isDisposed()) {
                    ++count;
                }
                ++i;
            }
            if (count != this.tabList.length) {
                Control[] newList = new Control[count];
                int index = 0;
                int i2 = 0;
                while (i2 < this.tabList.length) {
                    if (!this.tabList[i2].isDisposed()) {
                        newList[index++] = this.tabList[i2];
                    }
                    ++i2;
                }
                this.tabList = newList;
            }
        }
        return this.tabList;
    }

    boolean isTabGroup() {
        return true;
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this.getChildren();
        Rectangle clientArea = this.getClientArea();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x - clientArea.x + rect.width);
            height = Math.max(height, rect.y - clientArea.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void releaseChildren() {
        Control[] children = this.controlHolder.getControls();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    void removeControl(Control control) {
        if (this.controlHolder.contains(control)) {
            this.controlHolder.remove(control);
        }
    }

    void notifyResize(Point oldSize) {
        if (!oldSize.equals(this.getSize())) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    if (!Composite.this.isDisposed() && Composite.this.layout != null) {
                        Composite.this.markLayout(false, false);
                        Composite.this.updateLayout(false, false);
                    }
                }
            });
        }
        super.notifyResize(oldSize);
    }

    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        Control[] children = this.controlHolder.getControls();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null) {
                child.reskin(flags);
            }
            ++i;
        }
    }
}

