/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.java.util;

import java.lang.reflect.Modifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.java.JClass;
import org.eclipse.emf.java.JMethod;
import org.eclipse.emf.java.JPackage;
import org.eclipse.emf.java.JVisibility;
import org.eclipse.emf.java.JavaFactory;
import org.eclipse.emf.java.util.JavaPackageResourceFactoryImpl;
import org.eclipse.emf.java.util.JavaPackageResourceImpl;

public class JavaUtil {
    public static final String JAVA_PACKAGE_RESOURCE = "http:///org/eclipse/emf/java/.packages";
    public static final URI JAVA_PACKAGE_RESOURCE_URI = URI.createURI((String)"http:///org/eclipse/emf/java/.packages");

    public static URI createJPackageProxyURI(String packageName) {
        return JAVA_PACKAGE_RESOURCE_URI.appendFragment("/" + packageName);
    }

    public static JPackage createJPackageProxy(String packageName) {
        JPackage jPackage = JavaFactory.eINSTANCE.createJPackage();
        ((InternalEObject)jPackage).eSetProxyURI(JavaUtil.createJPackageProxyURI(packageName));
        return jPackage;
    }

    public static URI createJClassProxyURI(Class<?> javaClass) {
        String suffix = "";
        while (javaClass.getComponentType() != null) {
            suffix = String.valueOf(suffix) + "/[]";
            javaClass = javaClass.getComponentType();
        }
        String className = javaClass.getName();
        String packageName = "";
        int index = className.lastIndexOf(".");
        if (index != -1) {
            packageName = className.substring(0, index);
            className = className.substring(index + 1);
        }
        if (javaClass.isPrimitive()) {
            packageName = "java.lang";
        }
        return JAVA_PACKAGE_RESOURCE_URI.appendFragment("/" + packageName + "/" + className.replace('$', '/') + suffix);
    }

    public static JClass createJClassProxy(Class<?> javaClass) {
        JClass jClass = JavaFactory.eINSTANCE.createJClass();
        ((InternalEObject)jClass).eSetProxyURI(JavaUtil.createJClassProxyURI(javaClass));
        return jClass;
    }

    public static URI createJClassProxyURI(String className) {
        StringBuffer result = new StringBuffer("/");
        result.append(className);
        int dotIndex = className.lastIndexOf(".");
        if (dotIndex != -1) {
            result.setCharAt(dotIndex + 1, '/');
        }
        int i = dotIndex + 2;
        while (i < result.length()) {
            switch (result.charAt(i)) {
                case '$': {
                    result.setCharAt(i, '/');
                    break;
                }
                case '[': {
                    result.insert(i++, '/');
                }
            }
            ++i;
        }
        if (dotIndex == -1) {
            result.insert(0, '/');
        }
        return JAVA_PACKAGE_RESOURCE_URI.appendFragment(result.toString());
    }

    public static JClass createJClassProxy(String className) {
        JClass jClass = JavaFactory.eINSTANCE.createJClass();
        ((InternalEObject)jClass).eSetProxyURI(JavaUtil.createJClassProxyURI(className));
        return jClass;
    }

    public static URI createJClassProxyURI(URI javaSourceURI) {
        return javaSourceURI.appendFragment("//@types.0");
    }

    public static JClass createJClassProxy(URI javaSourceURI) {
        JClass jClass = JavaFactory.eINSTANCE.createJClass();
        ((InternalEObject)jClass).eSetProxyURI(JavaUtil.createJClassProxyURI(javaSourceURI));
        return jClass;
    }

    public static JVisibility getFlagVisibility(int flags) {
        if ((flags & 1) != 0) {
            return JVisibility.PUBLIC_LITERAL;
        }
        if ((flags & 4) != 0) {
            return JVisibility.PROTECTED_LITERAL;
        }
        if ((flags & 2) != 0) {
            return JVisibility.PRIVATE_LITERAL;
        }
        return JVisibility.PACKAGE_LITERAL;
    }

    public static JVisibility getModifierVisibility(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return JVisibility.PUBLIC_LITERAL;
        }
        if (Modifier.isProtected(modifiers)) {
            return JVisibility.PROTECTED_LITERAL;
        }
        if (Modifier.isPrivate(modifiers)) {
            return JVisibility.PRIVATE_LITERAL;
        }
        return JVisibility.PACKAGE_LITERAL;
    }

    public static boolean isPrefixOf(String name, String fullName) {
        if (fullName.startsWith(name)) {
            int fullNameLength;
            int nameLength = name.length();
            if (nameLength == (fullNameLength = fullName.length())) {
                return true;
            }
            if (nameLength > fullNameLength) {
                return fullName.charAt(nameLength) == '.';
            }
            return false;
        }
        return false;
    }

    public static String[] separateTypeArgument(String typeName) {
        int gtIndex;
        String typeArgument = null;
        int ltIndex = typeName.indexOf(60);
        if (ltIndex > 0 && (gtIndex = typeName.lastIndexOf(62)) > ltIndex + 1) {
            typeArgument = typeName.substring(ltIndex + 1, gtIndex).trim();
            typeName = typeName.substring(0, ltIndex).trim();
        }
        return new String[]{typeName, typeArgument};
    }

    public static class StandAloneTest {
        public static void main(String[] arguments) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("packages", new JavaPackageResourceFactoryImpl());
            JavaPackageResourceImpl javaPackageResource = (JavaPackageResourceImpl)resourceSet.getResource(JAVA_PACKAGE_RESOURCE_URI, true);
            javaPackageResource.setClassLoader(StandAloneTest.class.getClassLoader());
            JClass thisClass = (JClass)resourceSet.getEObject(JAVA_PACKAGE_RESOURCE_URI.appendFragment("/org.eclipse.emf.java.util/JavaUtil/StandAloneTest"), true);
            System.out.println("All Methods of " + thisClass.getQualifiedName());
            for (JMethod jMethod : thisClass.getAllMethods()) {
                System.out.println("  " + jMethod.getQualifiedName());
            }
            System.exit(1);
        }
    }
}

