/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters072.utils.HwElementsCacheEnum;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.1"})
public class HwElementsCacheBuilder
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HwElementsCacheBuilder.class);
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        LOGGER.info("Build up HwElementsCache for 0.7.1");
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            File targetFile = entry.getKey();
            Document document = entry.getValue();
            if (document == null) continue;
            Element rootElement = document.getRootElement();
            Map<String, Object> fileCache = this.map.get(targetFile);
            if (fileCache == null) {
                fileCache = new HashMap<String, Object>();
                this.map.put(targetFile, fileCache);
            }
            ArrayList<String> coreNames = new ArrayList<String>();
            fileCache.put(HwElementsCacheEnum.CORE_NAMES.name(), coreNames);
            ArrayList coreTypeNames = new ArrayList();
            fileCache.put(HwElementsCacheEnum.CORE_TYPE_NAMES.name(), coreTypeNames);
            ArrayList<String> memoryNames = new ArrayList<String>();
            fileCache.put(HwElementsCacheEnum.MEMORY_NAMES.name(), memoryNames);
            ArrayList memoryTypeNames = new ArrayList();
            fileCache.put(HwElementsCacheEnum.MEMORY_TYPE_NAMES.name(), memoryTypeNames);
            fileCache.put(HwElementsCacheEnum.HwModel.name(), null);
            List hwModelElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./hwModel", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._070, (String)"am")});
            if (!hwModelElements.isEmpty()) {
                fileCache.put(HwElementsCacheEnum.HwModel.name(), hwModelElements.get(0));
            }
            StringBuilder xpathBuilder = new StringBuilder();
            xpathBuilder.append("./hwModel//memories");
            xpathBuilder.append("|");
            xpathBuilder.append("./hwModel//cores");
            xpathBuilder.append("|");
            xpathBuilder.append("./hwModel/coreTypes");
            xpathBuilder.append("|");
            xpathBuilder.append("./hwModel/memoryTypes");
            List hwElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuilder.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._070, (String)"am")});
            for (Element hwElement : hwElements) {
                if (hwElement.getName().equals("memories")) {
                    memoryNames.add(hwElement.getAttributeValue("name"));
                    continue;
                }
                if (hwElement.getName().equals("cores")) {
                    coreNames.add(hwElement.getAttributeValue("name"));
                    continue;
                }
                if (hwElement.getName().equals("coreTypes")) {
                    coreNames.add(hwElement.getAttributeValue("name"));
                    continue;
                }
                if (!hwElement.getName().equals("memoryTypes")) continue;
                coreNames.add(hwElement.getAttributeValue("name"));
            }
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

