/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters095.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.4", "output_model_version=0.9.5"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.4 to 0.9.5 : Executing Sw converter for model file : {}", (Object)targetFile.getName());
        this.basicConvert(targetFile, filename2documentMap, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateGraphEntries(rootElement);
        this.updateCallSequences(rootElement);
        this.updateRunnableItems(rootElement);
        this.updateRunnableModeSwitches(rootElement);
        this.updateRunnableProbabilitySwitches(rootElement);
    }

    private void updateGraphEntries(Element rootElement) {
        String xpath = "./swModel/tasks/callGraph/graphEntries|./swModel/isrs/callGraph/graphEntries";
        List entries = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/tasks/callGraph/graphEntries|./swModel/isrs/callGraph/graphEntries", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element graphEntry : entries) {
            graphEntry.setName("items");
        }
    }

    private void updateCallSequences(Element rootElement) {
        String xpath = "./swModel/tasks//*[@xsi:type=\"am:CallSequence\"]|./swModel/isrs//*[@xsi:type=\"am:CallSequence\"]";
        List callSequences = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/tasks//*[@xsi:type=\"am:CallSequence\"]|./swModel/isrs//*[@xsi:type=\"am:CallSequence\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element cs : callSequences) {
            cs.setAttribute("type", "am:Group", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            String oldName = cs.getAttributeValue("name");
            if (oldName == null || oldName.isEmpty()) {
                cs.setAttribute("name", "CallSequence");
            }
            cs.setAttribute("ordered", "true");
            for (Element call : cs.getChildren()) {
                Element counter;
                call.setName("items");
                String callType = call.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (callType.equals("am:TaskRunnableCall")) {
                    call.setAttribute("type", "am:RunnableCall", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                }
                if (callType.equals("am:InterProcessTrigger") || (counter = call.getChild("counter")) == null) continue;
                this.migrateCounterToCustomProps(call, counter);
            }
        }
    }

    private void migrateCounterToCustomProps(Element callSequenceItem, Element counter) {
        Attribute prescaler = counter.getAttribute("prescaler");
        Attribute offset = counter.getAttribute("offset");
        if (prescaler != null) {
            this.createCounterCustomProps(counter, callSequenceItem, "counter-prescaler", prescaler.getValue());
        }
        if (offset != null) {
            this.createCounterCustomProps(counter, callSequenceItem, "counter-offset", offset.getValue());
        }
        counter.detach();
    }

    private void createCounterCustomProps(Element counter, Element callSequenceItem, String key, String val) {
        Element customProps = new Element("customProperties");
        customProps.setAttribute("key", key);
        Element customVal = new Element("value");
        customVal.setAttribute("type", "am:IntegerObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        customVal.setAttribute("value", val);
        customProps.addContent((Content)customVal);
        callSequenceItem.addContent((Content)customProps);
    }

    private void updateRunnableItems(Element rootElement) {
        String xpath = "./swModel/runnables";
        List runnables = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element runnable : runnables) {
            Element callGraph = new Element("callGraph");
            runnable.addContent((Content)callGraph);
            ArrayList runnableItems = new ArrayList(runnable.getChildren("runnableItems"));
            for (Element item : runnableItems) {
                item.setName("items");
                item.detach();
                callGraph.addContent((Content)item);
            }
        }
    }

    private void updateRunnableModeSwitches(Element rootElement) {
        String xpath = "./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]";
        List switches = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element elem : switches) {
            elem.setAttribute("type", "am:ModeSwitch", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        }
    }

    private void updateRunnableProbabilitySwitches(Element rootElement) {
        String xpath = "./swModel/runnables//*[@xsi:type=\"am:RunnableProbabilitySwitch\"]";
        List switches = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables//*[@xsi:type=\"am:RunnableProbabilitySwitch\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element elem : switches) {
            elem.setAttribute("type", "am:ProbabilitySwitch", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        }
    }
}

