/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.ModelMigration;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jdom2.Document;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MigrationProcessor.class})
public class MigrationProcessor {
    private static final String NEWLINE = System.getProperty("line.separator");
    @Reference(target="(component.factory=org.eclipse.app4mc.amalthea.modelmigration.factory)")
    ComponentFactory<ModelMigration> factory;
    @Reference(target="(component.factory=org.eclipse.app4mc.amalthea.sessionlog.factory)")
    ComponentFactory<SessionLogger> loggerFactory;

    public int execute(MigrationSettings settings, IProgressMonitor monitor) {
        ComponentInstance loggerInstance = this.loggerFactory.newInstance(null);
        SessionLogger logger = (SessionLogger)loggerInstance.getInstance();
        settings.getMigModelFiles().forEach(f -> f.setSessionLogger(logger));
        try {
            Map<String, String> migStepEntries;
            if (monitor != null) {
                monitor.setTaskName("Collecting information for intermediate migration steps");
            }
            if ((migStepEntries = MigrationHelper.generateMigrationSteps(settings.getInputModelVersion(), settings.getMigrationModelVersion())).isEmpty()) {
                logger.error("Migration not supported for the selected model versions. \nInput Model version : \"{0}\" Output Model Version : \"{1}\"", new Object[]{settings.getInputModelVersion(), settings.getMigrationModelVersion()});
                return 20;
            }
            SubMonitor subMonitor = monitor != null ? SubMonitor.convert((IProgressMonitor)monitor, (int)(migStepEntries.size() + 1)) : null;
            Map<File, Document> fileDocumentMapping = settings.getMigModelFilesMap();
            StringBuilder builder = new StringBuilder();
            builder.append(NEWLINE);
            builder.append("*******************************************************************************************************************");
            builder.append(NEWLINE);
            builder.append("\t\t Starting model migration for the following AMALTHEA models: ");
            builder.append(NEWLINE);
            for (File modelFile : fileDocumentMapping.keySet()) {
                builder.append("\t\t -- ");
                builder.append(modelFile.getAbsolutePath());
                builder.append(NEWLINE);
            }
            builder.append(NEWLINE);
            builder.append("*******************************************************************************************************************");
            builder.append(NEWLINE);
            logger.info("{0}", new Object[]{builder});
            boolean conversionPerformed = false;
            String currentModelVersion = settings.getInputModelVersion();
            while (!currentModelVersion.equals(settings.getMigrationModelVersion())) {
                if (subMonitor != null && subMonitor.isCanceled()) {
                    return 40;
                }
                Hashtable<String, String> properties = new Hashtable<String, String>();
                String inputFilterExp = "(input_model_version=" + currentModelVersion + ")";
                String inputOuputFilterExpression = "(&(input_model_version=" + currentModelVersion + ")(output_model_version=" + migStepEntries.get(currentModelVersion) + "))";
                ((Dictionary)properties).put("input_model_version", currentModelVersion);
                ((Dictionary)properties).put("output_model_version", migStepEntries.get(currentModelVersion));
                ((Dictionary)properties).put("caches.target", inputFilterExp);
                ((Dictionary)properties).put("converter.target", inputOuputFilterExpression);
                ((Dictionary)properties).put("postProcessor.target", inputOuputFilterExpression);
                ComponentInstance newInstance = this.factory.newInstance(properties);
                ModelMigration modelMigration = (ModelMigration)newInstance.getInstance();
                String outputModelVersion = modelMigration.getOutputModelVersion();
                if (subMonitor != null) {
                    subMonitor.setTaskName("Migrating AMALTHEA models from : " + currentModelVersion + " to " + outputModelVersion);
                }
                logger.info("=========== START: Migrating AMALTHEA models from : {0} to {1} ========== ", new Object[]{currentModelVersion, outputModelVersion});
                for (ICache cache : modelMigration.getCaches()) {
                    cache.clearCacheMap();
                    cache.buildCache(fileDocumentMapping);
                }
                for (IConverter converter : modelMigration.getConverter()) {
                    for (File file : fileDocumentMapping.keySet()) {
                        converter.convert(file, fileDocumentMapping, modelMigration.getCaches());
                        conversionPerformed = true;
                    }
                }
                for (IPostProcessor postProcessor : modelMigration.getPostProcessor()) {
                    postProcessor.process(fileDocumentMapping);
                }
                logger.info("=========== END: Migrating AMALTHEA models from : {0} to {1}  =========== \n\r", new Object[]{currentModelVersion, outputModelVersion});
                if (currentModelVersion.equals(outputModelVersion)) {
                    outputModelVersion = migStepEntries.get(currentModelVersion);
                }
                currentModelVersion = outputModelVersion;
                for (ICache cache : modelMigration.getCaches()) {
                    cache.clearCacheMap();
                }
                if (subMonitor != null) {
                    subMonitor.worked(1);
                }
                newInstance.dispose();
            }
            if (conversionPerformed) {
                if (subMonitor != null) {
                    subMonitor.setTaskName("Saving migrated AMALTHEA model files ");
                }
                try {
                    try {
                        MigrationHelper.saveFiles(settings, logger);
                    }
                    catch (IOException e) {
                        throw new MigrationException("Error on saving migrated files.", e);
                    }
                }
                finally {
                    settings.close();
                }
            }
            if (subMonitor != null) {
                subMonitor.worked(1);
            }
            return 10;
        }
        finally {
            logger.info("Migration session finished", new Object[0]);
            String dateToStr = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss").format(new Date());
            logger.flush(new File(settings.getOutputDirectoryLocation(), "ModelMigration__" + dateToStr + ".log"));
            loggerInstance.dispose();
        }
    }
}

