/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.util.sessionlog.console;

import java.io.File;
import java.util.List;
import org.eclipse.app4mc.util.sessionlog.SessionLogEntry;
import org.eclipse.app4mc.util.sessionlog.SessionLogWriter;
import org.osgi.service.component.annotations.Component;

@Component
public class SessionLogConsoleWriter
implements SessionLogWriter {
    public void write(File sessionLogFile, List<SessionLogEntry> log) {
        String logLevel = System.getProperty("app4mc.log.level");
        SessionLogEntry.Status logStatus = SessionLogEntry.Status.parseStatus((String)logLevel);
        log.stream().filter(entry -> entry.test(logStatus)).forEach(entry -> {
            System.out.println(entry.message);
            if (entry.throwable != null) {
                System.out.println(entry.getStackTrace());
            }
        });
    }
}

