package org.jdom2.test.cases;

import static org.junit.Assert.*;

import org.jdom2.Verifier;
import org.junit.Test;

@SuppressWarnings("javadoc")
public class TestVerifierCharacters {

	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsHighSurrogate () {
		final int[] flips = new int[] {

				 0xd800, 0xdc00
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isHighSurrogate((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isHighSurrogate but it failed.");
				}
			} else {
				if (Verifier.isHighSurrogate((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isHighSurrogate but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsHighSurrogate in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsLowSurrogate () {
		final int[] flips = new int[] {

				 0xdc00, 0xe000
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isLowSurrogate((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isLowSurrogate but it failed.");
				}
			} else {
				if (Verifier.isLowSurrogate((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isLowSurrogate but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsLowSurrogate in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLDigit () {
		final int[] flips = new int[] {

				 0x0030, 0x003a, 0x0660, 0x066a, 0x06f0, 0x06fa, 0x0966, 0x0970, 0x09e6, 0x09f0, 0x0a66, 0x0a70, 0x0ae6, 0x0af0, 0x0b66, 0x0b70,
				 0x0be7, 0x0bf0, 0x0c66, 0x0c70, 0x0ce6, 0x0cf0, 0x0d66, 0x0d70, 0x0e50, 0x0e5a, 0x0ed0, 0x0eda, 0x0f20, 0x0f2a
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLDigit((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLDigit but it failed.");
				}
			} else {
				if (Verifier.isXMLDigit((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLDigit but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLDigit in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLNameCharacter () {
		final int[] flips = new int[] {

				 0x002d, 0x002f, 0x0030, 0x003b, 0x0041, 0x005b, 0x005f, 0x0060, 0x0061, 0x007b, 0x00b7, 0x00b8, 0x00c0, 0x00d7, 0x00d8, 0x00f7,
				 0x00f8, 0x0132, 0x0134, 0x013f, 0x0141, 0x0149, 0x014a, 0x017f, 0x0180, 0x01c4, 0x01cd, 0x01f1, 0x01f4, 0x01f6, 0x01fa, 0x0218,
				 0x0250, 0x02a9, 0x02bb, 0x02c2, 0x02d0, 0x02d2, 0x0300, 0x0346, 0x0360, 0x0362, 0x0386, 0x038b, 0x038c, 0x038d, 0x038e, 0x03a2,
				 0x03a3, 0x03cf, 0x03d0, 0x03d7, 0x03da, 0x03db, 0x03dc, 0x03dd, 0x03de, 0x03df, 0x03e0, 0x03e1, 0x03e2, 0x03f4, 0x0401, 0x040d,
				 0x040e, 0x0450, 0x0451, 0x045d, 0x045e, 0x0482, 0x0483, 0x0487, 0x0490, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04ec,
				 0x04ee, 0x04f6, 0x04f8, 0x04fa, 0x0531, 0x0557, 0x0559, 0x055a, 0x0561, 0x0587, 0x0591, 0x05a2, 0x05a3, 0x05ba, 0x05bb, 0x05be,
				 0x05bf, 0x05c0, 0x05c1, 0x05c3, 0x05c4, 0x05c5, 0x05d0, 0x05eb, 0x05f0, 0x05f3, 0x0621, 0x063b, 0x0640, 0x0653, 0x0660, 0x066a,
				 0x0670, 0x06b8, 0x06ba, 0x06bf, 0x06c0, 0x06cf, 0x06d0, 0x06d4, 0x06d5, 0x06e9, 0x06ea, 0x06ee, 0x06f0, 0x06fa, 0x0901, 0x0904,
				 0x0905, 0x093a, 0x093c, 0x094e, 0x0951, 0x0955, 0x0958, 0x0964, 0x0966, 0x0970, 0x0981, 0x0984, 0x0985, 0x098d, 0x098f, 0x0991,
				 0x0993, 0x09a9, 0x09aa, 0x09b1, 0x09b2, 0x09b3, 0x09b6, 0x09ba, 0x09bc, 0x09bd, 0x09be, 0x09c5, 0x09c7, 0x09c9, 0x09cb, 0x09ce,
				 0x09d7, 0x09d8, 0x09dc, 0x09de, 0x09df, 0x09e4, 0x09e6, 0x09f2, 0x0a02, 0x0a03, 0x0a05, 0x0a0b, 0x0a0f, 0x0a11, 0x0a13, 0x0a29,
				 0x0a2a, 0x0a31, 0x0a32, 0x0a34, 0x0a35, 0x0a37, 0x0a38, 0x0a3a, 0x0a3c, 0x0a3d, 0x0a3e, 0x0a43, 0x0a47, 0x0a49, 0x0a4b, 0x0a4e,
				 0x0a59, 0x0a5d, 0x0a5e, 0x0a5f, 0x0a66, 0x0a75, 0x0a81, 0x0a84, 0x0a85, 0x0a8c, 0x0a8d, 0x0a8e, 0x0a8f, 0x0a92, 0x0a93, 0x0aa9,
				 0x0aaa, 0x0ab1, 0x0ab2, 0x0ab4, 0x0ab5, 0x0aba, 0x0abc, 0x0ac6, 0x0ac7, 0x0aca, 0x0acb, 0x0ace, 0x0ae0, 0x0ae1, 0x0ae6, 0x0af0,
				 0x0b01, 0x0b04, 0x0b05, 0x0b0d, 0x0b0f, 0x0b11, 0x0b13, 0x0b29, 0x0b2a, 0x0b31, 0x0b32, 0x0b34, 0x0b36, 0x0b3a, 0x0b3c, 0x0b44,
				 0x0b47, 0x0b49, 0x0b4b, 0x0b4e, 0x0b56, 0x0b58, 0x0b5c, 0x0b5e, 0x0b5f, 0x0b62, 0x0b66, 0x0b70, 0x0b82, 0x0b84, 0x0b85, 0x0b8b,
				 0x0b8e, 0x0b91, 0x0b92, 0x0b96, 0x0b99, 0x0b9b, 0x0b9c, 0x0b9d, 0x0b9e, 0x0ba0, 0x0ba3, 0x0ba5, 0x0ba8, 0x0bab, 0x0bae, 0x0bb6,
				 0x0bb7, 0x0bba, 0x0bbe, 0x0bc3, 0x0bc6, 0x0bc9, 0x0bca, 0x0bce, 0x0bd7, 0x0bd8, 0x0be7, 0x0bf0, 0x0c01, 0x0c04, 0x0c05, 0x0c0d,
				 0x0c0e, 0x0c11, 0x0c12, 0x0c29, 0x0c2a, 0x0c34, 0x0c35, 0x0c3a, 0x0c3e, 0x0c45, 0x0c46, 0x0c49, 0x0c4a, 0x0c4e, 0x0c55, 0x0c57,
				 0x0c60, 0x0c62, 0x0c66, 0x0c70, 0x0c82, 0x0c84, 0x0c85, 0x0c8d, 0x0c8e, 0x0c91, 0x0c92, 0x0ca9, 0x0caa, 0x0cb4, 0x0cb5, 0x0cba,
				 0x0cbe, 0x0cc5, 0x0cc6, 0x0cc9, 0x0cca, 0x0cce, 0x0cd5, 0x0cd7, 0x0cde, 0x0cdf, 0x0ce0, 0x0ce2, 0x0ce6, 0x0cf0, 0x0d02, 0x0d04,
				 0x0d05, 0x0d0d, 0x0d0e, 0x0d11, 0x0d12, 0x0d29, 0x0d2a, 0x0d3a, 0x0d3e, 0x0d44, 0x0d46, 0x0d49, 0x0d4a, 0x0d4e, 0x0d57, 0x0d58,
				 0x0d60, 0x0d62, 0x0d66, 0x0d70, 0x0e01, 0x0e2f, 0x0e30, 0x0e3b, 0x0e40, 0x0e4f, 0x0e50, 0x0e5a, 0x0e81, 0x0e83, 0x0e84, 0x0e85,
				 0x0e87, 0x0e89, 0x0e8a, 0x0e8b, 0x0e8d, 0x0e8e, 0x0e94, 0x0e98, 0x0e99, 0x0ea0, 0x0ea1, 0x0ea4, 0x0ea5, 0x0ea6, 0x0ea7, 0x0ea8,
				 0x0eaa, 0x0eac, 0x0ead, 0x0eaf, 0x0eb0, 0x0eba, 0x0ebb, 0x0ebe, 0x0ec0, 0x0ec5, 0x0ec6, 0x0ec7, 0x0ec8, 0x0ece, 0x0ed0, 0x0eda,
				 0x0f18, 0x0f1a, 0x0f20, 0x0f2a, 0x0f35, 0x0f36, 0x0f37, 0x0f38, 0x0f39, 0x0f3a, 0x0f3e, 0x0f48, 0x0f49, 0x0f6a, 0x0f71, 0x0f85,
				 0x0f86, 0x0f8c, 0x0f90, 0x0f96, 0x0f97, 0x0f98, 0x0f99, 0x0fae, 0x0fb1, 0x0fb8, 0x0fb9, 0x0fba, 0x10a0, 0x10c6, 0x10d0, 0x10f7,
				 0x1100, 0x1101, 0x1102, 0x1104, 0x1105, 0x1108, 0x1109, 0x110a, 0x110b, 0x110d, 0x110e, 0x1113, 0x113c, 0x113d, 0x113e, 0x113f,
				 0x1140, 0x1141, 0x114c, 0x114d, 0x114e, 0x114f, 0x1150, 0x1151, 0x1154, 0x1156, 0x1159, 0x115a, 0x115f, 0x1162, 0x1163, 0x1164,
				 0x1165, 0x1166, 0x1167, 0x1168, 0x1169, 0x116a, 0x116d, 0x116f, 0x1172, 0x1174, 0x1175, 0x1176, 0x119e, 0x119f, 0x11a8, 0x11a9,
				 0x11ab, 0x11ac, 0x11ae, 0x11b0, 0x11b7, 0x11b9, 0x11ba, 0x11bb, 0x11bc, 0x11c3, 0x11eb, 0x11ec, 0x11f0, 0x11f1, 0x11f9, 0x11fa,
				 0x1e00, 0x1e9c, 0x1ea0, 0x1efa, 0x1f00, 0x1f16, 0x1f18, 0x1f1e, 0x1f20, 0x1f46, 0x1f48, 0x1f4e, 0x1f50, 0x1f58, 0x1f59, 0x1f5a,
				 0x1f5b, 0x1f5c, 0x1f5d, 0x1f5e, 0x1f5f, 0x1f7e, 0x1f80, 0x1fb5, 0x1fb6, 0x1fbd, 0x1fbe, 0x1fbf, 0x1fc2, 0x1fc5, 0x1fc6, 0x1fcd,
				 0x1fd0, 0x1fd4, 0x1fd6, 0x1fdc, 0x1fe0, 0x1fed, 0x1ff2, 0x1ff5, 0x1ff6, 0x1ffd, 0x20d0, 0x20dd, 0x20e1, 0x20e2, 0x2126, 0x2127,
				 0x212a, 0x212c, 0x212e, 0x212f, 0x2180, 0x2183, 0x3005, 0x3006, 0x3007, 0x3008, 0x3021, 0x3030, 0x3031, 0x3036, 0x3041, 0x3095,
				 0x3099, 0x309b, 0x309d, 0x309f, 0x30a1, 0x30fb, 0x30fc, 0x30ff, 0x3105, 0x312d, 0x4e00, 0x9fa6, 0xac00, 0xd7a4
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLNameCharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLNameCharacter but it failed.");
				}
			} else {
				if (Verifier.isXMLNameCharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLNameCharacter but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLNameCharacter in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLPublicIDCharacter () {
		final int[] flips = new int[] {

				 0x0009, 0x000b, 0x000d, 0x000e, 0x0020, 0x0022, 0x0023, 0x0026, 0x0027, 0x003c, 0x003d, 0x003e, 0x003f, 0x005b, 0x005f, 0x0060,
				 0x0061, 0x007b
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLPublicIDCharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLPublicIDCharacter but it failed.");
				}
			} else {
				if (Verifier.isXMLPublicIDCharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLPublicIDCharacter but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLPublicIDCharacter in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLNameStartCharacter () {
		final int[] flips = new int[] {

				 0x003a, 0x003b, 0x0041, 0x005b, 0x005f, 0x0060, 0x0061, 0x007b, 0x00c0, 0x00d7, 0x00d8, 0x00f7, 0x00f8, 0x0132, 0x0134, 0x013f,
				 0x0141, 0x0149, 0x014a, 0x017f, 0x0180, 0x01c4, 0x01cd, 0x01f1, 0x01f4, 0x01f6, 0x01fa, 0x0218, 0x0250, 0x02a9, 0x02bb, 0x02c2,
				 0x0386, 0x0387, 0x0388, 0x038b, 0x038c, 0x038d, 0x038e, 0x03a2, 0x03a3, 0x03cf, 0x03d0, 0x03d7, 0x03da, 0x03db, 0x03dc, 0x03dd,
				 0x03de, 0x03df, 0x03e0, 0x03e1, 0x03e2, 0x03f4, 0x0401, 0x040d, 0x040e, 0x0450, 0x0451, 0x045d, 0x045e, 0x0482, 0x0490, 0x04c5,
				 0x04c7, 0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04ec, 0x04ee, 0x04f6, 0x04f8, 0x04fa, 0x0531, 0x0557, 0x0559, 0x055a, 0x0561, 0x0587,
				 0x05d0, 0x05eb, 0x05f0, 0x05f3, 0x0621, 0x063b, 0x0641, 0x064b, 0x0671, 0x06b8, 0x06ba, 0x06bf, 0x06c0, 0x06cf, 0x06d0, 0x06d4,
				 0x06d5, 0x06d6, 0x06e5, 0x06e7, 0x0905, 0x093a, 0x093d, 0x093e, 0x0958, 0x0962, 0x0985, 0x098d, 0x098f, 0x0991, 0x0993, 0x09a9,
				 0x09aa, 0x09b1, 0x09b2, 0x09b3, 0x09b6, 0x09ba, 0x09dc, 0x09de, 0x09df, 0x09e2, 0x09f0, 0x09f2, 0x0a05, 0x0a0b, 0x0a0f, 0x0a11,
				 0x0a13, 0x0a29, 0x0a2a, 0x0a31, 0x0a32, 0x0a34, 0x0a35, 0x0a37, 0x0a38, 0x0a3a, 0x0a59, 0x0a5d, 0x0a5e, 0x0a5f, 0x0a72, 0x0a75,
				 0x0a85, 0x0a8c, 0x0a8d, 0x0a8e, 0x0a8f, 0x0a92, 0x0a93, 0x0aa9, 0x0aaa, 0x0ab1, 0x0ab2, 0x0ab4, 0x0ab5, 0x0aba, 0x0abd, 0x0abe,
				 0x0ae0, 0x0ae1, 0x0b05, 0x0b0d, 0x0b0f, 0x0b11, 0x0b13, 0x0b29, 0x0b2a, 0x0b31, 0x0b32, 0x0b34, 0x0b36, 0x0b3a, 0x0b3d, 0x0b3e,
				 0x0b5c, 0x0b5e, 0x0b5f, 0x0b62, 0x0b85, 0x0b8b, 0x0b8e, 0x0b91, 0x0b92, 0x0b96, 0x0b99, 0x0b9b, 0x0b9c, 0x0b9d, 0x0b9e, 0x0ba0,
				 0x0ba3, 0x0ba5, 0x0ba8, 0x0bab, 0x0bae, 0x0bb6, 0x0bb7, 0x0bba, 0x0c05, 0x0c0d, 0x0c0e, 0x0c11, 0x0c12, 0x0c29, 0x0c2a, 0x0c34,
				 0x0c35, 0x0c3a, 0x0c60, 0x0c62, 0x0c85, 0x0c8d, 0x0c8e, 0x0c91, 0x0c92, 0x0ca9, 0x0caa, 0x0cb4, 0x0cb5, 0x0cba, 0x0cde, 0x0cdf,
				 0x0ce0, 0x0ce2, 0x0d05, 0x0d0d, 0x0d0e, 0x0d11, 0x0d12, 0x0d29, 0x0d2a, 0x0d3a, 0x0d60, 0x0d62, 0x0e01, 0x0e2f, 0x0e30, 0x0e31,
				 0x0e32, 0x0e34, 0x0e40, 0x0e46, 0x0e81, 0x0e83, 0x0e84, 0x0e85, 0x0e87, 0x0e89, 0x0e8a, 0x0e8b, 0x0e8d, 0x0e8e, 0x0e94, 0x0e98,
				 0x0e99, 0x0ea0, 0x0ea1, 0x0ea4, 0x0ea5, 0x0ea6, 0x0ea7, 0x0ea8, 0x0eaa, 0x0eac, 0x0ead, 0x0eaf, 0x0eb0, 0x0eb1, 0x0eb2, 0x0eb4,
				 0x0ebd, 0x0ebe, 0x0ec0, 0x0ec5, 0x0f40, 0x0f48, 0x0f49, 0x0f6a, 0x10a0, 0x10c6, 0x10d0, 0x10f7, 0x1100, 0x1101, 0x1102, 0x1104,
				 0x1105, 0x1108, 0x1109, 0x110a, 0x110b, 0x110d, 0x110e, 0x1113, 0x113c, 0x113d, 0x113e, 0x113f, 0x1140, 0x1141, 0x114c, 0x114d,
				 0x114e, 0x114f, 0x1150, 0x1151, 0x1154, 0x1156, 0x1159, 0x115a, 0x115f, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0x1167, 0x1168,
				 0x1169, 0x116a, 0x116d, 0x116f, 0x1172, 0x1174, 0x1175, 0x1176, 0x119e, 0x119f, 0x11a8, 0x11a9, 0x11ab, 0x11ac, 0x11ae, 0x11b0,
				 0x11b7, 0x11b9, 0x11ba, 0x11bb, 0x11bc, 0x11c3, 0x11eb, 0x11ec, 0x11f0, 0x11f1, 0x11f9, 0x11fa, 0x1e00, 0x1e9c, 0x1ea0, 0x1efa,
				 0x1f00, 0x1f16, 0x1f18, 0x1f1e, 0x1f20, 0x1f46, 0x1f48, 0x1f4e, 0x1f50, 0x1f58, 0x1f59, 0x1f5a, 0x1f5b, 0x1f5c, 0x1f5d, 0x1f5e,
				 0x1f5f, 0x1f7e, 0x1f80, 0x1fb5, 0x1fb6, 0x1fbd, 0x1fbe, 0x1fbf, 0x1fc2, 0x1fc5, 0x1fc6, 0x1fcd, 0x1fd0, 0x1fd4, 0x1fd6, 0x1fdc,
				 0x1fe0, 0x1fed, 0x1ff2, 0x1ff5, 0x1ff6, 0x1ffd, 0x2126, 0x2127, 0x212a, 0x212c, 0x212e, 0x212f, 0x2180, 0x2183, 0x3007, 0x3008,
				 0x3021, 0x302a, 0x3041, 0x3095, 0x30a1, 0x30fb, 0x3105, 0x312d, 0x4e00, 0x9fa6, 0xac00, 0xd7a4
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLNameStartCharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLNameStartCharacter but it failed.");
				}
			} else {
				if (Verifier.isXMLNameStartCharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLNameStartCharacter but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLNameStartCharacter in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsURICharacter () {
		final int[] flips = new int[] {

				 0x0021, 0x0022, 0x0024, 0x003b, 0x003d, 0x003e, 0x003f, 0x005b, 0x005f, 0x0060, 0x0061, 0x007b, 0x007e, 0x007f
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isURICharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isURICharacter but it failed.");
				}
			} else {
				if (Verifier.isURICharacter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isURICharacter but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsURICharacter in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsHexDigit () {
		final int[] flips = new int[] {

				 0x0030, 0x003a, 0x0041, 0x0047, 0x0061, 0x0067
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isHexDigit((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isHexDigit but it failed.");
				}
			} else {
				if (Verifier.isHexDigit((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isHexDigit but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsHexDigit in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLLetter () {
		final int[] flips = new int[] {

				 0x0041, 0x005b, 0x0061, 0x007b, 0x00c0, 0x00d7, 0x00d8, 0x00f7, 0x00f8, 0x0132, 0x0134, 0x013f, 0x0141, 0x0149, 0x014a, 0x017f,
				 0x0180, 0x01c4, 0x01cd, 0x01f1, 0x01f4, 0x01f6, 0x01fa, 0x0218, 0x0250, 0x02a9, 0x02bb, 0x02c2, 0x0386, 0x0387, 0x0388, 0x038b,
				 0x038c, 0x038d, 0x038e, 0x03a2, 0x03a3, 0x03cf, 0x03d0, 0x03d7, 0x03da, 0x03db, 0x03dc, 0x03dd, 0x03de, 0x03df, 0x03e0, 0x03e1,
				 0x03e2, 0x03f4, 0x0401, 0x040d, 0x040e, 0x0450, 0x0451, 0x045d, 0x045e, 0x0482, 0x0490, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd,
				 0x04d0, 0x04ec, 0x04ee, 0x04f6, 0x04f8, 0x04fa, 0x0531, 0x0557, 0x0559, 0x055a, 0x0561, 0x0587, 0x05d0, 0x05eb, 0x05f0, 0x05f3,
				 0x0621, 0x063b, 0x0641, 0x064b, 0x0671, 0x06b8, 0x06ba, 0x06bf, 0x06c0, 0x06cf, 0x06d0, 0x06d4, 0x06d5, 0x06d6, 0x06e5, 0x06e7,
				 0x0905, 0x093a, 0x093d, 0x093e, 0x0958, 0x0962, 0x0985, 0x098d, 0x098f, 0x0991, 0x0993, 0x09a9, 0x09aa, 0x09b1, 0x09b2, 0x09b3,
				 0x09b6, 0x09ba, 0x09dc, 0x09de, 0x09df, 0x09e2, 0x09f0, 0x09f2, 0x0a05, 0x0a0b, 0x0a0f, 0x0a11, 0x0a13, 0x0a29, 0x0a2a, 0x0a31,
				 0x0a32, 0x0a34, 0x0a35, 0x0a37, 0x0a38, 0x0a3a, 0x0a59, 0x0a5d, 0x0a5e, 0x0a5f, 0x0a72, 0x0a75, 0x0a85, 0x0a8c, 0x0a8d, 0x0a8e,
				 0x0a8f, 0x0a92, 0x0a93, 0x0aa9, 0x0aaa, 0x0ab1, 0x0ab2, 0x0ab4, 0x0ab5, 0x0aba, 0x0abd, 0x0abe, 0x0ae0, 0x0ae1, 0x0b05, 0x0b0d,
				 0x0b0f, 0x0b11, 0x0b13, 0x0b29, 0x0b2a, 0x0b31, 0x0b32, 0x0b34, 0x0b36, 0x0b3a, 0x0b3d, 0x0b3e, 0x0b5c, 0x0b5e, 0x0b5f, 0x0b62,
				 0x0b85, 0x0b8b, 0x0b8e, 0x0b91, 0x0b92, 0x0b96, 0x0b99, 0x0b9b, 0x0b9c, 0x0b9d, 0x0b9e, 0x0ba0, 0x0ba3, 0x0ba5, 0x0ba8, 0x0bab,
				 0x0bae, 0x0bb6, 0x0bb7, 0x0bba, 0x0c05, 0x0c0d, 0x0c0e, 0x0c11, 0x0c12, 0x0c29, 0x0c2a, 0x0c34, 0x0c35, 0x0c3a, 0x0c60, 0x0c62,
				 0x0c85, 0x0c8d, 0x0c8e, 0x0c91, 0x0c92, 0x0ca9, 0x0caa, 0x0cb4, 0x0cb5, 0x0cba, 0x0cde, 0x0cdf, 0x0ce0, 0x0ce2, 0x0d05, 0x0d0d,
				 0x0d0e, 0x0d11, 0x0d12, 0x0d29, 0x0d2a, 0x0d3a, 0x0d60, 0x0d62, 0x0e01, 0x0e2f, 0x0e30, 0x0e31, 0x0e32, 0x0e34, 0x0e40, 0x0e46,
				 0x0e81, 0x0e83, 0x0e84, 0x0e85, 0x0e87, 0x0e89, 0x0e8a, 0x0e8b, 0x0e8d, 0x0e8e, 0x0e94, 0x0e98, 0x0e99, 0x0ea0, 0x0ea1, 0x0ea4,
				 0x0ea5, 0x0ea6, 0x0ea7, 0x0ea8, 0x0eaa, 0x0eac, 0x0ead, 0x0eaf, 0x0eb0, 0x0eb1, 0x0eb2, 0x0eb4, 0x0ebd, 0x0ebe, 0x0ec0, 0x0ec5,
				 0x0f40, 0x0f48, 0x0f49, 0x0f6a, 0x10a0, 0x10c6, 0x10d0, 0x10f7, 0x1100, 0x1101, 0x1102, 0x1104, 0x1105, 0x1108, 0x1109, 0x110a,
				 0x110b, 0x110d, 0x110e, 0x1113, 0x113c, 0x113d, 0x113e, 0x113f, 0x1140, 0x1141, 0x114c, 0x114d, 0x114e, 0x114f, 0x1150, 0x1151,
				 0x1154, 0x1156, 0x1159, 0x115a, 0x115f, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0x1167, 0x1168, 0x1169, 0x116a, 0x116d, 0x116f,
				 0x1172, 0x1174, 0x1175, 0x1176, 0x119e, 0x119f, 0x11a8, 0x11a9, 0x11ab, 0x11ac, 0x11ae, 0x11b0, 0x11b7, 0x11b9, 0x11ba, 0x11bb,
				 0x11bc, 0x11c3, 0x11eb, 0x11ec, 0x11f0, 0x11f1, 0x11f9, 0x11fa, 0x1e00, 0x1e9c, 0x1ea0, 0x1efa, 0x1f00, 0x1f16, 0x1f18, 0x1f1e,
				 0x1f20, 0x1f46, 0x1f48, 0x1f4e, 0x1f50, 0x1f58, 0x1f59, 0x1f5a, 0x1f5b, 0x1f5c, 0x1f5d, 0x1f5e, 0x1f5f, 0x1f7e, 0x1f80, 0x1fb5,
				 0x1fb6, 0x1fbd, 0x1fbe, 0x1fbf, 0x1fc2, 0x1fc5, 0x1fc6, 0x1fcd, 0x1fd0, 0x1fd4, 0x1fd6, 0x1fdc, 0x1fe0, 0x1fed, 0x1ff2, 0x1ff5,
				 0x1ff6, 0x1ffd, 0x2126, 0x2127, 0x212a, 0x212c, 0x212e, 0x212f, 0x2180, 0x2183, 0x3007, 0x3008, 0x3021, 0x302a, 0x3041, 0x3095,
				 0x30a1, 0x30fb, 0x3105, 0x312d, 0x4e00, 0x9fa6, 0xac00, 0xd7a4
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLLetter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLLetter but it failed.");
				}
			} else {
				if (Verifier.isXMLLetter((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLLetter but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLLetter in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLCombiningChar () {
		final int[] flips = new int[] {

				 0x0300, 0x0346, 0x0360, 0x0362, 0x0483, 0x0487, 0x0591, 0x05a2, 0x05a3, 0x05ba, 0x05bb, 0x05be, 0x05bf, 0x05c0, 0x05c1, 0x05c3,
				 0x05c4, 0x05c5, 0x064b, 0x0653, 0x0670, 0x0671, 0x06d6, 0x06e5, 0x06e7, 0x06e9, 0x06ea, 0x06ee, 0x0901, 0x0904, 0x093c, 0x093d,
				 0x093e, 0x094e, 0x0951, 0x0955, 0x0962, 0x0964, 0x0981, 0x0984, 0x09bc, 0x09bd, 0x09be, 0x09c5, 0x09c7, 0x09c9, 0x09cb, 0x09ce,
				 0x09d7, 0x09d8, 0x09e2, 0x09e4, 0x0a02, 0x0a03, 0x0a3c, 0x0a3d, 0x0a3e, 0x0a43, 0x0a47, 0x0a49, 0x0a4b, 0x0a4e, 0x0a70, 0x0a72,
				 0x0a81, 0x0a84, 0x0abc, 0x0abd, 0x0abe, 0x0ac6, 0x0ac7, 0x0aca, 0x0acb, 0x0ace, 0x0b01, 0x0b04, 0x0b3c, 0x0b3d, 0x0b3e, 0x0b44,
				 0x0b47, 0x0b49, 0x0b4b, 0x0b4e, 0x0b56, 0x0b58, 0x0b82, 0x0b84, 0x0bbe, 0x0bc3, 0x0bc6, 0x0bc9, 0x0bca, 0x0bce, 0x0bd7, 0x0bd8,
				 0x0c01, 0x0c04, 0x0c3e, 0x0c45, 0x0c46, 0x0c49, 0x0c4a, 0x0c4e, 0x0c55, 0x0c57, 0x0c82, 0x0c84, 0x0cbe, 0x0cc5, 0x0cc6, 0x0cc9,
				 0x0cca, 0x0cce, 0x0cd5, 0x0cd7, 0x0d02, 0x0d04, 0x0d3e, 0x0d44, 0x0d46, 0x0d49, 0x0d4a, 0x0d4e, 0x0d57, 0x0d58, 0x0e31, 0x0e32,
				 0x0e34, 0x0e3b, 0x0e47, 0x0e4f, 0x0eb1, 0x0eb2, 0x0eb4, 0x0eba, 0x0ebb, 0x0ebd, 0x0ec8, 0x0ece, 0x0f18, 0x0f1a, 0x0f35, 0x0f36,
				 0x0f37, 0x0f38, 0x0f39, 0x0f3a, 0x0f3e, 0x0f40, 0x0f71, 0x0f85, 0x0f86, 0x0f8c, 0x0f90, 0x0f96, 0x0f97, 0x0f98, 0x0f99, 0x0fae,
				 0x0fb1, 0x0fb8, 0x0fb9, 0x0fba, 0x20d0, 0x20dd, 0x20e1, 0x20e2, 0x302a, 0x3030, 0x3099, 0x309b
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLCombiningChar((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLCombiningChar but it failed.");
				}
			} else {
				if (Verifier.isXMLCombiningChar((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLCombiningChar but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLCombiningChar in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLExtender () {
		final int[] flips = new int[] {

				 0x00b7, 0x00b8, 0x02d0, 0x02d2, 0x0387, 0x0388, 0x0640, 0x0641, 0x0e46, 0x0e47, 0x0ec6, 0x0ec7, 0x3005, 0x3006, 0x3031, 0x3036,
				 0x309d, 0x309f, 0x30fc, 0x30ff
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLExtender((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLExtender but it failed.");
				}
			} else {
				if (Verifier.isXMLExtender((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLExtender but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLExtender in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLLetterOrDigit () {
		final int[] flips = new int[] {

				 0x0030, 0x003a, 0x0041, 0x005b, 0x0061, 0x007b, 0x00c0, 0x00d7, 0x00d8, 0x00f7, 0x00f8, 0x0132, 0x0134, 0x013f, 0x0141, 0x0149,
				 0x014a, 0x017f, 0x0180, 0x01c4, 0x01cd, 0x01f1, 0x01f4, 0x01f6, 0x01fa, 0x0218, 0x0250, 0x02a9, 0x02bb, 0x02c2, 0x0386, 0x0387,
				 0x0388, 0x038b, 0x038c, 0x038d, 0x038e, 0x03a2, 0x03a3, 0x03cf, 0x03d0, 0x03d7, 0x03da, 0x03db, 0x03dc, 0x03dd, 0x03de, 0x03df,
				 0x03e0, 0x03e1, 0x03e2, 0x03f4, 0x0401, 0x040d, 0x040e, 0x0450, 0x0451, 0x045d, 0x045e, 0x0482, 0x0490, 0x04c5, 0x04c7, 0x04c9,
				 0x04cb, 0x04cd, 0x04d0, 0x04ec, 0x04ee, 0x04f6, 0x04f8, 0x04fa, 0x0531, 0x0557, 0x0559, 0x055a, 0x0561, 0x0587, 0x05d0, 0x05eb,
				 0x05f0, 0x05f3, 0x0621, 0x063b, 0x0641, 0x064b, 0x0660, 0x066a, 0x0671, 0x06b8, 0x06ba, 0x06bf, 0x06c0, 0x06cf, 0x06d0, 0x06d4,
				 0x06d5, 0x06d6, 0x06e5, 0x06e7, 0x06f0, 0x06fa, 0x0905, 0x093a, 0x093d, 0x093e, 0x0958, 0x0962, 0x0966, 0x0970, 0x0985, 0x098d,
				 0x098f, 0x0991, 0x0993, 0x09a9, 0x09aa, 0x09b1, 0x09b2, 0x09b3, 0x09b6, 0x09ba, 0x09dc, 0x09de, 0x09df, 0x09e2, 0x09e6, 0x09f2,
				 0x0a05, 0x0a0b, 0x0a0f, 0x0a11, 0x0a13, 0x0a29, 0x0a2a, 0x0a31, 0x0a32, 0x0a34, 0x0a35, 0x0a37, 0x0a38, 0x0a3a, 0x0a59, 0x0a5d,
				 0x0a5e, 0x0a5f, 0x0a66, 0x0a70, 0x0a72, 0x0a75, 0x0a85, 0x0a8c, 0x0a8d, 0x0a8e, 0x0a8f, 0x0a92, 0x0a93, 0x0aa9, 0x0aaa, 0x0ab1,
				 0x0ab2, 0x0ab4, 0x0ab5, 0x0aba, 0x0abd, 0x0abe, 0x0ae0, 0x0ae1, 0x0ae6, 0x0af0, 0x0b05, 0x0b0d, 0x0b0f, 0x0b11, 0x0b13, 0x0b29,
				 0x0b2a, 0x0b31, 0x0b32, 0x0b34, 0x0b36, 0x0b3a, 0x0b3d, 0x0b3e, 0x0b5c, 0x0b5e, 0x0b5f, 0x0b62, 0x0b66, 0x0b70, 0x0b85, 0x0b8b,
				 0x0b8e, 0x0b91, 0x0b92, 0x0b96, 0x0b99, 0x0b9b, 0x0b9c, 0x0b9d, 0x0b9e, 0x0ba0, 0x0ba3, 0x0ba5, 0x0ba8, 0x0bab, 0x0bae, 0x0bb6,
				 0x0bb7, 0x0bba, 0x0be7, 0x0bf0, 0x0c05, 0x0c0d, 0x0c0e, 0x0c11, 0x0c12, 0x0c29, 0x0c2a, 0x0c34, 0x0c35, 0x0c3a, 0x0c60, 0x0c62,
				 0x0c66, 0x0c70, 0x0c85, 0x0c8d, 0x0c8e, 0x0c91, 0x0c92, 0x0ca9, 0x0caa, 0x0cb4, 0x0cb5, 0x0cba, 0x0cde, 0x0cdf, 0x0ce0, 0x0ce2,
				 0x0ce6, 0x0cf0, 0x0d05, 0x0d0d, 0x0d0e, 0x0d11, 0x0d12, 0x0d29, 0x0d2a, 0x0d3a, 0x0d60, 0x0d62, 0x0d66, 0x0d70, 0x0e01, 0x0e2f,
				 0x0e30, 0x0e31, 0x0e32, 0x0e34, 0x0e40, 0x0e46, 0x0e50, 0x0e5a, 0x0e81, 0x0e83, 0x0e84, 0x0e85, 0x0e87, 0x0e89, 0x0e8a, 0x0e8b,
				 0x0e8d, 0x0e8e, 0x0e94, 0x0e98, 0x0e99, 0x0ea0, 0x0ea1, 0x0ea4, 0x0ea5, 0x0ea6, 0x0ea7, 0x0ea8, 0x0eaa, 0x0eac, 0x0ead, 0x0eaf,
				 0x0eb0, 0x0eb1, 0x0eb2, 0x0eb4, 0x0ebd, 0x0ebe, 0x0ec0, 0x0ec5, 0x0ed0, 0x0eda, 0x0f20, 0x0f2a, 0x0f40, 0x0f48, 0x0f49, 0x0f6a,
				 0x10a0, 0x10c6, 0x10d0, 0x10f7, 0x1100, 0x1101, 0x1102, 0x1104, 0x1105, 0x1108, 0x1109, 0x110a, 0x110b, 0x110d, 0x110e, 0x1113,
				 0x113c, 0x113d, 0x113e, 0x113f, 0x1140, 0x1141, 0x114c, 0x114d, 0x114e, 0x114f, 0x1150, 0x1151, 0x1154, 0x1156, 0x1159, 0x115a,
				 0x115f, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0x1167, 0x1168, 0x1169, 0x116a, 0x116d, 0x116f, 0x1172, 0x1174, 0x1175, 0x1176,
				 0x119e, 0x119f, 0x11a8, 0x11a9, 0x11ab, 0x11ac, 0x11ae, 0x11b0, 0x11b7, 0x11b9, 0x11ba, 0x11bb, 0x11bc, 0x11c3, 0x11eb, 0x11ec,
				 0x11f0, 0x11f1, 0x11f9, 0x11fa, 0x1e00, 0x1e9c, 0x1ea0, 0x1efa, 0x1f00, 0x1f16, 0x1f18, 0x1f1e, 0x1f20, 0x1f46, 0x1f48, 0x1f4e,
				 0x1f50, 0x1f58, 0x1f59, 0x1f5a, 0x1f5b, 0x1f5c, 0x1f5d, 0x1f5e, 0x1f5f, 0x1f7e, 0x1f80, 0x1fb5, 0x1fb6, 0x1fbd, 0x1fbe, 0x1fbf,
				 0x1fc2, 0x1fc5, 0x1fc6, 0x1fcd, 0x1fd0, 0x1fd4, 0x1fd6, 0x1fdc, 0x1fe0, 0x1fed, 0x1ff2, 0x1ff5, 0x1ff6, 0x1ffd, 0x2126, 0x2127,
				 0x212a, 0x212c, 0x212e, 0x212f, 0x2180, 0x2183, 0x3007, 0x3008, 0x3021, 0x302a, 0x3041, 0x3095, 0x30a1, 0x30fb, 0x3105, 0x312d,
				 0x4e00, 0x9fa6, 0xac00, 0xd7a4
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLLetterOrDigit((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLLetterOrDigit but it failed.");
				}
			} else {
				if (Verifier.isXMLLetterOrDigit((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLLetterOrDigit but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLLetterOrDigit in %dms\n", System.currentTimeMillis() - ms);
	}


	// Automated test built by VerifierTestBuilder
	@Test
	public void  testIsXMLWhitespace () {
		final int[] flips = new int[] {

				 0x0009, 0x000b, 0x000d, 0x000e, 0x0020, 0x0021
		};
		int c = 0;
		int fcnt = 0;
		boolean valid = false;
		final long ms = System.currentTimeMillis();
		while (c <= Character.MAX_VALUE) {
			if (fcnt < flips.length && flips[fcnt] == c) {
				valid = !valid;
				fcnt++;
			}
			if (valid) {
				if (!Verifier.isXMLWhitespace((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to pass isXMLWhitespace but it failed.");
				}
			} else {
				if (Verifier.isXMLWhitespace((char)c)) {
					fail("Expected char 0x" + Integer.toHexString(c) + " to fail isXMLWhitespace but it passed.");
				}
			}
			c++;
		}
		System.out.printf("Completed test testIsXMLWhitespace in %dms\n", System.currentTimeMillis() - ms);
	}

}
