/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.special.Gamma;

public class WeibullUtil {
    private static final String NO_VALID_WEIBULL_DISTRIBUTION_FOUND = "invalid argument: there is no valid weibull distribution for the used parameter";

    private WeibullUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static double computeAverage(double shape, double scale, double location, Double upperBound) {
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (upperBound == null || upperBound.isNaN() || upperBound.isInfinite()) {
            return location + scale * Gamma.gamma((double)(1.0 + 1.0 / shape));
        }
        if (location < upperBound) {
            double range = upperBound - location;
            double power = Math.pow(range / scale, shape);
            double factor1 = scale / (1.0 - Math.exp(-1.0 * power));
            double factor2 = WeibullUtil.lowerIncompleteGammaFunction(1.0 + 1.0 / shape, power);
            return location + factor1 * factor2;
        }
        return Double.NaN;
    }

    private static double lowerIncompleteGammaFunction(double s, double x) {
        return Gamma.regularizedGammaP((double)s, (double)x) * Gamma.gamma((double)s);
    }

    public static double computeMedian(double shape, double scale, double location, Double upperBound) {
        double pRemainPromille = upperBound == null || upperBound.isNaN() || upperBound.isInfinite() ? 0.0 : WeibullUtil.computePRemainPromille(shape, scale, location, upperBound);
        return WeibullUtil.computeMedianWithPRemainPromille(shape, scale, location, pRemainPromille);
    }

    public static double computeMedianWithPRemainPromille(double shape, double scale, double location, double pRemainPromille) {
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (pRemainPromille < 0.0 || pRemainPromille >= 1000.0) {
            return Double.NaN;
        }
        double x = scale * Math.pow(-1.0 * Math.log(0.5 + pRemainPromille / 2000.0), 1.0 / shape);
        return location + x;
    }

    public static double computePRemainPromille(double shape, double scale, double location, double upperBound) {
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        if (location < upperBound) {
            double range = upperBound - location;
            double power = Math.pow(range / scale, shape);
            return Math.exp(-1.0 * power) * 1000.0;
        }
        return Double.NaN;
    }

    public static double computeUpperBound(double shape, double scale, double location, double pRemainPromille) {
        if (shape <= 0.0 || scale <= 0.0) {
            return Double.NaN;
        }
        double pRemain = pRemainPromille / 1000.0;
        if (pRemain > 0.0 && pRemain < 1.0) {
            return location + Math.pow(-1.0 * Math.log(pRemain), 1.0 / shape) * scale;
        }
        return Double.NaN;
    }

    public static Parameters findParameters(double lowerBound, double average, double upperBound, double pRemainPromille) {
        Parameters p1 = WeibullUtil.findParametersForAverage(lowerBound, average, upperBound, pRemainPromille);
        Parameters p2 = WeibullUtil.findParametersForMedian(lowerBound, average, upperBound, pRemainPromille);
        if (p2.error != null) {
            return p1;
        }
        double p1_average = WeibullUtil.computeAverage(p1.shape, p1.scale, lowerBound, upperBound);
        double p1_pRemainPromille = WeibullUtil.computePRemainPromille(p1.shape, p1.scale, lowerBound, upperBound);
        double p2_average = WeibullUtil.computeAverage(p2.shape, p2.scale, lowerBound, upperBound);
        double p2_pRemainPromille = WeibullUtil.computePRemainPromille(p2.shape, p2.scale, lowerBound, upperBound);
        double error1 = Math.abs(1.0 - p1_average / average) + Math.abs(1.0 - p1_pRemainPromille / pRemainPromille);
        double error2 = Math.abs(1.0 - p2_average / average) + Math.abs(1.0 - p2_pRemainPromille / pRemainPromille);
        if (error2 < error1) {
            return p2;
        }
        return p1;
    }

    public static Parameters findParametersForAverage(double lowerBound, double average, double upperBound, double pRemainPromille) {
        double half_f;
        Parameters result = new Parameters();
        result.shape = 1.0;
        result.scale = 1.0;
        result.requested_pRemainPromille = pRemainPromille;
        result.given_lowerBound = lowerBound;
        result.requested_mean = average;
        result.given_upperBound = upperBound;
        double avg = average - lowerBound;
        double max = upperBound - lowerBound;
        double pRemain = pRemainPromille / 1000.0;
        if (max / avg > 10000.0) {
            result.error = "finding: upper bound and mean have no valid value for parameter";
            return result;
        }
        if (pRemain > 1.0) {
            result.error = "invalid_argument: pRemainPromille needs to be smaller than 1";
            return result;
        }
        double right = 0.2;
        double left = 0.1;
        double right_f = WeibullUtil.paramZeroFunctionforAverage(right, avg, max, pRemain);
        double left_f = WeibullUtil.paramZeroFunctionforAverage(left, avg, max, pRemain);
        while ((right_f > 0.0 || left_f < 0.0) && right < 1000.0 && pRemain + right_f > 0.0) {
            left = right;
            right += Math.max(0.1 * right, 0.1);
            right_f = WeibullUtil.paramZeroFunctionforAverage(right, avg, max, pRemain);
            left_f = WeibullUtil.paramZeroFunctionforAverage(left, avg, max, pRemain);
        }
        if (right_f > 0.0 && left_f < 0.0) {
            result.error = NO_VALID_WEIBULL_DISTRIBUTION_FOUND;
            return result;
        }
        if (left_f == 0.0) {
            right = left;
            right_f = left_f;
        }
        if (right_f == 0.0) {
            result.shape = right;
            result.scale = WeibullUtil.computeScaleForAverage(result.shape, avg, pRemain);
            return result;
        }
        do {
            double half;
            if ((half_f = WeibullUtil.paramZeroFunctionforAverage(half = left + (right - left) / 2.0, avg, max, pRemain)) == 0.0 || left == right || half == right || half == left) {
                result.shape = half;
                result.scale = WeibullUtil.computeScaleForAverage(result.shape, avg, pRemain);
                return result;
            }
            if (Math.signum(1.0) == Math.signum(half_f)) {
                left = half;
                continue;
            }
            right = half;
        } while (Double.isFinite(left) && Double.isFinite(right) && Double.isFinite(half_f));
        result.error = NO_VALID_WEIBULL_DISTRIBUTION_FOUND;
        return result;
    }

    private static double paramZeroFunctionforAverage(double shape, double avg, double max, double pRemain) {
        return 1.0 / Math.exp(Math.pow(max / avg * Gamma.gamma((double)(1.0 + 1.0 / shape)), shape)) - pRemain;
    }

    private static double computeScaleForAverage(double shape, double avg, double pRemain) {
        return avg / Gamma.gamma((double)(1.0 + 1.0 / shape));
    }

    public static Parameters findParametersForMedian(double lowerBound, double median, double upperBound, double pRemainPromille) {
        double half_f;
        Parameters result = new Parameters();
        result.shape = 1.0;
        result.scale = 1.0;
        result.requested_pRemainPromille = pRemainPromille;
        result.given_lowerBound = lowerBound;
        result.requested_mean = median;
        result.given_upperBound = upperBound;
        double med = median - lowerBound;
        double max = upperBound - lowerBound;
        double pRemain = pRemainPromille / 1000.0;
        if (max / med > 10000.0) {
            result.error = "finding: upper bound and mean have no valid value for parameter";
            return result;
        }
        if (pRemain > 1.0) {
            result.error = "invalid_argument: pRemainPromille needs to be smaller than 1";
            return result;
        }
        double right = 0.2;
        double left = 0.1;
        double right_f = WeibullUtil.paramZeroFunctionForMedian(right, med, max, pRemain);
        double left_f = WeibullUtil.paramZeroFunctionForMedian(left, med, max, pRemain);
        while ((right_f > 0.0 || left_f < 0.0) && right < 1000.0 && pRemain + right_f > 0.0) {
            left = right;
            right += Math.max(0.1 * right, 0.1);
            right_f = WeibullUtil.paramZeroFunctionForMedian(right, med, max, pRemain);
            left_f = WeibullUtil.paramZeroFunctionForMedian(left, med, max, pRemain);
        }
        if (right_f > 0.0 && left_f < 0.0) {
            result.error = NO_VALID_WEIBULL_DISTRIBUTION_FOUND;
            return result;
        }
        if (left_f == 0.0) {
            right = left;
            right_f = left_f;
        }
        if (right_f == 0.0) {
            result.shape = right;
            result.scale = WeibullUtil.computeScaleForMedian(result.shape, med, pRemain);
            return result;
        }
        do {
            double half;
            if ((half_f = WeibullUtil.paramZeroFunctionForMedian(half = left + (right - left) / 2.0, med, max, pRemain)) == 0.0 || left == right || half == right || half == left) {
                result.shape = half;
                result.scale = WeibullUtil.computeScaleForMedian(result.shape, med, pRemain);
                return result;
            }
            if (Math.signum(1.0) == Math.signum(half_f)) {
                left = half;
                continue;
            }
            right = half;
        } while (Double.isFinite(left) && Double.isFinite(right) && Double.isFinite(half_f));
        result.error = NO_VALID_WEIBULL_DISTRIBUTION_FOUND;
        return result;
    }

    private static double paramZeroFunctionForMedian(double shape, double median, double max, double pRemain) {
        double factor1 = max / median;
        double factor2 = Math.pow(-1.0 * Math.log(0.5 + pRemain / 2.0), 1.0 / shape);
        return 1.0 / Math.exp(Math.pow(factor1 * factor2, shape)) - pRemain;
    }

    private static double computeScaleForMedian(double shape, double median, double pRemain) {
        return median / Math.pow(-1.0 * Math.log(0.5 + pRemain / 2.0), 1.0 / shape);
    }

    public static class Parameters {
        public double given_lowerBound = 0.0;
        public double given_upperBound = 0.0;
        public double requested_mean = 0.0;
        public double requested_pRemainPromille = 0.0;
        public double shape = 1.0;
        public double scale = 1.0;
        public String error = null;

        public String toString() {
            String output = "WeibullParam\n  shape = " + this.shape + "\n  scale = " + this.scale + "\n  lowerBound      = " + this.given_lowerBound + "\n  upperBound      = " + this.given_upperBound + "\n  mean            = " + this.requested_mean + "\n  pRemainPromille = " + this.requested_pRemainPromille;
            if (this.error != null) {
                output = String.valueOf(output) + "\n  *** error *** : " + this.error;
            }
            return output;
        }

        public String qualityReport() {
            WeibullDistribution mathFunction = new WeibullDistribution(null, this.shape, this.scale);
            double cdfAvg = mathFunction.cumulativeProbability(this.requested_mean - this.given_lowerBound);
            double cdfMax = mathFunction.cumulativeProbability(this.given_upperBound - this.given_lowerBound);
            double remPromilleC = (1.0 - cdfMax) * 1000.0;
            double averageC = WeibullUtil.computeAverage(this.shape, this.scale, this.given_lowerBound, this.given_upperBound);
            double medianC = WeibullUtil.computeMedian(this.shape, this.scale, this.given_lowerBound, this.given_upperBound);
            String output = "Weibull Parameter Quality\nInput: [" + this.given_lowerBound + ", " + this.requested_mean + ", " + this.given_upperBound + "], " + this.requested_pRemainPromille + "\nEstimated parameters: shape = " + this.shape + "\tscale = " + this.scale + "\n computed average: " + averageC + "\n computed median: " + medianC + "\n computed pRemainPromille: " + remPromilleC + "\n computed cdf(lower interval) = " + cdfAvg + "\n computed cdf(upper interval) = " + (cdfMax - cdfAvg);
            return output;
        }
    }
}

