/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb.metrics;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.MetricAggregation;
import org.eclipse.app4mc.atdb.metrics.DBResultRowDataProvider;
import org.eclipse.app4mc.atdb.metrics.Messages;
import org.eclipse.core.resources.IFile;

public class DatabaseAccess
implements AutoCloseable {
    private final ATDBConnection traceDbConnection;
    private final String timeBase;
    private final Map<String, DBResultRowDataProvider> query2Result;

    private static String getPrependedColumnsEntityIdStr(List<PrependedColumn> prependedColumns) {
        return prependedColumns.isEmpty() ? "" : String.valueOf(prependedColumns.stream().map(c -> ((PrependedColumn)c).entityIdStr).collect(Collectors.joining(", "))) + ", ";
    }

    private static String getPrependedColumns2Order(List<PrependedColumn> prependedColumns) {
        String result = prependedColumns.stream().map(c -> ((PrependedColumn)c).orderedEntityIdStr ? ((PrependedColumn)c).entityIdStr : "").filter(s -> s.length() > 0).collect(Collectors.joining(", "));
        if (result.length() > 0) {
            result = String.valueOf(result) + ", ";
        }
        return result;
    }

    private static String getPrependedColumnsEntityId2Query(List<PrependedColumn> prependedColumns, String indent) {
        return prependedColumns.isEmpty() ? "" : String.valueOf(indent) + prependedColumns.stream().map(c -> ((PrependedColumn)c).entityId2Query).collect(Collectors.joining(",\n" + indent)) + ",\n";
    }

    private static String getPrependedColumnsEntityId2Name(List<PrependedColumn> prependedColumns, String indent) {
        return prependedColumns.isEmpty() ? "" : String.valueOf(indent) + prependedColumns.stream().map(c -> ((PrependedColumn)c).entityId2Name).collect(Collectors.joining(",\n" + indent)) + ",\n";
    }

    public DatabaseAccess(IFile databaseFile) throws SQLException {
        this.traceDbConnection = new ATDBConnection(databaseFile.getLocation().toFile().toString());
        this.timeBase = this.traceDbConnection.getTimeBase();
        this.query2Result = new LinkedHashMap<String, DBResultRowDataProvider>();
    }

    @Override
    public void close() throws SQLException {
        this.query2Result.clear();
        this.traceDbConnection.close();
    }

    public DBResultRowDataProvider getProcessMetricValues(List<String> metricDimensions, boolean groupByProcess) throws SQLException {
        return this.getMetricValues(Arrays.asList("T", "I"), metricDimensions, Collections.emptyList(), Messages.DBViewer_processTitle, groupByProcess ? Arrays.asList(0) : Collections.emptyList());
    }

    public DBResultRowDataProvider getRunnableMetricValues(List<String> metricDimensions, boolean showAndGroupByProcess, boolean groupByRunnable) throws SQLException {
        ArrayList<PrependedColumn> prependColumns = new ArrayList<PrependedColumn>();
        if (showAndGroupByProcess) {
            prependColumns.add(new PrependedColumn(String.valueOf(Messages.DBViewer_processTitle.toLowerCase()) + "Id", true, "    (SELECT entityId FROM propertyValue\n      WHERE propertyId = (SELECT id FROM property WHERE name = 'runnables') AND\n      CAST(propertyValue.value AS INTEGER) = entityInstanceMetricValue.entityId)", "(SELECT name FROM entity WHERE id = " + Messages.DBViewer_processTitle.toLowerCase() + "Id) AS '" + Messages.DBViewer_processTitle + " " + Messages.DBViewer_nameTitle + "'"));
        }
        ArrayList<Integer> groupColumnIndices = new ArrayList<Integer>();
        if (showAndGroupByProcess || groupByRunnable) {
            groupColumnIndices.add(0);
        }
        if (showAndGroupByProcess && groupByRunnable) {
            groupColumnIndices.add(1);
        }
        return this.getMetricValues(Arrays.asList("R"), metricDimensions, prependColumns, Messages.DBViewer_runnableTitle, groupColumnIndices);
    }

    public DBResultRowDataProvider getEventChainMetricValues(List<String> metricDimensions) throws SQLException {
        return this.getMetricValues(Arrays.asList("EC"), metricDimensions, Collections.emptyList(), Messages.DBViewer_eventChainTitle, Collections.emptyList());
    }

    private DBResultRowDataProvider getMetricValues(List<String> entityTypes, List<String> metricDimensions, List<PrependedColumn> prependColumns, String entityTypeLabel, List<Integer> groupColumnIndices) throws SQLException {
        String entityTypesFilter = entityTypes.isEmpty() ? "" : " WHERE entityTypeId IN (SELECT id FROM entityType WHERE name IN (" + entityTypes.stream().map(et -> "'" + et + "'").collect(Collectors.joining(", ")) + "))";
        String metricDimensionsFilter = metricDimensions.isEmpty() ? "" : " WHERE dimension IN (" + metricDimensions.stream().map(md -> "'" + md + "'").collect(Collectors.joining(", ")) + ")";
        String queryString = "WITH\n  entitiesToConsider(id) AS (SELECT id FROM entity" + entityTypesFilter + "),\n" + "  metricsToConsider(id) AS (SELECT id FROM metric" + metricDimensionsFilter + "),\n" + "  precalculated(" + DatabaseAccess.getPrependedColumnsEntityIdStr(prependColumns) + entityTypeLabel.toLowerCase() + "Id, metricId, " + Stream.of(MetricAggregation.values()).map(ma -> ma.getSQLLabel()).collect(Collectors.joining(", ")) + ") AS (SELECT\n" + DatabaseAccess.getPrependedColumnsEntityId2Query(prependColumns, "    ") + "    entityInstanceMetricValue.entityId,\n" + "    entityInstanceMetricValue.metricId,\n" + Stream.of(MetricAggregation.values()).map(ma -> "    " + ma.getSQLStr("entityInstanceMetricValue.value")).collect(Collectors.joining(",\n")) + "\n" + "  FROM entityInstanceMetricValue\n" + "  WHERE entityId IN (SELECT id FROM entitiesToConsider) AND\n" + "    metricId IN (SELECT id FROM metricsToConsider)\n" + "  GROUP BY entityId, metricId)\n\n" + "SELECT\n" + DatabaseAccess.getPrependedColumnsEntityId2Name(prependColumns, "  ") + "  (SELECT name FROM entity WHERE id = " + entityTypeLabel.toLowerCase() + "Id) AS '" + entityTypeLabel + " " + Messages.DBViewer_nameTitle + "',\n" + "  (SELECT name FROM metric WHERE id = metricId) AS '" + Messages.DBViewer_metricColumnTitle + "',\n" + Stream.of(MetricAggregation.values()).map(ma -> "  " + ma.getSQLLabel() + " AS '" + String.format(Messages.metricAggr2UILabel.get(ma), this.timeBase) + "'").collect(Collectors.joining(",\n")) + "\n" + "FROM precalculated\n" + "ORDER BY " + DatabaseAccess.getPrependedColumns2Order(prependColumns) + entityTypeLabel.toLowerCase() + "Id, metricId;";
        if (!this.query2Result.containsKey(queryString)) {
            this.traceDbConnection.queryAndConsumeResult(queryString, rs -> {
                DBResultRowDataProvider dBResultRowDataProvider = this.query2Result.put(queryString, DBResultRowDataProvider.of(rs, groupColumnIndices));
            });
        }
        return this.query2Result.get(queryString);
    }

    private static class PrependedColumn {
        private final String entityIdStr;
        private final boolean orderedEntityIdStr;
        private final String entityId2Query;
        private final String entityId2Name;

        private PrependedColumn(String entityIdStr, boolean ordered, String entityId2Query, String entityId2Name) {
            this.entityIdStr = entityIdStr;
            this.orderedEntityIdStr = ordered;
            this.entityId2Query = entityId2Query;
            this.entityId2Name = entityId2Name;
        }
    }
}

