/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter.atdb;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableLong;
import org.eclipse.app4mc.tracing.converter.atdb.model.EntityType;
import org.eclipse.app4mc.tracing.converter.atdb.model.EventType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.ClockType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventDescriptionType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventIdMappingType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventTypeEnum;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TimeBaseEnum;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TimeValueType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TraceEntryType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TracesType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.XmlTraceType;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;

public class ATDBWriter {
    private static final String INSERT_INTO_META_INFORMATION = "INSERT INTO MetaInformation (Name, Value) VALUES (?,?)";
    private static final String UPDATE_META_INFORMATION = "UPDATE MetaInformation SET Value = ? WHERE Name = ? ";
    private static final String SELECT_FROM_META_INFORMATION = "SELECT Value FROM MetaInformation WHERE Name = ?";
    private Statement stat;
    private Connection conn;
    final Map<Long, String> mapEntityIdToEntityName = new HashMap<Long, String>();
    final Map<Long, String> mapEntityIdToTableName = new HashMap<Long, String>();
    final Map<Long, EventType> mapEntityIdLastEventType = new HashMap<Long, EventType>();
    final Map<Long, Long> mapEntityIdStartTime = new HashMap<Long, Long>();
    final Map<Long, MutableLong> mapEntityIdInstanceCounter = new HashMap<Long, MutableLong>();
    final Map<Long, EntityType> mapEntityIdToEntityType = new HashMap<Long, EntityType>();
    final Map<Long, EventType> mapEventTypeIdToEventType = new HashMap<Long, EventType>();
    final Map<EventType, Long> mapEventTypeToEventTypeId = new HashMap<EventType, Long>();
    Map<EntityType, Integer> mapEntityTypeId = new HashMap<EntityType, Integer>();
    long globalEventCounter = 0L;
    long timestampZeroCounter = 0L;
    private PreparedStatement insertIntoMetaInfo;
    private PreparedStatement updateMetaInfo;
    private PreparedStatement selectFromMetaInfo;
    private PreparedStatement prepInsertEntityInstance;
    private long counterPrepInsertEntityInstance = 0L;
    private long bufCounterPrepInsertEntityInstance = 0L;
    Map<String, PreparedStatement> mapTraceStatements = new HashMap<String, PreparedStatement>();
    Map<String, MutableLong> mapTraceStatementCounter = new HashMap<String, MutableLong>();
    Map<String, MutableInt> mapTraceStatementsBufferCnt = new HashMap<String, MutableInt>();
    Map<Long, Set<Long>> mapEntitySourceCache = new HashMap<Long, Set<Long>>();

    public void createATDB(IFile atdbFile) {
        this.conn = null;
        try {
            Class.forName("org.sqlite.JDBC");
            String name = atdbFile.getLocation().toOSString();
            String connectionString = "jdbc:sqlite:" + name;
            this.conn = DriverManager.getConnection(connectionString);
            atdbFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            this.stat = this.conn.createStatement();
            this.createMetaInformationTable();
            this.createEntityInstanceTable();
            this.createEntitySourceTable();
            this.createEntitiesTable();
            this.createEntityTypeTable();
            this.createEventTypeTable();
            this.prepareGeneralStatements();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void prepareGeneralStatements() throws SQLException {
        this.insertIntoMetaInfo = this.conn.prepareStatement(INSERT_INTO_META_INFORMATION);
        this.selectFromMetaInfo = this.conn.prepareStatement(SELECT_FROM_META_INFORMATION);
        this.updateMetaInfo = this.conn.prepareStatement(UPDATE_META_INFORMATION);
    }

    public void close() {
        try {
            if (this.stat != null) {
                this.stat.close();
                this.stat = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createEntitiesTable() throws SQLException {
        this.executeUpdate("CREATE TABLE Entity\t(Id INTEGER PRIMARY KEY ASC, Name TEXT, EntityTypeId INTEGER, HasEvents BOOLEAN, EventTableName TEXT);");
    }

    private void createEntityInstanceTable() throws SQLException {
        this.executeUpdate("CREATE TABLE EntityInstance (Id INTEGER, EntityId INTEGER, EntityInstanceId INTEGER, TimeFrom INT8, TimeTo INT8, PRIMARY KEY(EntityId, EntityInstanceId));", "CREATE INDEX IndexEntityInstance ON EntityInstance (EntityId,TimeFrom,TimeTo);", "CREATE INDEX EntityInstanceInstanceIdIndex on EntityInstance(id);");
    }

    private void createEntitySourceTable() throws SQLException {
        this.executeUpdate("CREATE TABLE EntitySource ( EntityId INT8, SourceEntityId INT8, PRIMARY KEY (EntityId, SourceEntityId) );", "CREATE INDEX EntitySourceIndex on EntitySource(EntityId, SourceEntityId);");
    }

    private void createEntityTypeTable() throws SQLException {
        this.executeUpdate("CREATE TABLE EntityType (Id INTEGER PRIMARY KEY ASC, Name TEXT);");
    }

    private void createEventTypeTable() throws SQLException {
        this.executeUpdate("CREATE TABLE EventType (Id INTEGER PRIMARY KEY ASC, Name TEXT);");
    }

    private void createMetaInformationTable() throws SQLException {
        this.executeUpdate("CREATE TABLE MetaInformation ( Name TEXT PRIMARY KEY, Value TEXT );");
    }

    /*
     * Loose catch block
     */
    public Long insertEntity(SchedulingEntityType schedEntityType, EntityType entityType) {
        try {
            long entityId = 0L;
            while (this.mapEntityIdToEntityName.containsKey(entityId)) {
                ++entityId;
            }
            String entityName = this.correctEntityName(schedEntityType.getName());
            int entityTypeId = this.getEntityTypeId(entityType);
            Throwable throwable = null;
            Object var8_9 = null;
            try (PreparedStatement prep = this.conn.prepareStatement("insert into Entity values (?, ?, ?, null, null);");){
                Long l;
                ResultSet generatedKeys;
                Throwable throwable2;
                block22: {
                    prep.setLong(1, entityId);
                    prep.setString(2, entityName);
                    prep.setInt(3, entityTypeId);
                    prep.execute();
                    throwable2 = null;
                    Object var11_14 = null;
                    generatedKeys = prep.getGeneratedKeys();
                    generatedKeys.next();
                    long id = generatedKeys.getLong(1);
                    this.mapEntityIdToEntityName.put(id, entityName);
                    this.mapEntityIdToEntityType.put(id, entityType);
                    this.mapEntityIdInstanceCounter.put(entityId, new MutableLong(-1L));
                    l = id;
                    if (generatedKeys == null) break block22;
                    generatedKeys.close();
                }
                return l;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (generatedKeys != null) {
                                generatedKeys.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void insertEntities(SchedulingEntityType schedulingEntity, Collection<SchedulingEntityElementType> elements) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement prep = this.conn.prepareStatement("insert into Entity values (?, ?, ?, null, null);");){
            for (SchedulingEntityElementType element : elements) {
                Long entityId = element.getId().longValue();
                if (this.mapEntityIdToEntityName.containsKey(entityId)) continue;
                String entityName = this.correctEntityName(element.getName());
                EntityType entityType = EntityType.getEntityTypeForOT1Class(element);
                if (entityType == null || EntityType.getATDBAbbrev(entityType) == null) {
                    System.out.println("Entity-Type [" + element.getClass().getSimpleName() + "] not supported.");
                    continue;
                }
                int entityTypeId = this.getEntityTypeId(entityType);
                this.mapEntityIdToEntityName.put(entityId, entityName);
                this.mapEntityIdInstanceCounter.put(entityId, new MutableLong(-1L));
                this.mapEntityIdToEntityType.put(entityId, entityType);
                prep.setLong(1, entityId);
                prep.setString(2, entityName);
                prep.setInt(3, entityTypeId);
                prep.addBatch();
                EList subElements = element.getElement();
                this.insertEntities(schedulingEntity, (Collection<SchedulingEntityElementType>)subElements);
            }
            this.conn.setAutoCommit(false);
            prep.executeBatch();
            this.conn.setAutoCommit(true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getEntityTypeId(EntityType entityType) throws SQLException {
        Integer entityTypeId = this.mapEntityTypeId.get((Object)entityType);
        if (entityTypeId == null) {
            entityTypeId = this.insertEntityType(entityType);
            this.mapEntityTypeId.put(entityType, entityTypeId);
        }
        return entityTypeId;
    }

    private Integer insertEntityType(EntityType entityType) throws SQLException {
        String atdbAbbrev = EntityType.getATDBAbbrev(entityType);
        if (atdbAbbrev == null) {
            atdbAbbrev = entityType.name();
        }
        this.stat.executeUpdate("insert into EntityType (Name) values ('" + atdbAbbrev + "')");
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet generatedKeys = this.stat.getGeneratedKeys();){
            generatedKeys.next();
            int id = generatedKeys.getInt(1);
            return id;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String correctEntityName(String name) {
        name = StringUtils.replaceChars((String)name, (String)": ^\ufffd!\"\ufffd$%&/()=?`\ufffd{[]}\\|<>,;#'+*~", (String)"________________________________");
        return name;
    }

    private void executeUpdate(String ... sqls) throws SQLException {
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            this.stat.executeUpdate(sql);
            ++n2;
        }
    }

    public void insertEventTypes(SchedulingEntityType schedEntityType) throws Exception {
        EventDescriptionType eventDescription = schedEntityType.getEventDescription();
        EList eventIdMappings = eventDescription.getEventIdMapping();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement prep = this.conn.prepareStatement("insert into EventType values (?, ?);");){
            for (EventIdMappingType eventIdMapping : eventIdMappings) {
                Long eventTypeIdAlreadyPresent;
                long eventTypeId = eventIdMapping.getEventId().longValue();
                EventTypeEnum ot1EventType = eventIdMapping.getEventType();
                EventType eventType = EventType.getEventTypeForOT1(ot1EventType);
                if (eventType == null || this.mapEventTypeIdToEventType.containsKey(eventTypeId)) continue;
                if (this.mapEventTypeToEventTypeId.containsKey((Object)eventType) && (eventTypeIdAlreadyPresent = this.mapEventTypeToEventTypeId.get((Object)eventType)) != null) {
                    eventTypeIdAlreadyPresent.longValue();
                }
                this.mapEventTypeIdToEventType.put(eventTypeId, eventType);
                this.mapEventTypeToEventTypeId.put(eventType, eventTypeId);
                String eventTypeName = eventType.name();
                prep.setLong(1, eventTypeId);
                prep.setString(2, eventTypeName);
                prep.addBatch();
            }
            this.conn.setAutoCommit(false);
            prep.executeBatch();
            this.conn.setAutoCommit(true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void insertTraceEntries(SchedulingEntityType schedEntityType, long pSourceEntityId) throws SQLException {
        TimeValueType tickduration;
        double factor = 1.0;
        ClockType clock = schedEntityType.getClock();
        if (clock != null && (tickduration = clock.getTickduration()) != null) {
            BigInteger biNominator = tickduration.getNominator();
            BigInteger biDenominator = tickduration.getDenominator();
            if (biNominator != null && biDenominator != null) {
                long nominator = biNominator.longValue();
                long denominator = biDenominator.longValue();
                factor = (double)nominator / (double)denominator;
            }
            factor *= this.getUnitFactorToNs(tickduration.getUnit());
        }
        TracesType traces = schedEntityType.getTraces();
        EList xmlTraces = traces.getXmlTrace();
        for (XmlTraceType xmlTrace : xmlTraces) {
            EList traceEntries = xmlTrace.getTraceEntry();
            long lastTime = -1L;
            int timeCounter = 0;
            for (TraceEntryType traceEntry : traceEntries) {
                long time = traceEntry.getTime().longValue();
                if (time == 0L) {
                    ++this.timestampZeroCounter;
                }
                if (time != lastTime) {
                    timeCounter = 0;
                }
                long entityId = traceEntry.getElementRefId().longValue();
                long eventId = traceEntry.getEventId().longValue();
                long sourceEntityId = pSourceEntityId;
                EntityType entityType = this.mapEntityIdToEntityType.get(entityId);
                if (entityType == null) continue;
                Throwable throwable = null;
                Object var27_22 = null;
                try (PreparedStatement prep = this.getPreparedStatementForEntity(entityId);){
                    String tableName = this.mapEntityIdToTableName.get(entityId);
                    MutableLong tableCounter = this.mapTraceStatementCounter.get(tableName);
                    MutableLong lastEntityInstanceID = this.mapEntityIdInstanceCounter.get(entityId);
                    EventType eventType = this.mapEventTypeIdToEventType.get(eventId);
                    if (lastEntityInstanceID.longValue() == -1L && eventType == EventType.START && entityType == EntityType.PROCESS) {
                        this.cacheEntitySource(entityId, sourceEntityId);
                        this.insertZeroTimeActivation(entityId, sourceEntityId);
                    }
                    double timestampDouble = (double)time * factor;
                    long timestamp = (long)timestampDouble;
                    long remainder = (long)(timestampDouble * 1000.0) % 1000L;
                    long seqNr = timeCounter;
                    String value = null;
                    if (eventType == EventType.ACTIVATE && entityType == EntityType.PROCESS) {
                        lastEntityInstanceID.increment();
                        this.mapEntityIdStartTime.put(entityId, timestamp);
                    }
                    EventType lastEventType = this.mapEntityIdLastEventType.get(entityId);
                    if (eventType == EventType.START && lastEventType != EventType.ACTIVATE && (entityType == EntityType.PROCESS || entityType == EntityType.INTERRUPT)) {
                        lastEntityInstanceID.increment();
                        this.mapEntityIdStartTime.put(entityId, timestamp);
                        long id = tableCounter.longValue();
                        long entityInstanceId = lastEntityInstanceID.longValue();
                        long eventId2 = this.mapEventTypeToEventTypeId.get((Object)EventType.ACTIVATE);
                        prep.setLong(1, id);
                        prep.setLong(2, timestamp);
                        prep.setLong(3, remainder);
                        prep.setLong(4, seqNr);
                        prep.setLong(5, entityId);
                        prep.setLong(6, entityInstanceId);
                        prep.setLong(7, sourceEntityId);
                        prep.setLong(8, -1L);
                        prep.setLong(9, eventId2);
                        prep.setString(10, value);
                        prep.addBatch();
                        MutableInt bufCounter = this.mapTraceStatementsBufferCnt.get(tableName);
                        bufCounter.increment();
                        tableCounter.increment();
                        ++timeCounter;
                        ++this.globalEventCounter;
                    }
                    long entityInstanceId = lastEntityInstanceID.longValue();
                    long id = tableCounter.longValue();
                    if (eventType == EventType.TERMINATE && (entityType == EntityType.PROCESS || entityType == EntityType.INTERRUPT)) {
                        Long startTime = this.mapEntityIdStartTime.get(entityId);
                        if (startTime == null) {
                            startTime = 0L;
                        }
                        long endTime = timestamp;
                        this.insertEntityInstance(entityId, entityInstanceId, startTime, endTime);
                    }
                    this.cacheEntitySource(entityId, sourceEntityId);
                    prep.setLong(1, id);
                    prep.setLong(2, timestamp);
                    prep.setLong(3, remainder);
                    prep.setLong(4, seqNr);
                    prep.setLong(5, entityId);
                    prep.setLong(6, entityInstanceId);
                    prep.setLong(7, sourceEntityId);
                    prep.setLong(8, -1L);
                    prep.setLong(9, eventId);
                    prep.setString(10, value);
                    prep.addBatch();
                    MutableInt bufCounter = this.mapTraceStatementsBufferCnt.get(tableName);
                    bufCounter.increment();
                    if (bufCounter.intValue() > 1000) {
                        this.flushCache(entityId);
                    }
                    lastTime = time;
                    tableCounter.increment();
                    ++timeCounter;
                    ++this.globalEventCounter;
                    this.mapEntityIdLastEventType.put(entityId, eventType);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        this.flushOpenTraceStatements();
        this.flushEntityInstance();
    }

    private void flushOpenTraceStatements() throws SQLException {
        for (Map.Entry<String, PreparedStatement> entry : this.mapTraceStatements.entrySet()) {
            String tableName = entry.getKey();
            Throwable throwable = null;
            Object var5_6 = null;
            try (PreparedStatement prep = entry.getValue();){
                MutableInt mutableInt = this.mapTraceStatementsBufferCnt.get(tableName);
                if (mutableInt.intValue() == 0) continue;
                this.conn.setAutoCommit(false);
                prep.executeBatch();
                this.conn.setAutoCommit(true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void insertEntityInstance(long entityId, long entityInstanceId, Long startTime, long endTime) throws SQLException {
        if (this.prepInsertEntityInstance == null) {
            this.prepInsertEntityInstance = this.conn.prepareStatement("insert into EntityInstance (Id, EntityId, EntityInstanceId, TimeFrom, TimeTo) values (?, ?, ?, ?, ?);");
        }
        PreparedStatement prep = this.prepInsertEntityInstance;
        prep.setLong(1, this.counterPrepInsertEntityInstance);
        prep.setLong(2, entityId);
        prep.setLong(3, entityInstanceId);
        prep.setLong(4, startTime);
        prep.setLong(5, endTime);
        prep.addBatch();
        ++this.bufCounterPrepInsertEntityInstance;
        ++this.counterPrepInsertEntityInstance;
        if (this.bufCounterPrepInsertEntityInstance > 1000L) {
            this.flushEntityInstance();
        }
    }

    private void flushEntityInstance() throws SQLException {
        if (this.bufCounterPrepInsertEntityInstance > 0L) {
            this.conn.setAutoCommit(false);
            this.prepInsertEntityInstance.executeBatch();
            this.conn.setAutoCommit(true);
            this.bufCounterPrepInsertEntityInstance = 0L;
        }
    }

    private void cacheEntitySource(long entityId, long sourceEntityId) {
        Set<Long> set = this.mapEntitySourceCache.get(entityId);
        if (set == null) {
            set = new HashSet<Long>();
            this.mapEntitySourceCache.put(entityId, set);
        }
        set.add(sourceEntityId);
    }

    void fillEntitySource() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (PreparedStatement prep = this.conn.prepareStatement("insert into EntitySource (EntityId, SourceEntityId) values (?, ?);");){
            for (Map.Entry<Long, Set<Long>> entry : this.mapEntitySourceCache.entrySet()) {
                Set<Long> sourceEntityIds = entry.getValue();
                for (Long sourceEntityId : sourceEntityIds) {
                    prep.setLong(1, entry.getKey());
                    prep.setLong(2, sourceEntityId);
                    prep.addBatch();
                }
            }
            this.conn.setAutoCommit(false);
            prep.executeBatch();
            this.conn.setAutoCommit(true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void insertZeroTimeActivation(long entityId, long sourceEntityId) throws SQLException {
        long insertId;
        this.flushCache(entityId);
        String tableName = this.mapEntityIdToTableName.get(entityId);
        String sql = "select max(Id) from '" + tableName + "' where timestamp = 0;";
        Throwable throwable = null;
        Object var10_8 = null;
        try (ResultSet executeQuery = this.stat.executeQuery(sql);){
            insertId = executeQuery.next() ? executeQuery.getLong(1) + 1L : 1L;
            sql = "update '" + tableName + "' set Id = Id + 1 where Id >= " + insertId;
            this.stat.executeUpdate(sql);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        long id = insertId;
        long seqNr = this.timestampZeroCounter++;
        String value = null;
        long eventId = this.mapEventTypeToEventTypeId.get((Object)EventType.ACTIVATE);
        Throwable throwable3 = null;
        Object var17_17 = null;
        try (PreparedStatement prep = this.getPreparedStatementForEntity(entityId);){
            prep.setLong(1, id);
            prep.setLong(2, 0L);
            prep.setLong(3, 0L);
            prep.setLong(4, seqNr);
            prep.setLong(5, entityId);
            prep.setLong(6, 0L);
            prep.setLong(7, sourceEntityId);
            prep.setLong(8, -1L);
            prep.setLong(9, eventId);
            prep.setString(10, value);
            prep.addBatch();
            MutableInt bufCounter = this.mapTraceStatementsBufferCnt.get(tableName);
            bufCounter.increment();
            MutableLong tableCounter = this.mapTraceStatementCounter.get(tableName);
            tableCounter.increment();
            this.mapEntityIdStartTime.put(entityId, 0L);
            MutableLong lastEntityInstanceID = this.mapEntityIdInstanceCounter.get(entityId);
            lastEntityInstanceID.increment();
            this.mapEntityIdStartTime.put(entityId, 0L);
            EventType eventType = this.mapEventTypeIdToEventType.get(eventId);
            this.mapEntityIdLastEventType.put(entityId, eventType);
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }

    private void flushCache(long entityId) throws SQLException {
        Throwable throwable = null;
        Object var4_4 = null;
        try (PreparedStatement prep = this.getPreparedStatementForEntity(entityId);){
            String tableNameForEntity = this.getTableNameForEntity(entityId);
            MutableInt bufCounter = this.mapTraceStatementsBufferCnt.get(tableNameForEntity);
            if (bufCounter.longValue() > 0L) {
                this.conn.setAutoCommit(false);
                prep.executeBatch();
                this.conn.setAutoCommit(true);
                bufCounter.setValue(0);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private double getUnitFactorToNs(TimeBaseEnum unit) {
        if (unit == null) {
            return 1.0;
        }
        switch (unit) {
            case MS: {
                return 1000.0;
            }
            case NS: {
                return 1.0;
            }
            case S: {
                return 1000000.0;
            }
            case US: {
                return 0.001;
            }
        }
        return 1.0;
    }

    private PreparedStatement getPreparedStatementForEntity(long targetEntityId) throws SQLException {
        String entityTableName = this.mapEntityIdToTableName.get(targetEntityId);
        PreparedStatement preparedStatement = null;
        if (entityTableName != null) {
            preparedStatement = this.mapTraceStatements.get(entityTableName);
        }
        if (preparedStatement == null) {
            String createEntityEventTable = this.createEntityEventTable(targetEntityId);
            preparedStatement = this.conn.prepareStatement("insert into '" + createEntityEventTable + "' (Id, Timestamp, Remainder, SQCNR, EntityId, EntityInstanceId, SourceEntityId, SourceEntityInstanceId, EventTypeId, Value) " + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            this.mapTraceStatements.put(createEntityEventTable, preparedStatement);
            this.mapTraceStatementCounter.put(createEntityEventTable, new MutableLong(1L));
            this.mapTraceStatementsBufferCnt.put(createEntityEventTable, new MutableInt(0));
            this.mapEntityIdToTableName.put(targetEntityId, createEntityEventTable);
        }
        return preparedStatement;
    }

    private String createEntityEventTable(long targetEntityId) throws SQLException {
        String tableName = this.getTableNameForEntity(targetEntityId);
        String sql1 = "CREATE TABLE '" + tableName + "' ( Id INTEGER PRIMARY KEY ASC, Timestamp INT8, Remainder INTEGER, SQCNR INTEGER, EntityId INTEGER, EntityInstanceId INTEGER, SourceEntityId INTEGER, SourceEntityInstanceId INTEGER, EventTypeId INTEGER, Value TEXT);";
        String sql2 = "CREATE INDEX '" + tableName + "_SourceEntityIdIndex' ON '" + tableName + "' (SourceEntityId, Timestamp);";
        String sql3 = "CREATE INDEX '" + tableName + "_EntityInstanceIdIndex' ON '" + tableName + "' (EntityId, EntityInstanceId, Timestamp);";
        String sql4 = "update Entity set HasEvents=1, EventTableName='" + tableName + "' where Id = " + targetEntityId;
        this.executeUpdate(sql1, sql2, sql3, sql4);
        return tableName;
    }

    private String getTableNameForEntity(long targetEntityId) {
        String name = this.mapEntityIdToEntityName.get(targetEntityId);
        EntityType type = this.mapEntityIdToEntityType.get(targetEntityId);
        if (type == EntityType.SIGNAL) {
            return "Signal_Event";
        }
        return String.valueOf(name) + ":" + EntityType.getATDBAbbrev(type) + ":" + targetEntityId + "_Event";
    }

    public void setMetaInformation(String name, String value) {
        try {
            if (this.getMetaInformation(name) == null) {
                this.insertIntoMetaInfo.setString(1, name);
                this.insertIntoMetaInfo.setString(2, value);
                this.insertIntoMetaInfo.execute();
            } else {
                this.updateMetaInfo.setString(1, value);
                this.updateMetaInfo.setString(2, name);
                this.updateMetaInfo.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getMetaInformation(String name) {
        try {
            this.selectFromMetaInfo.setString(1, name);
            Throwable throwable = null;
            Object var3_5 = null;
            try (ResultSet result = this.selectFromMetaInfo.executeQuery();){
                String value = null;
                if (result.next()) {
                    value = result.getString(1);
                }
                return value;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fillMetaInformation(String input) {
        this.setMetaInformation("db_version", "v0.2.0");
        this.setMetaInformation("events_written", String.valueOf(this.globalEventCounter));
        this.setMetaInformation("input", input);
        this.setMetaInformation("time_base", "ns");
    }
}

