/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.software;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Channel;
import org.eclipse.app4mc.amalthea.model.ChannelAccess;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.amalthea.validations.sim.software.SimSoftwareMemoryAccessFeasibility;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Sim-Software-ChannelAccessFeasibility", checks={"Checks if a channel access can be performed from certain runnable, as a hosting processing unit must be able to access the channel's memory location."})
public class SimSoftwareChannelAccessFeasibility
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getChannelAccess();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof ChannelAccess) {
            ChannelAccess channelAccess = (ChannelAccess)eObject;
            if (channelAccess == null || channelAccess.getData() == null) {
                return;
            }
            Channel abstractMemoryElement = channelAccess.getData();
            if (!SimSoftwareMemoryAccessFeasibility.validate(results, (ActivityGraphItem)channelAccess, (AbstractMemoryElement)abstractMemoryElement)) {
                this.addIssue(results, (EObject)channelAccess, (EStructuralFeature)ePackage.getChannelAccess_Data(), SimSoftwareChannelAccessFeasibility.getMessage());
            }
        }
    }

    public static String getMessage() {
        return "Channel's memory location is not accessible from each core, onto which this activity item is deployed.";
    }
}

