/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb;

import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.atdb.DBConnection;
import org.eclipse.app4mc.atdb.EntityType;

public class ATDBBuilder {
    private final DBConnection<?> connection;

    public ATDBBuilder(DBConnection<?> connection) throws SQLException {
        this.connection = connection;
    }

    public ATDBBuilder createBasicDBStructure() throws SQLException {
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS metaInformation (\n  name  TEXT PRIMARY KEY,\n  value TEXT\n);");
        this.connection.executeUpdate("INSERT OR IGNORE INTO metaInformation VALUES('dbVersion', 'v1.0.0');");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS entityType (\n  id   INTEGER PRIMARY KEY,\n  name TEXT NOT NULL UNIQUE\n);");
        this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS entityTypeIndex ON entityType(name);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS entity (\n  id           INTEGER PRIMARY KEY,\n  name         TEXT NOT NULL UNIQUE,\n  entityTypeId REFERENCES entityType(id)\n);");
        this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS entityIndex ON entity(name);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS entityInstance (\n  entityId REFERENCES entity(id),\n  sqcnr    INTEGER,\n  PRIMARY KEY(entityId, sqcnr)\n);");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS entityInstanceIndex ON entityInstance(entityId, sqcnr);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS eventType (\n  id   INTEGER PRIMARY KEY,\n  name TEXT NOT NULL UNIQUE\n);");
        this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS eventTypeIndex ON eventType(name);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS property (\n  id   INTEGER PRIMARY KEY,\n  name TEXT NOT NULL UNIQUE,\n  type TEXT);");
        this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS propertyIndex ON property(name);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS propertyValue (\n  entityId   REFERENCES entity(id),\n  propertyId REFERENCES property(id),\n  sqcnr      INTEGER DEFAULT 0,\n  value      TEXT,\n  PRIMARY KEY(entityId, propertyId, sqcnr)\n);");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS propertyValueIndex ON propertyValue(entityId, propertyId);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS event (\n  id             INTEGER PRIMARY KEY,\n  name           TEXT NOT NULL UNIQUE,\n  eventTypeId    REFERENCES eventType,\n  entityId       REFERENCES entity,\n  sourceEntityId REFERENCES entity DEFAULT NULL\n);");
        this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS eventIndex ON event(name);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS metric (\n  id        INTEGER PRIMARY KEY,\n  name      TEXT NOT NULL UNIQUE,\n  dimension TEXT NOT NULL\n);");
        this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS metricIndex ON metric(name);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS entityMetricInstanceValue (\n  entityId       REFERENCES entity(id),\n  metricId       REFERENCES metric(id),\n  sqcnr          INTEGER,\n  value          TEXT,\n  PRIMARY KEY(entityId, metricId, sqcnr)\n);");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS entityMetricInstanceValueIndex ON entityMetricInstanceValue(entityId, metricId, sqcnr);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS entityInstanceMetricValue (\n  entityId       ,\n  entityInstance ,\n  metricId       REFERENCES metric(id),\n  value          TEXT,\n  PRIMARY KEY(entityId, entityInstance, metricId),\n  FOREIGN KEY(entityId, entityInstance) REFERENCES entityInstance\n);");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS entityInstanceMetricValueIndex ON entityInstanceMetricValue(entityId, entityInstance, metricId);");
        this.connection.executeUpdate("CREATE TABLE IF NOT EXISTS entityMetricValue (\n  entityId REFERENCES entity(id),\n  metricId REFERENCES metric(id),\n  value    TEXT,\n  PRIMARY KEY(entityId, metricId)\n);");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS entityMetricValueIndex ON entityMetricValue(entityId, metricId);");
        return this;
    }

    public ATDBBuilder createBasicViews() throws SQLException {
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vPropertyValue AS SELECT\n  (SELECT name FROM entity WHERE id = propertyValue.entityId) AS entityName,\n  (SELECT name FROM entityType WHERE id = (SELECT entityTypeId FROM entity WHERE id = propertyValue.entityId)) AS entityType,\n  (SELECT name FROM property WHERE id = propertyValue.propertyId) AS propertyName,\n  (SELECT type FROM property WHERE id = propertyValue.propertyId) AS propertyType,\n  (GROUP_CONCAT(CASE\n" + Stream.of("entity", "event").map(tableName -> String.format("    WHEN %2$s.propertyId IN (SELECT id FROM property WHERE type = '%1$sIdRef') THEN\n      (SELECT name FROM %1$s WHERE id = %2$s.value)\n", tableName, "propertyValue")).collect(Collectors.joining()) + "    ELSE\n" + "      propertyValue.value\n" + "  END, ', ')) AS value\n" + "FROM propertyValue GROUP BY entityId, propertyId ORDER BY entityId, propertyId;");
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vEvent AS SELECT\n  name,\n  (SELECT name FROM eventType WHERE id = eventTypeId) AS eventType,\n  (SELECT name FROM entity WHERE id = entityId) AS entityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = event.entityId)\n  ) AS entityType,\n  (SELECT name FROM entity WHERE id = sourceEntityId) AS sourceEntityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = event.sourceEntityId)\n  ) AS sourceEntityType\nFROM event;");
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vEventChainEntity AS SELECT\n  name AS eventChainName,\n  (SELECT GROUP_CONCAT((SELECT name FROM event  WHERE id = value), ', ') FROM propertyValue WHERE\n    entityId = ecEntity.id AND propertyId = (SELECT id FROM property WHERE name = 'ecStimulus')) AS stimulus,\n  (SELECT GROUP_CONCAT((SELECT name FROM event  WHERE id = value), ', ') FROM propertyValue WHERE\n    entityId = ecEntity.id AND propertyId = (SELECT id FROM property WHERE name = 'ecResponse')) AS response,\n  (SELECT GROUP_CONCAT((SELECT name FROM entity WHERE id = value), ', ') FROM propertyValue WHERE\n    entityId = ecEntity.id AND propertyId = (SELECT id FROM property WHERE name = 'ecItems')) AS items,\n  (SELECT value FROM propertyValue WHERE entityId = ecEntity.id AND propertyId =    (SELECT id FROM property WHERE name = 'ecMinItemsCompleted')) AS minItemsCompleted,\n  EXISTS(SELECT value FROM propertyValue WHERE entityId = ecEntity.id AND propertyId =    (SELECT id FROM property WHERE name = 'ecMinItemsCompleted')) AS isParallel\nFROM entity AS ecEntity WHERE entityTypeId = (SELECT id FROM entityType WHERE entityType.name = 'EC');");
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vEntityMetricInstanceValue AS SELECT\n  (SELECT name FROM entity WHERE id = entityMetricInstanceValue.entityId) AS entityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = entityMetricInstanceValue.entityId)\n  ) AS entityType,\n  (SELECT name FROM metric WHERE id = entityMetricInstanceValue.metricId) AS metricName,\n  entityMetricInstanceValue.sqcnr,\n  entityMetricInstanceValue.value\nFROM entityMetricInstanceValue\nORDER BY entityId, metricId, sqcnr;");
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vEntityInstanceMetricValue AS SELECT\n  (SELECT name FROM entity WHERE id = entityInstanceMetricValue.entityId) AS entityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = entityInstanceMetricValue.entityId)\n  ) AS entityType,\n  entityInstanceMetricValue.entityInstance,\n  (SELECT name FROM metric WHERE id = entityInstanceMetricValue.metricId) AS metricName,\n  entityInstanceMetricValue.value\nFROM entityInstanceMetricValue\nORDER BY entityId, entityInstance, metricId;");
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vEntityMetricValue AS SELECT\n  (SELECT name FROM entity WHERE id = entityMetricValue.entityId) AS entityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = entityMetricValue.entityId)\n  ) AS entityType,\n  (SELECT name FROM metric WHERE id = entityMetricValue.metricId) AS metricName,\n  entityMetricValue.value\nFROM entityMetricValue\nORDER BY entityId, metricId;");
        return this;
    }

    private static String getPersistableTablePrefix(boolean persistTable) {
        return "CREATE" + (persistTable ? " " : " TEMPORARY ") + "TABLE IF NOT EXISTS ";
    }

    private static String getInstRuntimeEventsQuery(EntityType<?> entityType) {
        String events = entityType.getPossibleEvents().stream().map(e -> "'" + e.toString().toLowerCase() + "'").collect(Collectors.joining(", "));
        String traceAliases = entityType.getTraceAliases().stream().map(ta -> "'" + ta + "'").collect(Collectors.joining(", "));
        return "  SELECT timestamp, sqcnr, entityId, entityInstance, sourceEntityId, sourceEntityInstance, eventTypeId\n  FROM traceEvent WHERE\n    eventTypeId IN (SELECT id FROM eventType WHERE name IN (" + events + ")) AND\n" + "    entityId IN (SELECT id FROM entity WHERE entityTypeId IN\n" + "      (SELECT id FROM entityType WHERE name IN (" + traceAliases + "))\n" + "    )\n" + "  GROUP BY entityId, entityInstance, timestamp, sqcnr";
    }

    private static String getInstEventInfosQuery(EntityType<?> entityType) {
        return "SELECT *, (" + String.join((CharSequence)" AND ", entityType.getValidityConstraints()) + ") isComplete " + "FROM (SELECT" + " entityId," + " entityInstance," + entityType.getPossibleEvents().stream().map(e -> " SUM(CASE WHEN eventTypeId = (SELECT id FROM eventType WHERE name = '" + e.toString().toLowerCase() + "') THEN 1 ELSE 0 END) " + e + "EventCount").collect(Collectors.joining(",")) + " FROM " + entityType.getName() + "InstanceRuntimeTraceEvent GROUP BY entityId, entityInstance)";
    }

    public ATDBBuilder createOptionalAndTemporaryTables(Collection<? extends EntityType<?>> entityTypes, boolean persistOptionalTables) throws SQLException {
        String persistableTablePref = ATDBBuilder.getPersistableTablePrefix(persistOptionalTables);
        this.connection.executeUpdate(String.valueOf(persistableTablePref) + "traceEvent (\n" + "  timestamp            INTEGER,\n" + "  sqcnr                INTEGER,\n" + "  entityId             INTEGER,\n" + "  entityInstance       INTEGER,\n" + "  sourceEntityId       INTEGER,\n" + "  sourceEntityInstance INTEGER,\n" + "  eventTypeId          INTEGER,\n" + "  value                TEXT,\n" + "  PRIMARY KEY(timestamp, sqcnr)" + (persistOptionalTables ? ",\n  FOREIGN KEY(entityId, entityInstance) REFERENCES entityInstance,\n  FOREIGN KEY(sourceEntityId, sourceEntityInstance) REFERENCES entityInstance,\n  FOREIGN KEY(eventTypeId) REFERENCES eventType\n" : "\n") + ");");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS traceEventIndex ON traceEvent(timestamp, sqcnr);");
        this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS traceEventIndexForECs ON traceEvent(entityId, eventTypeId);");
        this.createTemporaryEntityFilteredTraceEventTables(entityTypes);
        for (EntityType<?> et : entityTypes) {
            this.connection.executeUpdate(String.valueOf(persistableTablePref) + et.getName() + "InstanceTraceInfo (\n" + "  entityId             INTEGER,\n" + "  entityInstance       INTEGER,\n" + et.getPossibleEvents().stream().map(e -> String.valueOf(e.toString().toLowerCase()) + "EventCount  INTEGER,\n").collect(Collectors.joining()) + "  isComplete           BOOLEAN,\n" + "  PRIMARY KEY(entityId, entityInstance)\n" + ");");
            this.connection.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS " + et.getName() + "InstanceTraceInfoIndex ON " + et.getName() + "InstanceTraceInfo(entityId, entityInstance);");
        }
        this.connection.executeUpdate(String.valueOf(persistableTablePref) + "eventChainInstanceInfo (\n" + "  entityId          INTEGER,\n" + "  entityInstance    INTEGER,\n" + "  stimulusTimestamp INTEGER,\n" + "  stimulusSqcnr     INTEGER,\n" + "  responseTimestamp INTEGER,\n" + "  responseSqcnr     INTEGER,\n" + "  isAge             BOOLEAN,\n" + "  isReaction        BOOLEAN,\n" + "  PRIMARY KEY(entityId, entityInstance),\n" + "  FOREIGN KEY(stimulusTimestamp, stimulusSqcnr) REFERENCES traceEvent,\n" + "  FOREIGN KEY(responseTimestamp, responseSqcnr) REFERENCES traceEvent" + (persistOptionalTables ? ",\n  FOREIGN KEY(entityId, entityInstance) REFERENCES entityInstance" : "") + "\n);");
        return this;
    }

    public ATDBBuilder createTemporaryEntityFilteredTraceEventTables(Collection<? extends EntityType<?>> entityTypes) throws SQLException {
        for (EntityType<?> et : entityTypes) {
            this.connection.executeUpdate("CREATE TEMPORARY TABLE IF NOT EXISTS " + et.getName() + "InstanceRuntimeTraceEvent (\n" + "  timestamp            INTEGER,\n" + "  sqcnr                INTEGER,\n" + "  entityId             INTEGER,\n" + "  entityInstance       INTEGER,\n" + "  sourceEntityId       INTEGER,\n" + "  sourceEntityInstance INTEGER,\n" + "  eventTypeId          INTEGER,\n" + "  PRIMARY KEY(timestamp, sqcnr)\n" + ");");
            this.connection.executeUpdate("CREATE INDEX IF NOT EXISTS " + et.getName() + "InstanceRuntimeTraceEventIndex ON " + et.getName() + "InstanceRuntimeTraceEvent(entityId, entityInstance, eventTypeId);");
        }
        return this;
    }

    public ATDBBuilder createOptionalViews(Collection<? extends EntityType<?>> entityTypes) throws SQLException {
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vTraceEvent AS SELECT\n  traceEvent.timestamp,\n  traceEvent.sqcnr,\n  (SELECT name FROM entity WHERE id = traceEvent.entityId) AS entityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = traceEvent.entityId)\n  ) AS entityType,\n  traceEvent.entityInstance,\n  (SELECT name FROM entity WHERE id = traceEvent.sourceEntityId) AS sourceEntityName,\n  (SELECT name FROM entityType WHERE id =\n    (SELECT entityTypeId FROM entity WHERE id = traceEvent.sourceEntityId)\n  ) AS sourceEntityType,\n  traceEvent.sourceEntityInstance,\n  (SELECT name FROM eventType WHERE id = traceEvent.eventTypeId) AS eventType,\n  traceEvent.value\nFROM traceEvent;");
        for (EntityType<?> et : entityTypes) {
            String reDBName = String.valueOf(et.getName()) + "InstanceRuntimeTraceEvent";
            this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS v" + reDBName + " AS SELECT\n" + "  timestamp,\n" + "  sqcnr,\n" + "  (SELECT name FROM entity WHERE id = entityId) AS " + et.getUCName() + "Name,\n" + "  entityInstance,\n" + "  (SELECT name FROM entity WHERE id = sourceEntityId) AS sourceEntityName,\n" + "  sourceEntityInstance,\n" + "  (SELECT name FROM eventType WHERE id = " + "eventTypeId) AS eventType\n" + "FROM (\n" + ATDBBuilder.getInstRuntimeEventsQuery(et) + "\n);");
            String eiDBName = String.valueOf(et.getName()) + "InstanceTraceInfo";
            String eventCountColumns = et.getPossibleEvents().stream().map(ev -> String.valueOf(eiDBName) + "." + ev.toString().toLowerCase() + "EventCount").collect(Collectors.joining(",\n  "));
            this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS v" + eiDBName + " AS SELECT\n" + "  (SELECT name FROM entity WHERE id = " + eiDBName + ".entityId) AS " + et.getUCName() + "Name,\n" + "  " + eiDBName + ".entityInstance,\n" + "  " + eventCountColumns + ",\n" + "  " + eiDBName + ".isComplete\n" + "FROM " + eiDBName + ";");
        }
        this.connection.executeUpdate("CREATE VIEW IF NOT EXISTS vEventChainInstanceInfo AS SELECT\n  (SELECT name FROM entity WHERE id = entityId) AS eventChainName,\n  entityInstance AS ecInstance,\n  stimulusTimestamp,\n  (SELECT name FROM entity WHERE id = (SELECT entityId FROM traceEvent WHERE timestamp = stimulusTimestamp AND sqcnr = stimulusSqcnr)) AS stimulusEntityName,\n  (SELECT entityInstance FROM traceEvent WHERE timestamp = stimulusTimestamp AND sqcnr = stimulusSqcnr) AS stimulusEntityInstance,\n  (SELECT name FROM eventType WHERE id = (SELECT eventTypeId FROM traceEvent WHERE timestamp = stimulusTimestamp AND sqcnr = stimulusSqcnr)) AS stimulusEvent,\n  responseTimestamp,\n  (SELECT name FROM entity WHERE id = (SELECT entityId FROM traceEvent WHERE timestamp = responseTimestamp AND sqcnr = responseSqcnr)) AS responseEntityName,\n  (SELECT entityInstance FROM traceEvent WHERE timestamp = responseTimestamp AND sqcnr = responseSqcnr) AS responseEntityInstance,\n  (SELECT name FROM eventType WHERE id = (SELECT eventTypeId FROM traceEvent WHERE timestamp = responseTimestamp AND sqcnr = responseSqcnr)) AS responseEvent,\n  (CASE WHEN isAge AND isReaction THEN 'age/reaction' WHEN isAge THEN 'age' WHEN isReaction THEN 'reaction' END) AS latencyType\nFROM eventChainInstanceInfo;");
        return this;
    }

    public void autoPopulateEntityFilteredTraceEventTables(Collection<? extends EntityType<?>> entityTypes) throws SQLException {
        for (EntityType<?> et : entityTypes) {
            this.connection.executeUpdate("INSERT INTO " + et.getName() + "InstanceRuntimeTraceEvent\n" + ATDBBuilder.getInstRuntimeEventsQuery(et) + ";");
            this.connection.executeUpdate("INSERT INTO " + et.getName() + "InstanceTraceInfo\n" + ATDBBuilder.getInstEventInfosQuery(et) + ";");
        }
    }
}

