/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea.handler;

import java.util.List;
import javax.inject.Named;
import org.eclipse.app4mc.atdb._import.amalthea.wizard.ImportWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class AMXMI2ATDBImport {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, IWorkbenchWindow runnableContext) {
        List selectionList = selection.toList();
        String amxmiSource = selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("amxmi")).map(f -> f.getLocation().toString()).findFirst().orElseThrow(() -> new IllegalArgumentException("Selection does not contain an *.amxmi file!"));
        String atdbSource = selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("atdb")).map(f -> f.getLocation().toString()).findFirst().orElseThrow(() -> new IllegalArgumentException("Selection does not contain an *.atdb file!"));
        IFile atdbTarget = selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("amxmi")).map(f -> f.getParent()).map(c -> {
            int from = Math.max(amxmiSource.lastIndexOf(47), amxmiSource.lastIndexOf(92));
            int to = amxmiSource.lastIndexOf(".amxmi");
            String name = amxmiSource.substring(from + 1, to);
            return c.getProject().getFile(String.valueOf(name) + ".atdb");
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("Selected *.amxmi file is not part of a Eclipse workspace!"));
        if (amxmiSource.length() == 0 || atdbSource.length() == 0) {
            return;
        }
        if (runnableContext == null) {
            return;
        }
        ImportWizard.importAndOpenInIDE(amxmiSource, atdbSource, atdbTarget, true, (IRunnableContext)runnableContext);
    }
}

