/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.misc;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-Constraints-EventChain", checks={"Stimulus and response shall not reference the same event", "The stimulus of the first segment has to be the same as the stimulus of the event chain", "The stimulus of other segments have to be equal to the response of the previous segment", "The response of the last segment has to be the same as the response of the event chain"})
public class AmConstraintsEventChain
extends AmaltheaValidation {
    private static final String EVENT_CHAIN = "Event Chain ";

    public EClassifier getEClassifier() {
        return ePackage.getAbstractEventChain();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof AbstractEventChain) {
            AbstractEventChain chain = (AbstractEventChain)object;
            this.checkChainConsistency(chain, results);
        }
    }

    private void checkChainConsistency(AbstractEventChain eventChain, List<ValidationDiagnostic> results) {
        if (eventChain == null) {
            return;
        }
        Event stimulus = eventChain.getStimulus();
        Event response = eventChain.getResponse();
        if (stimulus != null && response != null && stimulus == response) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Stimulus(), EVENT_CHAIN + this.name((INamed)eventChain) + ": stimulus and response refer to the same event");
        }
        switch (eventChain.getItemType()) {
            case SEQUENCE: {
                this.checkSequence(eventChain, (EList<EventChainItem>)eventChain.getItems(), results);
                break;
            }
            case PARALLEL: {
                this.checkParallel(eventChain, (EList<EventChainItem>)eventChain.getItems(), results);
                break;
            }
        }
    }

    private void checkSequence(AbstractEventChain eventChain, EList<EventChainItem> eventChainItems, List<ValidationDiagnostic> results) {
        if (eventChainItems == null || eventChainItems.isEmpty()) {
            return;
        }
        if (eventChainItems.contains(null)) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": sequence item list contains null reference");
        }
        List subEventChains = eventChainItems.stream().map(EventChainItem::getEventChain).filter(Objects::nonNull).collect(Collectors.toList());
        AbstractEventChain first = (AbstractEventChain)subEventChains.get(0);
        AbstractEventChain last = (AbstractEventChain)subEventChains.get(subEventChains.size() - 1);
        if (eventChain.getStimulus() != first.getStimulus()) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": stimulus of first sequence item <> stimulus of event chain");
        }
        if (eventChain.getResponse() != last.getResponse()) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": response of last sequence item <> response of event chain");
        }
        int i = 0;
        while (i < subEventChains.size() - 1) {
            AbstractEventChain current = (AbstractEventChain)subEventChains.get(i);
            AbstractEventChain next = (AbstractEventChain)subEventChains.get(i + 1);
            if (current.getResponse() != next.getStimulus()) {
                this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": response of sequence item " + i + " <> stimulus of sequence item " + (i + 1));
            }
            ++i;
        }
    }

    private void checkParallel(AbstractEventChain eventChain, EList<EventChainItem> eventChainItems, List<ValidationDiagnostic> results) {
        if (eventChainItems == null || eventChainItems.isEmpty()) {
            return;
        }
        if (eventChainItems.contains(null)) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": parallel item list contains null reference");
        }
        List subEventChains = eventChainItems.stream().map(EventChainItem::getEventChain).filter(Objects::nonNull).collect(Collectors.toList());
        for (AbstractEventChain subEC : subEventChains) {
            if (eventChain.getStimulus() != subEC.getStimulus()) {
                this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": stimulus of parallel sub chain " + this.name((INamed)subEC) + " <> stimulus of event chain");
            }
            if (eventChain.getResponse() == subEC.getResponse()) continue;
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Items(), EVENT_CHAIN + this.name((INamed)eventChain) + ": response of parallel sub chain " + this.name((INamed)subEC) + " <> response of event chain");
        }
    }
}

