/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.model.AbstractElementMappingConstraint;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceType;
import org.eclipse.app4mc.amalthea.model.Alias;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ArchitectureRequirement;
import org.eclipse.app4mc.amalthea.model.ArithmeticExpression;
import org.eclipse.app4mc.amalthea.model.ArithmeticOperator;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry;
import org.eclipse.app4mc.amalthea.model.AsynchronousServerCall;
import org.eclipse.app4mc.amalthea.model.BaseTypeDefinition;
import org.eclipse.app4mc.amalthea.model.BigIntegerObject;
import org.eclipse.app4mc.amalthea.model.BlockingType;
import org.eclipse.app4mc.amalthea.model.BooleanObject;
import org.eclipse.app4mc.amalthea.model.CPUPercentageMetric;
import org.eclipse.app4mc.amalthea.model.CPUPercentageRequirementLimit;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.ChainedProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Channel;
import org.eclipse.app4mc.amalthea.model.ChannelAccess;
import org.eclipse.app4mc.amalthea.model.ChannelFillCondition;
import org.eclipse.app4mc.amalthea.model.ChannelFillRef;
import org.eclipse.app4mc.amalthea.model.ChannelReceive;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.CoherencyDirection;
import org.eclipse.app4mc.amalthea.model.CombinatorialCondition;
import org.eclipse.app4mc.amalthea.model.Component;
import org.eclipse.app4mc.amalthea.model.ComponentInstance;
import org.eclipse.app4mc.amalthea.model.ComponentInterface;
import org.eclipse.app4mc.amalthea.model.ComponentPort;
import org.eclipse.app4mc.amalthea.model.ComponentScope;
import org.eclipse.app4mc.amalthea.model.ComponentStructure;
import org.eclipse.app4mc.amalthea.model.Composite;
import org.eclipse.app4mc.amalthea.model.ConditionDisjunction;
import org.eclipse.app4mc.amalthea.model.Connector;
import org.eclipse.app4mc.amalthea.model.CoreClassification;
import org.eclipse.app4mc.amalthea.model.CountMetric;
import org.eclipse.app4mc.amalthea.model.CountRequirementLimit;
import org.eclipse.app4mc.amalthea.model.CustomEvent;
import org.eclipse.app4mc.amalthea.model.CustomEventTrigger;
import org.eclipse.app4mc.amalthea.model.DataAgeCycle;
import org.eclipse.app4mc.amalthea.model.DataAgeTime;
import org.eclipse.app4mc.amalthea.model.DataCoherencyGroup;
import org.eclipse.app4mc.amalthea.model.DataGroupScope;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.DataRateUnit;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.DataStability;
import org.eclipse.app4mc.amalthea.model.DataTypeDefinition;
import org.eclipse.app4mc.amalthea.model.DirectionType;
import org.eclipse.app4mc.amalthea.model.DoubleObject;
import org.eclipse.app4mc.amalthea.model.EntityEvent;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainContainer;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.EventConfig;
import org.eclipse.app4mc.amalthea.model.FloatObject;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyMetric;
import org.eclipse.app4mc.amalthea.model.FrequencyRequirementLimit;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.GetResultServerCall;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.GroupingType;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ILocalModeValueSource;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.IntegerConst;
import org.eclipse.app4mc.amalthea.model.IntegerObject;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.InterfaceKind;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.ListObject;
import org.eclipse.app4mc.amalthea.model.LocalModeCondition;
import org.eclipse.app4mc.amalthea.model.LocalModeLabel;
import org.eclipse.app4mc.amalthea.model.LocalModeLabelAssignment;
import org.eclipse.app4mc.amalthea.model.LocalModeLabelRef;
import org.eclipse.app4mc.amalthea.model.LocalModeValue;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.MainInterface;
import org.eclipse.app4mc.amalthea.model.MapObject;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryClassification;
import org.eclipse.app4mc.amalthea.model.MemoryMapping;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeAssignment;
import org.eclipse.app4mc.amalthea.model.ModeConditionConjunction;
import org.eclipse.app4mc.amalthea.model.ModeConditionDisjunction;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.ModeLabelAssignment;
import org.eclipse.app4mc.amalthea.model.ModeLabelCondition;
import org.eclipse.app4mc.amalthea.model.ModeLabelRef;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeLiteralConst;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.ModeValueCondition;
import org.eclipse.app4mc.amalthea.model.ModeValueList;
import org.eclipse.app4mc.amalthea.model.Namespace;
import org.eclipse.app4mc.amalthea.model.NonAtomicDataCoherency;
import org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.OrderType;
import org.eclipse.app4mc.amalthea.model.OsAPIOverhead;
import org.eclipse.app4mc.amalthea.model.OsDataConsistency;
import org.eclipse.app4mc.amalthea.model.OsDataConsistencyMode;
import org.eclipse.app4mc.amalthea.model.OsISROverhead;
import org.eclipse.app4mc.amalthea.model.OsOverhead;
import org.eclipse.app4mc.amalthea.model.ParameterType;
import org.eclipse.app4mc.amalthea.model.PercentageMetric;
import org.eclipse.app4mc.amalthea.model.PercentageRequirementLimit;
import org.eclipse.app4mc.amalthea.model.PhysicalSectionConstraint;
import org.eclipse.app4mc.amalthea.model.PhysicalSectionMapping;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessAllocationConstraint;
import org.eclipse.app4mc.amalthea.model.ProcessChain;
import org.eclipse.app4mc.amalthea.model.ProcessChainRequirement;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessPrototypeAllocationConstraint;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.ProcessScope;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.QualifiedPort;
import org.eclipse.app4mc.amalthea.model.ReferenceObject;
import org.eclipse.app4mc.amalthea.model.RelationalOperator;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableAllocation;
import org.eclipse.app4mc.amalthea.model.RunnableAllocationConstraint;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.model.RunnableRequirement;
import org.eclipse.app4mc.amalthea.model.RunnableScope;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.SchedulerAssociation;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.Section;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.SemaphoreAccess;
import org.eclipse.app4mc.amalthea.model.SemaphoreAccessEnum;
import org.eclipse.app4mc.amalthea.model.SenderReceiverRead;
import org.eclipse.app4mc.amalthea.model.SenderReceiverWrite;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.StructureType;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.model.SubInterface;
import org.eclipse.app4mc.amalthea.model.SwitchEntry;
import org.eclipse.app4mc.amalthea.model.SynchronousServerCall;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.TagGroup;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TransmissionPolicy;
import org.eclipse.app4mc.amalthea.model.TypeDefinition;
import org.eclipse.app4mc.amalthea.model.TypeRef;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.Voltage;
import org.eclipse.app4mc.amalthea.model.VoltageUnit;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.WaitingBehaviour;
import org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl;
import org.eclipse.app4mc.amalthea.model.impl.InterfaceChannelImpl;
import org.eclipse.app4mc.amalthea.model.impl.NeedEntryImpl;
import org.eclipse.app4mc.amalthea.model.impl.SchedulingParameterImpl;
import org.eclipse.app4mc.amalthea.model.impl.TicksEntryImpl;
import org.eclipse.app4mc.amalthea.model.provider.CustomDeviationItemProviderService;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CustomItemProviderService {
    private static void addParentLabelNotification(List<ViewerNotification> list, Notification notification) {
        CustomItemProviderService.addParentLabelNotification(list, notification, 1);
    }

    private static void addParentLabelNotification(List<ViewerNotification> list, Notification notification, int number) {
        Object _notifier = notification.getNotifier();
        EObject obj = (EObject)_notifier;
        int i = 0;
        while (++i <= number && (obj = obj.eContainer()) != null) {
            ViewerNotification _viewerNotification = new ViewerNotification(notification, (Object)obj, false, true);
            list.add(0, _viewerNotification);
        }
    }

    private static String getLabelProviderText(Object object, AdapterFactory rootAF) {
        Object plainAdapter;
        if (object != null && rootAF.isFactoryForType(object) && (plainAdapter = rootAF.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)plainAdapter).getText(object);
        }
        return "";
    }

    private static String containingFeatureName(EObject object) {
        return CustomItemProviderService.containingFeatureName(object, "", ": ");
    }

    private static String containingFeatureName(EObject object, String defaultText, String separator) {
        EStructuralFeature _eContainingFeature = null;
        if (object != null) {
            _eContainingFeature = object.eContainingFeature();
        }
        EStructuralFeature feature = _eContainingFeature;
        String _xifexpression = null;
        _xifexpression = feature == null ? defaultText : feature.getName();
        String name = _xifexpression;
        String _xifexpression_1 = null;
        boolean _equals = Objects.equal((Object)name, (Object)"values");
        _xifexpression_1 = _equals ? "value: " : String.valueOf(name) + separator;
        return _xifexpression_1;
    }

    private static String typePrefix(EObject object) {
        String _ppCamelCase = CustomItemProviderService.ppCamelCase(object.eClass().getName());
        return String.valueOf(_ppCamelCase) + " ";
    }

    private static String ppCamelCase(String s) {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)s), (String)" ");
    }

    private static String ppName(String name) {
        return CustomItemProviderService.ppName(name, "???");
    }

    private static String ppName(String name, String surrogate) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
        if (_isNullOrEmpty) {
            return surrogate;
        }
        return name;
    }

    public static String getAmaltheaItemProviderText(Object object, String defaultText) {
        if (object instanceof Amalthea) {
            String _version = ((Amalthea)object).getVersion();
            String _plus = "AMALTHEA model (version " + _version;
            return String.valueOf(_plus) + ")";
        }
        return defaultText;
    }

    private static String getTimeText(Time time) {
        if (time == null) {
            return "<time>";
        }
        String _xifexpression = null;
        BigInteger _value = time.getValue();
        boolean _tripleEquals = _value == null;
        _xifexpression = _tripleEquals ? "???" : time.getValue().toString();
        String value = _xifexpression;
        String _xifexpression_1 = null;
        TimeUnit _unit = time.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)TimeUnit._UNDEFINED_);
        _xifexpression_1 = _equals ? "<unit>" : time.getUnit().getLiteral();
        String unit = _xifexpression_1;
        return String.valueOf(value) + " " + unit;
    }

    private static String getDataSizeText(DataSize size) {
        if (size == null) {
            return "<data size>";
        }
        String _xifexpression = null;
        BigInteger _value = size.getValue();
        boolean _tripleEquals = _value == null;
        _xifexpression = _tripleEquals ? "???" : size.getValue().toString();
        String value = _xifexpression;
        String _xifexpression_1 = null;
        DataSizeUnit _unit = size.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)DataSizeUnit._UNDEFINED_);
        _xifexpression_1 = _equals ? "<unit>" : size.getUnit().getLiteral();
        String unit = _xifexpression_1;
        return String.valueOf(value) + " " + unit;
    }

    private static String getDataRateText(DataRate rate) {
        if (rate == null) {
            return "<data rate>";
        }
        String _xifexpression = null;
        BigInteger _value = rate.getValue();
        boolean _tripleEquals = _value == null;
        _xifexpression = _tripleEquals ? "???" : rate.getValue().toString();
        String value = _xifexpression;
        String _xifexpression_1 = null;
        DataRateUnit _unit = rate.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)DataRateUnit._UNDEFINED_);
        _xifexpression_1 = _equals ? "<unit>" : rate.getUnit().getLiteral();
        String unit = _xifexpression_1;
        String _replace = unit.replace("PerSecond", "/s");
        return String.valueOf(value) + " " + _replace;
    }

    private static String getFrequencyText(Frequency frequency) {
        if (frequency == null) {
            return "<frequency>";
        }
        String value = Double.toString(frequency.getValue());
        String _xifexpression = null;
        FrequencyUnit _unit = frequency.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)FrequencyUnit._UNDEFINED_);
        _xifexpression = _equals ? "<unit>" : frequency.getUnit().getLiteral();
        String unit = _xifexpression;
        return String.valueOf(value) + " " + unit;
    }

    private static String getVoltageText(Voltage voltage) {
        if (voltage == null) {
            return "<voltage>";
        }
        String value = Double.toString(voltage.getValue());
        String _xifexpression = null;
        VoltageUnit _unit = voltage.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)VoltageUnit._UNDEFINED_);
        _xifexpression = _equals ? "<unit>" : voltage.getUnit().getLiteral();
        String unit = _xifexpression;
        return String.valueOf(value) + " " + unit;
    }

    private static String getDeviationBoundText(Object bound) {
        String _switchResult = null;
        boolean _matched = false;
        if (bound instanceof LongObject) {
            _matched = true;
            _switchResult = String.valueOf(((LongObject)bound).getValue());
        }
        if (!_matched && bound instanceof DoubleObject) {
            _matched = true;
            _switchResult = String.valueOf(((DoubleObject)bound).getValue());
        }
        if (!_matched && bound instanceof Time) {
            _matched = true;
            _switchResult = CustomItemProviderService.getTimeText((Time)bound);
        }
        return _switchResult;
    }

    private static String trimDistName(String name) {
        if (name == null) {
            return "";
        }
        return name.replace("Distribution", "").replace("Estimators", "").replace("Parameters", "");
    }

    private static String trimMultilineString(String text) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)text);
        if (_isNullOrEmpty) {
            return "???";
        }
        char[] charArray = text.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            boolean _isISOControl = Character.isISOControl(charArray[i]);
            if (_isISOControl) {
                String _substring = text.substring(0, i);
                return String.valueOf(_substring) + "...";
            }
            ++i;
        }
        return text;
    }

    private static String getValueText(Value object) {
        String _plus;
        boolean _tripleEquals;
        Object _value;
        String _xifexpression;
        String _xblockexpression = null;
        if (object == null) {
            return "null";
        }
        String _switchResult = null;
        boolean _matched = false;
        if (object instanceof BooleanObject) {
            _matched = true;
            _switchResult = String.valueOf(((BooleanObject)object).isValue());
        }
        if (!_matched && object instanceof IntegerObject) {
            _matched = true;
            _switchResult = String.valueOf(((IntegerObject)object).getValue());
        }
        if (!_matched && object instanceof LongObject) {
            _matched = true;
            _switchResult = String.valueOf(((LongObject)object).getValue());
        }
        if (!_matched && object instanceof BigIntegerObject) {
            _matched = true;
            _switchResult = String.valueOf(((BigIntegerObject)object).getValue());
        }
        if (!_matched && object instanceof FloatObject) {
            _matched = true;
            _switchResult = String.valueOf(((FloatObject)object).getValue());
        }
        if (!_matched && object instanceof DoubleObject) {
            _matched = true;
            _switchResult = String.valueOf(((DoubleObject)object).getValue());
        }
        if (!_matched && object instanceof StringObject) {
            _matched = true;
            _xifexpression = null;
            _value = ((StringObject)object).getValue();
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                _xifexpression = "null";
            } else {
                String _trimMultilineString = CustomItemProviderService.trimMultilineString(((StringObject)object).getValue());
                _plus = "\"" + _trimMultilineString;
                _xifexpression = String.valueOf(_plus) + "\"";
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && object instanceof ReferenceObject) {
            _matched = true;
            _xifexpression = null;
            _value = ((ReferenceObject)object).getValue();
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                _xifexpression = "null";
            } else {
                String _name = ((ReferenceObject)object).getValue().eClass().getName();
                _plus = String.valueOf(_name) + " \"";
                IReferable _value_1 = null;
                if ((ReferenceObject)object != null) {
                    _value_1 = ((ReferenceObject)object).getValue();
                }
                String _qualifiedName = null;
                if (_value_1 != null) {
                    _qualifiedName = _value_1.getQualifiedName();
                }
                String _ppName = CustomItemProviderService.ppName(_qualifiedName);
                String _plus_1 = String.valueOf(_plus) + _ppName;
                _xifexpression = String.valueOf(_plus_1) + "\"";
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && object instanceof Time) {
            _matched = true;
            _xifexpression = null;
            _value = ((Time)object).getValue();
            _tripleEquals = _value == null;
            _xifexpression = _tripleEquals ? "null" : CustomItemProviderService.getTimeText((Time)object);
            _switchResult = _xifexpression;
        }
        if (!_matched && object instanceof ListObject) {
            _matched = true;
            _switchResult = "";
        }
        if (!_matched && object instanceof MapObject) {
            _matched = true;
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public static String getCustomPropertyItemProviderText(Object object, String defaultText) {
        if (object instanceof CustomPropertyImpl) {
            String key = ((CustomPropertyImpl)object).getKey();
            Value value = ((CustomPropertyImpl)object).getValue();
            EClass _eClass = null;
            if (value != null) {
                _eClass = value.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String valueType = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)key);
            _xifexpression = _isNullOrEmpty ? "<key>" : "\"" + key + "\"";
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            if (valueType == null) {
                _xifexpression_1 = "";
            } else {
                String _replace = valueType.replace("Object", "");
                String _plus = "(" + _replace;
                _xifexpression_1 = String.valueOf(_plus) + ") ";
            }
            String s2 = _xifexpression_1;
            String s3 = CustomItemProviderService.getValueText(value);
            return String.valueOf(s1) + " -> " + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getCustomPropertyItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getBooleanObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof BooleanObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getBooleanObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(BooleanObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDoubleObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof DoubleObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDoubleObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DoubleObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getFloatObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof FloatObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getFloatObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(FloatObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getIntegerObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof IntegerObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getIntegerObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(IntegerObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getLongObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof LongObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getLongObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(LongObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getStringObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof StringObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getStringObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(StringObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getBigIntegerObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof BigIntegerObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getBigIntegerObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(BigIntegerObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getReferenceObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof ReferenceObject) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _valueText = CustomItemProviderService.getValueText((Value)object);
            return String.valueOf(_containingFeatureName) + _valueText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getReferenceObjectItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ReferenceObject.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getFrequencyItemProviderText(Object object, String defaultText) {
        if (object instanceof Frequency) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _frequencyText = CustomItemProviderService.getFrequencyText((Frequency)object);
            return String.valueOf(_containingFeatureName) + _frequencyText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getFrequencyItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(Frequency.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getVoltageItemProviderText(Object object, String defaultText) {
        if (object instanceof Voltage) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _voltageText = CustomItemProviderService.getVoltageText((Voltage)object);
            return String.valueOf(_containingFeatureName) + _voltageText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getVoltageItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(Voltage.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDataSizeItemProviderText(Object object, String defaultText) {
        if (object instanceof DataSize) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _dataSizeText = CustomItemProviderService.getDataSizeText((DataSize)object);
            return String.valueOf(_containingFeatureName) + _dataSizeText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDataSizeItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DataSize.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDataRateItemProviderText(Object object, String defaultText) {
        if (object instanceof DataRate) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _dataRateText = CustomItemProviderService.getDataRateText((DataRate)object);
            return String.valueOf(_containingFeatureName) + _dataRateText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDataRateItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DataRate.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getMinAvgMaxStatisticItemProviderText(Object object, String defaultText) {
        if (object instanceof MinAvgMaxStatistic) {
            String s1 = CustomItemProviderService.containingFeatureName((EObject)object);
            int _min = ((MinAvgMaxStatistic)object).getMin();
            String _plus = String.valueOf(s1) + Integer.valueOf(_min);
            String _plus_1 = String.valueOf(_plus) + " : ";
            float _avg = ((MinAvgMaxStatistic)object).getAvg();
            String _plus_2 = String.valueOf(_plus_1) + Float.valueOf(_avg);
            String _plus_3 = String.valueOf(_plus_2) + " : ";
            int _max = ((MinAvgMaxStatistic)object).getMax();
            return String.valueOf(_plus_3) + Integer.valueOf(_max);
        }
        return defaultText;
    }

    public static String getSingleValueStatisticItemProviderText(Object object, String defaultText) {
        if (object instanceof SingleValueStatistic) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            float _value = ((SingleValueStatistic)object).getValue();
            return String.valueOf(_containingFeatureName) + Float.valueOf(_value);
        }
        return defaultText;
    }

    public static String getTimeItemProviderText(Object object, String defaultText) {
        if (object instanceof Time) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _timeText = CustomItemProviderService.getTimeText((Time)object);
            return String.valueOf(_containingFeatureName) + _timeText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(Time.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification, 2);
        }
        return list;
    }

    public static String getNamespaceItemProviderText(Object object, String defaultText) {
        if (object instanceof Namespace) {
            String _qualifiedName = null;
            if ((Namespace)object != null) {
                _qualifiedName = ((Namespace)object).getQualifiedName();
            }
            String longname = _qualifiedName;
            String _ppName = CustomItemProviderService.ppName(longname, "<namespace>");
            return "Namespace " + _ppName;
        }
        return defaultText;
    }

    public static ViewerNotification getNamespaceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Namespace.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getTransmissionPolicyItemProviderText(Object object, String defaultText) {
        if (object instanceof TransmissionPolicy) {
            DataSize size = ((TransmissionPolicy)object).getChunkSize();
            int ticks = ((TransmissionPolicy)object).getChunkProcessingTicks();
            double ratio = ((TransmissionPolicy)object).getTransmitRatio();
            String _dataSizeText = CustomItemProviderService.getDataSizeText(size);
            String _plus = "transmission (chunk size: " + _dataSizeText;
            String _plus_1 = String.valueOf(_plus) + " ticks: ";
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(ticks);
            String _plus_3 = String.valueOf(_plus_2) + " ratio: ";
            String _plus_4 = String.valueOf(_plus_3) + Double.valueOf(ratio);
            return String.valueOf(_plus_4) + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getTransmissionPolicyItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TransmissionPolicy.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static ViewerNotification getSystemItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(System.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)5)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getComponentStructureItemProviderText(Object object, String defaultText) {
        if (object instanceof ComponentStructure) {
            String _qualifiedName = null;
            if ((ComponentStructure)object != null) {
                _qualifiedName = ((ComponentStructure)object).getQualifiedName();
            }
            String name = _qualifiedName;
            String _structureType = null;
            if ((ComponentStructure)object != null) {
                _structureType = ((ComponentStructure)object).getStructureType();
            }
            String typeName = _structureType;
            String s1 = CustomItemProviderService.ppName(typeName, "");
            String _xifexpression = null;
            boolean _isEmpty = s1.isEmpty();
            _xifexpression = _isEmpty ? "" : " ";
            String s2 = _xifexpression;
            String s3 = CustomItemProviderService.ppName(name, "<structure>");
            return "Component Structure " + s1 + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getComponentStructureItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ComponentStructure.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getComponentItemProviderText(Object object, String defaultText) {
        if (object instanceof Component) {
            String _qualifiedName = null;
            if ((Component)object != null) {
                _qualifiedName = ((Component)object).getQualifiedName();
            }
            String name = _qualifiedName;
            String _ppName = CustomItemProviderService.ppName(name, "<component>");
            return "Component " + _ppName;
        }
        return defaultText;
    }

    public static String getCompositeItemProviderText(Object object, String defaultText) {
        if (object instanceof Composite) {
            String _qualifiedName = null;
            if ((Composite)object != null) {
                _qualifiedName = ((Composite)object).getQualifiedName();
            }
            String name = _qualifiedName;
            String _ppName = CustomItemProviderService.ppName(name, "<composite>");
            return "Composite " + _ppName;
        }
        return defaultText;
    }

    public static ViewerNotification getCompositeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Composite.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)13)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)14)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)15)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getComponentInstanceItemProviderText(Object object, String defaultText) {
        if (object instanceof ComponentInstance) {
            String _qualifiedName = null;
            if ((ComponentInstance)object != null) {
                _qualifiedName = ((ComponentInstance)object).getQualifiedName();
            }
            String name = _qualifiedName;
            Component _type = null;
            if ((ComponentInstance)object != null) {
                _type = ((ComponentInstance)object).getType();
            }
            String _qualifiedName_1 = null;
            if (_type != null) {
                _qualifiedName_1 = _type.getQualifiedName();
            }
            String typeName = _qualifiedName_1;
            String s1 = CustomItemProviderService.ppName(name, "<component instance>");
            String s2 = CustomItemProviderService.ppName(typeName);
            return "Component Instance " + s1 + " (type: " + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getComponentInstanceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ComponentInstance.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getConnectorItemProviderText(Object object, String defaultText) {
        if (object instanceof Connector) {
            String _name = null;
            if ((Connector)object != null) {
                _name = ((Connector)object).getName();
            }
            String name = _name;
            String _ppName = CustomItemProviderService.ppName(name, "<connector>");
            return "Connector " + _ppName;
        }
        return defaultText;
    }

    public static String getComponentPortItemProviderText(Object object, String defaultText) {
        if (object instanceof ComponentPort) {
            Component _containingComponent = null;
            if ((ComponentPort)object != null) {
                _containingComponent = ((ComponentPort)object).getContainingComponent();
            }
            String cName = _containingComponent.getQualifiedName();
            InterfaceKind _kind = null;
            if ((ComponentPort)object != null) {
                _kind = ((ComponentPort)object).getKind();
            }
            InterfaceKind kind = _kind;
            String _name = null;
            if ((ComponentPort)object != null) {
                _name = ((ComponentPort)object).getName();
            }
            String name = _name;
            String s1 = CustomItemProviderService.ppName(cName, "<component>");
            String _xifexpression = null;
            _xifexpression = kind == null || Objects.equal((Object)kind, (Object)InterfaceKind._UNDEFINED_) ? "<kind>" : kind.getLiteral();
            String s2 = _xifexpression;
            String s3 = CustomItemProviderService.ppName(name, "<port>");
            return "Component Port " + s1 + " " + s2 + " " + s3;
        }
        return defaultText;
    }

    public static String getQualifiedPortItemProviderText(Object object, String defaultText) {
        if (object instanceof QualifiedPort) {
            boolean _tripleEquals;
            ComponentInstance _instance = null;
            if ((QualifiedPort)object != null) {
                _instance = ((QualifiedPort)object).getInstance();
            }
            String _qualifiedName = null;
            if (_instance != null) {
                _qualifiedName = _instance.getQualifiedName();
            }
            String instName = _qualifiedName;
            ComponentPort _port = null;
            if ((QualifiedPort)object != null) {
                _port = ((QualifiedPort)object).getPort();
            }
            String _name = null;
            if (_port != null) {
                _name = _port.getName();
            }
            String portName = _name;
            String s2 = "";
            String s4 = "";
            ComponentInstance _instance_1 = null;
            if ((QualifiedPort)object != null) {
                _instance_1 = ((QualifiedPort)object).getInstance();
            }
            boolean bl = _tripleEquals = _instance_1 == null;
            if (_tripleEquals) {
                s4 = " (enclosing composite)";
            } else {
                String _xifexpression = null;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)instName);
                _xifexpression = _isNullOrEmpty ? "??? / " : String.valueOf(instName) + " - ";
                s2 = _xifexpression;
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)portName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<port>" : portName;
            String s3 = _xifexpression_1;
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            String _plus = String.valueOf(_containingFeatureName) + s2;
            String _plus_1 = String.valueOf(_plus) + s3;
            return String.valueOf(_plus_1) + s4;
        }
        return defaultText;
    }

    public static ViewerNotification getQualifiedPortItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(QualifiedPort.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static ViewerNotification getMainInterfaceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(MainInterface.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static ViewerNotification getSubInterfaceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SubInterface.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getInterfaceChannelItemProviderText(Object object, String defaultText) {
        if (object instanceof InterfaceChannelImpl) {
            ComponentInterface _key = null;
            if ((InterfaceChannelImpl)object != null) {
                _key = ((InterfaceChannelImpl)object).getKey();
            }
            ComponentInterface key = _key;
            Channel _value = null;
            if ((InterfaceChannelImpl)object != null) {
                _value = ((InterfaceChannelImpl)object).getValue();
            }
            Channel value = _value;
            String _xifexpression = null;
            if (key == null || StringExtensions.isNullOrEmpty((String)key.getName())) {
                _xifexpression = "<interface>";
            } else {
                String _name = key.getName();
                _xifexpression = "Interface " + _name;
            }
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            if (value == null || StringExtensions.isNullOrEmpty((String)value.getName())) {
                _xifexpression_1 = "<channel>";
            } else {
                String _name_1 = value.getName();
                _xifexpression_1 = "Channel " + _name_1;
            }
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + " -> " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getInterfaceChannelItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getEventConfigItemProviderText(Object object, String defaultText, AdapterFactory rootAF) {
        if (object instanceof EventConfig) {
            String _name = null;
            if ((EventConfig)object != null) {
                _name = ((EventConfig)object).getName();
            }
            String name = _name;
            EntityEvent _event = null;
            if ((EventConfig)object != null) {
                _event = ((EventConfig)object).getEvent();
            }
            EntityEvent event = _event;
            String s1 = CustomItemProviderService.ppName(name);
            String _xifexpression = null;
            _xifexpression = event == null ? "<event>" : CustomItemProviderService.getLabelProviderText(event, rootAF);
            String s2 = _xifexpression;
            return "Event Config " + s1 + " -> trace " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getEventConfigItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(EventConfig.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    private static String getLimitTypeText(LimitType limitType) {
        String _switchResult = null;
        if (limitType != null) {
            switch (limitType) {
                case UPPER_LIMIT: {
                    _switchResult = " <= ";
                    break;
                }
                case LOWER_LIMIT: {
                    _switchResult = " >= ";
                    break;
                }
                default: {
                    _switchResult = " ? ";
                    break;
                }
            }
        } else {
            _switchResult = " ? ";
        }
        return _switchResult;
    }

    public static String getComponentScopeItemProviderText(Object object, String defaultText) {
        if (object instanceof ComponentScope) {
            Component _component = null;
            if ((ComponentScope)object != null) {
                _component = ((ComponentScope)object).getComponent();
            }
            String _name = null;
            if (_component != null) {
                _name = _component.getName();
            }
            String compName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)compName);
            _xifexpression = _isNullOrEmpty ? "<component>" : "Component " + compName;
            String s1 = _xifexpression;
            return "Scope: " + s1;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getComponentScopeItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ComponentScope.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getProcessScopeItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessScope) {
            boolean _isNullOrEmpty;
            AbstractProcess _process = null;
            if ((ProcessScope)object != null) {
                _process = ((ProcessScope)object).getProcess();
            }
            AbstractProcess proc = _process;
            String _xifexpression = null;
            String _name = null;
            if (proc != null) {
                _name = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<process>";
            } else {
                String _name_1 = proc.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "Scope: " + s1;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getProcessScopeItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ProcessScope.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getRunnableScopeItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableScope) {
            Runnable _runnable = null;
            if ((RunnableScope)object != null) {
                _runnable = ((RunnableScope)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)runName);
            _xifexpression = _isNullOrEmpty ? "<runnable>" : "Runnable " + runName;
            String s1 = _xifexpression;
            return "Scope: " + s1;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getRunnableScopeItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(RunnableScope.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getArchitectureRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof ArchitectureRequirement) {
            String _name = null;
            if ((ArchitectureRequirement)object != null) {
                _name = ((ArchitectureRequirement)object).getName();
            }
            String reqName = _name;
            Component _component = null;
            if ((ArchitectureRequirement)object != null) {
                _component = ((ArchitectureRequirement)object).getComponent();
            }
            String _name_1 = null;
            if (_component != null) {
                _name_1 = _component.getName();
            }
            String compName = _name_1;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)compName);
            _xifexpression = _isNullOrEmpty ? "<component>" : "Component " + compName;
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getArchitectureRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ArchitectureRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getCountRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof CountRequirementLimit) {
            CountMetric _metric = null;
            if ((CountRequirementLimit)object != null) {
                _metric = ((CountRequirementLimit)object).getMetric();
            }
            CountMetric metric = _metric;
            LimitType _limitType = null;
            if ((CountRequirementLimit)object != null) {
                _limitType = ((CountRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            int _xifexpression = 0;
            _xifexpression = object == null ? 0 : ((CountRequirementLimit)object).getLimitValue();
            int limitValue = _xifexpression;
            String _xifexpression_1 = null;
            if (metric == null || Objects.equal((Object)metric, (Object)CountMetric._UNDEFINED_)) {
                _xifexpression_1 = "<count metric>";
            } else {
                String _literal = metric.getLiteral();
                _xifexpression_1 = String.valueOf(_literal) + " count";
            }
            String s1 = _xifexpression_1;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String s3 = Double.toString(limitValue);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static String getCPUPercentageRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof CPUPercentageRequirementLimit) {
            CPUPercentageMetric _metric = null;
            if ((CPUPercentageRequirementLimit)object != null) {
                _metric = ((CPUPercentageRequirementLimit)object).getMetric();
            }
            CPUPercentageMetric metric = _metric;
            ProcessingUnit _hardwareContext = null;
            if ((CPUPercentageRequirementLimit)object != null) {
                _hardwareContext = ((CPUPercentageRequirementLimit)object).getHardwareContext();
            }
            String _name = null;
            if (_hardwareContext != null) {
                _name = _hardwareContext.getName();
            }
            String hwContext = _name;
            LimitType _limitType = null;
            if ((CPUPercentageRequirementLimit)object != null) {
                _limitType = ((CPUPercentageRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            double _xifexpression = 0.0;
            _xifexpression = object == null ? 0.0 : ((CPUPercentageRequirementLimit)object).getLimitValue();
            double limitValue = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = metric == null || Objects.equal((Object)metric, (Object)CPUPercentageMetric._UNDEFINED_) ? "<CPU % metric>" : metric.getLiteral();
            String s1 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)hwContext);
            _xifexpression_2 = _isNullOrEmpty ? "" : " on " + hwContext;
            String s2 = _xifexpression_2;
            String s3 = CustomItemProviderService.getLimitTypeText(limitType);
            String _string = Double.toString(limitValue);
            String s4 = String.valueOf(_string) + " %";
            return String.valueOf(s1) + s2 + s3 + s4;
        }
        return defaultText;
    }

    public static String getFrequencyRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof FrequencyRequirementLimit) {
            FrequencyMetric _metric = null;
            if ((FrequencyRequirementLimit)object != null) {
                _metric = ((FrequencyRequirementLimit)object).getMetric();
            }
            FrequencyMetric metric = _metric;
            LimitType _limitType = null;
            if ((FrequencyRequirementLimit)object != null) {
                _limitType = ((FrequencyRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            Frequency _limitValue = null;
            if ((FrequencyRequirementLimit)object != null) {
                _limitValue = ((FrequencyRequirementLimit)object).getLimitValue();
            }
            Frequency limitValue = _limitValue;
            String _xifexpression = null;
            _xifexpression = metric == null || Objects.equal((Object)metric, (Object)FrequencyMetric._UNDEFINED_) ? "<frequency metric>" : metric.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String s3 = CustomItemProviderService.getFrequencyText(limitValue);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getFrequencyRequirementLimitItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(FrequencyRequirementLimit.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getPercentageRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof PercentageRequirementLimit) {
            PercentageMetric _metric = null;
            if ((PercentageRequirementLimit)object != null) {
                _metric = ((PercentageRequirementLimit)object).getMetric();
            }
            PercentageMetric metric = _metric;
            LimitType _limitType = null;
            if ((PercentageRequirementLimit)object != null) {
                _limitType = ((PercentageRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            double _xifexpression = 0.0;
            _xifexpression = object == null ? 0.0 : ((PercentageRequirementLimit)object).getLimitValue();
            double limitValue = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = metric == null || Objects.equal((Object)metric, (Object)PercentageMetric._UNDEFINED_) ? "<% metric>" : metric.getLiteral();
            String s1 = _xifexpression_1;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String _string = Double.toString(limitValue);
            String s3 = String.valueOf(_string) + " %";
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static String getTimeRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeRequirementLimit) {
            TimeMetric _metric = null;
            if ((TimeRequirementLimit)object != null) {
                _metric = ((TimeRequirementLimit)object).getMetric();
            }
            TimeMetric metric = _metric;
            LimitType _limitType = null;
            if ((TimeRequirementLimit)object != null) {
                _limitType = ((TimeRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            Time _limitValue = null;
            if ((TimeRequirementLimit)object != null) {
                _limitValue = ((TimeRequirementLimit)object).getLimitValue();
            }
            Time limitValue = _limitValue;
            String _xifexpression = null;
            _xifexpression = metric == null || Objects.equal((Object)metric, (Object)TimeMetric._UNDEFINED_) ? "<time metric>" : metric.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String s3 = CustomItemProviderService.getTimeText(limitValue);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getTimeRequirementLimitItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TimeRequirementLimit.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getProcessRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessRequirement) {
            boolean _isNullOrEmpty;
            String _name = null;
            if ((ProcessRequirement)object != null) {
                _name = ((ProcessRequirement)object).getName();
            }
            String reqName = _name;
            AbstractProcess _process = null;
            if ((ProcessRequirement)object != null) {
                _process = ((ProcessRequirement)object).getProcess();
            }
            AbstractProcess proc = _process;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            String _name_1 = null;
            if (proc != null) {
                _name_1 = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name_1)) {
                _xifexpression = "<process>";
            } else {
                String _name_2 = proc.eClass().getName();
                String _plus = String.valueOf(_name_2) + " ";
                String _name_3 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_3;
            }
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableRequirement) {
            String _name = null;
            if ((RunnableRequirement)object != null) {
                _name = ((RunnableRequirement)object).getName();
            }
            String reqName = _name;
            Runnable _runnable = null;
            if ((RunnableRequirement)object != null) {
                _runnable = ((RunnableRequirement)object).getRunnable();
            }
            String _name_1 = null;
            if (_runnable != null) {
                _name_1 = _runnable.getName();
            }
            String runName = _name_1;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)runName);
            _xifexpression = _isNullOrEmpty ? "<runnable>" : "Runnable " + runName;
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getProcessChainRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessChainRequirement) {
            String _name = null;
            if ((ProcessChainRequirement)object != null) {
                _name = ((ProcessChainRequirement)object).getName();
            }
            String reqName = _name;
            ProcessChain _processChain = null;
            if ((ProcessChainRequirement)object != null) {
                _processChain = ((ProcessChainRequirement)object).getProcessChain();
            }
            String _name_1 = null;
            if (_processChain != null) {
                _name_1 = _processChain.getName();
            }
            String pcName = _name_1;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)pcName);
            _xifexpression = _isNullOrEmpty ? "<process chain>" : "Process Chain " + pcName;
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessChainRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessChainRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getDataAgeCycleItemProviderText(Object object, String defaultText) {
        if (object instanceof DataAgeCycle) {
            int _minimumCycle = ((DataAgeCycle)object).getMinimumCycle();
            String _plus = "Age cycles c: " + Integer.valueOf(_minimumCycle);
            String _plus_1 = String.valueOf(_plus) + " <= c <= ";
            int _maximumCycle = ((DataAgeCycle)object).getMaximumCycle();
            return String.valueOf(_plus_1) + Integer.valueOf(_maximumCycle);
        }
        return defaultText;
    }

    public static String getDataAgeTimeItemProviderText(Object object, String defaultText) {
        if (object instanceof DataAgeTime) {
            Time _minimumTime = null;
            if ((DataAgeTime)object != null) {
                _minimumTime = ((DataAgeTime)object).getMinimumTime();
            }
            Time minTime = _minimumTime;
            Time _maximumTime = null;
            if ((DataAgeTime)object != null) {
                _maximumTime = ((DataAgeTime)object).getMaximumTime();
            }
            Time maxTime = _maximumTime;
            String _timeText = CustomItemProviderService.getTimeText(minTime);
            String _plus = "Age time t: " + _timeText;
            String _plus_1 = String.valueOf(_plus) + " <= t <= ";
            String _timeText_1 = CustomItemProviderService.getTimeText(maxTime);
            return String.valueOf(_plus_1) + _timeText_1;
        }
        return defaultText;
    }

    public static ViewerNotification getDataAgeTimeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(DataAgeTime.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getDataCoherencyGroupItemProviderText(Object object, String defaultText) {
        if (object instanceof DataCoherencyGroup) {
            String _name_2;
            boolean _isNullOrEmpty;
            String _name_1;
            String _xifexpression_1;
            String _name = null;
            if ((DataCoherencyGroup)object != null) {
                _name = ((DataCoherencyGroup)object).getName();
            }
            String name = _name;
            CoherencyDirection _direction = null;
            if ((DataCoherencyGroup)object != null) {
                _direction = ((DataCoherencyGroup)object).getDirection();
            }
            CoherencyDirection direction = _direction;
            DataGroupScope _scope = null;
            if ((DataCoherencyGroup)object != null) {
                _scope = ((DataCoherencyGroup)object).getScope();
            }
            DataGroupScope scope = _scope;
            String s1 = CustomItemProviderService.ppName(name, "<group>");
            String _xifexpression = null;
            _xifexpression = direction == null || Objects.equal((Object)direction, (Object)CoherencyDirection._UNDEFINED_) ? "<direction>" : direction.getLiteral();
            String s2 = _xifexpression;
            String _switchResult = null;
            boolean _matched = false;
            if (scope instanceof RunnableScope) {
                _matched = true;
                _xifexpression_1 = null;
                Runnable _runnable = ((RunnableScope)scope).getRunnable();
                _name_1 = null;
                if (_runnable != null) {
                    _name_1 = _runnable.getName();
                }
                if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name_1)) {
                    _xifexpression_1 = "<runnable>";
                } else {
                    _name_2 = ((RunnableScope)scope).getRunnable().getName();
                    _xifexpression_1 = "Runnable " + _name_2;
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched && scope instanceof ProcessScope) {
                _matched = true;
                _xifexpression_1 = null;
                AbstractProcess _process = ((ProcessScope)scope).getProcess();
                _name_1 = null;
                if (_process != null) {
                    _name_1 = _process.getName();
                }
                if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_name_1)) {
                    _xifexpression_1 = "<process>";
                } else {
                    _name_2 = ((ProcessScope)scope).getProcess().eClass().getName();
                    String _plus = String.valueOf(_name_2) + " ";
                    String _name_3 = ((ProcessScope)scope).getProcess().getName();
                    _xifexpression_1 = String.valueOf(_plus) + _name_3;
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched && scope instanceof ComponentScope) {
                _matched = true;
                _xifexpression_1 = null;
                Component _component = ((ComponentScope)scope).getComponent();
                _name_1 = null;
                if (_component != null) {
                    _name_1 = _component.getName();
                }
                if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_name_1)) {
                    _xifexpression_1 = "<component>";
                } else {
                    _name_2 = ((ComponentScope)scope).getComponent().getName();
                    _xifexpression_1 = "Component " + _name_2;
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched) {
                _switchResult = "?";
            }
            String s3 = _switchResult;
            return "CoherencyGroup " + s1 + " " + s2 + " (Scope: " + s3 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getDataCoherencyGroupItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(DataCoherencyGroup.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getEventChainReferenceItemProviderText(Object object, String defaultText) {
        if (object instanceof EventChainReference) {
            EventChain _eventChain = null;
            if ((EventChainReference)object != null) {
                _eventChain = ((EventChainReference)object).getEventChain();
            }
            String _name = null;
            if (_eventChain != null) {
                _name = _eventChain.getName();
            }
            String chainName = _name;
            String s1 = CustomItemProviderService.containingFeatureName((EObject)object);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)chainName);
            _xifexpression = _isNullOrEmpty ? "<chain ref>" : "(Chain Ref) " + chainName;
            String s2 = _xifexpression;
            return String.valueOf(s1) + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getEventChainReferenceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(EventChainReference.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getEventChainContainerItemProviderText(Object object, String defaultText) {
        if (object instanceof EventChainContainer) {
            SubEventChain _eventChain = null;
            if ((EventChainContainer)object != null) {
                _eventChain = ((EventChainContainer)object).getEventChain();
            }
            SubEventChain chain = _eventChain;
            String s1 = CustomItemProviderService.containingFeatureName((EObject)object);
            String _xifexpression = null;
            if (chain == null) {
                _xifexpression = "<sub chain>";
            } else {
                String _xifexpression_1 = null;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)chain.getName());
                if (_isNullOrEmpty) {
                    _xifexpression_1 = "Sub Chain";
                } else {
                    String _name = chain.getName();
                    _xifexpression_1 = "(Sub Chain) " + _name;
                }
                _xifexpression = _xifexpression_1;
            }
            String s2 = _xifexpression;
            return String.valueOf(s1) + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getEventChainContainerItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SubEventChain.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getTagGroupItemProviderText(Object object, String defaultText) {
        if (object instanceof TagGroup) {
            Tag _tag = null;
            if ((TagGroup)object != null) {
                _tag = ((TagGroup)object).getTag();
            }
            String _name = null;
            if (_tag != null) {
                _name = _tag.getName();
            }
            String tagName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)tagName);
            _xifexpression = _isNullOrEmpty ? "<tag>" : "\"" + tagName + "\"";
            String s1 = _xifexpression;
            return "Items with tag " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getTagGroupItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TagGroup.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getPhysicalSectionConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof PhysicalSectionConstraint) {
            boolean _isNullOrEmpty_3;
            boolean _not;
            boolean _isNullOrEmpty;
            Section _section = null;
            if ((PhysicalSectionConstraint)object != null) {
                _section = ((PhysicalSectionConstraint)object).getSection();
            }
            Section section = _section;
            EList _memories = null;
            if ((PhysicalSectionConstraint)object != null) {
                _memories = ((PhysicalSectionConstraint)object).getMemories();
            }
            EList memories = _memories;
            String _xifexpression = null;
            String _name = null;
            if (section != null) {
                _name = section.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<section>";
            } else {
                String _name_1 = section.getName();
                _xifexpression = "Section :  " + _name_1;
            }
            String sectionString = _xifexpression;
            ArrayList memoryNames = new ArrayList();
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)memories);
            boolean bl = _not = !_isNullOrEmpty_1;
            if (_not) {
                Consumer<Memory> _function = it -> {
                    boolean _isNullOrEmpty_2;
                    String _xifexpression_1 = null;
                    String _name_2 = null;
                    if (it != null) {
                        _name_2 = it.getName();
                    }
                    _xifexpression_1 = (_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(_name_2)) ? "???" : it.getName();
                    String st = _xifexpression_1;
                    memoryNames.add(st);
                };
                memories.forEach(_function);
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(memoryNames);
            if (_isNullOrEmpty_2) {
                _xifexpression_1 = "<memories>";
            } else {
                boolean _greaterThan;
                String _xifexpression_2 = null;
                int _size = memoryNames.size();
                boolean bl2 = _greaterThan = _size > 10;
                if (_greaterThan) {
                    String _join = IterableExtensions.join(memoryNames.subList(0, 10), (CharSequence)", ");
                    String _plus = " Memories : " + _join;
                    _xifexpression_2 = String.valueOf(_plus) + ", ...";
                } else {
                    String _join_1 = IterableExtensions.join(memoryNames, (CharSequence)", ");
                    _xifexpression_2 = " Memories : " + _join_1;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            String memoriesString = _xifexpression_1;
            String _xifexpression_3 = null;
            String _name_2 = null;
            if ((PhysicalSectionConstraint)object != null) {
                _name_2 = ((PhysicalSectionConstraint)object).getName();
            }
            _xifexpression_3 = (_isNullOrEmpty_3 = StringExtensions.isNullOrEmpty(_name_2)) ? "<name>" : ((PhysicalSectionConstraint)object).getName();
            String s0 = _xifexpression_3;
            return String.valueOf(s0) + " : (" + sectionString + ")" + " --> (" + memoriesString + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getPhysicalSectionConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(PhysicalSectionConstraint.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, false);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
            Object _notifier_2 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_2, true, true);
        }
        return null;
    }

    public static String getHwStructureItemProviderImageName(Object object, String defaultName) {
        if (object instanceof HwStructure) {
            StructureType _structureType = ((HwStructure)object).getStructureType();
            if (_structureType != null) {
                switch (_structureType) {
                    case SYSTEM: {
                        return "HwStructure_System";
                    }
                    case ECU: {
                        return "HwStructure_ECU";
                    }
                    case MICROCONTROLLER: {
                        return "HwStructure_Microcontroller";
                    }
                }
                return "HwStructure";
            }
            return "HwStructure";
        }
        return defaultName;
    }

    public static ViewerNotification getHwFeatureCategoryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwFeatureCategory.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getHwFeatureItemProviderText(Object object, String defaultText) {
        if (object instanceof HwFeature) {
            String _string = ((HwFeature)object).toString();
            return "Hw Feature " + _string;
        }
        return defaultText;
    }

    public static String getHwPortItemProviderText(Object object, String defaultText) {
        if (object instanceof HwPort) {
            String name = ((HwPort)object).getName();
            EObject _eContainer = ((HwPort)object).eContainer();
            String cName = ((INamed)_eContainer).getName();
            String _xifexpression = null;
            EObject _eContainer_1 = ((HwPort)object).eContainer();
            _xifexpression = _eContainer_1 instanceof HwStructure ? "<structure>" : "<module>";
            String cType = _xifexpression;
            String s1 = CustomItemProviderService.ppName(cName, cType);
            String s2 = CustomItemProviderService.ppName(name, "<port>");
            return "Hw Port " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getHwPortItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwPort.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getHwAccessElementItemProviderText(Object object, String defaultText) {
        if (object instanceof HwAccessElement) {
            String s1 = CustomItemProviderService.ppName(((HwAccessElement)object).getName(), "???");
            ProcessingUnit _source = ((HwAccessElement)object).getSource();
            String _name = null;
            if (_source != null) {
                _name = _source.getName();
            }
            String s2 = CustomItemProviderService.ppName(_name, "<source>");
            HwDestination _destination = ((HwAccessElement)object).getDestination();
            String _name_1 = null;
            if (_destination != null) {
                _name_1 = _destination.getName();
            }
            String s3 = CustomItemProviderService.ppName(_name_1, "<destination>");
            return String.valueOf(s1) + ": " + s2 + " --> " + s3;
        }
        return null;
    }

    public static ViewerNotification getHwAccessElementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwAccessElement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)5)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getHwAccessPathItemProviderText(Object object, String defaultText) {
        if (object instanceof HwAccessPath) {
            return ((HwAccessPath)object).getName();
        }
        return null;
    }

    public static String getHwConnectionItemProviderText(Object object, String defaultText) {
        if (object instanceof HwConnection) {
            HwPort _port1 = ((HwConnection)object).getPort1();
            EObject _eContainer = null;
            if (_port1 != null) {
                _eContainer = _port1.eContainer();
            }
            String _name = null;
            if ((INamed)_eContainer != null) {
                _name = ((INamed)_eContainer).getName();
            }
            String cName1 = _name;
            HwPort _port2 = ((HwConnection)object).getPort2();
            EObject _eContainer_1 = null;
            if (_port2 != null) {
                _eContainer_1 = _port2.eContainer();
            }
            String _name_1 = null;
            if ((INamed)_eContainer_1 != null) {
                _name_1 = ((INamed)_eContainer_1).getName();
            }
            String cName2 = _name_1;
            String s1 = CustomItemProviderService.ppName(((HwConnection)object).getName(), "???");
            String s2 = CustomItemProviderService.ppName(cName1, "<module1>");
            HwPort _port1_1 = ((HwConnection)object).getPort1();
            String _name_2 = null;
            if (_port1_1 != null) {
                _name_2 = _port1_1.getName();
            }
            String s3 = CustomItemProviderService.ppName(_name_2, "<port1>");
            String s4 = CustomItemProviderService.ppName(cName2, "<module2>");
            HwPort _port2_1 = ((HwConnection)object).getPort2();
            String _name_3 = null;
            if (_port2_1 != null) {
                _name_3 = _port2_1.getName();
            }
            String s5 = CustomItemProviderService.ppName(_name_3, "<port2>");
            return "Hw Connection " + s1 + ": " + s2 + "_" + s3 + " --> " + s4 + "_" + s5;
        }
        return null;
    }

    public static ViewerNotification getHwConnectionItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwConnection.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)9)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)5)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getMappingModelItemProviderText(Object object, String defaultText) {
        return "Mapping";
    }

    public static String getSchedulerAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof SchedulerAllocation) {
            Scheduler _scheduler = null;
            if ((SchedulerAllocation)object != null) {
                _scheduler = ((SchedulerAllocation)object).getScheduler();
            }
            String _name = null;
            if (_scheduler != null) {
                _name = _scheduler.getName();
            }
            String schedName = _name;
            EList _responsibility = null;
            if ((SchedulerAllocation)object != null) {
                _responsibility = ((SchedulerAllocation)object).getResponsibility();
            }
            EList cores = _responsibility;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)schedName);
            _xifexpression = _isNullOrEmpty ? "<scheduler>" : "Scheduler " + schedName;
            String s1 = _xifexpression;
            Functions.Function1 _function = e -> {
                String _name_1 = null;
                if (e != null) {
                    _name_1 = e.getName();
                }
                return CustomItemProviderService.ppName(_name_1);
            };
            String s2 = IterableExtensions.join((Iterable)ListExtensions.map((List)cores, (Functions.Function1)_function), (CharSequence)", ");
            return "Allocation: " + s1 + " -- Processing Units ( " + s2 + " )";
        }
        return defaultText;
    }

    public static ViewerNotification getSchedulerAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SchedulerAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getISRAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof ISRAllocation) {
            InterruptController _controller = null;
            if ((ISRAllocation)object != null) {
                _controller = ((ISRAllocation)object).getController();
            }
            String _name = null;
            if (_controller != null) {
                _name = _controller.getName();
            }
            String ctrlName = _name;
            ISR _isr = null;
            if ((ISRAllocation)object != null) {
                _isr = ((ISRAllocation)object).getIsr();
            }
            String _name_1 = null;
            if (_isr != null) {
                _name_1 = _isr.getName();
            }
            String isrName = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)ctrlName);
            _xifexpression = _isNullOrEmpty ? "<controller>" : "Controller " + ctrlName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)isrName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<isr>" : "ISR " + isrName;
            String s2 = _xifexpression_1;
            return "Allocation: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getISRAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ISRAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableAllocation) {
            Scheduler _scheduler = null;
            if ((RunnableAllocation)object != null) {
                _scheduler = ((RunnableAllocation)object).getScheduler();
            }
            String _name = null;
            if (_scheduler != null) {
                _name = _scheduler.getName();
            }
            String schedName = _name;
            Runnable _entity = null;
            if ((RunnableAllocation)object != null) {
                _entity = ((RunnableAllocation)object).getEntity();
            }
            String _name_1 = null;
            if (_entity != null) {
                _name_1 = _entity.getName();
            }
            String entityName = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)schedName);
            _xifexpression = _isNullOrEmpty ? "<scheduler>" : "Scheduler " + schedName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)entityName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<runnable>" : "Runnable " + entityName;
            String s2 = _xifexpression_1;
            return "Allocation: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getTaskAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof TaskAllocation) {
            TaskScheduler _scheduler = null;
            if ((TaskAllocation)object != null) {
                _scheduler = ((TaskAllocation)object).getScheduler();
            }
            String _name = null;
            if (_scheduler != null) {
                _name = _scheduler.getName();
            }
            String schedName = _name;
            Task _task = null;
            if ((TaskAllocation)object != null) {
                _task = ((TaskAllocation)object).getTask();
            }
            String _name_1 = null;
            if (_task != null) {
                _name_1 = _task.getName();
            }
            String taskName = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)schedName);
            _xifexpression = _isNullOrEmpty ? "<scheduler>" : "Scheduler " + schedName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)taskName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<task>" : "Task " + taskName;
            String s2 = _xifexpression_1;
            return "Allocation: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getTaskAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TaskAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getMemoryMappingItemProviderText(Object object, String defaultText) {
        if (object instanceof MemoryMapping) {
            boolean _isNullOrEmpty_1;
            Memory _memory = null;
            if ((MemoryMapping)object != null) {
                _memory = ((MemoryMapping)object).getMemory();
            }
            String _name = null;
            if (_memory != null) {
                _name = _memory.getName();
            }
            String memName = _name;
            AbstractMemoryElement _abstractElement = null;
            if ((MemoryMapping)object != null) {
                _abstractElement = ((MemoryMapping)object).getAbstractElement();
            }
            AbstractMemoryElement elem = _abstractElement;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)memName);
            _xifexpression = _isNullOrEmpty ? "<memory>" : "Memory " + memName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            String _name_1 = null;
            if (elem != null) {
                _name_1 = elem.getName();
            }
            if (_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(_name_1)) {
                _xifexpression_1 = "<element>";
            } else {
                String _name_2 = elem.eClass().getName();
                String _plus = String.valueOf(_name_2) + " ";
                String _name_3 = elem.getName();
                _xifexpression_1 = String.valueOf(_plus) + _name_3;
            }
            String s2 = _xifexpression_1;
            return "Mapping: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getMemoryMappingItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(MemoryMapping.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getPhysicalSectionMappingItemProviderText(Object object, String defaultText) {
        if (object instanceof PhysicalSectionMapping) {
            boolean _not;
            boolean _isNullOrEmpty;
            Memory _memory = null;
            if ((PhysicalSectionMapping)object != null) {
                _memory = ((PhysicalSectionMapping)object).getMemory();
            }
            Memory memory = _memory;
            EList _origin = null;
            if ((PhysicalSectionMapping)object != null) {
                _origin = ((PhysicalSectionMapping)object).getOrigin();
            }
            EList sections = _origin;
            String _xifexpression = null;
            String _name = null;
            if (memory != null) {
                _name = memory.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<memory>";
            } else {
                String _name_1 = memory.getName();
                _xifexpression = "Memory :  " + _name_1;
            }
            String memoryString = _xifexpression;
            ArrayList sectionNames = new ArrayList();
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)sections);
            boolean bl = _not = !_isNullOrEmpty_1;
            if (_not) {
                Consumer<Section> _function = it -> {
                    boolean _isNullOrEmpty_2;
                    String _xifexpression_1 = null;
                    String _name_2 = null;
                    if (it != null) {
                        _name_2 = it.getName();
                    }
                    _xifexpression_1 = (_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(_name_2)) ? "???" : it.getName();
                    String st = _xifexpression_1;
                    sectionNames.add(st);
                };
                sections.forEach(_function);
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(sectionNames);
            if (_isNullOrEmpty_2) {
                _xifexpression_1 = "<sections>";
            } else {
                boolean _greaterThan;
                String _xifexpression_2 = null;
                int _size = sectionNames.size();
                boolean bl2 = _greaterThan = _size > 10;
                if (_greaterThan) {
                    String _join = IterableExtensions.join(sectionNames.subList(0, 10), (CharSequence)", ");
                    String _plus = " Sections : " + _join;
                    _xifexpression_2 = String.valueOf(_plus) + ", ...";
                } else {
                    String _join_1 = IterableExtensions.join(sectionNames, (CharSequence)", ");
                    _xifexpression_2 = " Sections : " + _join_1;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            String sectionsString = _xifexpression_1;
            String _name_2 = null;
            if ((PhysicalSectionMapping)object != null) {
                _name_2 = ((PhysicalSectionMapping)object).getName();
            }
            String s0 = CustomItemProviderService.ppName(_name_2, "<name>");
            return String.valueOf(s0) + " : (" + sectionsString + ")" + " --> (" + memoryString + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getPhysicalSectionMappingItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(PhysicalSectionMapping.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_2 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_2, true, false);
        }
        return null;
    }

    public static String getSchedulingParameterDefinitionItemProviderText(Object object, String defaultText) {
        if (object instanceof SchedulingParameterDefinition) {
            boolean _tripleEquals_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((SchedulingParameterDefinition)object).getName());
            _xifexpression = _isNullOrEmpty ? "<name>" : ((SchedulingParameterDefinition)object).getName();
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isMandatory = ((SchedulingParameterDefinition)object).isMandatory();
            _xifexpression_1 = _isMandatory ? "1" : "0";
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isMany = ((SchedulingParameterDefinition)object).isMany();
            _xifexpression_2 = _isMany ? "n" : "1";
            String s3 = _xifexpression_2;
            String _xifexpression_3 = null;
            ParameterType _type = ((SchedulingParameterDefinition)object).getType();
            boolean _tripleEquals = _type == ParameterType._UNDEFINED_;
            _xifexpression_3 = _tripleEquals ? "<type>" : ((SchedulingParameterDefinition)object).getType().getName();
            String s4 = _xifexpression_3;
            String _xifexpression_4 = null;
            Value _defaultValue = ((SchedulingParameterDefinition)object).getDefaultValue();
            boolean bl = _tripleEquals_1 = _defaultValue == null;
            if (_tripleEquals_1) {
                _xifexpression_4 = "";
            } else {
                String _valueText = CustomItemProviderService.getValueText(((SchedulingParameterDefinition)object).getDefaultValue());
                _xifexpression_4 = " =  " + _valueText;
            }
            String s5 = _xifexpression_4;
            return String.valueOf(s1) + " [" + s2 + ".." + s3 + "] " + s4 + s5;
        }
        return defaultText;
    }

    public static ViewerNotification getSchedulingParameterDefinitionItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SchedulingParameterDefinition.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getSchedulingParameterItemProviderText(Object object, String defaultText) {
        if (object instanceof SchedulingParameterImpl) {
            SchedulingParameterDefinition _key = ((SchedulingParameterImpl)object).getKey();
            String _name = null;
            if (_key != null) {
                _name = _key.getName();
            }
            String paramName = _name;
            Value value = ((SchedulingParameterImpl)object).getValue();
            EClass _eClass = null;
            if (value != null) {
                _eClass = value.eClass();
            }
            String _name_1 = null;
            if (_eClass != null) {
                _name_1 = _eClass.getName();
            }
            String valueType = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)paramName);
            _xifexpression = _isNullOrEmpty ? "<parameter>" : paramName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            if (valueType == null) {
                _xifexpression_1 = "";
            } else {
                String _replace = valueType.replace("Object", "");
                String _plus = "(" + _replace;
                _xifexpression_1 = String.valueOf(_plus) + ") ";
            }
            String s2 = _xifexpression_1;
            String s3 = CustomItemProviderService.getValueText(value);
            return String.valueOf(s1) + " -> " + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getSchedulingParameterItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getSchedulerAssociationItemProviderText(Object object, String defaultText) {
        if (object instanceof SchedulerAssociation) {
            TaskScheduler parent = ((SchedulerAssociation)object).getParent();
            String _xifexpression = null;
            _xifexpression = parent == null ? "<scheduler>" : CustomItemProviderService.ppName(parent.getName());
            String s1 = _xifexpression;
            return "(parent) " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSchedulerAssociationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SchedulerAssociation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getOsDataConsistencyItemProviderText(Object object, String defaultText) {
        if (object instanceof OsDataConsistency) {
            OsDataConsistencyMode mode = ((OsDataConsistency)object).getMode();
            String _xifexpression = null;
            _xifexpression = mode == null || Objects.equal((Object)mode, (Object)OsDataConsistencyMode._UNDEFINED_) ? "?" : mode.getLiteral();
            String s2 = _xifexpression;
            return "OS Data Consistency - " + s2;
        }
        return defaultText;
    }

    public static String getDataStabilityItemProviderText(Object object, String defaultText) {
        if (object instanceof DataStability) {
            String _string = Boolean.valueOf(((DataStability)object).isEnabled()).toString();
            return "OS Data Stability - enabled: " + _string;
        }
        return defaultText;
    }

    public static String getNonAtomicDataCoherencyItemProviderText(Object object, String defaultText) {
        if (object instanceof NonAtomicDataCoherency) {
            String _string = Boolean.valueOf(((NonAtomicDataCoherency)object).isEnabled()).toString();
            return "OS Data Coherency - enabled: " + _string;
        }
        return defaultText;
    }

    public static String getOsOverheadItemProviderText(Object object, String defaultText) {
        if (object instanceof OsOverhead) {
            String name = ((OsOverhead)object).getName();
            String _ppName = CustomItemProviderService.ppName(name);
            return "Os Overhead " + _ppName;
        }
        return defaultText;
    }

    public static String getOsAPIOverheadItemProviderText(Object object, String defaultText) {
        if (object instanceof OsAPIOverhead) {
            return CustomItemProviderService.containingFeatureName((EObject)object, "API Overhead", "");
        }
        return defaultText;
    }

    public static String getOsISROverheadItemProviderText(Object object, String defaultText) {
        if (object instanceof OsISROverhead) {
            return CustomItemProviderService.containingFeatureName((EObject)object, "ISR Overhead", "");
        }
        return defaultText;
    }

    public static String getProcessPrototypeAllocationConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessPrototypeAllocationConstraint) {
            ProcessPrototype _processPrototype = null;
            if ((ProcessPrototypeAllocationConstraint)object != null) {
                _processPrototype = ((ProcessPrototypeAllocationConstraint)object).getProcessPrototype();
            }
            String _name = null;
            if (_processPrototype != null) {
                _name = _processPrototype.getName();
            }
            String name = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
            _xifexpression = _isNullOrEmpty ? "<process prototype>" : "Prototype " + name;
            String s1 = _xifexpression;
            return "Constraint allocation of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessPrototypeAllocationConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessPrototypeAllocationConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getProcessAllocationConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessAllocationConstraint) {
            boolean _isNullOrEmpty;
            Process _process = null;
            if ((ProcessAllocationConstraint)object != null) {
                _process = ((ProcessAllocationConstraint)object).getProcess();
            }
            Process proc = _process;
            String _xifexpression = null;
            String _name = null;
            if (proc != null) {
                _name = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<process>";
            } else {
                String _name_1 = proc.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "Constraint allocation of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessAllocationConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessAllocationConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableAllocationConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableAllocationConstraint) {
            Runnable _runnable = null;
            if ((RunnableAllocationConstraint)object != null) {
                _runnable = ((RunnableAllocationConstraint)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)runName);
            _xifexpression = _isNullOrEmpty ? "<runnable>" : "Runnable " + runName;
            String s1 = _xifexpression;
            return "Constraint allocation of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableAllocationConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableAllocationConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getCoreClassificationItemProviderText(Object object, String defaultText) {
        if (object instanceof CoreClassification) {
            CombinatorialCondition _condition = null;
            if ((CoreClassification)object != null) {
                _condition = ((CoreClassification)object).getCondition();
            }
            CombinatorialCondition con = _condition;
            GroupingType _grouping = null;
            if ((CoreClassification)object != null) {
                _grouping = ((CoreClassification)object).getGrouping();
            }
            GroupingType grp = _grouping;
            EList _classifiers = null;
            if ((CoreClassification)object != null) {
                _classifiers = ((CoreClassification)object).getClassifiers();
            }
            EList cla = _classifiers;
            String _xifexpression = null;
            _xifexpression = con == null || Objects.equal((Object)con, (Object)CombinatorialCondition._UNDEFINED_) ? "<condition>" : con.getLiteral();
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = grp == null || Objects.equal((Object)grp, (Object)GroupingType._UNDEFINED_) ? "<grouping>" : CustomItemProviderService.ppCamelCase(grp.getLiteral()).toLowerCase();
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)cla);
            if (_isNullOrEmpty) {
                _xifexpression_2 = "<classifiers>";
            } else {
                Functions.Function1 _function = e -> {
                    String _name = null;
                    if (e != null) {
                        _name = e.getName();
                    }
                    return CustomItemProviderService.ppName(_name);
                };
                _xifexpression_2 = IterableExtensions.join((Iterable)ListExtensions.map((List)cla, (Functions.Function1)_function), (CharSequence)", ");
            }
            String s3 = _xifexpression_2;
            return String.valueOf(s1) + " (" + s2 + "): " + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getCoreClassificationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(CoreClassification.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getAbstractElementMappingConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof AbstractElementMappingConstraint) {
            boolean _isNullOrEmpty;
            AbstractMemoryElement _abstractElement = null;
            if ((AbstractElementMappingConstraint)object != null) {
                _abstractElement = ((AbstractElementMappingConstraint)object).getAbstractElement();
            }
            AbstractMemoryElement elem = _abstractElement;
            String _xifexpression = null;
            String _name = null;
            if (elem != null) {
                _name = elem.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<element>";
            } else {
                String _name_1 = elem.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = elem.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "Constraint mapping of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getAbstractElementMappingConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(AbstractElementMappingConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getMemoryClassificationItemProviderText(Object object, String defaultText) {
        if (object instanceof MemoryClassification) {
            CombinatorialCondition _condition = null;
            if ((MemoryClassification)object != null) {
                _condition = ((MemoryClassification)object).getCondition();
            }
            CombinatorialCondition con = _condition;
            GroupingType _grouping = null;
            if ((MemoryClassification)object != null) {
                _grouping = ((MemoryClassification)object).getGrouping();
            }
            GroupingType grp = _grouping;
            EList _classifiers = null;
            if ((MemoryClassification)object != null) {
                _classifiers = ((MemoryClassification)object).getClassifiers();
            }
            EList cla = _classifiers;
            String _xifexpression = null;
            _xifexpression = con == null || Objects.equal((Object)con, (Object)CombinatorialCondition._UNDEFINED_) ? "<condition>" : con.getLiteral();
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = grp == null || Objects.equal((Object)grp, (Object)GroupingType._UNDEFINED_) ? "<grouping>" : CustomItemProviderService.ppCamelCase(grp.getLiteral()).toLowerCase();
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)cla);
            if (_isNullOrEmpty) {
                _xifexpression_2 = "<classifiers>";
            } else {
                Functions.Function1 _function = e -> {
                    String _name = null;
                    if (e != null) {
                        _name = e.getName();
                    }
                    return CustomItemProviderService.ppName(_name);
                };
                _xifexpression_2 = IterableExtensions.join((Iterable)ListExtensions.map((List)cla, (Functions.Function1)_function), (CharSequence)", ");
            }
            String s3 = _xifexpression_2;
            return String.valueOf(s1) + " (" + s2 + "): " + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getMemoryClassificationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(MemoryClassification.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeValueListItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeValueList) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + defaultText;
        }
        return defaultText;
    }

    public static String getConditionDisjunctionItemProviderText(Object object, String defaultText) {
        if (object instanceof ConditionDisjunction) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + "OR";
        }
        return defaultText;
    }

    public static String getModeConditionDisjunctionItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeConditionDisjunction) {
            String _containingFeatureName = CustomItemProviderService.containingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + "OR";
        }
        return defaultText;
    }

    public static String getModeConditionConjunctionItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeConditionConjunction) {
            return "AND";
        }
        return defaultText;
    }

    public static String getModeAssignmentItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeAssignment) {
            boolean _isNullOrEmpty;
            ModeLabel label = ((ModeAssignment)object).getLabel();
            String value = ((ModeAssignment)object).getValue();
            String _xifexpression = null;
            String _name = null;
            if (label != null) {
                _name = label.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<mode label>";
            } else {
                String _name_1 = label.getName();
                _xifexpression = "Mode Label " + _name_1;
            }
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = value == null ? "<value>" : value;
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + " := " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getModeAssignmentItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeAssignment.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    private static String getRelationOperatorText(RelationalOperator relation) {
        String _switchResult = null;
        if (relation != null) {
            switch (relation) {
                case _UNDEFINED_: {
                    _switchResult = "  <relation>  ";
                    break;
                }
                case EQUAL: {
                    _switchResult = "  =  ";
                    break;
                }
                case NOT_EQUAL: {
                    _switchResult = "  \u2260  ";
                    break;
                }
                case LESS_THAN: {
                    _switchResult = "  <  ";
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    _switchResult = "  \u2264  ";
                    break;
                }
                case GREATER_THAN: {
                    _switchResult = "  >  ";
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    _switchResult = "  \u2265  ";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public static String getModeValueConditionItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeValueCondition) {
            ModeLabel label = ((ModeValueCondition)object).getLabel();
            String value = ((ModeValueCondition)object).getValue();
            String _xifexpression = null;
            _xifexpression = label == null ? "<mode label>" : CustomItemProviderService.ppName(label.getName());
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = value == null ? "<value>" : value;
            String s2 = _xifexpression_1;
            String relation = CustomItemProviderService.getRelationOperatorText(((ModeValueCondition)object).getRelation());
            return String.valueOf(s1) + relation + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getModeValueConditionItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeValueCondition.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeLabelConditionItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLabelCondition) {
            ModeLabel label1 = ((ModeLabelCondition)object).getLabel1();
            ModeLabel label2 = ((ModeLabelCondition)object).getLabel2();
            String _xifexpression = null;
            _xifexpression = label1 == null ? "<mode label>" : CustomItemProviderService.ppName(label1.getName());
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = label2 == null ? "<mode label>" : CustomItemProviderService.ppName(label2.getName());
            String s2 = _xifexpression_1;
            String relation = CustomItemProviderService.getRelationOperatorText(((ModeLabelCondition)object).getRelation());
            return String.valueOf(s1) + relation + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getModeLabelConditionItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeLabelCondition.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getChannelFillConditionItemProviderText(Object object, String defaultText) {
        if (object instanceof ChannelFillCondition) {
            Channel channel = ((ChannelFillCondition)object).getChannel();
            int fillLevel = ((ChannelFillCondition)object).getFillLevel();
            String _xifexpression = null;
            _xifexpression = channel == null ? "<channel>" : CustomItemProviderService.ppName(channel.getName());
            String s1 = _xifexpression;
            String relation = CustomItemProviderService.getRelationOperatorText(((ChannelFillCondition)object).getRelation());
            String _xifexpression_1 = null;
            _xifexpression_1 = fillLevel == 1 ? " element" : " elements";
            String elements = _xifexpression_1;
            return String.valueOf(s1) + ": fill level" + relation + Integer.valueOf(fillLevel) + elements;
        }
        return defaultText;
    }

    public static ViewerNotification getChannelFillConditionItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ChannelFillCondition.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getArrivalCurveEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof ArrivalCurveEntry) {
            int _xifexpression = 0;
            _xifexpression = object == null ? 0 : ((ArrivalCurveEntry)object).getNumberOfOccurrences();
            int num = _xifexpression;
            Time _lowerTimeBorder = null;
            if ((ArrivalCurveEntry)object != null) {
                _lowerTimeBorder = ((ArrivalCurveEntry)object).getLowerTimeBorder();
            }
            String s1 = CustomItemProviderService.getTimeText(_lowerTimeBorder);
            Time _upperTimeBorder = null;
            if ((ArrivalCurveEntry)object != null) {
                _upperTimeBorder = ((ArrivalCurveEntry)object).getUpperTimeBorder();
            }
            String s2 = CustomItemProviderService.getTimeText(_upperTimeBorder);
            return "#occurrences: " + Integer.valueOf(num) + " -- interval: " + s1 + ", " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getArrivalCurveEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ArrivalCurveEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)2)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, true);
            }
        }
        return null;
    }

    public static String getAccessPrecedenceSpecItemProviderText(Object object, String defaultText) {
        if (object instanceof AccessPrecedenceSpec) {
            Runnable _origin = null;
            if ((AccessPrecedenceSpec)object != null) {
                _origin = ((AccessPrecedenceSpec)object).getOrigin();
            }
            String _name = null;
            if (_origin != null) {
                _name = _origin.getName();
            }
            String originName = _name;
            Runnable _target = null;
            if ((AccessPrecedenceSpec)object != null) {
                _target = ((AccessPrecedenceSpec)object).getTarget();
            }
            String _name_1 = null;
            if (_target != null) {
                _name_1 = _target.getName();
            }
            String targetName = _name_1;
            Label _label = null;
            if ((AccessPrecedenceSpec)object != null) {
                _label = ((AccessPrecedenceSpec)object).getLabel();
            }
            String _name_2 = null;
            if (_label != null) {
                _name_2 = _label.getName();
            }
            String labelName = _name_2;
            AccessPrecedenceType _orderType = null;
            if ((AccessPrecedenceSpec)object != null) {
                _orderType = ((AccessPrecedenceSpec)object).getOrderType();
            }
            AccessPrecedenceType accessType = _orderType;
            String s1 = CustomItemProviderService.ppName(originName, "<runnable>");
            String s2 = CustomItemProviderService.ppName(targetName, "<runnable>");
            String s3 = CustomItemProviderService.ppName(labelName, "<label>");
            String _xifexpression = null;
            _xifexpression = accessType == null || Objects.equal((Object)accessType, (Object)AccessPrecedenceType._UNDEFINED_) ? "<access>" : accessType.getLiteral();
            String s4 = _xifexpression;
            return "Spec: " + s1 + " --> " + s2 + " (" + s3 + " : " + s4 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getAccessPrecedenceSpecItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(AccessPrecedenceSpec.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getOrderPrecedenceSpecItemProviderText(Object object, String defaultText) {
        if (object instanceof OrderPrecedenceSpec) {
            Runnable _origin = null;
            if ((OrderPrecedenceSpec)object != null) {
                _origin = ((OrderPrecedenceSpec)object).getOrigin();
            }
            String _name = null;
            if (_origin != null) {
                _name = _origin.getName();
            }
            String originName = _name;
            Runnable _target = null;
            if ((OrderPrecedenceSpec)object != null) {
                _target = ((OrderPrecedenceSpec)object).getTarget();
            }
            String _name_1 = null;
            if (_target != null) {
                _name_1 = _target.getName();
            }
            String targetName = _name_1;
            OrderType _orderType = null;
            if ((OrderPrecedenceSpec)object != null) {
                _orderType = ((OrderPrecedenceSpec)object).getOrderType();
            }
            OrderType order = _orderType;
            String s1 = CustomItemProviderService.ppName(originName, "<runnable>");
            String s2 = CustomItemProviderService.ppName(targetName, "<runnable>");
            String _xifexpression = null;
            _xifexpression = order == null || Objects.equal((Object)order, (Object)OrderType._UNDEFINED_) ? "<order>" : order.getLiteral();
            String s3 = _xifexpression;
            return "Spec: " + s1 + " --> " + s2 + " (" + s3 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getOrderPrecedenceSpecItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(OrderPrecedenceSpec.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getAsynchronousServerCallItemProviderText(Object object, String defaultText) {
        if (object instanceof AsynchronousServerCall) {
            Runnable _serverRunnable = null;
            if ((AsynchronousServerCall)object != null) {
                _serverRunnable = ((AsynchronousServerCall)object).getServerRunnable();
            }
            String _qualifiedName = null;
            if (_serverRunnable != null) {
                _qualifiedName = _serverRunnable.getQualifiedName();
            }
            String serverRun = _qualifiedName;
            Runnable _resultRunnable = null;
            if ((AsynchronousServerCall)object != null) {
                _resultRunnable = ((AsynchronousServerCall)object).getResultRunnable();
            }
            String _qualifiedName_1 = null;
            if (_resultRunnable != null) {
                _qualifiedName_1 = _resultRunnable.getQualifiedName();
            }
            String resultRun = _qualifiedName_1;
            String s1 = CustomItemProviderService.ppName(serverRun, "<runnable>");
            String s2 = CustomItemProviderService.ppName(resultRun, "<runnable>");
            return "call server: " + s1 + " (async - result: " + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getAsynchronousServerCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(AsynchronousServerCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSynchronousServerCallItemProviderText(Object object, String defaultText) {
        if (object instanceof SynchronousServerCall) {
            Runnable _serverRunnable = null;
            if ((SynchronousServerCall)object != null) {
                _serverRunnable = ((SynchronousServerCall)object).getServerRunnable();
            }
            String _qualifiedName = null;
            if (_serverRunnable != null) {
                _qualifiedName = _serverRunnable.getQualifiedName();
            }
            String serverRun = _qualifiedName;
            WaitingBehaviour _waitingBehaviour = null;
            if ((SynchronousServerCall)object != null) {
                _waitingBehaviour = ((SynchronousServerCall)object).getWaitingBehaviour();
            }
            WaitingBehaviour waiting = _waitingBehaviour;
            String s1 = CustomItemProviderService.ppName(serverRun, "<runnable>");
            String _xifexpression = null;
            _xifexpression = waiting == null || Objects.equal((Object)waiting, (Object)WaitingBehaviour._UNDEFINED_) ? "undefined" : waiting.getLiteral();
            String s2 = _xifexpression;
            return "call server: " + s1 + " (sync - " + s2 + " waiting)";
        }
        return defaultText;
    }

    public static ViewerNotification getSynchronousServerCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SynchronousServerCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getGetResultServerCallItemProviderText(Object object, String defaultText) {
        if (object instanceof GetResultServerCall) {
            Runnable _serverRunnable = null;
            if ((GetResultServerCall)object != null) {
                _serverRunnable = ((GetResultServerCall)object).getServerRunnable();
            }
            String _qualifiedName = null;
            if (_serverRunnable != null) {
                _qualifiedName = _serverRunnable.getQualifiedName();
            }
            String serverRun = _qualifiedName;
            BlockingType _blockingType = null;
            if ((GetResultServerCall)object != null) {
                _blockingType = ((GetResultServerCall)object).getBlockingType();
            }
            BlockingType blocking = _blockingType;
            String s1 = CustomItemProviderService.ppName(serverRun, "<runnable>");
            String _xifexpression = null;
            _xifexpression = blocking == null || Objects.equal((Object)blocking, (Object)BlockingType._UNDEFINED_) ? "undefined" : blocking.getLiteral().replace("_", " ");
            String s2 = _xifexpression;
            return "call server: " + s1 + " (get result - " + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getGetResultServerCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(GetResultServerCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getChainedProcessPrototypeItemProviderText(Object object, String defaultText) {
        if (object instanceof ChainedProcessPrototype) {
            ProcessPrototype _prototype = null;
            if ((ChainedProcessPrototype)object != null) {
                _prototype = ((ChainedProcessPrototype)object).getPrototype();
            }
            String _name = null;
            if (_prototype != null) {
                _name = _prototype.getName();
            }
            String proto = _name;
            int _xifexpression = 0;
            _xifexpression = object == null ? 0 : ((ChainedProcessPrototype)object).getApply();
            int apply = _xifexpression;
            int _xifexpression_1 = 0;
            _xifexpression_1 = object == null ? 0 : ((ChainedProcessPrototype)object).getOffset();
            int offset = _xifexpression_1;
            String s1 = CustomItemProviderService.ppName(proto, "<process prototype>");
            return "Chained Prototype " + s1 + " ( apply: " + Integer.valueOf(apply) + " offset: " + Integer.valueOf(offset) + " )";
        }
        return defaultText;
    }

    public static ViewerNotification getChainedProcessPrototypeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ChainedProcessPrototype.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getGroupItemProviderText(Object object, String defaultText) {
        if (object instanceof Group) {
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((Group)object).getName());
            _xifexpression = _isNullOrEmpty ? null : ((Group)object).getName();
            String name = _xifexpression;
            boolean _xifexpression_1 = false;
            _xifexpression_1 = object == null ? false : ((Group)object).isOrdered();
            boolean ordered = _xifexpression_1;
            String _xifexpression_2 = null;
            _xifexpression_2 = ordered ? "(Sequence)" : "(Set)";
            String result = _xifexpression_2;
            String _xifexpression_3 = null;
            _xifexpression_3 = name == null ? result : String.valueOf(result) + " " + name;
            return _xifexpression_3;
        }
        return null;
    }

    public static String getGroupItemProviderImageName(Object object, String defaultName) {
        if (object instanceof Group) {
            String _xifexpression = null;
            boolean _isOrdered = ((Group)object).isOrdered();
            _xifexpression = _isOrdered ? "_ordered" : "_unordered";
            String order = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isInterruptible = ((Group)object).isInterruptible();
            _xifexpression_1 = _isInterruptible ? "" : "_protected";
            String protect = _xifexpression_1;
            return "Group" + order + protect;
        }
        return defaultName;
    }

    public static String getInterProcessTriggerItemProviderText(Object object, String defaultText) {
        if (object instanceof InterProcessTrigger) {
            InterProcessStimulus _stimulus = null;
            if ((InterProcessTrigger)object != null) {
                _stimulus = ((InterProcessTrigger)object).getStimulus();
            }
            String _name = null;
            if (_stimulus != null) {
                _name = _stimulus.getName();
            }
            String stimulusName = _name;
            String s1 = CustomItemProviderService.ppName(stimulusName, "<stimulus>");
            return "trigger " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getInterProcessTriggerItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(InterProcessTrigger.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getModeLiteralItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLiteral) {
            return ((ModeLiteral)object).toString();
        }
        return defaultText;
    }

    public static String getModeLabelItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLabel) {
            String name = ((ModeLabel)object).getName();
            Mode _mode = ((ModeLabel)object).getMode();
            String _name = null;
            if (_mode != null) {
                _name = _mode.getName();
            }
            String modeName = _name;
            String s1 = CustomItemProviderService.ppName(name, "<mode label>");
            String s2 = CustomItemProviderService.ppName(modeName, "<mode>");
            return String.valueOf(s1) + " (" + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getModeLabelItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeLabel.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)9)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeSwitchEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeSwitchEntry) {
            String _name = null;
            if ((ModeSwitchEntry)object != null) {
                _name = ((ModeSwitchEntry)object).getName();
            }
            String entryName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)entryName);
            _xifexpression = _isNullOrEmpty ? "_" : "\"" + entryName + "\"";
            String s1 = _xifexpression;
            return "case: " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getModeSwitchEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeSwitchEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, false);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, false, true);
        }
        return null;
    }

    public static String getModeSwitchDefaultItemProviderText(Object object, String defaultText) {
        return "default";
    }

    public static String getSwitchEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof SwitchEntry) {
            String _name = null;
            if ((SwitchEntry)object != null) {
                _name = ((SwitchEntry)object).getName();
            }
            String entryName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)entryName);
            _xifexpression = _isNullOrEmpty ? "_" : "\"" + entryName + "\"";
            String s1 = _xifexpression;
            return "case: " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSwitchEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SwitchEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, false);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, false, true);
        }
        return null;
    }

    public static String getLabelAccessItemProviderText(Object object, String defaultText) {
        if (object instanceof LabelAccess) {
            LabelAccessEnum _access = null;
            if ((LabelAccess)object != null) {
                _access = ((LabelAccess)object).getAccess();
            }
            LabelAccessEnum access = _access;
            Label _data = null;
            if ((LabelAccess)object != null) {
                _data = ((LabelAccess)object).getData();
            }
            String _qualifiedName = null;
            if (_data != null) {
                _qualifiedName = _data.getQualifiedName();
            }
            String labelName = _qualifiedName;
            String _xifexpression = null;
            _xifexpression = access == null || Objects.equal((Object)access, (Object)LabelAccessEnum._UNDEFINED_) ? "<access>" : access.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.ppName(labelName, "<label>");
            return String.valueOf(s1) + " " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getLabelAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(LabelAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)9)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static ViewerNotification getChannelAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ChannelAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getChannelReceiveItemProviderText(Object object, String defaultText) {
        if (object instanceof ChannelReceive) {
            Channel _data = null;
            if ((ChannelReceive)object != null) {
                _data = ((ChannelReceive)object).getData();
            }
            String _qualifiedName = null;
            if (_data != null) {
                _qualifiedName = _data.getQualifiedName();
            }
            String data = _qualifiedName;
            String s1 = CustomItemProviderService.ppName(data, "<channel>");
            return "receive from " + s1;
        }
        return defaultText;
    }

    public static String getChannelSendItemProviderText(Object object, String defaultText) {
        if (object instanceof ChannelSend) {
            Channel _data = null;
            if ((ChannelSend)object != null) {
                _data = ((ChannelSend)object).getData();
            }
            String _qualifiedName = null;
            if (_data != null) {
                _qualifiedName = _data.getQualifiedName();
            }
            String data = _qualifiedName;
            String s1 = CustomItemProviderService.ppName(data, "<channel>");
            return "send to " + s1;
        }
        return defaultText;
    }

    public static String getSemaphoreAccessItemProviderText(Object object, String defaultText) {
        if (object instanceof SemaphoreAccess) {
            SemaphoreAccessEnum _access = null;
            if ((SemaphoreAccess)object != null) {
                _access = ((SemaphoreAccess)object).getAccess();
            }
            SemaphoreAccessEnum access = _access;
            Semaphore _semaphore = null;
            if ((SemaphoreAccess)object != null) {
                _semaphore = ((SemaphoreAccess)object).getSemaphore();
            }
            String _name = null;
            if (_semaphore != null) {
                _name = _semaphore.getName();
            }
            String semName = _name;
            String _xifexpression = null;
            _xifexpression = access == null || Objects.equal((Object)access, (Object)SemaphoreAccessEnum._UNDEFINED_) ? "<access>" : access.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.ppName(semName, "<semaphore>");
            return String.valueOf(s1) + " " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getSemaphoreAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SemaphoreAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeLabelAccessItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLabelAccess) {
            ModeLabelAccessEnum access = ((ModeLabelAccess)object).getAccess();
            ModeLabel _data = ((ModeLabelAccess)object).getData();
            String _name = null;
            if (_data != null) {
                _name = _data.getName();
            }
            String label = _name;
            String _xifexpression = null;
            _xifexpression = access == null || Objects.equal((Object)access, (Object)LabelAccessEnum._UNDEFINED_) ? "<access>" : access.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.ppName(label, "<mode label>");
            String _xifexpression_1 = null;
            boolean _equals = Objects.equal((Object)s1, (Object)"set");
            if (_equals) {
                String _value = ((ModeLabelAccess)object).getValue();
                _xifexpression_1 = ": " + _value;
            } else {
                _xifexpression_1 = "";
            }
            String s3 = _xifexpression_1;
            String _xifexpression_2 = null;
            if (Objects.equal((Object)s1, (Object)"increment") || Objects.equal((Object)s1, (Object)"decrement")) {
                int _step = ((ModeLabelAccess)object).getStep();
                _xifexpression_2 = " by " + Integer.valueOf(_step);
            } else {
                _xifexpression_2 = "";
            }
            String s4 = _xifexpression_2;
            return String.valueOf(s1) + " " + s2 + s3 + s4;
        }
        return defaultText;
    }

    public static ViewerNotification getModeLabelAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeLabelAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getLocalModeLabelItemProviderText(Object object, String defaultText) {
        if (object instanceof LocalModeLabel) {
            String name = ((LocalModeLabel)object).getName();
            Mode _mode = ((LocalModeLabel)object).getMode();
            String _name = null;
            if (_mode != null) {
                _name = _mode.getName();
            }
            String modeName = _name;
            String s1 = CustomItemProviderService.ppName(name, "<local label>");
            String s2 = CustomItemProviderService.ppName(modeName, "<mode>");
            return String.valueOf(s1) + " (" + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getLocalModeLabelItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(LocalModeLabel.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    private static String getArithmeticOperatorText(ArithmeticOperator op) {
        String _switchResult = null;
        if (op != null) {
            switch (op) {
                case _UNDEFINED_: {
                    _switchResult = " <operator> ";
                    break;
                }
                case ADD: {
                    _switchResult = " + ";
                    break;
                }
                case SUBTRACT: {
                    _switchResult = " - ";
                    break;
                }
                case MULTIPLY: {
                    _switchResult = " * ";
                    break;
                }
                case MODULO: {
                    _switchResult = " modulo ";
                    break;
                }
            }
        }
        return _switchResult;
    }

    private static String getILocalModeValueSourceText(ILocalModeValueSource source) {
        LocalModeLabel _value;
        boolean _tripleEquals;
        ModeLiteral _value2;
        String _xifexpression;
        String _switchResult = null;
        boolean _matched = false;
        if (source instanceof IntegerConst) {
            _matched = true;
            _switchResult = Integer.valueOf(((IntegerConst)source).getValue()).toString();
        }
        if (!_matched && source instanceof ModeLiteralConst) {
            _matched = true;
            _xifexpression = null;
            _value2 = ((ModeLiteralConst)source).getValue();
            _tripleEquals = _value2 == null;
            _xifexpression = _tripleEquals ? "<mode literal>" : CustomItemProviderService.ppName(((ModeLiteralConst)source).getValue().getName());
            _switchResult = _xifexpression;
        }
        if (!_matched && source instanceof LocalModeLabelRef) {
            _matched = true;
            _value = ((LocalModeLabelRef)source).getValue();
            String _qualifiedName = null;
            if (_value != null) {
                _qualifiedName = _value.getQualifiedName();
            }
            _switchResult = _qualifiedName;
        }
        if (!_matched && source instanceof ModeLabelRef) {
            _matched = true;
            _value = ((ModeLabelRef)source).getValue();
            String _name = null;
            if (_value != null) {
                _name = _value.getName();
            }
            _switchResult = _name;
        }
        if (!_matched && source instanceof ChannelFillRef) {
            _matched = true;
            _xifexpression = null;
            _value2 = ((ChannelFillRef)source).getValue();
            boolean bl = _tripleEquals = _value2 == null;
            if (_tripleEquals) {
                _xifexpression = "fillLevel(<channel>)";
            } else {
                String _ppName = CustomItemProviderService.ppName(((ChannelFillRef)source).getValue().getName());
                String _plus = "fillLevel(" + _ppName;
                _xifexpression = String.valueOf(_plus) + ")";
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && source instanceof ArithmeticExpression) {
            _matched = true;
            String _iLocalModeValueSourceText = CustomItemProviderService.getILocalModeValueSourceText(((ArithmeticExpression)source).getOperand1());
            String _plus = "(" + _iLocalModeValueSourceText;
            String _arithmeticOperatorText = CustomItemProviderService.getArithmeticOperatorText(((ArithmeticExpression)source).getOperator());
            String _plus_1 = String.valueOf(_plus) + _arithmeticOperatorText;
            String _iLocalModeValueSourceText_1 = CustomItemProviderService.getILocalModeValueSourceText(((ArithmeticExpression)source).getOperand2());
            String _plus_2 = String.valueOf(_plus_1) + _iLocalModeValueSourceText_1;
            _switchResult = String.valueOf(_plus_2) + ")";
        }
        if (!_matched) {
            _switchResult = "<value>";
        }
        return _switchResult;
    }

    public static List<ViewerNotification> getIntegerConstItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(IntegerConst.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification, 10);
        }
        return list;
    }

    public static String getModeLiteralConstItemProviderText(Object object, String defaultText) {
        String _xifexpression = null;
        if (!(object instanceof ModeLiteralConst)) {
            return defaultText;
        }
        _xifexpression = CustomItemProviderService.getILocalModeValueSourceText((ILocalModeValueSource)object);
        return _xifexpression;
    }

    public static List<ViewerNotification> getModeLiteralConstItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ModeLiteralConst.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification, 10);
        }
        return list;
    }

    public static String getLocalModeLabelRefItemProviderText(Object object, String defaultText) {
        String _xifexpression = null;
        if (!(object instanceof LocalModeLabelRef)) {
            return defaultText;
        }
        _xifexpression = CustomItemProviderService.getILocalModeValueSourceText((ILocalModeValueSource)object);
        return _xifexpression;
    }

    public static List<ViewerNotification> getLocalModeLabelRefItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(LocalModeLabelRef.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification, 10);
        }
        return list;
    }

    public static String getModeLabelRefItemProviderText(Object object, String defaultText) {
        String _xifexpression = null;
        if (!(object instanceof ModeLabelRef)) {
            return defaultText;
        }
        _xifexpression = CustomItemProviderService.getILocalModeValueSourceText((ILocalModeValueSource)object);
        return _xifexpression;
    }

    public static List<ViewerNotification> getModeLabelRefItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ModeLabelRef.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification, 10);
        }
        return list;
    }

    public static String getChannelFillRefItemProviderText(Object object, String defaultText) {
        String _xifexpression = null;
        if (!(object instanceof ChannelFillRef)) {
            return defaultText;
        }
        _xifexpression = CustomItemProviderService.getILocalModeValueSourceText((ILocalModeValueSource)object);
        return _xifexpression;
    }

    public static List<ViewerNotification> getChannelFillRefItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ChannelFillRef.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification, 10);
        }
        return list;
    }

    public static List<ViewerNotification> getArithmeticExpressionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ArithmeticExpression.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomItemProviderService.addParentLabelNotification(list, notification);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)0)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                ViewerNotification _viewerNotification_1 = new ViewerNotification(notification, _notifier_1, true, true);
                list.add(_viewerNotification_1);
                CustomItemProviderService.addParentLabelNotification(list, notification, 10);
            }
        }
        return list;
    }

    public static ViewerNotification getLocalModeValueItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(LocalModeValue.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getLocalModeLabelAssignmentItemProviderText(Object object, String defaultText) {
        if (object instanceof LocalModeLabelAssignment) {
            LocalModeLabel label = ((LocalModeLabelAssignment)object).getLabel();
            ILocalModeValueSource value = ((LocalModeLabelAssignment)object).getValueSource();
            String _xifexpression = null;
            _xifexpression = label == null ? "<local label>" : CustomItemProviderService.ppName(label.getQualifiedName());
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.getILocalModeValueSourceText(value);
            return String.valueOf(s1) + "  \u2bc7\u2013  " + s2;
        }
        return defaultText;
    }

    public static String getLocalModeConditionItemProviderText(Object object, String defaultText) {
        if (object instanceof LocalModeCondition) {
            LocalModeLabel label = ((LocalModeCondition)object).getLabel();
            RelationalOperator relation = ((LocalModeCondition)object).getRelation();
            ILocalModeValueSource value = ((LocalModeCondition)object).getValueSource();
            String _xifexpression = null;
            _xifexpression = label == null ? "<local label>" : CustomItemProviderService.ppName(label.getQualifiedName());
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.getRelationOperatorText(relation);
            String s3 = CustomItemProviderService.getILocalModeValueSourceText(value);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static String getModeLabelAssignmentItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLabelAssignment) {
            LocalModeLabel label1 = ((ModeLabelAssignment)object).getLocalLabel();
            ModeLabel label2 = ((ModeLabelAssignment)object).getGlobalLabel();
            String _xifexpression = null;
            _xifexpression = label1 == null ? "<local label>" : CustomItemProviderService.ppName(label1.getQualifiedName());
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = label2 == null ? "<global label>" : CustomItemProviderService.ppName(label2.getName());
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + "  \u2013\u2bc8  " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getModeLabelAssignmentItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeLabelAssignment.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getTicksItemProviderText(Object object, String defaultText) {
        if (object instanceof Ticks) {
            String feature = CustomItemProviderService.containingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _contains = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"items", "computationItems"})).contains(feature);
            _xifexpression = _contains ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            return String.valueOf(s1) + defaultText;
        }
        return defaultText;
    }

    public static String getTicksEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof TicksEntryImpl) {
            ProcessingUnitDefinition _key = null;
            if ((TicksEntryImpl)object != null) {
                _key = ((TicksEntryImpl)object).getKey();
            }
            String _name = null;
            if (_key != null) {
                _name = _key.getName();
            }
            String typeName = _name;
            IDiscreteValueDeviation _value = null;
            if ((TicksEntryImpl)object != null) {
                _value = ((TicksEntryImpl)object).getValue();
            }
            IDiscreteValueDeviation deviation = _value;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)typeName);
            _xifexpression = _isNullOrEmpty ? "<pu definition>" : "Definition " + typeName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = deviation == null ? "<ticks>" : CustomDeviationItemProviderService.deviationText(deviation);
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + " -- " + s2;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTicksEntryItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            ViewerNotification _viewerNotification_1 = new ViewerNotification(notification, _notifier_1, true, true);
            list.add(_viewerNotification_1);
        }
        return list;
    }

    public static String getNeedEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof NeedEntryImpl) {
            String _key = null;
            if ((NeedEntryImpl)object != null) {
                _key = ((NeedEntryImpl)object).getKey();
            }
            String featureName = _key;
            IDiscreteValueDeviation _value = null;
            if ((NeedEntryImpl)object != null) {
                _value = ((NeedEntryImpl)object).getValue();
            }
            IDiscreteValueDeviation dev = _value;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)featureName);
            _xifexpression = _isNullOrEmpty ? "<feature>" : "Feature \"" + featureName + "\"";
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = dev == null ? "<usages>" : CustomDeviationItemProviderService.deviationText(dev);
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getNeedEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getRunnableCallItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableCall) {
            Runnable _runnable = null;
            if ((RunnableCall)object != null) {
                _runnable = ((RunnableCall)object).getRunnable();
            }
            String _qualifiedName = null;
            if (_runnable != null) {
                _qualifiedName = _runnable.getQualifiedName();
            }
            String runName = _qualifiedName;
            String s1 = CustomItemProviderService.ppName(runName, "<runnable>");
            return "call " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)6)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)7)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)9)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)10)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getCustomEventTriggerItemProviderText(Object object, String defaultText) {
        if (object instanceof CustomEventTrigger) {
            CustomEvent _event = null;
            if ((CustomEventTrigger)object != null) {
                _event = ((CustomEventTrigger)object).getEvent();
            }
            String _name = null;
            if (_event != null) {
                _name = _event.getName();
            }
            String eventName = _name;
            String s1 = CustomItemProviderService.ppName(eventName, "<custom event>");
            return "trigger " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getCustomEventTriggerItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(CustomEventTrigger.class);
        if (Objects.equal((Object)_featureID, (Object)5)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSenderReceiverReadItemProviderText(Object object, String defaultText) {
        if (object instanceof SenderReceiverRead) {
            Label _label = null;
            if ((SenderReceiverRead)object != null) {
                _label = ((SenderReceiverRead)object).getLabel();
            }
            String _qualifiedName = null;
            if (_label != null) {
                _qualifiedName = _label.getQualifiedName();
            }
            String labelName = _qualifiedName;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)labelName);
            _xifexpression = _isNullOrEmpty ? "<label>" : "Label " + labelName;
            String s1 = _xifexpression;
            return "Sender Receiver - Read " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSenderReceiverReadItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SenderReceiverRead.class);
        if (Objects.equal((Object)_featureID, (Object)6)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSenderReceiverWriteItemProviderText(Object object, String defaultText) {
        if (object instanceof SenderReceiverWrite) {
            Label _label = null;
            if ((SenderReceiverWrite)object != null) {
                _label = ((SenderReceiverWrite)object).getLabel();
            }
            String _qualifiedName = null;
            if (_label != null) {
                _qualifiedName = _label.getQualifiedName();
            }
            String labelName = _qualifiedName;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)labelName);
            _xifexpression = _isNullOrEmpty ? "<label>" : "Label " + labelName;
            String s1 = _xifexpression;
            return "Sender Receiver - Write " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSenderReceiverWriteItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SenderReceiverWrite.class);
        if (Objects.equal((Object)_featureID, (Object)6)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSetEventItemProviderText(Object object, String defaultText) {
        if (object instanceof SetEvent) {
            boolean _isNullOrEmpty;
            Process _process = null;
            if ((SetEvent)object != null) {
                _process = ((SetEvent)object).getProcess();
            }
            Process proc = _process;
            String _xifexpression = null;
            String _name = null;
            if (proc != null) {
                _name = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<process>";
            } else {
                String _name_1 = proc.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "SetEvent " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSetEventItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SetEvent.class);
        if (Objects.equal((Object)_featureID, (Object)6)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getWaitEventItemProviderText(Object object, String defaultText) {
        if (object instanceof WaitEvent) {
            WaitingBehaviour _waitingBehaviour = null;
            if ((WaitEvent)object != null) {
                _waitingBehaviour = ((WaitEvent)object).getWaitingBehaviour();
            }
            WaitingBehaviour waiting = _waitingBehaviour;
            String _xifexpression = null;
            _xifexpression = waiting == null || Objects.equal((Object)waiting, (Object)WaitingBehaviour._UNDEFINED_) ? "<waiting>" : waiting.getLiteral();
            String s1 = _xifexpression;
            return "WaitEvent " + s1;
        }
        return defaultText;
    }

    public static String getClearEventItemProviderText(Object object, String defaultText) {
        if (object instanceof ClearEvent) {
            return "ClearEvent";
        }
        return defaultText;
    }

    public static String getBaseTypeDefinitionItemProviderText(Object object, String defaultText) {
        if (object instanceof BaseTypeDefinition) {
            String _qualifiedName = null;
            if ((BaseTypeDefinition)object != null) {
                _qualifiedName = ((BaseTypeDefinition)object).getQualifiedName();
            }
            String name = _qualifiedName;
            String s1 = CustomItemProviderService.ppName(name, "<type definition>");
            return "BaseType " + s1;
        }
        return defaultText;
    }

    public static String getDataTypeDefinitionItemProviderText(Object object, String defaultText) {
        if (object instanceof DataTypeDefinition) {
            String _qualifiedName = null;
            if ((DataTypeDefinition)object != null) {
                _qualifiedName = ((DataTypeDefinition)object).getQualifiedName();
            }
            String name = _qualifiedName;
            String s1 = CustomItemProviderService.ppName(name, "<type definition>");
            return "DataType " + s1;
        }
        return defaultText;
    }

    public static String getTypeRefItemProviderText(Object object, String defaultText) {
        if (object instanceof TypeRef) {
            TypeDefinition _typeDef = null;
            if ((TypeRef)object != null) {
                _typeDef = ((TypeRef)object).getTypeDef();
            }
            String _qualifiedName = null;
            if (_typeDef != null) {
                _qualifiedName = _typeDef.getQualifiedName();
            }
            String typeName = _qualifiedName;
            String s1 = CustomItemProviderService.ppName(typeName, "<type definition>");
            return "TypeRef " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getTypeRefItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TypeRef.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getAliasItemProviderText(Object object, String defaultText) {
        if (object instanceof Alias) {
            String _target = null;
            if ((Alias)object != null) {
                _target = ((Alias)object).getTarget();
            }
            String name = _target;
            String _alias = null;
            if ((Alias)object != null) {
                _alias = ((Alias)object).getAlias();
            }
            String typeName = _alias;
            String s1 = CustomItemProviderService.ppName(name, "<target>");
            String s2 = CustomItemProviderService.ppName(typeName, "<alias>");
            return "Alias: " + s1 + " --> " + s2;
        }
        return defaultText;
    }

    public static String getRunnableParameterItemProviderImageName(Object object, String defaultName) {
        if (object instanceof RunnableParameter) {
            String _xifexpression = null;
            DirectionType _direction = ((RunnableParameter)object).getDirection();
            boolean _equals = Objects.equal((Object)_direction, (Object)DirectionType._UNDEFINED_);
            if (_equals) {
                _xifexpression = "";
            } else {
                String _literal = ((RunnableParameter)object).getDirection().getLiteral();
                _xifexpression = "_" + _literal;
            }
            String direction = _xifexpression;
            return "RunnableParameter" + direction;
        }
        return defaultName;
    }

    public static String getCallArgumentItemProviderText(Object object, String defaultText) {
        if (object instanceof CallArgument) {
            String name = ((CallArgument)object).getName();
            RunnableParameter param = ((CallArgument)object).getParameter();
            DirectionType _direction = null;
            if (param != null) {
                _direction = param.getDirection();
            }
            DirectionType dir = _direction;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
            _xifexpression = _isNullOrEmpty ? "???" : name;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = dir == null || Objects.equal((Object)dir, (Object)DirectionType._UNDEFINED_) ? "???" : dir.getLiteral().toUpperCase();
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            _xifexpression_2 = param == null ? "<argument>" : param.getQualifiedName();
            String s3 = _xifexpression_2;
            return "Call Argument " + s1 + ": (" + s2 + ") " + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getCallArgumentItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(CallArgument.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }
}

