/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.List;
import java.util.Objects;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.predefined.AmaltheaTemplates;
import org.eclipse.app4mc.amalthea.model.predefined.StandardSchedulers;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Standard-Scheduling-Parameter-Definition-Conformance", checks={"Scheduling parameter definition that are used in a standard scheduler should conform to the parameters defined by the APP4MC standard scheduler library"})
public class AmOSStandardSchedulingParameterDefinitionConformance
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSchedulingParameterDefinition();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof SchedulingParameterDefinition) {
            SchedulingParameterDefinition candidateSPD = (SchedulingParameterDefinition)object;
            OSModel dummyOSModel = AmaltheaFactory.eINSTANCE.createOSModel();
            candidateSPD.getSchedulerDefinitions().stream().flatMap(sd -> StandardSchedulers.getAllParametersOfAlgorithm((String)sd.getName()).stream()).filter(Objects::nonNull).distinct().filter(spd -> spd.getParameterName().equals(candidateSPD.getName())).findFirst().map(spd -> AmaltheaTemplates.addStandardSchedulingParameterDefinition((OSModel)dummyOSModel, (StandardSchedulers.Parameter)spd)).ifPresent(standardSPD -> {
                ePackage.getSchedulingParameterDefinition().getEAttributes().forEach(spdAttribute -> {
                    Object candidateValue;
                    Object standardValue = standardSPD.eGet((EStructuralFeature)spdAttribute);
                    if (!standardValue.equals(candidateValue = candidateSPD.eGet((EStructuralFeature)spdAttribute))) {
                        this.addIssue(results, (EObject)candidateSPD, (EStructuralFeature)spdAttribute, "Standard scheduling parameter definition \"" + standardSPD.getName() + "\" expects " + spdAttribute.getName() + " set to '" + standardValue + "', but found '" + candidateValue + "' in " + this.objectInfo((EObject)candidateSPD));
                    }
                });
                if (!candidateSPD.isMandatory() && candidateSPD.getDefaultValue() == null && standardSPD.getDefaultValue() != null) {
                    this.addIssue(results, (EObject)candidateSPD, (EStructuralFeature)ePackage.getSchedulingParameterDefinition_DefaultValue(), "Standard scheduling parameter definition \"" + standardSPD.getName() + "\" defines a default value, which should also be provided here, " + "since " + this.objectInfo((EObject)candidateSPD) + " is optional");
                }
            });
        }
    }
}

