/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.model;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.ProcessEventType;
import org.eclipse.app4mc.amalthea.model.RunnableEventType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityType;

public enum BTFCountMetric {
    activations((Enum<?>)ProcessEventType.ACTIVATE),
    preemptions((Enum<?>)ProcessEventType.PREEMPT),
    suspensions((Enum<?>)RunnableEventType.SUSPEND);

    public final Enum<?> eventToCount;
    public final BTFEntityType entityType;

    private BTFCountMetric(Enum<?> eventToCount) {
        this.eventToCount = eventToCount;
        String entityTypeName = eventToCount.getClass().getSimpleName();
        entityTypeName = entityTypeName.substring(0, entityTypeName.indexOf("EventType")).toLowerCase();
        this.entityType = BTFEntityType.getForName(entityTypeName);
    }

    public static List<Enum<?>> getInvolvedBTFEventsForEntityType(BTFEntityType entityType) {
        return Stream.of(BTFCountMetric.values()).filter(cm -> cm.entityType == entityType).map(cm -> cm.eventToCount).collect(Collectors.toList());
    }
}

