/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb.handler;

import java.util.List;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea._import.atdb.wizard.ImportWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class ATDB2AMXMIImport {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, IWorkbenchWindow runnableContext) {
        List selectionList = selection.toList();
        String atdbSource = selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("atdb")).map(f -> f.getLocation().toString()).findFirst().orElseThrow(() -> new IllegalArgumentException("Selection does not contain an *.atdb file!"));
        IFile amxmiTarget = selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("amxmi")).findFirst().orElseGet(() -> {
            int from = Math.max(atdbSource.lastIndexOf(47), atdbSource.lastIndexOf(92));
            int to = atdbSource.lastIndexOf(".atdb");
            String name = atdbSource.substring(from + 1, to);
            return selectionList.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equalsIgnoreCase("atdb")).map(IResource::getParent).map(c -> c.getProject().getFile(String.valueOf(name) + ".amxmi")).findFirst().orElseThrow(() -> new IllegalArgumentException("Selected *.atdb file is not part of a Eclipse workspace!"));
        });
        if (atdbSource.length() == 0 || runnableContext == null) {
            return;
        }
        ImportWizard.importAndOpenInIDE(atdbSource, amxmiTarget, true, true, true, (IRunnableContext)runnableContext);
    }
}

