/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter.atdb.model;

import org.eclipse.app4mc.tracing.converter.ot1.OT1.ApplicationElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.CodeBlockType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.CommunicationElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.DataElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.DataRangeElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventChainElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventReferenceElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.FrameElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.FunctionType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.InterruptType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.MessageType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.PduType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.ProcessType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.RunnableType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulableApplicationElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SignalType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TaskType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.ThreadType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TimeRangeElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TimeStampElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.VariableType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.VirtualElementType;

public enum EntityType {
    INSTRUCTION_BLOCK,
    RUNNABLE,
    INTERRUPT,
    PROCESS,
    SIGNAL,
    EVENT_CHAIN_ELEMENT,
    CORE;


    public static EntityType getEntityTypeForOT1Class(SchedulingEntityElementType ot1element) {
        SchedulingEntityElementType o = ot1element;
        if (o instanceof ApplicationElementType) {
            if (o instanceof CodeBlockType) {
                return INSTRUCTION_BLOCK;
            }
            if (o instanceof FunctionType) {
                return RUNNABLE;
            }
            if (o instanceof RunnableType) {
                return RUNNABLE;
            }
            if (o instanceof SchedulableApplicationElementType) {
                if (o instanceof InterruptType) {
                    return INTERRUPT;
                }
                if (o instanceof ProcessType) {
                    return PROCESS;
                }
                if (o instanceof TaskType) {
                    return PROCESS;
                }
                if (o instanceof ThreadType) {
                    return null;
                }
                return null;
            }
        } else if (o instanceof CommunicationElementType) {
            if (o instanceof FrameElementType) {
                return null;
            }
            if (o instanceof MessageType) {
                return null;
            }
            if (o instanceof PduType) {
                return null;
            }
            if (o instanceof SignalType) {
                return SIGNAL;
            }
        } else if (o instanceof DataElementType) {
            if (o instanceof DataRangeElementType) {
                return SIGNAL;
            }
            if (o instanceof VariableType) {
                return SIGNAL;
            }
        } else if (o instanceof VirtualElementType) {
            if (o instanceof TimeRangeElementType) {
                if (o instanceof EventChainElementType) {
                    return EVENT_CHAIN_ELEMENT;
                }
                return null;
            }
            if (o instanceof TimeStampElementType) {
                if (o instanceof EventReferenceElementType) {
                    return null;
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Type of OT1-Element not supported by now.");
    }

    public static String getATDBAbbrev(EntityType entityType) {
        switch (entityType) {
            case CORE: {
                return "Core";
            }
            case EVENT_CHAIN_ELEMENT: {
                return "EventChain";
            }
            case INTERRUPT: {
                return "Interrupt";
            }
            case INSTRUCTION_BLOCK: {
                return "InstructionBlock";
            }
            case PROCESS: {
                return "Process";
            }
            case RUNNABLE: {
                return "Runnable";
            }
            case SIGNAL: {
                return "Signal";
            }
        }
        return null;
    }
}

