/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.ui.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.app4mc.visualization.ui.VisualizationPart;
import org.eclipse.app4mc.visualization.ui.registry.ModelVisualization;
import org.eclipse.app4mc.visualization.ui.registry.ModelVisualizationRegistry;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class SettingsVisualizationsHandler {
    @Inject
    @Service
    ModelVisualizationRegistry registry;

    @Execute
    public void execute(Shell shell, @Active MPart activePart) {
        if (activePart.getObject() instanceof VisualizationPart) {
            VisualizationPart part = (VisualizationPart)activePart.getObject();
            List allVisualizations = this.registry.getAllVisualizations().stream().sorted(Comparator.comparing(this::label)).collect(Collectors.toList());
            ArrayList initial = new ArrayList();
            allVisualizations.stream().filter(mv -> part.getVisualizations().contains(mv.getId())).forEach(initial::add);
            ListSelectionDialog dialog = new ListSelectionDialog(shell, allVisualizations, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)LabelProvider.createTextProvider(mv -> this.label((ModelVisualization)mv)), "Only show selected visualizations:");
            dialog.setTitle("APP4MC Visualization Settings");
            dialog.setInitialElementSelections(initial);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                part.getVisualizations().clear();
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof ModelVisualization) {
                        ModelVisualization mv2 = (ModelVisualization)selected;
                        part.getVisualizations().add(mv2.getId());
                    }
                    ++n2;
                }
            }
        }
    }

    private String label(ModelVisualization mv) {
        String type = mv.getType().substring(mv.getType().lastIndexOf(".") + 1);
        String name = mv.getName();
        return "[" + type + "]  " + name;
    }
}

