/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.hw;

import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.PortInterface;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Inchron-HWModule-InconsistentPortWidths", checks={"HW Module cannot have ports with unequal bitwidth"})
public class InchronHWModulePortWidthCheck
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwModule();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof HwModule) {
            HwModule module = (HwModule)eObject;
            EList portList = module.getPorts();
            HashSet<Integer> portSet = new HashSet<Integer>();
            for (HwPort port : portList) {
                if (port.getPortInterface() != PortInterface.CUSTOM && port.getPortInterface() != PortInterface.AHB && port.getPortInterface() != PortInterface.AXI && port.getPortInterface() != PortInterface.APB) continue;
                portSet.add(port.getBitWidth());
            }
            if (portSet.size() > 1) {
                this.addIssue(results, (EObject)module, (EStructuralFeature)ePackage.getHwModule_Ports(), "HW Module " + this.name((INamed)module) + " has custom/AHB/APB/AXI ports with unequal bitwidths");
            }
        }
    }
}

