/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.os;

import java.util.List;
import java.util.Optional;
import org.eclipse.app4mc.amalthea.model.SchedulerDefinition;
import org.eclipse.app4mc.amalthea.model.SchedulingParameterDefinition;
import org.eclipse.app4mc.amalthea.model.predefined.StandardSchedulers;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-OS-Standard-Scheduler-Definition-Conformance", checks={"Standard schedulers with their parameters should be modeled as defined by the APP4MC standard scheduler library"})
public class AmOSStandardSchedulerDefinitionConformance
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getSchedulerDefinition();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof SchedulerDefinition) {
            SchedulerDefinition definition = (SchedulerDefinition)object;
            StandardSchedulers.Algorithm standard = StandardSchedulers.getAlgorithm((String)definition.getName());
            if (standard == null) {
                return;
            }
            this.validateSPDs(standard.getAlgorithmParameters(), (List<SchedulingParameterDefinition>)definition.getAlgorithmParameters(), ePackage.getSchedulerDefinition_AlgorithmParameters(), definition, results);
            this.validateSPDs(standard.getProcessParameters(), (List<SchedulingParameterDefinition>)definition.getProcessParameters(), ePackage.getSchedulerDefinition_ProcessParameters(), definition, results);
        }
    }

    private void validateSPDs(List<StandardSchedulers.Parameter> standardParameters, List<SchedulingParameterDefinition> candidateParameters, EReference containerReference, SchedulerDefinition container, List<ValidationDiagnostic> results) {
        for (StandardSchedulers.Parameter standardParam : standardParameters) {
            Optional<SchedulingParameterDefinition> oCandidateSPD = candidateParameters.stream().filter(c -> c.getName().equals(standardParam.getParameterName())).findFirst();
            if (oCandidateSPD.isPresent()) continue;
            this.addIssue(results, (EObject)container, (EStructuralFeature)containerReference, "Expected scheduling parameter definition \"" + standardParam.getParameterName() + "\" is not provided in " + containerReference.getName() + " for standard " + this.objectInfo((EObject)container));
        }
    }
}

