/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveStimulus;
import org.eclipse.app4mc.amalthea.model.CustomStimulus;
import org.eclipse.app4mc.amalthea.model.EventStimulus;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.VariableRateStimulus;
import org.eclipse.app4mc.amalthea.model.util.DeploymentUtil;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class RuntimeUtil {
    private RuntimeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Time getExecutionTimeForProcess(Process process, EMap<ModeLabel, String> modes, TimeType executionCase) {
        Time dummy = FactoryUtil.createTime();
        if (process == null) {
            return dummy;
        }
        Amalthea model = RuntimeUtil.getContainingModel(process);
        if (model == null) {
            return dummy;
        }
        Set<ProcessingUnit> puSet = DeploymentUtil.getAssignedCoreForProcess(process);
        if (puSet.size() != 1) {
            System.out.println("Mapping unclear. Process mapped to " + puSet.size() + " Cores - Use PU specific method");
            return dummy;
        }
        ProcessingUnit processingUnit = puSet.iterator().next();
        return RuntimeUtil.getExecutionTimeForProcess(process, processingUnit, modes, executionCase);
    }

    public static Time getExecutionTimeForProcess(Process process, ProcessingUnit processingUnit, EMap<ModeLabel, String> modes, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        if (process == null || processingUnit == null) {
            return result;
        }
        for (Runnable runnable : SoftwareUtil.getRunnableList(process, modes)) {
            result = result.add(RuntimeUtil.getExecutionTimeForRunnable(runnable, processingUnit, modes, executionCase));
        }
        return result;
    }

    public static Time getExecutionTimeForRunnable(Runnable runnable, ProcessingUnit processingUnit, EMap<ModeLabel, String> modes, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        List<Ticks> tickList = SoftwareUtil.getTicks(runnable, modes);
        for (Ticks tick : tickList) {
            result = result.add(RuntimeUtil.getExecutionTimeForTicks(tick, processingUnit, executionCase));
        }
        List<ExecutionNeed> executionNeedList = SoftwareUtil.getExecutionNeeds(runnable, modes);
        if (!executionNeedList.isEmpty()) {
            for (ExecutionNeed need : executionNeedList) {
                result = result.add(RuntimeUtil.getExecutionTimeForExecutionNeeds(need, processingUnit, executionCase));
            }
        }
        return result;
    }

    public static Time getExecutionTimeForTicks(Ticks ticks, ProcessingUnit processingUnit, TimeType executionCase) {
        Time result = null;
        if (ticks.getExtended().get((Object)processingUnit.getDefinition()) != null) {
            IDiscreteValueDeviation deviation = (IDiscreteValueDeviation)ticks.getExtended().get((Object)processingUnit.getDefinition());
            result = RuntimeUtil.getExecutionTimeForTicksDeviation(deviation, processingUnit, executionCase);
        } else {
            result = RuntimeUtil.getExecutionTimeForTicksDeviation(ticks.getDefault(), processingUnit, executionCase);
        }
        return result;
    }

    public static Time getExecutionTimeForTicksDeviation(IDiscreteValueDeviation deviation, ProcessingUnit processingUnit, TimeType executionCase) {
        double ticks = 0.0;
        switch (executionCase) {
            case BCET: {
                ticks = deviation.getLowerBound().doubleValue();
                break;
            }
            case ACET: {
                ticks = deviation.getAverage();
                break;
            }
            case WCET: {
                ticks = deviation.getUpperBound().doubleValue();
            }
        }
        return RuntimeUtil.getExecutionTimeForCycles(ticks, processingUnit.getFrequencyDomain().getDefaultValue());
    }

    public static Time getExecutionTimeForExecutionNeeds(ExecutionNeed need, ProcessingUnit processingUnit, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        if (need == null || processingUnit == null) {
            return result;
        }
        Amalthea model = RuntimeUtil.getContainingModel(processingUnit);
        if (model == null) {
            return result;
        }
        for (Map.Entry needEntry : need.getNeeds()) {
            String categoryName = (String)needEntry.getKey();
            if (categoryName == null) continue;
            Set<HwFeatureCategory> categorySet = AmaltheaIndex.getElements((Notifier)model, categoryName, HwFeatureCategory.class);
            if (categorySet.size() == 1) {
                result = RuntimeUtil.getExecutionTimeForExecutionNeedEntry((IDiscreteValueDeviation)needEntry.getValue(), categorySet.iterator().next(), processingUnit, executionCase);
                continue;
            }
            System.out.println("Mutliple Categories with the same name: " + categoryName);
        }
        return result;
    }

    public static Time getExecutionTimeForExecutionNeedEntry(IDiscreteValueDeviation deviation, HwFeatureCategory hwFeatureCategory, ProcessingUnit processingUnit, TimeType executionCase) {
        double ticks = 0.0;
        switch (executionCase) {
            case BCET: {
                ticks = deviation.getLowerBound().doubleValue();
                break;
            }
            case ACET: {
                ticks = deviation.getAverage();
                break;
            }
            case WCET: {
                ticks = deviation.getUpperBound().doubleValue();
            }
        }
        double scaleFactor = 0.0;
        for (HwFeature feature : processingUnit.getDefinition().getFeatures()) {
            if (!feature.getContainingCategory().equals(hwFeatureCategory)) continue;
            scaleFactor = feature.getValue();
        }
        return RuntimeUtil.getExecutionTimeForCycles(ticks *= scaleFactor, processingUnit.getFrequencyDomain().getDefaultValue());
    }

    public static Time getExecutionTimeForCycles(double ticks, Frequency frequency) {
        if (frequency == null) {
            return null;
        }
        double cyclesPerSecond = AmaltheaServices.convertToHertz(frequency).doubleValue();
        double factor = 1.0 / cyclesPerSecond;
        Time oneSecond = FactoryUtil.createTime(1L, TimeUnit.S);
        Time t1 = oneSecond.multiply(ticks);
        Time result = t1.multiply(factor);
        return result.adjustUnit();
    }

    public static double getTicksForExecutionTimeInSeconds(BigDecimal executionTime, Frequency frequency) {
        if (executionTime == null || frequency == null) {
            return Double.NaN;
        }
        BigDecimal cyclesPerSecond = AmaltheaServices.convertToHertz(frequency);
        BigDecimal ticks = executionTime.multiply(cyclesPerSecond);
        return ticks.doubleValue();
    }

    public static double getTicksForExecutionTime(Time executionTime, Frequency frequency) {
        if (executionTime == null) {
            return Double.NaN;
        }
        return RuntimeUtil.getTicksForExecutionTimeInSeconds(AmaltheaServices.convertToSeconds(executionTime), frequency);
    }

    public static void setRuntimeOfRunnable(Runnable runnable, ExecutionNeed need, EMap<ModeLabel, String> modes) {
        RuntimeUtil.clearRuntimeOfRunnable(runnable, modes);
        RuntimeUtil.addRuntimeToRunnable(runnable, need);
    }

    public static void setRuntimeOfRunnable(Runnable runnable, Ticks ticks, EMap<ModeLabel, String> modes) {
        RuntimeUtil.clearRuntimeOfRunnable(runnable, modes);
        RuntimeUtil.addRuntimeToRunnable(runnable, ticks);
    }

    public static void addRuntimeToRunnable(Runnable runnable, ExecutionNeed need) {
        runnable.getRunnableItems().add((Object)need);
    }

    public static void addRuntimeToRunnable(Runnable runnable, Ticks ticks) {
        runnable.getRunnableItems().add((Object)ticks);
    }

    public static void clearRuntimeOfModel(Amalthea model, EMap<ModeLabel, String> modes) {
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process process : processes) {
            RuntimeUtil.clearRuntimeOfProcess(process, modes);
        }
    }

    public static void clearRuntimeOfProcess(Process process, EMap<ModeLabel, String> modes) {
        List<ExecutionNeed> executionNeeds = SoftwareUtil.getExecutionNeeds(process, modes);
        AmaltheaIndex.deleteAll(executionNeeds);
        List<Ticks> ticks = SoftwareUtil.getTicks(process, modes);
        AmaltheaIndex.deleteAll(ticks);
    }

    public static void clearRuntimeOfRunnable(Runnable runnable, EMap<ModeLabel, String> modes) {
        List<ExecutionNeed> executionNeeds = SoftwareUtil.getExecutionNeeds(runnable, modes);
        AmaltheaIndex.deleteAll(executionNeeds);
        List<Ticks> ticks = SoftwareUtil.getTicks(runnable, modes);
        AmaltheaIndex.deleteAll(ticks);
    }

    public static Runnable addRuntimeToProcessAsNewRunnable(Process process, ExecutionNeed need, String runnableName, PositionType positon) {
        Runnable run = AmaltheaFactory.eINSTANCE.createRunnable();
        run.setName(runnableName);
        run.getRunnableItems().add((Object)need);
        RunnableCall call = AmaltheaFactory.eINSTANCE.createRunnableCall();
        call.setRunnable(run);
        if (positon.equals((Object)PositionType.FIRST)) {
            process.getActivityGraph().getItems().add(0, (Object)call);
        } else {
            process.getActivityGraph().getItems().add((Object)call);
        }
        return run;
    }

    public static Runnable addRuntimeToProcessAsNewRunnable(Process process, Ticks ticks, String runnableName, PositionType positon) {
        Runnable run = AmaltheaFactory.eINSTANCE.createRunnable();
        run.setName(runnableName);
        run.getRunnableItems().add((Object)ticks);
        RunnableCall call = AmaltheaFactory.eINSTANCE.createRunnableCall();
        call.setRunnable(run);
        if (positon.equals((Object)PositionType.FIRST)) {
            process.getActivityGraph().getItems().add(0, (Object)call);
        } else {
            process.getActivityGraph().getItems().add((Object)call);
        }
        return run;
    }

    public static double getProcUnitUtilization(ProcessingUnit procUnit, Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        double utilization = 0.0;
        for (Process proc : DeploymentUtil.getProcessesMappedToCore(procUnit, model)) {
            utilization += RuntimeUtil.getProcessUtilization(proc, procUnit, model, tt, hwFeatures, modes);
        }
        return utilization;
    }

    public static Map<ProcessingUnit, Double> getProcessUtilization(Process process, Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        HashMap<ProcessingUnit, Double> utilizations = new HashMap<ProcessingUnit, Double>();
        Set<ProcessingUnit> procUnits = DeploymentUtil.getAssignedCoreForProcess(process);
        for (ProcessingUnit procUnit : procUnits) {
            double utilization = RuntimeUtil.getProcessUtilization(process, procUnit, model, tt, hwFeatures, modes);
            utilizations.put(procUnit, utilization);
        }
        return utilizations;
    }

    public static double getProcessUtilization(Process process, ProcessingUnit procUnit, Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        double utilization = 0.0;
        List<Time> periods = RuntimeUtil.getPeriodsOfProcess(process, tt, modes);
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        if (time.getValue().compareTo(BigInteger.valueOf(0L)) < 0) {
            System.err.println("execTime " + time);
        }
        for (Time period : periods) {
            if (period == null || period.getValue().intValue() == 0) continue;
            utilization += time.divide(period);
        }
        return utilization;
    }

    public static double getProcessUtilization(Process process, Time period, TimeType tt, EMap<ModeLabel, String> modes) {
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        return time.divide(period);
    }

    public static Map<Process, Double> getCumulativeProcessUtilizations(Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        HashMap<Process, Double> utilizations = new HashMap<Process, Double>();
        ArrayList<Process> procList = new ArrayList<Process>();
        procList.addAll((Collection<Process>)model.getSwModel().getTasks());
        procList.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process proc : procList) {
            Map<ProcessingUnit, Double> utilizationMap = RuntimeUtil.getProcessUtilization(proc, model, tt, hwFeatures, modes);
            double util = 0.0;
            for (Double value : utilizationMap.values()) {
                util += value.doubleValue();
            }
            utilizations.put(proc, util);
        }
        return utilizations;
    }

    public static Map<Process, List<Time>> getPeriodsOfAllProcesses(Amalthea model, TimeType tt, EMap<ModeLabel, String> modes) {
        HashMap<Process, List<Time>> result = new HashMap<Process, List<Time>>();
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process process : processes) {
            List<Time> periods = RuntimeUtil.getPeriodsOfProcess(process, tt, modes);
            result.put(process, periods);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Time> getPeriodsOfProcess(Process process, TimeType tt, EMap<ModeLabel, String> modes) {
        ArrayList<Time> result = new ArrayList<Time>();
        for (Stimulus stimulus : process.getStimuli()) {
            Stimulus stimulus2 = stimulus;
            if (stimulus2 instanceof PeriodicStimulus) {
                void p;
                PeriodicStimulus cfr_ignored_0 = (PeriodicStimulus)stimulus2;
                PeriodicStimulus cfr_ignored_1 = (PeriodicStimulus)stimulus2;
                result.add(p.getRecurrence());
                continue;
            }
            Stimulus stimulus3 = stimulus;
            if (stimulus3 instanceof InterProcessStimulus) {
                Map<Process, Long> triggeringProcesses;
                void ip;
                InterProcessStimulus cfr_ignored_2 = (InterProcessStimulus)stimulus3;
                InterProcessStimulus cfr_ignored_3 = (InterProcessStimulus)stimulus3;
                long ipPrescaler = 1L;
                if (ip.getCounter() != null) {
                    ipPrescaler = ip.getCounter().getPrescaler();
                }
                if ((triggeringProcesses = RuntimeUtil.getTriggeringProcesses((InterProcessStimulus)ip, modes)).containsKey(process)) {
                    triggeringProcesses.remove(process);
                }
                for (Map.Entry<Process, Long> entry : triggeringProcesses.entrySet()) {
                    Process triggeringProcess = entry.getKey();
                    long ipaPrescaler = entry.getValue();
                    List<Time> periods = RuntimeUtil.getPeriodsOfProcess(triggeringProcess, tt, modes);
                    for (Time t : periods) {
                        result.add(t.multiply(ipaPrescaler * ipPrescaler));
                    }
                }
                continue;
            }
            Stimulus stimulus4 = stimulus;
            if (!(stimulus4 instanceof RelativePeriodicStimulus)) continue;
            RelativePeriodicStimulus cfr_ignored_4 = (RelativePeriodicStimulus)stimulus4;
            RelativePeriodicStimulus cfr_ignored_5 = (RelativePeriodicStimulus)stimulus4;
            Time time = null;
            switch (tt) {
                case ACET: {
                    void rp;
                    if (rp.getNextOccurrence() == null) break;
                    time = rp.getNextOccurrence().getAverage();
                    break;
                }
                case BCET: {
                    void rp;
                    if (rp.getNextOccurrence() == null) break;
                    time = rp.getNextOccurrence().getUpperBound();
                    break;
                }
                case WCET: {
                    void rp;
                    if (rp.getNextOccurrence() == null) break;
                    time = rp.getNextOccurrence().getLowerBound();
                    break;
                }
            }
            if (time == null) continue;
            result.add(time);
        }
        Collections.sort(result);
        return result;
    }

    public static Map<Process, Long> getTriggeringProcesses(InterProcessStimulus ip, EMap<ModeLabel, String> modes) {
        HashMap<Process, Long> result = new HashMap<Process, Long>();
        for (InterProcessTrigger interProcessTrigger : ip.getExplicitTriggers()) {
            Process parentProcess = AmaltheaServices.getContainerOfType(interProcessTrigger, Process.class);
            if (interProcessTrigger.getCounter() != null) {
                result.put(parentProcess, interProcessTrigger.getCounter().getPrescaler());
                continue;
            }
            result.put(parentProcess, 1L);
        }
        return result;
    }

    public static Map<Stimulus, Long> getTriggeredStimuli(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Stimulus, Long> stimuliMap = new HashMap<Stimulus, Long>();
        EList<InterProcessTrigger> interProcessTriggers = SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, InterProcessTrigger.class);
        interProcessTriggers.forEach(ipa -> {
            if (ipa.getCounter() != null) {
                stimuliMap.put(ipa.getStimulus(), ipa.getCounter().getPrescaler());
            } else {
                stimuliMap.put(ipa.getStimulus(), 1L);
            }
        });
        return stimuliMap;
    }

    public static Map<Process, List<Time>> getProcessesWithRelativePeriodicStimulus(Amalthea model, TimeType tt) {
        HashSet<Process> processes = new HashSet<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        Map<Process, List<Time>> result = processes.stream().collect(Collectors.toMap(p -> p, p -> p.getStimuli().stream().filter(RelativePeriodicStimulus.class::isInstance).map(s -> RuntimeUtil.getActivationTimeFromDeviation(((RelativePeriodicStimulus)s).getNextOccurrence(), tt)).toList()));
        return result;
    }

    private static Time getActivationTimeFromDeviation(ITimeDeviation deviation, TimeType tt) {
        switch (tt) {
            case ACET: {
                return deviation.getAverage();
            }
            case BCET: {
                return deviation.getUpperBound();
            }
            case WCET: {
                return deviation.getLowerBound();
            }
        }
        return null;
    }

    public static Map<Process, List<ITimeDeviation>> getProcessesWithRelativePeriodicStimulus(Amalthea model) {
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        Map<Process, List<ITimeDeviation>> result = processes.stream().filter(p -> p.getStimuli().stream().filter(RelativePeriodicStimulus.class::isInstance).toList().size() > 0).collect(Collectors.toMap(p -> p, p -> p.getStimuli().stream().filter(RelativePeriodicStimulus.class::isInstance).map(s -> ((RelativePeriodicStimulus)s).getNextOccurrence()).toList()));
        return result;
    }

    public static Map<Process, Map<Stimulus, Long>> getPlainTriggersForModel(Amalthea model, Function<Stimulus, Boolean> filter) {
        HashMap<Process, Map<Stimulus, Long>> map = new HashMap<Process, Map<Stimulus, Long>>();
        ArrayList<Process> processes = new ArrayList<Process>();
        SWModel swModel = ModelUtil.getOrCreateSwModel(model);
        processes.addAll((Collection<Process>)swModel.getTasks());
        processes.addAll((Collection<Process>)swModel.getIsrs());
        for (Process p : processes) {
            Map<Stimulus, Long> plainTriggerForProcess = RuntimeUtil.getPlainTriggerForProcess(p, 1L, filter);
            if (plainTriggerForProcess == null || plainTriggerForProcess.isEmpty()) continue;
            map.put(p, plainTriggerForProcess);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Stimulus, Long> getPlainTriggerForProcess(Process process, long depthCounter, Function<Stimulus, Boolean> filter) {
        HashMap<Stimulus, Long> map = new HashMap<Stimulus, Long>();
        for (Stimulus stimulus : process.getStimuli()) {
            void ps;
            if (filter != null && !Boolean.TRUE.equals(filter.apply(stimulus))) continue;
            Stimulus stimulus2 = stimulus;
            if (stimulus2 instanceof PeriodicStimulus) {
                void p;
                PeriodicStimulus cfr_ignored_0 = (PeriodicStimulus)stimulus2;
                PeriodicStimulus cfr_ignored_1 = (PeriodicStimulus)stimulus2;
                map.put((Stimulus)p, depthCounter);
                continue;
            }
            Stimulus stimulus3 = stimulus;
            if (stimulus3 instanceof ArrivalCurveStimulus) {
                void ac;
                ArrivalCurveStimulus cfr_ignored_2 = (ArrivalCurveStimulus)stimulus3;
                ArrivalCurveStimulus cfr_ignored_3 = (ArrivalCurveStimulus)stimulus3;
                map.put((Stimulus)ac, depthCounter);
                continue;
            }
            Stimulus stimulus4 = stimulus;
            if (stimulus4 instanceof CustomStimulus) {
                void c;
                CustomStimulus cfr_ignored_4 = (CustomStimulus)stimulus4;
                CustomStimulus cfr_ignored_5 = (CustomStimulus)stimulus4;
                map.put((Stimulus)c, depthCounter);
                continue;
            }
            Stimulus stimulus5 = stimulus;
            if (stimulus5 instanceof EventStimulus) {
                void e;
                EventStimulus cfr_ignored_6 = (EventStimulus)stimulus5;
                EventStimulus cfr_ignored_7 = (EventStimulus)stimulus5;
                map.put((Stimulus)e, depthCounter);
                continue;
            }
            Stimulus stimulus6 = stimulus;
            if (stimulus6 instanceof InterProcessStimulus) {
                void ip;
                InterProcessStimulus cfr_ignored_8 = (InterProcessStimulus)stimulus6;
                InterProcessStimulus cfr_ignored_9 = (InterProcessStimulus)stimulus6;
                long ipPrescaler = 1L;
                if (ip.getCounter() != null) {
                    ipPrescaler = ip.getCounter().getPrescaler();
                }
                Map<Process, Long> triggeringProcesses = RuntimeUtil.getTriggeringProcesses((InterProcessStimulus)ip, null);
                for (Map.Entry<Process, Long> entry : triggeringProcesses.entrySet()) {
                    Process triggeringProcess = (Process)entry.getKey();
                    if (triggeringProcess.equals(process)) continue;
                    long ipaPrescaler = (Long)entry.getValue();
                    Map<Stimulus, Long> plainTriggerForProcess = RuntimeUtil.getPlainTriggerForProcess(triggeringProcess, depthCounter * ipaPrescaler * ipPrescaler, filter);
                    map.putAll(plainTriggerForProcess);
                }
                continue;
            }
            Stimulus stimulus7 = stimulus;
            if (stimulus7 instanceof VariableRateStimulus) {
                void vr;
                VariableRateStimulus cfr_ignored_10 = (VariableRateStimulus)stimulus7;
                VariableRateStimulus cfr_ignored_11 = (VariableRateStimulus)stimulus7;
                map.put((Stimulus)vr, depthCounter);
                continue;
            }
            Stimulus stimulus8 = stimulus;
            if (stimulus8 instanceof SingleStimulus) {
                void s;
                SingleStimulus cfr_ignored_12 = (SingleStimulus)stimulus8;
                SingleStimulus cfr_ignored_13 = (SingleStimulus)stimulus8;
                map.put((Stimulus)s, depthCounter);
                continue;
            }
            Stimulus stimulus9 = stimulus;
            if (stimulus9 instanceof RelativePeriodicStimulus) {
                void rp;
                RelativePeriodicStimulus cfr_ignored_14 = (RelativePeriodicStimulus)stimulus9;
                RelativePeriodicStimulus cfr_ignored_15 = (RelativePeriodicStimulus)stimulus9;
                map.put((Stimulus)rp, depthCounter);
                continue;
            }
            Stimulus stimulus10 = stimulus;
            if (!(stimulus10 instanceof PeriodicSyntheticStimulus)) continue;
            PeriodicSyntheticStimulus cfr_ignored_16 = (PeriodicSyntheticStimulus)stimulus10;
            PeriodicSyntheticStimulus cfr_ignored_17 = (PeriodicSyntheticStimulus)stimulus10;
            map.put((Stimulus)ps, depthCounter);
        }
        return map;
    }

    private static Amalthea getContainingModel(EObject object) {
        if (object == null) {
            return null;
        }
        return AmaltheaServices.getContainerOfType(object, Amalthea.class);
    }

    public static enum AccessDirection {
        READ,
        WRITE;

    }

    public static enum PositionType {
        FIRST,
        LAST;

    }

    public static enum TimeType {
        BCET,
        ACET,
        WCET;

    }
}

