/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.hardware;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.PortInterface;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-HW-Connection", checks={"HwConnections must refer to two HwPorts", "HwConnections must be linked to HwPorts of the same Interface"})
public class AmHwConnection
extends AmaltheaValidation {
    private static final String HW_CONNECTION = "HW Connection ";

    public EClassifier getEClassifier() {
        return ePackage.getHwConnection();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof HwConnection) {
            void connection;
            HwConnection hwConnection = (HwConnection)eObject;
            HwConnection cfr_ignored_0 = (HwConnection)eObject;
            boolean continueChecks = true;
            HwPort port1 = connection.getPort1();
            HwPort port2 = connection.getPort2();
            if (port1 == null) {
                this.addIssue(results, (EObject)connection, (EStructuralFeature)ePackage.getHwConnection_Port1(), HW_CONNECTION + this.qualifiedName((IReferable)connection) + ": Port 1 is missing");
                continueChecks = false;
            }
            if (port2 == null) {
                this.addIssue(results, (EObject)connection, (EStructuralFeature)ePackage.getHwConnection_Port2(), HW_CONNECTION + this.qualifiedName((IReferable)connection) + ": Port 2 is missing");
                continueChecks = false;
            }
            if (port1 != null && port1 == port2) {
                this.addIssue(results, (EObject)connection, (EStructuralFeature)ePackage.getHwConnection_Port1(), HW_CONNECTION + this.qualifiedName((IReferable)connection) + ": Port 1 equals port 2");
                continueChecks = false;
            }
            if (!continueChecks) {
                return;
            }
            if (!connection.isInternal() && port1.getPortInterface() != PortInterface._UNDEFINED_ && port2.getPortInterface() != PortInterface._UNDEFINED_ && port1.getPortInterface() != port2.getPortInterface()) {
                this.addIssue(results, (EObject)connection, (EStructuralFeature)ePackage.getHwConnection_Port1(), HW_CONNECTION + this.qualifiedName((IReferable)connection) + ": Port interfaces do not match");
            }
        }
    }
}

