/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.app4mc.tracing.converter.Htf2Ot1Converter;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.DocumentRoot;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConverterHandler
extends AbstractHandler {
    private IFile getSelectedPath(ExecutionEvent event) {
        IFile file = null;
        try {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            ISelectionService service = window.getSelectionService();
            IStructuredSelection structured = (IStructuredSelection)service.getSelection();
            file = (IFile)structured.getFirstElement();
        }
        catch (ExecutionException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).warn("Execution Exception", (Throwable)e);
        }
        return file;
    }

    private void saveModel(DocumentRoot model, String path) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createFileURI((String)path));
        resource.getContents().add((Object)model);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("DECLARE_XML", true);
        options.put("KEEP_DEFAULT_CONTENT", true);
        try {
            resource.save(options);
        }
        catch (IOException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).warn("IO Exception", (Throwable)e);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Htf2Ot1Converter converter = new Htf2Ot1Converter();
        IFile inputFile = this.getSelectedPath(event);
        if (inputFile == null) {
            return Boolean.FALSE;
        }
        IPath path = inputFile.getLocation();
        if (path == null) {
            return Boolean.FALSE;
        }
        path = path.makeAbsolute();
        DocumentRoot ot1Model = converter.convertHtf2Ot1(path.toOSString());
        path = inputFile.getFullPath();
        path = path.removeFileExtension();
        path = path.addFileExtension("xml");
        this.saveModel(ot1Model, path.toOSString());
        return Boolean.TRUE;
    }
}

