/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FormatSpecifierImpl;
import org.eclipse.birt.chart.util.NumberUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class JavaNumberFormatSpecifierImpl
extends FormatSpecifierImpl
implements JavaNumberFormatSpecifier {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    protected static final double MULTIPLIER_EDEFAULT = 0.0;
    protected double multiplier = 0.0;
    protected boolean multiplierESet;

    protected JavaNumberFormatSpecifierImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return AttributePackage.Literals.JAVA_NUMBER_FORMAT_SPECIFIER;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPattern, (Object)this.pattern));
        }
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void setMultiplier(double newMultiplier) {
        double oldMultiplier = this.multiplier;
        this.multiplier = newMultiplier;
        boolean oldMultiplierESet = this.multiplierESet;
        this.multiplierESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldMultiplier, this.multiplier, !oldMultiplierESet));
        }
    }

    @Override
    public void unsetMultiplier() {
        double oldMultiplier = this.multiplier;
        boolean oldMultiplierESet = this.multiplierESet;
        this.multiplier = 0.0;
        this.multiplierESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, oldMultiplier, 0.0, oldMultiplierESet));
        }
    }

    @Override
    public boolean isSetMultiplier() {
        return this.multiplierESet;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPattern();
            }
            case 1: {
                return this.getMultiplier();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPattern((String)newValue);
                return;
            }
            case 1: {
                this.setMultiplier((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetMultiplier();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
            case 1: {
                return this.isSetMultiplier();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(", multiplier: ");
        if (this.multiplierESet) {
            result.append(this.multiplier);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public static JavaNumberFormatSpecifier create(String sJavaPattern) {
        JavaNumberFormatSpecifier jnfs = AttributeFactory.eINSTANCE.createJavaNumberFormatSpecifier();
        jnfs.setPattern(sJavaPattern);
        return jnfs;
    }

    @Override
    public String format(double dValue, ULocale lo) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance((ULocale)lo);
        df.applyPattern(this.getPattern());
        return this.isSetMultiplier() ? df.format(dValue * this.getMultiplier()) : df.format(dValue);
    }

    @Override
    public String format(Number number, ULocale lo) {
        Number n = NumberUtil.transformNumber(number);
        if (n instanceof Double) {
            return this.format((double)((Double)n), lo);
        }
        BigDecimal bdNum = (BigDecimal)n;
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance((ULocale)lo);
        String vPattern = NumberUtil.adjustBigNumberFormatPattern(this.getPattern());
        if (vPattern.indexOf(69) < 0) {
            vPattern = String.valueOf(vPattern) + "E0";
        }
        df.applyPattern(vPattern);
        return this.isSetMultiplier() ? df.format(bdNum.multiply(BigDecimal.valueOf((double)this.getMultiplier()), NumberUtil.DEFAULT_MATHCONTEXT)) : df.format(bdNum);
    }

    @Override
    public String format(double dValue, Locale lo) {
        return this.format(dValue, ULocale.forLocale((Locale)lo));
    }

    @Override
    public JavaNumberFormatSpecifier copyInstance() {
        JavaNumberFormatSpecifierImpl dest = new JavaNumberFormatSpecifierImpl();
        dest.set(this);
        return dest;
    }

    protected void set(JavaNumberFormatSpecifier src) {
        super.set(src);
        this.pattern = src.getPattern();
        this.multiplier = src.getMultiplier();
        this.multiplierESet = src.isSetMultiplier();
    }
}

