/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDECPListElement;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDECPListLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.ProjectLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.preferences.ITreeListAdapter;
import org.eclipse.birt.report.designer.internal.ui.preferences.LayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.preferences.TreeListDialogField;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.DialogField;
import org.eclipse.birt.report.designer.ui.preferences.IDialogFieldListener;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IDEClassPathBlock
extends OptionsConfigurationBlock {
    private static OptionsConfigurationBlock.Key PREF_CLASSPATH;
    private final TreeListDialogField fLibrariesList;
    private static final int IDX_ADDJAR = 0;
    private static final int IDX_ADDEXT = 1;
    private static final int IDX_ADDVAR = 2;
    private static final int IDX_ADDFOL = 3;
    private static final int IDX_ADDEXTFOL = 4;
    private static final int IDX_ADDPROJECT = 5;
    private static final int IDX_UP = 7;
    private static final int IDX_DOWN = 8;
    private static final int IDX_EDIT = 9;
    private static final int IDX_REMOVE = 10;
    private static final int UNKNOW_TYPE = -1;
    private static int JAR_TYPE;
    private static final int EXTJAR_TYPE = 1;
    private static final int VAR_TYPE = 2;
    private static final int FOL_TYPE = 3;
    private static final int ADDFOL_TYPE = 4;
    private static final int PROJECT_TYPE = 5;
    private static final String ENTRY_SEPARATOR = "|";
    private static final String TYPE_SEPARATOR = "*";

    static {
        JAR_TYPE = 0;
    }

    public IDEClassPathBlock(IStatusChangeListener context, IProject project) {
        super(context, (AbstractUIPlugin)ReportPlugin.getDefault(), project);
        PREF_CLASSPATH = this.getReportKey("org.eclipse.birt.report.designer.ui.preferences.classpath");
        String[] stringArray = new String[11];
        stringArray[0] = Messages.getString((String)"IDEClassPathBlock.button_addJar");
        stringArray[1] = Messages.getString((String)"IDEClassPathBlock.button_addEXTJar");
        stringArray[2] = Messages.getString((String)"IDEClassPathBlock.button_addVar");
        stringArray[3] = Messages.getString((String)"IDEClassPathBlock.button_folder");
        stringArray[4] = Messages.getString((String)"IDEClassPathBlock.button_addExtFolder");
        stringArray[5] = Messages.getString((String)"IDEClassPathBlock.button_addProject");
        stringArray[7] = Messages.getString((String)"IDEClassPathBlock.button_up");
        stringArray[8] = Messages.getString((String)"IDEClassPathBlock.button_down");
        stringArray[9] = Messages.getString((String)"IDEClassPathBlock.button_edit");
        stringArray[10] = Messages.getString((String)"IDEClassPathBlock.button_remove");
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new IDECPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fLibrariesList.setLabelText(Messages.getString((String)"IDEClassPathBlock.fLibrariesList_text"));
        this.fLibrariesList.enableButton(7, false);
        this.fLibrariesList.enableButton(8, false);
        this.fLibrariesList.enableButton(10, false);
        this.fLibrariesList.enableButton(9, false);
        this.setKeys(this.getKeys());
        this.fLibrariesList.setElements(IDEClassPathBlock.readClassPathEntry(this.getValue(PREF_CLASSPATH)));
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{PREF_CLASSPATH};
        return keys;
    }

    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        if (this.getProject() == null) {
            this.fLibrariesList.removeButton(5);
        }
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fLibrariesList}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        return composite;
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 4: {
                libentries = this.openExternalClassFolderDialog(null);
                break;
            }
            case 5: {
                libentries = this.addProjectDialog();
                break;
            }
            case 7: {
                libentries = this.getSelection().toArray(new IDECPListElement[this.getSelection().size()]);
                this.fLibrariesList.up();
                break;
            }
            case 8: {
                libentries = this.getSelection().toArray(new IDECPListElement[this.getSelection().size()]);
                this.fLibrariesList.down();
                break;
            }
            case 9: {
                this.editEntry();
                return;
            }
            case 10: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<IDECPListElement> elementsToAdd = new ArrayList<IDECPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                IDECPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    public void addElement(IDECPListElement element) {
        this.fLibrariesList.addElement((Object)element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = field.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        return selElements.size() != 0;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((IDECPListElement)elem);
        }
    }

    private void editElementEntry(IDECPListElement elem) {
        IDECPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    File file = elem.getPath().toFile();
                    if (file.isDirectory()) {
                        res = this.openExternalClassFolderDialog(elem);
                        break;
                    }
                    res = this.openExtJarFileDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openJarFileDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            IDECPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement((Object)elem, (Object)curr);
            if (elem.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(9, this.canEdit(selElements));
        this.fLibrariesList.enableButton(10, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(1, noAttributes);
        this.fLibrariesList.enableButton(3, noAttributes);
        this.fLibrariesList.enableButton(4, noAttributes);
        this.fLibrariesList.enableButton(0, noAttributes);
        this.fLibrariesList.enableButton(2, noAttributes);
        this.fLibrariesList.enableButton(7, this.fLibrariesList.canMoveUp(selElements));
        this.fLibrariesList.enableButton(8, this.fLibrariesList.canMoveDown(selElements));
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof IDECPListElement) {
            IDECPListElement curr = (IDECPListElement)elem;
            return !(curr.getResource() instanceof IFolder) && !(curr.getResource() instanceof IProject) && curr.getParentContainer() == null;
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
    }

    private IDECPListElement[] openClassFolderDialog(IDECPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries((Shell)this.getShell(), (IPath)(this.getProject() == null ? null : this.getProject().getLocation()), (IPath[])this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<IDECPListElement> res = new ArrayList<IDECPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(IDEClassPathBlock.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new IDECPListElement[res.size()]);
        }
        return null;
    }

    private IDECPListElement[] openJarFileDialog(IDECPListElement existing) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)(this.getProject() == null ? null : this.getProject().getLocation()), (IPath[])this.getUsedJARFiles(existing));
            if (selected != null) {
                ArrayList<IDECPListElement> res = new ArrayList<IDECPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = root.findMember(curr);
                    if (resource instanceof IFile) {
                        res.add(IDEClassPathBlock.newCPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new IDECPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry((Shell)this.getShell(), (IPath)existing.getPath(), (IPath[])this.getUsedJARFiles(existing));
            if (configured != null && (resource = root.findMember(configured)) instanceof IFile) {
                return new IDECPListElement[]{IDEClassPathBlock.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(IDECPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            IDECPListElement elem = (IDECPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedJARFiles(IDECPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            IDECPListElement elem = (IDECPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private static IDECPListElement newCPLibraryElement(IResource res) {
        return new IDECPListElement(1, res.getFullPath(), res);
    }

    private IDECPListElement[] openExtJarFileDialog(IDECPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
            if (selected != null) {
                ArrayList<IDECPListElement> res = new ArrayList<IDECPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new IDECPListElement(1, selected[i], null));
                    ++i;
                }
                return res.toArray(new IDECPListElement[res.size()]);
            }
        } else {
            IPath path = existing.getPath();
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry((Shell)this.getShell(), (IPath)path);
            if (configured != null) {
                return new IDECPListElement[]{new IDECPListElement(1, configured, null)};
            }
        }
        return null;
    }

    private IDECPListElement[] openExternalClassFolderDialog(IDECPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalClassFolderEntries((Shell)this.getShell());
            if (selected != null) {
                ArrayList<IDECPListElement> res = new ArrayList<IDECPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new IDECPListElement(1, selected[i], null));
                    ++i;
                }
                return res.toArray(new IDECPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalClassFolderEntries((Shell)this.getShell(), (IPath)existing.getPath());
            if (configured != null) {
                return new IDECPListElement[]{new IDECPListElement(1, configured, null)};
            }
        }
        return null;
    }

    private static IDECPListElement createCPVariableElement(IPath path) {
        IDECPListElement elem = new IDECPListElement(4, path, null);
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
        elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
        return elem;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 2 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    private IDECPListElement[] openVariableSelectionDialog(IDECPListElement existing) {
        List existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            IDECPListElement elem = (IDECPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])existingPathsArray);
            if (paths != null) {
                ArrayList<IDECPListElement> result = new ArrayList<IDECPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    IPath path = paths[i2];
                    IDECPListElement elem = IDEClassPathBlock.createCPVariableElement(path);
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new IDECPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry((Shell)this.getShell(), (IPath)existing.getPath(), (IPath[])existingPathsArray);
            if (path != null) {
                return new IDECPListElement[]{IDEClassPathBlock.createCPVariableElement(path)};
            }
        }
        return null;
    }

    protected boolean containsOnlyTopLevelEntries(List selElements) {
        if (selElements.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof IDECPListElement) {
                if (((IDECPListElement)elem).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<IClasspathEntry> getEntries(String value) {
        List elements = IDEClassPathBlock.readClassPathEntry(value);
        ArrayList<IClasspathEntry> retValue = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < elements.size()) {
            retValue.add(((IDECPListElement)elements.get(i)).getClasspathEntry());
            ++i;
        }
        return retValue;
    }

    private static List readClassPathEntry(String value) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IDECPListElement> retValue = new ArrayList<IDECPListElement>();
        if (value == null || value.length() == 0) {
            return retValue;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ENTRY_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            IResource resource;
            StringTokenizer typeTokenizer;
            String entry = tokenizer.nextToken();
            if (entry == null || entry.length() == 0 || (typeTokenizer = new StringTokenizer(entry, TYPE_SEPARATOR)).countTokens() != 3) continue;
            int init = 0;
            Path path = null;
            int type = -1;
            while (typeTokenizer.hasMoreTokens()) {
                String str = typeTokenizer.nextToken();
                if (init == 1) {
                    type = Integer.parseInt(str);
                }
                if (init == 2) {
                    path = new Path(str);
                }
                ++init;
            }
            if (type == JAR_TYPE || type == 3) {
                resource = root.findMember(path);
                if (resource == null) continue;
                retValue.add(IDEClassPathBlock.newCPLibraryElement(resource));
                continue;
            }
            if (type == 1 || type == 4) {
                retValue.add(new IDECPListElement(1, (IPath)path, null));
                continue;
            }
            if (type == 2) {
                retValue.add(IDEClassPathBlock.createCPVariableElement((IPath)path));
                continue;
            }
            if (type != 5 || (resource = root.findMember((IPath)path)) == null) continue;
            retValue.add(new IDECPListElement(2, resource.getFullPath(), resource));
        }
        return retValue;
    }

    public boolean performApply() {
        String value = "";
        List list = this.fLibrariesList.getElements();
        int i = 0;
        while (i < list.size()) {
            IClasspathEntry entry;
            StringBuilder entryScript = new StringBuilder();
            IDECPListElement element = (IDECPListElement)list.get(i);
            int type = this.getType(element);
            if (type != -1 && (entry = element.getClasspathEntry()) != null) {
                entryScript.append(entry.getEntryKind());
                entryScript.append(TYPE_SEPARATOR);
                entryScript.append(type);
                entryScript.append(TYPE_SEPARATOR);
                IResource resource = element.getResource();
                IPath path = resource == null ? element.getPath() : resource.getFullPath();
                entryScript.append(path);
                if (i != list.size() - 1) {
                    entryScript.append(ENTRY_SEPARATOR);
                }
                value = String.valueOf(value) + entryScript.toString();
            }
            ++i;
        }
        this.setValue(PREF_CLASSPATH, value);
        return super.performApply();
    }

    private int getType(IDECPListElement element) {
        int kind = element.getEntryKind();
        if (kind == 4) {
            return 2;
        }
        if (kind == 2) {
            return 5;
        }
        if (kind == 1) {
            IResource resource = element.getResource();
            if (resource instanceof IFile) {
                return JAR_TYPE;
            }
            if (resource instanceof IContainer) {
                return 3;
            }
            IPath path = element.getPath();
            File file = path.toFile();
            if (file.isFile()) {
                return 1;
            }
            return 4;
        }
        return -1;
    }

    private IDECPListElement[] addProjectDialog() {
        try {
            Object[] selectArr = this.getNotYetRequiredProjects();
            new JavaElementComparator().sort(null, selectArr);
            ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ProjectLabelProvider(), Messages.getString((String)"IDEClassPathBlock.ProjectDialog_message"));
            dialog.setTitle(Messages.getString((String)"IDEClassPathBlock.ProjectDialog_title"));
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                IDECPListElement[] cpElements = new IDECPListElement[result.length];
                int i = 0;
                while (i < result.length) {
                    IJavaProject curr = (IJavaProject)result[i];
                    cpElements[i] = new IDECPListElement(2, curr.getPath(), curr.getResource());
                    ++i;
                }
                return cpElements;
            }
        }
        catch (JavaModelException e) {
            return null;
        }
        return null;
    }

    private boolean isJavaProject(IProject project) {
        try {
            return project != null && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    private Object[] getNotYetRequiredProjects() throws JavaModelException {
        ArrayList<IJavaProject> selectable = new ArrayList<IJavaProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (this.isJavaProject(projects[i])) {
                selectable.add(JavaCore.create((IProject)projects[i]));
            }
            ++i;
        }
        if (this.isJavaProject(this.getProject())) {
            selectable.remove(JavaCore.create((IProject)this.getProject()));
        }
        List elements = this.fLibrariesList.getElements();
        int i2 = 0;
        while (i2 < elements.size()) {
            IDECPListElement curr = (IDECPListElement)elements.get(i2);
            if (curr.getEntryKind() == 2) {
                IJavaProject proj = (IJavaProject)JavaCore.create((IResource)curr.getResource());
                selectable.remove(proj);
            }
            ++i2;
        }
        Object[] selectArr = selectable.toArray();
        return selectArr;
    }

    public void performDefaults() {
        this.fLibrariesList.setElements(new ArrayList());
        super.performDefaults();
    }

    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject fCurrProject) {
        this.fProject = fCurrProject;
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            IDEClassPathBlock.this.libaryPageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            IDEClassPathBlock.this.libaryPageSelectionChanged((DialogField)field);
        }

        public void doubleClicked(TreeListDialogField field) {
            IDEClassPathBlock.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            IDEClassPathBlock.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof IDECPListElement) {
                return ((IDECPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            IDEClassPathBlock.this.libaryPageDialogFieldChanged(field);
        }
    }
}

