/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;

public class SaxParserUtil {
    public static final String TEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN$-";
    public static final String ROOTTEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN_ROOT$-";
    private static final String EMPTY_STRING = "";
    private static final String FORWARD_SLASH = "/";
    private static final String DOUBLE_SLASH = "//";
    private static final String ANGLE_BRACKET = "<>";

    private SaxParserUtil() {
    }

    public static String removeRedundantParentAxis(String path) {
        if (path == null || path.equals(EMPTY_STRING) || path.indexOf("..") == -1 || path.indexOf("///") != -1) {
            return path;
        }
        String[] splits = path.replaceAll(DOUBLE_SLASH, "/<>/").split(FORWARD_SLASH);
        if (splits.length <= 1) {
            return path;
        }
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.add(splits[0]);
        int i = 1;
        while (i < splits.length) {
            if (splits[i].equals("..")) {
                if (pathElements.size() > 0) {
                    Object last = pathElements.get(pathElements.size() - 1);
                    if (last.equals(EMPTY_STRING) || last.equals("..") || last.equals(ANGLE_BRACKET)) {
                        pathElements.add(splits[i]);
                    } else {
                        pathElements.remove(pathElements.size() - 1);
                    }
                } else {
                    pathElements.add(splits[i]);
                }
            } else {
                pathElements.add(splits[i]);
            }
            ++i;
        }
        StringBuffer result = new StringBuffer(EMPTY_STRING);
        if (pathElements.get(0).equals(EMPTY_STRING) && !pathElements.get(1).equals(ANGLE_BRACKET)) {
            result.append(FORWARD_SLASH);
        } else {
            result.append(pathElements.get(0));
        }
        int i2 = 1;
        while (i2 <= pathElements.size() - 1) {
            if (pathElements.get(i2).equals(ANGLE_BRACKET)) {
                result.append(DOUBLE_SLASH);
            } else {
                result.append(FORWARD_SLASH).append(pathElements.get(i2));
            }
            ++i2;
        }
        return result.toString();
    }

    static String createTempColumnName(int index) {
        return TEMPCOLUMNNAMEPREFIX + index;
    }

    static String createTableRootTempColumnNameForFilter() {
        return ROOTTEMPCOLUMNNAMEPREFIX;
    }

    static boolean isTempColumn(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMPCOLUMNNAMEPREFIX) || name.startsWith(ROOTTEMPCOLUMNNAMEPREFIX);
    }

    static boolean isTwoValueMatch(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        return value1.equals(value2);
    }
}

