/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.editor;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.birt.report.debug.internal.ui.script.editor.ScriptEditorInputFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.IStorageEditorInput;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;

public class DebugJsInput
implements IStorageEditorInput,
IPathEditorInput,
IPersistableElement {
    private static final String ERRORMSG = "There is no script available.";
    private ModuleHandle handle;
    private File storage;
    private String id;

    public DebugJsInput(File storage, String id) {
        this.storage = storage;
        this.id = id;
    }

    public IStorage getStorage() throws CoreException {
        return new ScriptStorage();
    }

    public boolean exists() {
        return this.storage.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.storage.getAbsolutePath();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath() {
        return new Path(this.storage.getAbsolutePath());
    }

    public String getFactoryId() {
        return "org.eclipse.birt.report.debug.ui.script.ScriptEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        ScriptEditorInputFactory.saveState(memento, this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public File getFile() {
        return this.storage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DebugJsInput) {
            return ((DebugJsInput)obj).id.equals(this.id) && ((DebugJsInput)obj).storage.getAbsolutePath().equals(this.storage.getAbsolutePath());
        }
        return super.equals(obj);
    }

    public ModuleHandle getModuleHandle() {
        if (this.handle == null) {
            try {
                this.handle = this.getSessionHandle().openModule(this.getFile().getAbsolutePath(), (InputStream)new FileInputStream(this.getFile()));
            }
            catch (FileNotFoundException | DesignFileException throwable) {
                // empty catch block
            }
        }
        return this.handle;
    }

    private SessionHandle getSessionHandle() {
        return new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
    }

    private String getDisplayText() {
        String str = ModuleUtil.getScript((ModuleHandle)this.getModuleHandle(), (String)this.getId());
        if (str == null) {
            str = ERRORMSG;
        }
        return str;
    }

    public boolean sourceAvailable() {
        return !ERRORMSG.equals(this.getDisplayText());
    }

    private class ScriptStorage
    implements IStorage {
        private ScriptStorage() {
        }

        public InputStream getContents() throws CoreException {
            String str = DebugJsInput.this.getDisplayText();
            ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
            return input;
        }

        public IPath getFullPath() {
            return DebugJsInput.this.getPath();
        }

        public String getName() {
            return DebugJsInput.this.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return DebugJsInput.this.getAdapter(adapter);
        }
    }
}

