/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.querymodel.ClassColumnMappings;
import org.eclipse.birt.data.oda.pojo.querymodel.Column;
import org.eclipse.birt.data.oda.pojo.querymodel.ConstantParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.FieldSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.OneColumnMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PojoQueryParser {
    private PojoQueryParser() {
    }

    public static PojoQuery parse(String query) throws OdaException {
        if (query == null) {
            throw new NullPointerException("query is null");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(query.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OdaException((Throwable)new Exception(Messages.getString("Query.FailedToParse", query), e));
        }
        try {
            builder = dbf.newDocumentBuilder();
            doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            if (root == null) {
                throw new OdaException(Messages.getString("Query.FailedToParse", query));
            }
            String version = root.getAttribute("version");
            String dataSetClass = root.getAttribute("dataSetClass");
            String appContextKey = root.getAttribute("appContextKey");
            PojoQuery pojoQuery = new PojoQuery(version, dataSetClass, appContextKey);
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    Element mapping = (Element)child;
                    if ("ColumnMapping".equals(mapping.getTagName())) {
                        pojoQuery.addColumnsMapping(PojoQueryParser.createOneColumnMapping(mapping));
                    } else if ("ClassColumnMappings".equals(mapping.getTagName())) {
                        pojoQuery.addColumnsMapping(PojoQueryParser.createClassColumnsMapping(mapping));
                    }
                }
                ++i;
            }
            PojoQuery pojoQuery2 = pojoQuery;
            return pojoQuery2;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OdaException((Throwable)new Exception(Messages.getString("Query.FailedToParse", query), e));
        }
        finally {
            doc = null;
            builder = null;
            dbf = null;
        }
    }

    private static IColumnsMapping createOneColumnMapping(Element e) throws OdaException {
        assert (e != null);
        Column column = PojoQueryParser.createColumn(e);
        IMappingSource source = PojoQueryParser.createMappingSource(e);
        return new OneColumnMapping(source, column);
    }

    private static IColumnsMapping createClassColumnsMapping(Element e) throws OdaException {
        assert (e != null);
        IMappingSource source = PojoQueryParser.createMappingSource(e);
        ClassColumnMappings ccm = new ClassColumnMappings(source);
        NodeList children = e.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element mapping = (Element)child;
                if ("ColumnMapping".equals(mapping.getTagName())) {
                    ccm.addColumnsMapping(PojoQueryParser.createOneColumnMapping(mapping));
                } else if ("ClassColumnMappings".equals(mapping.getTagName())) {
                    ccm.addColumnsMapping(PojoQueryParser.createClassColumnsMapping(mapping));
                }
            }
            ++i;
        }
        return ccm;
    }

    private static Element getFirstSubElementByTag(Element e, String tagName) {
        assert (e != null && tagName != null);
        NodeList list = e.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String name;
            if (list.item(i) instanceof Element && tagName.equals(name = ((Element)list.item(i)).getTagName())) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    private static Element getMethodElement(Element e) {
        assert (e != null);
        return PojoQueryParser.getFirstSubElementByTag(e, "Method");
    }

    private static Element getFieldElement(Element e) {
        assert (e != null);
        return PojoQueryParser.getFirstSubElementByTag(e, "Field");
    }

    private static IMappingSource createMethodSource(Element method) throws OdaException {
        assert (method != null);
        String methodName = method.getAttribute("name");
        if (methodName == null || methodName.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "name", "Method"));
        }
        return new MethodSource(methodName, PojoQueryParser.createParameters(method));
    }

    private static IMethodParameter[] createParameters(Element method) throws OdaException {
        assert (method != null);
        ArrayList<IMethodParameter> result = new ArrayList<IMethodParameter>();
        NodeList children = method.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element param = (Element)child;
                if ("ConstantParameter".equals(param.getTagName())) {
                    result.add(PojoQueryParser.createConstantParameter(param));
                } else if ("VariableParameter".equals(param.getTagName())) {
                    result.add(PojoQueryParser.createVariableParameter(param));
                }
            }
            ++i;
        }
        return result.toArray(new IMethodParameter[0]);
    }

    private static ConstantParameter createConstantParameter(Element e) throws OdaException {
        String type;
        assert (e != null);
        String value = e.getAttribute("value");
        if (e.getAttributeNode("value") == null) {
            value = null;
        }
        if ((type = e.getAttribute("type")) == null || type.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "type", "ConstantParameter"));
        }
        return new ConstantParameter(value, type);
    }

    private static VariableParameter createVariableParameter(Element e) throws OdaException {
        assert (e != null);
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "name", "ColumnMapping"));
        }
        String type = e.getAttribute("type");
        if (type == null || type.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "type", "VariableParameter"));
        }
        VariableParameter vp = new VariableParameter(name, type);
        String value = e.getAttribute("value");
        if (value != null) {
            vp.setStringValue(value);
        }
        return vp;
    }

    private static IMappingSource createFieldSource(Element field) throws OdaException {
        assert (field != null);
        String fieldName = field.getAttribute("name");
        if (fieldName == null || fieldName.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "name", "Field"));
        }
        return new FieldSource(fieldName);
    }

    private static IMappingSource createMappingSource(Element e) throws OdaException {
        assert (e != null);
        Element method = PojoQueryParser.getMethodElement(e);
        if (method != null) {
            return PojoQueryParser.createMethodSource(method);
        }
        Element field = PojoQueryParser.getFieldElement(e);
        if (field != null) {
            return PojoQueryParser.createFieldSource(field);
        }
        throw new OdaException(Messages.getString("Query.Miss2Elements", "Method", "Field", e.getTagName()));
    }

    private static Column createColumn(Element e) throws OdaException {
        assert (e != null);
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "name", "ColumnMapping"));
        }
        String odaType = e.getAttribute("odaDataType");
        if (odaType == null || odaType.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "odaDataType", "ColumnMapping"));
        }
        String index = e.getAttribute("index");
        if (index == null || index.length() == 0) {
            throw new OdaException(Messages.getString("Query.MissAttributeInElement", "index", "ColumnMapping"));
        }
        int i = Integer.parseInt(index.trim());
        return new Column(name, odaType, i);
    }
}

