/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.aggregation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.aggregation.ArgumentInfo;
import org.eclipse.birt.report.designer.data.ui.aggregation.ArgumentInfoList;
import org.eclipse.birt.report.designer.data.ui.aggregation.MethodInfo;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class AggregationUtil {
    private static final String AGGREGATION_CATEGORY = "total";
    private static final String AGGREGATION_EXT_POINT = "org.eclipse.birt.data.aggregation";
    private static final String BLANK = " ";
    private static final String DEFUALT_RETURN_TYPE = "number";
    private static final String AGGREGATION_ATTR_NAME = "name";
    private static final String UIINFO_ATTR_TIP = "tip";
    private static final String UIINFO_ATTR_TEXTDATA = "textData";
    private static final String UIINFO_ATTR_PARAMTERMETAINFO = "parameterMetaInfo";
    private static final String REGULAR_EXPR_DELIMITER_COMMA = "[,]";

    public static List getMethods(IClassInfo classInfo) {
        if (!classInfo.getName().equalsIgnoreCase(AGGREGATION_CATEGORY)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MethodInfo> methodList = new ArrayList<MethodInfo>();
        IConfigurationElement[] aggregations = Platform.getExtensionRegistry().getConfigurationElementsFor(AGGREGATION_EXT_POINT);
        int i = 0;
        while (i < aggregations.length) {
            IConfigurationElement[] aggs = aggregations[i].getChildren();
            int j = 0;
            while (j < aggs.length) {
                IConfigurationElement[] uiInfos = aggs[j].getChildren();
                int k = 0;
                while (k < uiInfos.length) {
                    MethodInfo methodInfo = new MethodInfo(false);
                    methodInfo.setName(aggs[j].getAttribute(AGGREGATION_ATTR_NAME));
                    methodInfo.setDisplayNameKey(uiInfos[k].getAttribute(UIINFO_ATTR_TEXTDATA));
                    methodInfo.setToolTipKey(uiInfos[k].getAttribute(UIINFO_ATTR_TIP));
                    methodInfo.addArgumentList(AggregationUtil.loadArgumentList(uiInfos[k].getAttribute(UIINFO_ATTR_PARAMTERMETAINFO)));
                    methodInfo.setStatic(true);
                    methodInfo.setReturnType(DEFUALT_RETURN_TYPE);
                    methodList.add(methodInfo);
                    ++k;
                }
                Collections.sort(methodList, new AlphabeticallyComparator());
                ++j;
            }
            ++i;
        }
        return methodList;
    }

    private static ArgumentInfoList loadArgumentList(String metaInfo) {
        ArgumentInfoList argList = new ArgumentInfoList();
        if (metaInfo == null) {
            return argList;
        }
        String[] args = metaInfo.split(REGULAR_EXPR_DELIMITER_COMMA);
        if (!AggregationUtil.isValid(args)) {
            return argList;
        }
        int i = 0;
        while (i < args.length) {
            ArgumentInfo arg = new ArgumentInfo();
            String type = args[i].substring(0, args[i].indexOf(BLANK));
            String name = args[i].substring(args[i].indexOf(BLANK) + 1);
            arg.setDisplayNameKey(name);
            arg.setName(name);
            arg.setType(type);
            argList.addArgument((IArgumentInfo)arg);
            ++i;
        }
        return argList;
    }

    private static boolean isValid(String[] args) {
        int i = 0;
        while (i < args.length) {
            args[i] = args[i].trim();
            if (args[i].indexOf(BLANK) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

