/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.impl.FunctionProvider;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.aggregation.AggregationUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.IIndexInfo;
import org.eclipse.birt.report.designer.internal.ui.views.memento.Memento;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.expressions.IContextExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;

public class ExpressionTreeSupport
implements ISelectionChangedListener {
    private static final Image IMAGE_FOLDER = ReportPlatformUIImages.getImage("IMG_OBJ_FOLDER");
    private static final Image IMAGE_OPERATOR = ExpressionTreeSupport.getIconImage("Operator");
    private static final Image IMAGE_GOLBAL = ExpressionTreeSupport.getIconImage("Global");
    private static final Image IMAGE_METHOD = ExpressionTreeSupport.getIconImage("Method");
    private static final Image IMAGE_STATIC_METHOD = ExpressionTreeSupport.getIconImage("Static Method");
    private static final Image IMAGE_CONSTRUCTOR = ExpressionTreeSupport.getIconImage("Constructor");
    private static final Image IMAGE_MEMBER = ExpressionTreeSupport.getIconImage("Member");
    private static final Image IMAGE_STATIC_MEMBER = ExpressionTreeSupport.getIconImage("Static Member");
    private static final String[][] OPERATORS_ASSIGNMENT = new String[][]{{"=", Messages.getString((String)"ExpressionProvider.Operator.Assign")}, {"+=", Messages.getString((String)"ExpressionProvider.Operator.AddTo")}, {"-=", Messages.getString((String)"ExpressionProvider.Operator.SubFrom")}, {"*=", Messages.getString((String)"ExpressionProvider.Operator.MultTo")}, {"/=", Messages.getString((String)"ExpressionProvider.Operator.DividingFrom")}};
    private static final String[][] OPERATORS_COMPARISON = new String[][]{{"==", Messages.getString((String)"ExpressionProvider.Operator.Equals")}, {"<", Messages.getString((String)"ExpressionProvider.Operator.Less")}, {"<=", Messages.getString((String)"ExpressionProvider.Operator.LessEqual")}, {"!=", Messages.getString((String)"ExpressionProvider.Operator.NotEqual")}, {">", Messages.getString((String)"ExpressionProvider.Operator.Greater")}, {">=", Messages.getString((String)"ExpressionProvider.Operator.GreaterEquals")}};
    private static final String[][] OPERATORS_COMPUTATIONAL = new String[][]{{"+", Messages.getString((String)"ExpressionProvider.Operator.Add")}, {"-", Messages.getString((String)"ExpressionProvider.Operator.Sub")}, {"*", Messages.getString((String)"ExpressionProvider.Operator.Mult")}, {"/", Messages.getString((String)"ExpressionProvider.Operator.Divides")}, {"++X ", Messages.getString((String)"ExpressionProvider.Operator.Inc")}, {"X++ ", Messages.getString((String)"ExpressionProvider.Operator.ReturnInc")}, {"--X ", Messages.getString((String)"ExpressionProvider.Operator.Dec")}, {"X-- ", Messages.getString((String)"ExpressionProvider.Operator.ReturnDec")}};
    private static final String[][] OPERATORS_LOGICAL = new String[][]{{"&&", Messages.getString((String)"ExpressionProvider.Operator.And")}, {"||", Messages.getString((String)"ExpressionProvider.Operator.Or")}};
    private static final String TREE_ITEM_CONTEXT = Messages.getString((String)"ExpressionProvider.Category.Context");
    private static final String TREE_ITEM_OPERATORS = Messages.getString((String)"ExpressionProvider.Category.Operators");
    private static final String TREE_ITEM_BIRT_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.BirtObjects");
    private static final String TREE_ITEM_PARAMETERS = Messages.getString((String)"ExpressionProvider.Category.Parameters");
    private static final String TREE_ITEM_NATIVE_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.NativeObjects");
    private static final String TREE_ITEM_VARIABLES = Messages.getString((String)"ExpressionProvider.Category.Variables");
    private static final String TREE_ITEM_LOGICAL = Messages.getString((String)"ExpressionProvider.Operators.Logical");
    private static final String TREE_ITEM_COMPUTATIONAL = Messages.getString((String)"ExpressionProvider.Operators.Computational");
    private static final String TREE_ITEM_COMPARISON = Messages.getString((String)"ExpressionProvider.Operators.Comparison");
    private static final String TREE_ITEM_ASSIGNMENT = Messages.getString((String)"ExpressionProvider.Operators.Assignment");
    protected static final String ITEM_DATA_KEY_TOOLTIP = "TOOL_TIP";
    protected static final String ITEM_DATA_KEY_TEXT = "TEXT";
    protected static final String ITEM_DATA_KEY_ENABLED = "ENABLED";
    private static final String OBJECTS_TYPE_NATIVE = "native";
    private static final String OBJECTS_TYPE_BIRT = "birt";
    private SourceViewer expressionViewer;
    private Tree tree;
    private DropTarget dropTarget;
    private DropTargetAdapter dropTargetAdapter;
    private Object currentEditObject;
    private String currentMethodName;
    private TreeItem contextItem;
    private TreeItem parametersItem;
    private TreeItem nativeObejctsItem;
    private TreeItem birtObjectsItem;
    private TreeItem operatorsItem;
    private TreeItem variablesItem;
    private List<TreeItem> dynamicItems;
    private List staticFilters;
    private MementoBuilder builder = new MementoBuilder();
    private Memento viewerMemento;
    private int eventFireNum = 0;
    private int execNum = 0;

    public void createDefaultExpressionTree() {
        this.createFilteredExpressionTree(null);
    }

    public void createFilteredExpressionTree(List filterList) {
        this.staticFilters = filterList;
        this.createExpressionTree();
    }

    public String getElementType() {
        if (this.currentEditObject == null) {
            return null;
        }
        String displayName = ((DesignElementHandle)this.currentEditObject).getDefn().getDisplayName();
        if (displayName == null || "".equals(displayName)) {
            displayName = ((DesignElementHandle)this.currentEditObject).getDefn().getName();
        }
        return displayName;
    }

    private void createExpressionTree() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        ArrayList<IExpressionProvider> dynamicContextProviders = null;
        ArrayList<ExpressionFilter> dynamicFilters = null;
        if (this.currentEditObject != null && this.currentMethodName != null) {
            Object[] adapters;
            IMemento memento;
            if (this.viewerMemento != null && (memento = this.viewerMemento.getChild(this.getElementType())) == null) {
                Memento elementMemento = (Memento)this.viewerMemento.createChild(this.getElementType(), "Element");
                elementMemento.getMementoElement().setValue(this.getElementType());
            }
            if ((adapters = ElementAdapterManager.getAdapters(this.currentEditObject, IContextExpressionProvider.class)) != null) {
                Object[] objectArray = adapters;
                int n = adapters.length;
                int n2 = 0;
                while (n2 < n) {
                    Object adapt = objectArray[n2];
                    IContextExpressionProvider contextProvider = (IContextExpressionProvider)adapt;
                    if (contextProvider != null) {
                        ExpressionFilter exprFilter;
                        IExpressionProvider exprProvider = contextProvider.getExpressionProvider(this.currentMethodName);
                        if (exprProvider != null) {
                            if (dynamicContextProviders == null) {
                                dynamicContextProviders = new ArrayList<IExpressionProvider>();
                            }
                            dynamicContextProviders.add(exprProvider);
                        }
                        if ((exprFilter = contextProvider.getExpressionFilter(this.currentMethodName)) != null) {
                            if (dynamicFilters == null) {
                                dynamicFilters = new ArrayList<ExpressionFilter>();
                            }
                            dynamicFilters.add(exprFilter);
                        }
                    }
                    ++n2;
                }
            }
        }
        ArrayList<ExpressionFilter> filters = null;
        if (this.staticFilters != null && dynamicFilters != null) {
            filters = new ArrayList<ExpressionFilter>(this.staticFilters);
            filters.addAll(dynamicFilters);
        } else if (this.staticFilters != null) {
            filters = this.staticFilters;
        } else if (dynamicFilters != null) {
            filters = dynamicFilters;
        }
        boolean hasContext = false;
        boolean hasParameters = false;
        boolean hasVariables = false;
        boolean hasNativeObjects = false;
        boolean hasBirtObjects = false;
        boolean hasOperators = false;
        if (this.filter("Category", "Context", filters)) {
            hasContext = true;
            this.clearSubTreeItem(this.contextItem);
            this.createContextCatagory();
        }
        if (this.filter("Category", "Parameters", filters)) {
            hasParameters = true;
            if (this.parametersItem == null || this.parametersItem.isDisposed()) {
                this.createParamtersCategory();
            }
        }
        if (this.filter("Category", "Variables", filters)) {
            hasVariables = true;
            this.createVariablesCategory();
        }
        if (this.filter("Category", "Native Objects", filters)) {
            hasNativeObjects = true;
            if (this.nativeObejctsItem == null || this.nativeObejctsItem.isDisposed()) {
                this.createNativeObjectsCategory();
            }
        }
        if (this.filter("Category", "Birt Objects", filters)) {
            hasBirtObjects = true;
            if (this.birtObjectsItem == null || this.birtObjectsItem.isDisposed()) {
                this.createBirtObjectsCategory();
            }
        }
        if (this.filter("Category", "Operators", filters)) {
            hasOperators = true;
            if (this.operatorsItem == null || this.operatorsItem.isDisposed()) {
                this.createOperatorsCategory();
            }
        }
        if (!hasContext) {
            this.clearTreeItem(this.contextItem);
        }
        if (!hasParameters) {
            this.clearTreeItem(this.parametersItem);
        }
        if (!hasVariables) {
            this.clearTreeItem(this.variablesItem);
        }
        if (!hasNativeObjects) {
            this.clearTreeItem(this.nativeObejctsItem);
        }
        if (!hasBirtObjects) {
            this.clearTreeItem(this.birtObjectsItem);
        }
        if (!hasOperators) {
            this.clearTreeItem(this.operatorsItem);
        }
        this.clearDynamicItems();
        if (dynamicContextProviders != null) {
            this.updateDynamicItems(dynamicContextProviders);
        }
        this.restoreSelection();
    }

    protected void saveSelection(TreeItem selection) {
        Memento memento = (Memento)this.viewerMemento.getChild(this.getElementType());
        if (memento == null) {
            return;
        }
        MementoElement[] selectPath = this.createItemPath(selection);
        memento.getMementoElement().setAttribute("Selected", selectPath);
    }

    protected MementoElement[] createItemPath(TreeItem item) {
        MementoElement tempMemento = null;
        block0: while (item.getParentItem() != null) {
            TreeItem parent = item.getParentItem();
            int i = 0;
            while (i < parent.getItemCount()) {
                if (parent.getItem(i) == item) {
                    MementoElement memento = new MementoElement(item.getText(), item.getText(), "Element");
                    if (tempMemento != null) {
                        memento.addChild(tempMemento);
                    }
                    tempMemento = memento;
                    item = parent;
                    continue block0;
                }
                ++i;
            }
        }
        MementoElement memento = new MementoElement(item.getText(), item.getText(), "Element");
        if (tempMemento != null) {
            memento.addChild(tempMemento);
        }
        return this.getNodePath(memento);
    }

    public MementoElement[] getNodePath(MementoElement node) {
        ArrayList<MementoElement> pathList = new ArrayList<MementoElement>();
        MementoElement memento = node;
        pathList.add(node);
        while (memento.getChildren().length > 0) {
            pathList.add(memento.getChild(0));
            memento = memento.getChild(0);
        }
        MementoElement[] paths = new MementoElement[pathList.size()];
        pathList.toArray(paths);
        return paths;
    }

    private void restoreSelection() {
        Memento memento = (Memento)this.viewerMemento.getChild(this.getElementType());
        if (memento == null) {
            return;
        }
        this.expandTreeFromMemento(memento);
        Object obj = memento.getMementoElement().getAttribute("Selected");
        if (obj != null) {
            int i = 0;
            while (i < this.tree.getItemCount()) {
                this.restoreSelectedMemento(this.tree.getItem(i), (MementoElement[])obj);
                ++i;
            }
        }
    }

    private void restoreSelectedMemento(TreeItem root, MementoElement[] selectedPath) {
        if (selectedPath.length <= 0) {
            return;
        }
        int i = 0;
        while (i < selectedPath.length) {
            MementoElement element = selectedPath[i];
            if (!root.getText().equals(element.getValue())) {
                boolean flag = false;
                int j = 0;
                while (j < root.getItemCount()) {
                    if (root.getItem(j).getText().equals(element.getValue())) {
                        root = root.getItem(j);
                        flag = true;
                        break;
                    }
                    ++j;
                }
                if (!flag) {
                    return;
                }
            }
            ++i;
        }
        this.tree.setSelection(root);
    }

    private boolean filter(Object parent, Object child, List<ExpressionFilter> filters) {
        if (filters == null) {
            return true;
        }
        for (ExpressionFilter ft : filters) {
            if (ft == null || ft.select(parent, child)) continue;
            return false;
        }
        return true;
    }

    protected void createOperatorsCategory() {
        assert (this.tree != null);
        int idx = this.getIndex(this.birtObjectsItem, this.nativeObejctsItem, this.parametersItem, this.contextItem);
        this.operatorsItem = this.createTopTreeItem(this.tree, TREE_ITEM_OPERATORS, idx);
        TreeItem subItem = this.createSubFolderItem(this.operatorsItem, TREE_ITEM_ASSIGNMENT);
        this.createSubTreeItems(subItem, OPERATORS_ASSIGNMENT, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(this.operatorsItem, TREE_ITEM_COMPARISON);
        this.createSubTreeItems(subItem, OPERATORS_COMPARISON, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(this.operatorsItem, TREE_ITEM_COMPUTATIONAL);
        this.createSubTreeItems(subItem, OPERATORS_COMPUTATIONAL, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(this.operatorsItem, TREE_ITEM_LOGICAL);
        this.createSubTreeItems(subItem, OPERATORS_LOGICAL, IMAGE_OPERATOR);
    }

    protected void createNativeObjectsCategory() {
        assert (this.tree != null);
        int idx = this.getIndex(this.parametersItem, this.contextItem);
        this.nativeObejctsItem = this.createTopTreeItem(this.tree, TREE_ITEM_NATIVE_OBJECTS, idx);
        this.createObjects(this.nativeObejctsItem, OBJECTS_TYPE_NATIVE);
    }

    protected void createParamtersCategory() {
        assert (this.tree != null);
        int idx = this.getIndex(this.contextItem);
        this.parametersItem = this.createTopTreeItem(this.tree, TREE_ITEM_PARAMETERS, idx);
        this.buildParameterTree();
    }

    private void buildParameterTree() {
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (module == null) {
            return;
        }
        for (ReportElementHandle handle : module.getParameters()) {
            if (handle instanceof ParameterHandle) {
                this.createSubTreeItem(this.parametersItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), DEUtil.getExpression((Object)handle), ((ParameterHandle)handle).getHelpText(), true);
                continue;
            }
            if (!(handle instanceof ParameterGroupHandle)) continue;
            TreeItem groupItem = this.createSubTreeItem(this.parametersItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), true);
            for (ParameterHandle parameter : ((ParameterGroupHandle)handle).getParameters()) {
                this.createSubTreeItem(groupItem, parameter.getDisplayLabel(), ReportPlatformUIImages.getImage(handle), DEUtil.getExpression((Object)parameter), parameter.getDisplayLabel(), true);
            }
        }
    }

    protected void createVariablesCategory() {
        if (this.variablesItem == null || this.variablesItem.isDisposed()) {
            int idx = this.getIndex(this.contextItem);
            this.variablesItem = this.createTopTreeItem(this.tree, TREE_ITEM_VARIABLES, idx);
        }
        this.buildVariableTree();
    }

    private void buildVariableTree() {
        this.clearSubTreeItem(this.variablesItem);
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (handle instanceof ReportDesignHandle) {
            for (VariableElementHandle variableHandle : ((ReportDesignHandle)handle).getPageVariables()) {
                if (this.currentMethodName != null && "page".equals(variableHandle.getType()) && !this.currentMethodName.equals("onPageStart") && !this.currentMethodName.equals("onPageEnd") && !this.currentMethodName.equals("onRender")) continue;
                this.createSubTreeItem(this.variablesItem, DEUtil.getDisplayLabel((Object)variableHandle, (boolean)false), ReportPlatformUIImages.getImage(variableHandle), DEUtil.getExpression((Object)variableHandle), variableHandle.getDisplayLabel(), true);
            }
        }
        this.restoreSelection();
    }

    protected void createBirtObjectsCategory() {
        assert (this.tree != null);
        int idx = this.getIndex(this.nativeObejctsItem, this.parametersItem, this.contextItem);
        this.birtObjectsItem = this.createTopTreeItem(this.tree, TREE_ITEM_BIRT_OBJECTS, idx);
        this.createObjects(this.birtObjectsItem, OBJECTS_TYPE_BIRT);
    }

    private TreeItem createTopTreeItem(Tree parent, String text, int index) {
        TreeItem item = new TreeItem(parent, 0, index);
        item.setText(text);
        item.setImage(IMAGE_FOLDER);
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)"");
        return item;
    }

    private TreeItem createSubTreeItem(TreeItem parent, String text, Image image, boolean isEnabled) {
        return this.createSubTreeItem(parent, text, image, null, text, isEnabled);
    }

    private TreeItem createSubTreeItem(TreeItem parent, String text, Image image, String textData, String toolTip, boolean isEnabled) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        if (image != null) {
            item.setImage(image);
        }
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)toolTip);
        item.setData(ITEM_DATA_KEY_TEXT, (Object)textData);
        item.setData(ITEM_DATA_KEY_ENABLED, (Object)isEnabled);
        return item;
    }

    private TreeItem createSubFolderItem(TreeItem parent, String text) {
        return this.createSubTreeItem(parent, text, IMAGE_FOLDER, true);
    }

    private TreeItem createSubFolderItem(TreeItem parent, IClassInfo classInfo) {
        return this.createSubTreeItem(parent, classInfo.getDisplayName(), IMAGE_FOLDER, null, classInfo.getToolTip(), true);
    }

    private TreeItem createSubFolderItem(TreeItem parent, IScriptFunctionCategory category) {
        String categoreName = this.getCategoryDisplayName(category);
        return this.createSubTreeItem(parent, categoreName, IMAGE_FOLDER, null, category.getDescription(), true);
    }

    private String getCategoryDisplayName(IScriptFunctionCategory category) {
        return category.getName() == null ? Messages.getString((String)"ExpressionTreeSupport.Category.Global") : category.getName();
    }

    private void createSubTreeItems(TreeItem parent, String[][] texts, Image image) {
        int i = 0;
        while (i < texts.length) {
            this.createSubTreeItem(parent, texts[i][0], image, texts[i][0], texts[i][1], true);
            ++i;
        }
    }

    public void addMouseTrackListener() {
        assert (this.tree != null);
        this.tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == ExpressionTreeSupport.this.tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = ExpressionTreeSupport.this.tree.getItem(pt);
                    if (item == null) {
                        ExpressionTreeSupport.this.tree.setToolTipText("");
                    } else {
                        String text = (String)item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_TOOLTIP);
                        ExpressionTreeSupport.this.tree.setToolTipText(text);
                    }
                }
            }
        });
    }

    public void addMouseListener() {
        assert (this.tree != null);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeItem[] selection = ExpressionTreeSupport.this.getTreeSelection();
                if (selection == null || selection.length <= 0) {
                    return;
                }
                TreeItem item = selection[0];
                if (item != null) {
                    Object obj = item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT);
                    Boolean isEnabled = (Boolean)item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_ENABLED);
                    if (obj != null && isEnabled.booleanValue()) {
                        String text = (String)obj;
                        ExpressionTreeSupport.this.insertText(text);
                    }
                }
            }
        });
    }

    protected TreeItem[] getTreeSelection() {
        return this.tree.getSelection();
    }

    public void addDragSupportToTree() {
        assert (this.tree != null);
        DragSource dragSource = new DragSource((Control)this.tree, 3);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = ExpressionTreeSupport.this.tree.getSelection();
                if (selection.length <= 0 || selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT) == null || !((Boolean)selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_ENABLED)).booleanValue()) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem[] selection;
                if (TextTransfer.getInstance().isSupportedType(event.dataType) && (selection = ExpressionTreeSupport.this.tree.getSelection()).length > 0) {
                    event.data = selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT);
                }
            }
        });
    }

    protected void insertText(String text) {
        StyledText textWidget = this.expressionViewer.getTextWidget();
        if (!textWidget.isEnabled()) {
            return;
        }
        int selectionStart = textWidget.getSelection().x;
        if (text.equalsIgnoreCase("x++")) {
            text = String.valueOf(textWidget.getSelectionText()) + "++";
        } else if (text.equalsIgnoreCase("x--")) {
            text = String.valueOf(textWidget.getSelectionText()) + "--";
        } else if (text.equalsIgnoreCase("++x")) {
            text = "++" + textWidget.getSelectionText();
        } else if (text.equalsIgnoreCase("--x")) {
            text = "--" + textWidget.getSelectionText();
        }
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
        if (text.endsWith("()")) {
            textWidget.setCaretOffset(textWidget.getCaretOffset() - 1);
        }
    }

    public void addDropSupportToViewer() {
        assert (this.expressionViewer != null);
        if (this.dropTarget == null || this.dropTarget.isDisposed()) {
            final StyledText text = this.expressionViewer.getTextWidget();
            if (text.getData("DropTarget") != null) {
                return;
            }
            this.dropTarget = new DropTarget((Control)text, 17);
            this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            this.dropTargetAdapter = new DropTargetAdapter(){

                public void dragEnter(DropTargetEvent event) {
                    text.setFocus();
                    if (event.detail == 16) {
                        event.detail = 1;
                    }
                    if (event.detail != 1) {
                        event.detail = 0;
                    }
                }

                public void dragOver(DropTargetEvent event) {
                    event.feedback = 10;
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    this.dragEnter(event);
                }

                public void drop(DropTargetEvent event) {
                    if (event.data instanceof String) {
                        ExpressionTreeSupport.this.insertText((String)event.data);
                    }
                }
            };
            this.dropTarget.addDropListener((DropTargetListener)this.dropTargetAdapter);
        }
    }

    public void removeDropSupportToViewer() {
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            if (this.dropTargetAdapter != null) {
                this.dropTarget.removeDropListener((DropTargetListener)this.dropTargetAdapter);
                this.dropTargetAdapter = null;
            }
            this.dropTarget.dispose();
            this.dropTarget = null;
        }
    }

    public void setTree(final Tree tree) {
        this.tree = tree;
        this.viewerMemento = (Memento)this.builder.getRootMemento().getChild("ExpressionTreeSupport");
        if (this.viewerMemento == null) {
            this.viewerMemento = (Memento)this.builder.getRootMemento().createChild("ExpressionTreeSupport", "Viewer");
        }
        SelectionAdapter treeSelectionListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExpressionTreeSupport.this.saveSelection((TreeItem)e.item);
            }
        };
        tree.addSelectionListener((SelectionListener)treeSelectionListener);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TreeItem item = tree.getItem(pt);
                if (item != null) {
                    ExpressionTreeSupport.this.saveSelection(item);
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (tree.getSelectionCount() > 0) {
                    ExpressionTreeSupport.this.saveSelection(tree.getSelection()[0]);
                }
            }
        });
        TreeListener treeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                if (e.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)e.item;
                    MementoElement[] path = ExpressionTreeSupport.this.createItemPath(item);
                    ExpressionTreeSupport.this.removeNode((Memento)ExpressionTreeSupport.this.viewerMemento.getChild(ExpressionTreeSupport.this.getElementType()), path);
                    ExpressionTreeSupport.this.getTree().setSelection(item);
                    ExpressionTreeSupport.this.saveSelection(item);
                }
            }

            public void treeExpanded(TreeEvent e) {
                if (e.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)e.item;
                    MementoElement[] path = ExpressionTreeSupport.this.createItemPath(item);
                    ExpressionTreeSupport.this.addNode((Memento)ExpressionTreeSupport.this.viewerMemento.getChild(ExpressionTreeSupport.this.getElementType()), path);
                    ExpressionTreeSupport.this.getTree().setSelection(item);
                    ExpressionTreeSupport.this.saveSelection(item);
                }
            }
        };
        tree.addTreeListener(treeListener);
    }

    public boolean addNode(Memento element, MementoElement[] nodePath) {
        if (element == null) {
            return false;
        }
        if (nodePath != null && nodePath.length > 0) {
            MementoElement memento = element.getMementoElement();
            int i = 0;
            while (i < nodePath.length) {
                MementoElement child = this.getChild(memento, nodePath[i]);
                if (child == null) {
                    memento.addChild(nodePath[i]);
                    return true;
                }
                memento = child;
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean removeNode(Memento element, MementoElement[] nodePath) {
        if (element == null) {
            return false;
        }
        if (nodePath != null && nodePath.length > 0) {
            MementoElement memento = element.getMementoElement();
            int i = 0;
            while (i < nodePath.length) {
                MementoElement child = this.getChild(memento, nodePath[i]);
                if (child == null) {
                    return false;
                }
                memento = child;
                ++i;
            }
            memento.getParent().removeChild(memento);
            return true;
        }
        return false;
    }

    private void expandTreeFromMemento(Memento memento) {
        if (this.tree.getItemCount() == 0 || memento == null) {
            return;
        }
        int i = 0;
        while (i < this.tree.getItemCount()) {
            TreeItem root = this.tree.getItem(i);
            int j = 0;
            while (j < memento.getMementoElement().getChildren().length) {
                MementoElement child = memento.getMementoElement().getChildren()[j];
                this.restoreExpandedMemento(root, child);
                ++j;
            }
            ++i;
        }
    }

    private void restoreExpandedMemento(TreeItem root, MementoElement memento) {
        if (memento.getKey().equals(root.getText()) && root.getItemCount() > 0) {
            if (!root.getExpanded()) {
                root.setExpanded(true);
            }
            MementoElement[] children = memento.getChildren();
            int i = 0;
            while (i < children.length) {
                MementoElement child = children[i];
                String key = child.getValue().toString();
                int j = 0;
                while (j < root.getItemCount()) {
                    TreeItem item = root.getItem(j);
                    if (item.getText().equals(key)) {
                        this.restoreExpandedMemento(item, child);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private MementoElement getChild(MementoElement parent, MementoElement key) {
        MementoElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(key)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    protected Tree getTree() {
        return this.tree;
    }

    public void setExpressionViewer(SourceViewer expressionViewer) {
        this.expressionViewer = expressionViewer;
    }

    protected SourceViewer getExpressionViewer() {
        return this.expressionViewer;
    }

    private static Image getIconImage(String id) {
        return ReportPlatformUIImages.getImage(id);
    }

    private void createObjects(TreeItem topItem, String objectType) {
        TreeItem subItem;
        for (IClassInfo classInfo : DEUtil.getClasses()) {
            if (classInfo.isNative() && OBJECTS_TYPE_BIRT.equals(objectType) || !classInfo.isNative() && OBJECTS_TYPE_NATIVE.equals(objectType) || classInfo.getName().equals("Total")) continue;
            subItem = this.createSubFolderItem(topItem, classInfo);
            Image globalImage = null;
            if (this.isGlobal(classInfo.getName())) {
                globalImage = IMAGE_GOLBAL;
            }
            ArrayList<ILocalizableInfo[]> childrenList = new ArrayList<ILocalizableInfo[]>();
            IMemberInfo[] members = DEUtil.getMembers((IClassInfo)classInfo).toArray(new IMemberInfo[0]);
            int i = 0;
            while (i < members.length) {
                childrenList.add(new ILocalizableInfo[]{classInfo, members[i]});
                ++i;
            }
            ArrayList methodList = new ArrayList(DEUtil.getMethods((IClassInfo)classInfo, (boolean)true));
            methodList.addAll(AggregationUtil.getMethods(classInfo));
            IMethodInfo[] methods = methodList.toArray(new IMethodInfo[0]);
            int i2 = 0;
            while (i2 < methods.length) {
                IMethodInfo mi = methods[i2];
                this.processMethods(classInfo, mi, childrenList);
                ++i2;
            }
            ILocalizableInfo[][] children = (ILocalizableInfo[][])childrenList.toArray((T[])new ILocalizableInfo[0][]);
            this.sortLocalizableInfo(children);
            int i3 = 0;
            while (i3 < children.length) {
                ILocalizableInfo[] obj = children[i3];
                this.createSubTreeItem(subItem, this.getDisplayText(obj), globalImage == null ? this.getImage(obj) : globalImage, this.getInsertText(obj), this.getTooltipText(obj), true);
                ++i3;
            }
        }
        if (OBJECTS_TYPE_BIRT.equals(objectType)) {
            try {
                IScriptFunctionCategory[] categorys = FunctionProvider.getCategories();
                Arrays.sort(categorys, new Comparator<IScriptFunctionCategory>(){

                    @Override
                    public int compare(IScriptFunctionCategory o1, IScriptFunctionCategory o2) {
                        return ExpressionTreeSupport.this.getCategoryDisplayName(o1).compareTo(ExpressionTreeSupport.this.getCategoryDisplayName(o2));
                    }
                });
                if (categorys != null) {
                    int i = 0;
                    while (i < categorys.length) {
                        subItem = this.createSubFolderItem(topItem, categorys[i]);
                        IScriptFunction[] functions = categorys[i].getFunctions();
                        Arrays.sort(functions, new Comparator<IScriptFunction>(){

                            @Override
                            public int compare(IScriptFunction o1, IScriptFunction o2) {
                                return ExpressionTreeSupport.this.getFunctionDisplayText(o1).compareTo(ExpressionTreeSupport.this.getFunctionDisplayText(o2));
                            }
                        });
                        if (functions != null) {
                            int j = 0;
                            while (j < functions.length) {
                                Image image = null;
                                image = functions[j].isStatic() ? IMAGE_STATIC_METHOD : IMAGE_METHOD;
                                this.createSubTreeItem(subItem, this.getFunctionDisplayText(functions[j]), image, this.getFunctionExpression(categorys[i], functions[j]), functions[j].getDescription(), true);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void sortLocalizableInfo(ILocalizableInfo[][] infos) {
        Arrays.sort(infos, new Comparator<ILocalizableInfo[]>(){

            private int computeWeight(ILocalizableInfo obj) {
                if (obj instanceof IMemberInfo) {
                    return ((IMemberInfo)obj).isStatic() ? 0 : 2;
                }
                if (obj instanceof IMethodInfo) {
                    if (((IMethodInfo)obj).isConstructor()) {
                        return 3;
                    }
                    return ((IMethodInfo)obj).isStatic() ? 1 : 4;
                }
                return 4;
            }

            @Override
            public int compare(ILocalizableInfo[] o1, ILocalizableInfo[] o2) {
                int w2;
                ILocalizableInfo info1 = o1[1];
                ILocalizableInfo info2 = o2[1];
                int w1 = this.computeWeight(info1);
                if (w1 != (w2 = this.computeWeight(info2))) {
                    return w1 < w2 ? -1 : 1;
                }
                return Collator.getInstance().compare(ExpressionTreeSupport.this.getDisplayText(o1), ExpressionTreeSupport.this.getDisplayText(o2));
            }
        });
    }

    private Image getImage(Object element) {
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            if (info instanceof IMethodInfo) {
                if (((IMethodInfo)info).isStatic()) {
                    return IMAGE_STATIC_METHOD;
                }
                if (((IMethodInfo)info).isConstructor()) {
                    return IMAGE_CONSTRUCTOR;
                }
                return IMAGE_METHOD;
            }
            if (info instanceof IMemberInfo) {
                if (((IMemberInfo)info).isStatic()) {
                    return IMAGE_STATIC_MEMBER;
                }
                return IMAGE_MEMBER;
            }
        }
        return null;
    }

    private String getInsertText(Object element) {
        if (element instanceof VariableElementHandle) {
            return ((VariableElementHandle)element).getVariableName();
        }
        if (element instanceof ILocalizableInfo[]) {
            IClassInfo classInfo = (IClassInfo)((ILocalizableInfo[])element)[0];
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuilder insertText = new StringBuilder();
            if (info instanceof IMemberInfo) {
                IMemberInfo memberInfo = (IMemberInfo)info;
                if (memberInfo.isStatic()) {
                    insertText.append(String.valueOf(classInfo.getName()) + ".");
                }
                insertText.append(memberInfo.getName());
            } else if (info instanceof IMethodInfo) {
                IMethodInfo methodInfo = (IMethodInfo)info;
                if (methodInfo.isStatic()) {
                    insertText.append(String.valueOf(classInfo.getName()) + ".");
                } else if (methodInfo.isConstructor()) {
                    insertText.append("new ");
                }
                insertText.append(methodInfo.getName());
                insertText.append("()");
            }
            return insertText.toString();
        }
        return null;
    }

    private String getTooltipText(Object element) {
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            String tooltip = null;
            if (info instanceof IMemberInfo) {
                tooltip = ((IMemberInfo)info).getToolTip();
            } else if (info instanceof IMethodInfo) {
                tooltip = ((IMethodInfo)info).getToolTip();
            }
            return tooltip == null ? "" : tooltip;
        }
        return null;
    }

    protected String getDisplayText(Object element) {
        if (element instanceof ILocalizableInfo[]) {
            String dataType;
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuilder displayText = new StringBuilder(info.getName());
            if (info instanceof IMethodInfo) {
                IMethodInfo method = (IMethodInfo)info;
                displayText.append("(");
                int argIndex = ((ILocalizableInfo[])element).length > 2 ? ((IIndexInfo)((ILocalizableInfo[])element)[2]).getIndex() : 0;
                int idx = -1;
                Iterator argumentListIter = method.argumentListIterator();
                while (argumentListIter.hasNext()) {
                    IArgumentInfoList arguments = (IArgumentInfoList)argumentListIter.next();
                    if (++idx < argIndex) continue;
                    boolean isFirst = true;
                    Iterator iter = arguments.argumentsIterator();
                    while (iter.hasNext()) {
                        IArgumentInfo argInfo = (IArgumentInfo)iter.next();
                        if (!isFirst) {
                            displayText.append(", ");
                        }
                        isFirst = false;
                        if (argInfo.getType() != null && argInfo.getType().length() > 0) {
                            displayText.append(String.valueOf(argInfo.getType()) + " " + argInfo.getName());
                            continue;
                        }
                        displayText.append(argInfo.getName());
                    }
                    break block0;
                }
                displayText.append(")");
                if (!method.isConstructor()) {
                    displayText.append(" : ");
                    String returnType = method.getReturnType();
                    if (returnType == null || returnType.length() == 0) {
                        returnType = "void";
                    }
                    displayText.append(returnType);
                }
            } else if (info instanceof IMemberInfo && (dataType = ((IMemberInfo)info).getDataType()) != null && dataType.length() > 0) {
                displayText.append(" : ");
                displayText.append(dataType);
            }
            return displayText.toString();
        }
        return null;
    }

    private boolean isGlobal(String name) {
        return name != null && name.startsWith("Global");
    }

    private String getFunctionDisplayText(IScriptFunction function) {
        String functionStart = function.isConstructor() ? "new " : "";
        StringBuilder displayText = new StringBuilder(functionStart);
        displayText.append(function.getName());
        IScriptFunctionArgument[] arguments = function.getArguments();
        displayText.append("(");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                displayText.append(arguments[i].getName());
                if (i < arguments.length - 1) {
                    displayText.append(", ");
                }
                ++i;
            }
        }
        displayText.append(")");
        return displayText.toString();
    }

    private String getFunctionExpression(IScriptFunctionCategory category, IScriptFunction function) {
        String functionStart = function.isConstructor() ? "new " : "";
        StringBuilder textData = new StringBuilder(functionStart);
        if (function.isStatic() && category.getName() != null) {
            textData.append(String.valueOf(category.getName()) + ".");
        }
        textData.append(String.valueOf(function.getName()) + "()");
        return textData.toString();
    }

    protected void createContextCatagory() {
        assert (this.tree != null);
        if (this.contextItem == null || this.contextItem.isDisposed()) {
            this.contextItem = this.createTopTreeItem(this.tree, TREE_ITEM_CONTEXT, 0);
        }
        this.createContextObjects(this.currentMethodName);
    }

    protected void createContextObjects(String methodName) {
        if (this.currentEditObject != null && methodName != null) {
            DesignElementHandle handle = (DesignElementHandle)this.currentEditObject;
            List args = DEUtil.getDesignElementMethodArgumentsInfo((DesignElementHandle)handle, (String)methodName);
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                String argName = ((IArgumentInfo)iter.next()).getName();
                this.createSubTreeItem(this.contextItem, argName, IMAGE_METHOD, argName, "", true);
            }
        }
    }

    public void setCurrentEditObject(Object obj) {
        this.currentEditObject = obj;
    }

    private void clearTreeItem(TreeItem treeItem) {
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        treeItem.dispose();
    }

    private void clearSubTreeItem(TreeItem treeItem) {
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        TreeItem[] items = treeItem.getItems();
        int i = 0;
        while (i < items.length) {
            this.clearTreeItem(items[i]);
            ++i;
        }
    }

    private void clearDynamicItems() {
        if (this.dynamicItems != null) {
            for (TreeItem ti : this.dynamicItems) {
                this.clearTreeItem(ti);
            }
            this.dynamicItems.clear();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] sel;
        ISelection selection = event.getSelection();
        if (selection != null && (sel = ((IStructuredSelection)selection).toArray()).length == 1 && sel[0] instanceof IPropertyDefn) {
            final IPropertyDefn elePropDefn = (IPropertyDefn)sel[0];
            this.currentMethodName = elePropDefn.getName();
            ++this.eventFireNum;
            Display.getDefault().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    ++ExpressionTreeSupport.this.execNum;
                    if (elePropDefn.getName().equals(ExpressionTreeSupport.this.currentMethodName) && ExpressionTreeSupport.this.execNum == ExpressionTreeSupport.this.eventFireNum) {
                        ExpressionTreeSupport.this.createExpressionTree();
                    }
                    if (ExpressionTreeSupport.this.execNum >= ExpressionTreeSupport.this.eventFireNum) {
                        ExpressionTreeSupport.this.execNum = 0;
                        ExpressionTreeSupport.this.eventFireNum = 0;
                    }
                }
            });
        }
    }

    private void updateDynamicItems(List<IExpressionProvider> providers) {
        for (IExpressionProvider exprProvider : providers) {
            if (exprProvider == null) continue;
            this.createDynamicCategory(exprProvider);
        }
    }

    private void createDynamicCategory(IExpressionProvider provider) {
        Object[] cats = provider.getCategory();
        if (cats != null) {
            Object[] objectArray = cats;
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                Object cat = objectArray[n2];
                TreeItem ti = this.createTopTreeItem(this.tree, cat, provider);
                if (this.dynamicItems == null) {
                    this.dynamicItems = new ArrayList<TreeItem>();
                }
                this.dynamicItems.add(ti);
                if (provider.hasChildren(cat)) {
                    this.createDynamicChildern(ti, cat, provider);
                }
                ++n2;
            }
        }
    }

    private void createDynamicChildern(TreeItem parent, Object element, IExpressionProvider provider) {
        Object[] children = provider.getChildren(element);
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (provider.hasChildren(child)) {
                    TreeItem ti = this.createSubFolderItem(parent, child, provider);
                    this.createDynamicChildern(ti, child, provider);
                } else {
                    this.createSubTreeItem(parent, child, provider);
                }
                ++n2;
            }
        }
    }

    private TreeItem createTopTreeItem(Tree tree, Object element, IExpressionProvider provider) {
        TreeItem item = new TreeItem(tree, 0);
        item.setText(provider.getDisplayText(element));
        item.setImage(provider.getImage(element));
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)provider.getTooltipText(element));
        return item;
    }

    private TreeItem createSubFolderItem(TreeItem parent, Object element, IExpressionProvider provider) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(provider.getDisplayText(element));
        item.setImage(provider.getImage(element));
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)provider.getTooltipText(element));
        return item;
    }

    private TreeItem createSubTreeItem(TreeItem parent, Object element, IExpressionProvider provider) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(provider.getDisplayText(element));
        item.setImage(provider.getImage(element));
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)provider.getTooltipText(element));
        item.setData(ITEM_DATA_KEY_TEXT, (Object)provider.getInsertText(element));
        item.setData(ITEM_DATA_KEY_ENABLED, (Object)Boolean.TRUE);
        return item;
    }

    public void updateParametersTree() {
        if (this.parametersItem != null && !this.parametersItem.isDisposed()) {
            this.clearSubTreeItem(this.parametersItem);
            this.buildParameterTree();
            this.restoreSelection();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMethods(IClassInfo classInfo, IMethodInfo mi, List childrenList) {
        block1: {
            alitr = mi.argumentListIterator();
            idx = 0;
            if (alitr != null) ** GOTO lbl11
            childrenList.add(new ILocalizableInfo[]{classInfo, mi});
            break block1;
lbl-1000:
            // 1 sources

            {
                alitr.next();
                childrenList.add(new ILocalizableInfo[]{classInfo, mi, new IIndexInfo(idx++)});
lbl11:
                // 2 sources

                ** while (alitr.hasNext())
            }
        }
    }

    private int getIndex(TreeItem ... items) {
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem ti = treeItemArray[n2];
                if (ti != null && !ti.isDisposed()) {
                    return this.tree.indexOf(ti) + 1;
                }
                ++n2;
            }
        }
        return 0;
    }
}

