/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm.js;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.report.debug.internal.core.vm.ReportVM;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPointListener;
import org.eclipse.birt.report.debug.internal.core.vm.VMDebugger;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsContextData;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsDebugFrame;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsFunctionSource;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsLineBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsTransientLineBreakPoint;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class JsDebugger
extends VMDebugger
implements Debugger,
VMBreakPointListener {
    private Map scripts;
    private LinkedList cachedBreakPoints;
    private LinkedList transientBreakPoints;
    private boolean disposed = false;

    public JsDebugger(ReportVM vm) {
        super(vm);
        this.vm = vm;
        this.vm.addBreakPointListener(this);
        this.cachedBreakPoints = new LinkedList();
        this.transientBreakPoints = new LinkedList();
        this.scripts = new HashMap();
    }

    public DebugFrame getFrame(Context arg0, DebuggableScript arg1) {
        if (this.disposed) {
            return null;
        }
        JsFunctionSource src = (JsFunctionSource)this.scripts.get(arg1);
        if (src == null) {
            return null;
        }
        System.out.println(">>>> Frame Source Name: " + src.getSourceName());
        System.out.println(">>>> Frame Function Name: " + src.getFunctionName());
        return new JsDebugFrame(arg0, this, arg1, src);
    }

    public void handleCompilationDone(Context arg0, DebuggableScript arg1, String arg2) {
        if (this.disposed || !arg1.isTopLevel() || arg1.getSourceName() == null || arg1.getSourceName().equals(ScriptExpression.defaultID)) {
            return;
        }
        this.registerTopLevelScripts(arg1, arg2);
        System.out.println(">>>> Compiled Source: " + arg1.getSourceName() + "\r\n" + arg2 + "\r\n>>>> end compilation.");
    }

    private void registerTopLevelScripts(DebuggableScript script, String source) {
        ArrayList functions = new ArrayList();
        this.collectFunctions(script, functions);
        this.registerFunctions(source, functions);
    }

    private void registerFunctions(String source, List functions) {
        int i = 0;
        while (i < functions.size()) {
            DebuggableScript function = (DebuggableScript)functions.get(i);
            int firstLineNumber = this.getMinNumber(function.getLineNumbers());
            if (firstLineNumber != -1) {
                String funcName = function.getFunctionName();
                if (funcName == null) {
                    funcName = "";
                }
                this.scripts.put(function, new JsFunctionSource(function.getSourceName(), funcName, source, firstLineNumber));
            }
            ++i;
        }
    }

    private int getMinNumber(int[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return -1;
        }
        int min = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] < min) {
                min = numbers[i];
            }
            ++i;
        }
        return min;
    }

    private void collectFunctions(DebuggableScript function, List holder) {
        holder.add(function);
        int i = 0;
        while (i < function.getFunctionCount()) {
            this.collectFunctions(function.getFunction(i), holder);
            ++i;
        }
    }

    public void dispose() {
        this.disposed = true;
        this.vm.removeBreakPointListener(this);
        this.cachedBreakPoints.clear();
        this.transientBreakPoints.clear();
        this.scripts.clear();
    }

    int currentState() {
        return this.vmState();
    }

    boolean breakHitTest(JsContextData contextData) {
        boolean hit = this.checkBpHits(contextData, this.cachedBreakPoints);
        if (!hit) {
            hit = this.checkBpHits(contextData, this.transientBreakPoints);
        }
        return hit;
    }

    private boolean checkBpHits(JsContextData contextData, List bpList) {
        int i = 0;
        while (i < bpList.size()) {
            JsLineBreakPoint jsbp = (JsLineBreakPoint)bpList.get(i);
            if (JsDebugger.stringEqual(jsbp.name, contextData.currentName) && jsbp.lineNo == contextData.currentLineNo) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean stringEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    void handleBreakHit(JsContextData contextData, int interruptState) {
        this.transientBreakPoints.clear();
        this.vmInterrupt(contextData, interruptState);
    }

    private boolean interested(VMBreakPoint bp) {
        return bp instanceof JsLineBreakPoint;
    }

    @Override
    public void breakPointAdded(VMBreakPoint bp) {
        if (this.interested(bp)) {
            if (bp instanceof JsTransientLineBreakPoint && !this.transientBreakPoints.contains(bp)) {
                this.transientBreakPoints.add(bp);
            } else if (!this.cachedBreakPoints.contains(bp)) {
                this.cachedBreakPoints.add(bp);
            }
        }
    }

    @Override
    public void breakPointChanged(VMBreakPoint bp) {
        this.interested(bp);
    }

    @Override
    public void breakPointRemoved(VMBreakPoint bp) {
        if (this.interested(bp)) {
            if (bp instanceof JsTransientLineBreakPoint) {
                this.transientBreakPoints.remove(bp);
            } else {
                this.cachedBreakPoints.remove(bp);
            }
        }
    }

    @Override
    public void breakPointCleared() {
        this.transientBreakPoints.clear();
        this.cachedBreakPoints.clear();
    }
}

