/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.ui.IWorkbenchPart;

public class AddStyleAction
extends ContextSelectionAction {
    private static final String ACTION_MSG_ADD_STYLE_RULE = Messages.getString((String)"AddStyleAction.actionMsg.addStyleRule");
    public static final String ID = "AddStyleAction";
    private AbstractThemeHandle themeHandle;

    public AddStyleAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(ACTION_MSG_ADD_STYLE_RULE);
    }

    @Override
    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        boolean hasTheme = false;
        if (this.themeHandle != null) {
            hasTheme = true;
            CommandUtils.setVariable("NewStyleAction.ThemeHandleName", this.themeHandle);
        } else {
            ThemeHandle theme;
            ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
            if (module instanceof LibraryHandle && (theme = ((LibraryHandle)module).getTheme()) != null) {
                hasTheme = true;
                CommandUtils.setVariable("NewStyleAction.ThemeHandleName", theme);
            }
        }
        try {
            try {
                CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.newStyleCommand");
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                if (hasTheme) {
                    CommandUtils.removeVariable("NewStyleAction.ThemeHandleName");
                }
            }
        }
        finally {
            if (hasTheme) {
                CommandUtils.removeVariable("NewStyleAction.ThemeHandleName");
            }
        }
    }

    public void setThemeHandle(AbstractThemeHandle themeHandle) {
        this.themeHandle = themeHandle;
    }
}

