/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test;

import java.util.Enumeration;
import org.eclipse.gemini.blueprint.extender.internal.util.concurrent.Counter;
import org.eclipse.gemini.blueprint.extender.support.internal.ConfigUtils;
import org.eclipse.gemini.blueprint.test.AbstractConfigurableOsgiTests;
import org.eclipse.gemini.blueprint.util.OsgiBundleUtils;
import org.eclipse.gemini.blueprint.util.OsgiListenerUtils;
import org.eclipse.gemini.blueprint.util.OsgiStringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.springframework.util.ObjectUtils;

public abstract class AbstractSynchronizedOsgiTests
extends AbstractConfigurableOsgiTests {
    protected static final long DEFAULT_WAIT_TIME = 60L;
    private static final long SECOND = 1000L;

    public AbstractSynchronizedOsgiTests() {
    }

    public AbstractSynchronizedOsgiTests(String name) {
        super(name);
    }

    protected void waitOnContextCreation(String forBundleWithSymbolicName, long timeout) {
        this.waitOnContextCreation(this.bundleContext, forBundleWithSymbolicName, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitOnContextCreation(BundleContext context, String forBundleWithSymbolicName, long timeout) {
        long time = timeout * 1000L;
        final Counter counter = new Counter("waitForContext on bnd=" + forBundleWithSymbolicName);
        counter.increment();
        String filter = "(org.springframework.context.service.name=" + forBundleWithSymbolicName + ")";
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    counter.decrement();
                }
            }
        };
        OsgiListenerUtils.addServiceListener((BundleContext)context, (ServiceListener)listener, (String)filter);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Start waiting for Spring/OSGi bundle=" + forBundleWithSymbolicName));
        }
        try {
            if (counter.waitForZero(time)) {
                this.waitingFailed(forBundleWithSymbolicName);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found applicationContext for bundle=" + forBundleWithSymbolicName));
            }
        }
        finally {
            context.removeServiceListener(listener);
        }
    }

    protected void waitOnContextCreation(String forBundleWithSymbolicName) {
        this.waitOnContextCreation(forBundleWithSymbolicName, this.getDefaultWaitTime());
    }

    private void waitingFailed(String bundleName) {
        this.logger.warn((Object)("Waiting for applicationContext for bundle=" + bundleName + " timed out"));
        throw new RuntimeException("Gave up waiting for application context for '" + bundleName + "' to be created");
    }

    protected long getDefaultWaitTime() {
        return 60L;
    }

    protected boolean shouldWaitForSpringBundlesContextCreation() {
        return true;
    }

    protected void postProcessBundleContext(BundleContext platformBundleContext) throws Exception {
        if (this.shouldWaitForSpringBundlesContextCreation()) {
            boolean debug = this.logger.isDebugEnabled();
            boolean trace = this.logger.isTraceEnabled();
            if (debug) {
                this.logger.debug((Object)"Looking for Spring/OSGi powered bundles to wait for...");
            }
            Bundle[] bundles = platformBundleContext.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                String bundleName = OsgiStringUtils.nullSafeSymbolicName((Bundle)bundle);
                if (OsgiBundleUtils.isBundleActive((Bundle)bundle)) {
                    if (this.isSpringDMManaged(bundle) && ConfigUtils.getPublishContext(bundle.getHeaders())) {
                        if (debug) {
                            this.logger.debug((Object)("Bundle [" + bundleName + "] triggers a context creation; waiting for it"));
                        }
                        this.waitOnContextCreation(platformBundleContext, bundleName, this.getDefaultWaitTime());
                        continue;
                    }
                    if (!trace) continue;
                    this.logger.trace((Object)("Bundle [" + bundleName + "] does not trigger a context creation."));
                    continue;
                }
                if (!trace) continue;
                this.logger.trace((Object)("Bundle [" + bundleName + "] is not active (probably a fragment); ignoring"));
            }
        }
    }

    protected boolean isSpringDMManaged(Bundle bundle) {
        if (!ObjectUtils.isEmpty((Object[])ConfigUtils.getHeaderLocations(bundle.getHeaders()))) {
            return true;
        }
        Enumeration enm = bundle.findEntries("META-INF/spring", "*.xml", false);
        return enm != null && enm.hasMoreElements();
    }
}

